/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ArrayMap;
import org.apache.empire.commons.ArraySet;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class Options
extends AbstractSet<OptionEntry>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ArrayList<OptionEntry> list;
    protected OptionGroupResolver optionGroupResolver;

    public Options() {
        this.list = new ArrayList();
    }

    public Options(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public Options(Options other) {
        this.list = new ArrayList(other.size());
        this.addAll(other);
    }

    public Options(OptionEntry[] entries) {
        this.list = new ArrayList(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            this.add(entries[i]);
        }
    }

    public Options(Class<?> enumType) {
        if (enumType == null || !enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        Enum[] items = (Enum[])enumType.getEnumConstants();
        this.list = new ArrayList(items.length);
        for (int i = 0; i < items.length; ++i) {
            Enum item = items[i];
            this.append(item, item.toString(), true);
        }
    }

    @Override
    public boolean addAll(Collection<? extends OptionEntry> source) {
        for (OptionEntry optionEntry : source) {
            this.add((OptionEntry)optionEntry.clone());
        }
        return true;
    }

    public Options clone() {
        return new Options(this);
    }

    public OptionGroupResolver getOptionGroupResolver() {
        return this.optionGroupResolver;
    }

    public void setOptionGroupResolver(OptionGroupResolver optionGroupResolver) {
        this.optionGroupResolver = optionGroupResolver;
    }

    protected int getIndex(Object value) {
        OptionEntry oe;
        if (value instanceof OptionEntry) {
            int index = this.list.indexOf(value);
            if (index >= 0) {
                return index;
            }
            value = ((OptionEntry)value).getValue();
        }
        return (oe = this.getEntry(value)) != null ? this.list.indexOf(oe) : -1;
    }

    protected OptionEntry createOptionEntry(Object value, String text, boolean active) {
        return new OptionEntry(value, text, active);
    }

    public OptionEntry getEntry(Object value) {
        if (value instanceof Map.Entry) {
            value = ((Map.Entry)value).getKey();
        }
        if (value instanceof OptionEntry) {
            value = ((OptionEntry)value).getValue();
        }
        for (OptionEntry oe : this.list) {
            if (!oe.valueEquals(value)) continue;
            return oe;
        }
        return null;
    }

    public String get(Object value) {
        OptionEntry oe = this.getEntry(value);
        return oe != null ? oe.getText() : "";
    }

    public boolean isActive(Object value) {
        OptionEntry oe = this.getEntry(value);
        return oe != null ? oe.isActive() : false;
    }

    public Object getValueAt(int i) {
        return i >= 0 && i < this.list.size() ? this.list.get(i).getValue() : null;
    }

    public String getTextAt(int i) {
        return i >= 0 && i < this.list.size() ? this.list.get(i).getText() : "";
    }

    public Set<Object> getValues(boolean activeOnly) {
        int count = activeOnly ? this.getActiveCount() : this.list.size();
        ArraySet<Object> values = new ArraySet<Object>(count);
        for (OptionEntry e : this.list) {
            if (activeOnly && !e.isActive()) continue;
            values.add(e.getValue());
        }
        return values;
    }

    public final Set<Object> getValues() {
        return this.getValues(false);
    }

    public int getActiveCount() {
        int count = 0;
        for (OptionEntry e : this.list) {
            if (!e.isActive()) continue;
            ++count;
        }
        return count;
    }

    public Options getActive() {
        Options o = new Options(this.getActiveCount());
        for (OptionEntry e : this.list) {
            if (!e.isActive()) continue;
            o.list.add(e);
        }
        return o;
    }

    public void set(Object value, String text, Boolean active, InsertPos pos) {
        OptionEntry oe;
        if (text == null) {
            text = "";
        }
        if ((oe = this.getEntry(value)) != null) {
            oe.setText(text);
            if (active != null) {
                oe.setActive(active);
            }
        } else {
            int index = pos == InsertPos.Top ? 0 : (pos == InsertPos.Sort ? this.findInsertPos(text) : this.list.size());
            this.list.add(index, this.createOptionEntry(value, text, active != null ? active : true));
        }
    }

    public final void set(Object value, String text, InsertPos pos) {
        this.set(value, text, null, pos);
    }

    public void set(Object value, String text, Boolean active) {
        OptionEntry oe;
        if (text == null) {
            text = "";
        }
        if ((oe = this.getEntry(value)) != null) {
            oe.setText(text);
            if (active != null) {
                oe.setActive(active);
            }
        } else {
            this.append(value, text, active != null ? active : true);
        }
    }

    public final void set(Object value, String text) {
        this.set(value, text, (Boolean)null);
    }

    public final Options add(Object value, String text, boolean active) {
        this.set(value, text, active);
        return this;
    }

    public final Options add(Object value, String text) {
        this.set(value, text, (Boolean)null);
        return this;
    }

    @Override
    public boolean add(OptionEntry option) {
        if (option == null) {
            throw new InvalidArgumentException("option", option);
        }
        OptionEntry oe = this.getEntry(option.getValue());
        if (oe != null) {
            this.list.set(this.getIndex(oe), option);
        } else {
            this.append(option);
        }
        return true;
    }

    public void append(OptionEntry option) {
        this.list.add(option);
    }

    public void append(Object value, String text, boolean active) {
        if (text == null) {
            text = "";
        }
        this.append(this.createOptionEntry(value, text, active));
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object value) {
        return this.getEntry(value) != null;
    }

    public boolean containsNull() {
        return this.getEntry("") != null;
    }

    public boolean has(Object value) {
        return this.getEntry(value) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    @Override
    public Iterator<OptionEntry> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean remove(Object value) {
        OptionEntry oe = this.getEntry(value);
        if (oe == null) {
            return false;
        }
        this.list.remove(this.getIndex(oe));
        return true;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    public Map<Object, String> map() {
        return this.map(Object.class);
    }

    public <T> Map<T, String> map(Class<T> type) {
        return new ImmutableMap();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (OptionEntry e : this.list) {
            b.append(first ? "\"" : ",\r\n \"");
            b.append(StringUtils.toString(e.getValue()));
            b.append("\":\"");
            b.append(e.getText());
            b.append("\":");
            b.append(e.isActive() ? "1" : "0");
            first = false;
        }
        b.append("}");
        return b.toString();
    }

    public void addXml(Element element, DataType dataType) {
        for (OptionEntry e : this.list) {
            Object value = e.getValue();
            if (value instanceof Enum) {
                value = ObjectUtils.getEnumValue((Enum)value, dataType.isNumeric());
            }
            Element opt = XMLUtil.addElement(element, "option", e.getText());
            opt.setAttribute("value", String.valueOf(value));
            if (e.isActive()) continue;
            opt.setAttribute("disabled", "true");
        }
    }

    protected int findInsertPos(String text) {
        OptionEntry e;
        int i;
        for (i = 0; i < this.list.size() && text.compareToIgnoreCase((e = this.list.get(i)).getText()) > 0; ++i) {
        }
        return i;
    }

    public static enum InsertPos {
        Top,
        Bottom,
        Sort;

    }

    private class ImmutableMap<T>
    implements Map<T, String> {
        private ImmutableMap() {
        }

        @Override
        public int size() {
            return Options.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Options.this.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return Options.this.contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            for (OptionEntry e : Options.this.list) {
                if (!ObjectUtils.compareEqual(value, e.getText())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<T> keySet() {
            ArraySet<Object> keySet = new ArraySet<Object>(this.size());
            for (OptionEntry e : Options.this.list) {
                keySet.add(e.getValue());
            }
            return keySet;
        }

        @Override
        public Collection<String> values() {
            ArrayList<String> textValues = new ArrayList<String>(this.size());
            for (OptionEntry e : Options.this.list) {
                textValues.add(e.getText());
            }
            return textValues;
        }

        @Override
        public Set<Map.Entry<T, String>> entrySet() {
            ArraySet<ArrayMap.Entry<Object, String>> set = new ArraySet<ArrayMap.Entry<Object, String>>(Options.this.list.size());
            for (OptionEntry e : Options.this.list) {
                set.add(new ArrayMap.Entry<Object, String>(e.getValue(), e.getText()));
            }
            return set.immutable();
        }

        @Override
        public String get(Object key) {
            return Options.this.get(key);
        }

        @Override
        public String put(Object key, String value) {
            throw new NotSupportedException(this, "put");
        }

        @Override
        public void putAll(Map<? extends T, ? extends String> map) {
            throw new NotSupportedException(this, "putAll");
        }

        @Override
        public String remove(Object key) {
            throw new NotSupportedException(this, "remove");
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this, "clear");
        }

        public String toString() {
            return Options.this.toString();
        }
    }

    @FunctionalInterface
    public static interface OptionGroupResolver {
        public Object getGroup(OptionEntry var1);
    }
}

