/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final long MILLIS_IN_DAY = 86400000L;

    private DateUtils() {
    }

    public static Date getDateNow() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTimeNow() {
        return Calendar.getInstance().getTime();
    }

    public static Timestamp getTimestamp() {
        return Timestamp.valueOf(LocalDateTime.now());
    }

    public static Date addDate(Date date, int years, int months, int days) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (years != 0) {
            calendar.add(1, years);
        }
        if (months != 0) {
            calendar.add(2, months);
        }
        if (days != 0) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static Date setDate(Date date, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month > 0) {
            calendar.set(2, month - 1);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        return calendar.getTime();
    }

    public static Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month > 0) {
            calendar.set(2, month - 1);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDateTime(int year, int month, int day, int hours, int minutes, int seconds, int millis) {
        Calendar calendar = Calendar.getInstance();
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month > 0) {
            calendar.set(2, month - 1);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, millis);
        return calendar.getTime();
    }

    public static Date getDateTime(int year, int month, int day, int hours, int minutes, int seconds) {
        return DateUtils.getDateTime(year, month, day, hours, minutes, seconds, 0);
    }

    public static Date setTime(Date date, int hours, int minutes, int seconds, int millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, millis);
        return calendar.getTime();
    }

    public static Date getDateOnly(Date date) {
        return DateUtils.setTime(date, 0, 0, 0, 0);
    }

    public static Date getTimeOnly(Date date) {
        return DateUtils.setDate(date, 0, 0, 0);
    }

    public static long compareDates(Date date1, Date date2) {
        long time1 = DateUtils.setTime(date1, 0, 0, 0, 0).getTime();
        long time2 = DateUtils.setTime(date2, 0, 0, 0, 0).getTime();
        return (time1 /= 86400000L) - (time2 /= 86400000L);
    }

    public static boolean compareEqual(Date date1, Date date2) {
        return DateUtils.compareDates(date1, date2) == 0L;
    }

    public static int getDaysBetween(Date date1, Date date2) {
        if (date1 == null) {
            date1 = DateUtils.getDateNow();
        }
        if (date2 == null) {
            date2 = DateUtils.getDateNow();
        }
        long diffInMillies = date2.getTime() - date1.getTime();
        return (int)TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getYear(Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.YEAR);
    }

    public static int getMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int getMonth(Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.MONTH_OF_YEAR);
    }

    public static int getDay() {
        return Calendar.getInstance().get(5);
    }

    public static int getDay(Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.DAY_OF_MONTH);
    }

    public static int getDayOfWeek() {
        int dow = Calendar.getInstance().get(7) - 1;
        return dow <= 0 ? 7 : dow;
    }

    public static int getDayOfWeek(Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.DAY_OF_WEEK);
    }

    public static Date parseDate(String sDate, Locale locale) {
        try {
            DateFormat df = DateFormat.getDateInstance(3, DateUtils.getSafeLocale(locale));
            df.setLenient(true);
            return df.parse(sDate);
        }
        catch (ParseException e) {
            log.error("Invalid date value", (Throwable)e);
            return null;
        }
    }

    private static Locale getSafeLocale(Locale locale) {
        return locale == null ? Locale.getDefault() : locale;
    }

    public static String formatDate(Date date, Locale locale) {
        if (date == null) {
            return "";
        }
        DateFormat df = DateFormat.getDateInstance(2, DateUtils.getSafeLocale(locale));
        return df.format(date);
    }

    public static String formatTime(Date date, Locale locale, boolean withSeconds) {
        if (date == null) {
            return "";
        }
        int style = withSeconds ? 2 : 3;
        DateFormat df = DateFormat.getTimeInstance(style, DateUtils.getSafeLocale(locale));
        return df.format(date);
    }

    public static String formatDayOfWeek(Date date, Locale locale, boolean longFormat) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("", DateUtils.getSafeLocale(locale));
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        int dayOfWeek = c.get(7);
        if (longFormat) {
            return sdf.getDateFormatSymbols().getWeekdays()[dayOfWeek];
        }
        return sdf.getDateFormatSymbols().getShortWeekdays()[dayOfWeek];
    }

    public static String formatMonth(Date date, Locale locale, boolean longFormat) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("", DateUtils.getSafeLocale(locale));
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        int month = c.get(2);
        if (longFormat) {
            return sdf.getDateFormatSymbols().getMonths()[month];
        }
        return sdf.getDateFormatSymbols().getShortMonths()[month];
    }

    public static int getWeekOfYear(Date date, Locale locale) {
        if (date == null) {
            throw new InvalidArgumentException("date", date);
        }
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        return c.get(3);
    }

    public static String formatMonth(int month, Locale locale, boolean longFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat("", DateUtils.getSafeLocale(locale));
        if (longFormat) {
            return sdf.getDateFormatSymbols().getMonths()[month];
        }
        return sdf.getDateFormatSymbols().getShortMonths()[month];
    }

    public static String formatYear(Date date, Locale locale) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy", DateUtils.getSafeLocale(locale));
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        return sdf.format(date);
    }

    public static LocalDate toLocalDate(java.sql.Date date) {
        return date.toLocalDate();
    }

    public static LocalDate toLocalDate(Timestamp timestamp) {
        return timestamp.toLocalDateTime().toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(java.sql.Date date) {
        return date.toLocalDate().atStartOfDay();
    }

    public static LocalDateTime toLocalDateTime(Timestamp timestamp) {
        return timestamp.toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        if (date instanceof java.sql.Date) {
            return DateUtils.toLocalDate((java.sql.Date)date);
        }
        if (date instanceof Timestamp) {
            return DateUtils.toLocalDate((Timestamp)date);
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date instanceof java.sql.Date) {
            return DateUtils.toLocalDateTime((java.sql.Date)date);
        }
        if (date instanceof Timestamp) {
            return DateUtils.toLocalDateTime((Timestamp)date);
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(LocalDate localDate) {
        return java.sql.Date.valueOf(localDate);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Timestamp.valueOf(localDateTime);
    }

    public static LocalDate parseLocalDate(String date) {
        return LocalDate.parse(date);
    }

    public static LocalDate parseLocalDate(String date, DateTimeFormatter formatter) {
        return LocalDate.parse(date, formatter);
    }

    public static LocalDateTime parseLocalDateTime(String date) {
        return LocalDateTime.parse(date);
    }

    public static LocalDateTime parseLocalDateTime(String date, DateTimeFormatter formatter) {
        return LocalDateTime.parse(date, formatter);
    }

    public static DateTimeFormatter getLocalDateFormatter(Locale locale) {
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(DateUtils.getSafeLocale(locale));
    }

    public static DateTimeFormatter getLocalDateTimeFormatter(Locale locale, boolean withSeconds) {
        return DateTimeFormatter.ofLocalizedDateTime(withSeconds ? FormatStyle.MEDIUM : FormatStyle.SHORT).withLocale(DateUtils.getSafeLocale(locale));
    }

    public static String formatDate(LocalDate localDate, Locale locale) {
        if (localDate == null) {
            return "";
        }
        return DateUtils.getLocalDateFormatter(locale).format(localDate);
    }

    public static String formatDate(LocalDateTime localDateTime, Locale locale) {
        if (localDateTime == null) {
            return "";
        }
        return DateUtils.getLocalDateFormatter(locale).format(localDateTime.toLocalDate());
    }

    public static String formatDateTime(LocalDateTime localDateTime, Locale locale, boolean withSeconds) {
        if (localDateTime == null) {
            return "";
        }
        return DateUtils.getLocalDateTimeFormatter(locale, withSeconds).format(localDateTime);
    }
}

