/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.sqlite;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.sqlite.SQLiteDDLGenerator;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerSQLite
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerSQLite.class);
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBMSHandlerSQLite() {
        this.setReservedKeywords();
    }

    private void addReservedKeyWord(String keyWord) {
        boolean added = this.reservedSQLKeywords.add(keyWord.toLowerCase());
        if (!added) {
            log.debug("Existing keyWord added: " + keyWord);
        }
    }

    private void setReservedKeywords() {
        this.addReservedKeyWord("ABORT".toLowerCase());
        this.addReservedKeyWord("ACTION".toLowerCase());
        this.addReservedKeyWord("ADD".toLowerCase());
        this.addReservedKeyWord("AFTER".toLowerCase());
        this.addReservedKeyWord("ALL".toLowerCase());
        this.addReservedKeyWord("ALTER".toLowerCase());
        this.addReservedKeyWord("ANALYZE".toLowerCase());
        this.addReservedKeyWord("AND".toLowerCase());
        this.addReservedKeyWord("AS".toLowerCase());
        this.addReservedKeyWord("ASC".toLowerCase());
        this.addReservedKeyWord("ATTACH".toLowerCase());
        this.addReservedKeyWord("AUTOINCREMENT".toLowerCase());
        this.addReservedKeyWord("BEFORE".toLowerCase());
        this.addReservedKeyWord("BEGIN".toLowerCase());
        this.addReservedKeyWord("BETWEEN".toLowerCase());
        this.addReservedKeyWord("BY".toLowerCase());
        this.addReservedKeyWord("CASCADE".toLowerCase());
        this.addReservedKeyWord("CASE".toLowerCase());
        this.addReservedKeyWord("CAST".toLowerCase());
        this.addReservedKeyWord("CHECK".toLowerCase());
        this.addReservedKeyWord("COLLATE".toLowerCase());
        this.addReservedKeyWord("COLUMN".toLowerCase());
        this.addReservedKeyWord("COMMIT".toLowerCase());
        this.addReservedKeyWord("CONFLICT".toLowerCase());
        this.addReservedKeyWord("CONSTRAINT".toLowerCase());
        this.addReservedKeyWord("CREATE".toLowerCase());
        this.addReservedKeyWord("CROSS".toLowerCase());
        this.addReservedKeyWord("CURRENT_DATE".toLowerCase());
        this.addReservedKeyWord("CURRENT_TIME".toLowerCase());
        this.addReservedKeyWord("CURRENT_DATETIME".toLowerCase());
        this.addReservedKeyWord("DATABASE".toLowerCase());
        this.addReservedKeyWord("DEFAULT".toLowerCase());
        this.addReservedKeyWord("DEFERRABLE".toLowerCase());
        this.addReservedKeyWord("DEFERRED".toLowerCase());
        this.addReservedKeyWord("DELETE".toLowerCase());
        this.addReservedKeyWord("DESC".toLowerCase());
        this.addReservedKeyWord("DETACH".toLowerCase());
        this.addReservedKeyWord("DISTINCT".toLowerCase());
        this.addReservedKeyWord("DROP".toLowerCase());
        this.addReservedKeyWord("EACH".toLowerCase());
        this.addReservedKeyWord("ELSE".toLowerCase());
        this.addReservedKeyWord("END".toLowerCase());
        this.addReservedKeyWord("ESCAPE".toLowerCase());
        this.addReservedKeyWord("EXCEPT".toLowerCase());
        this.addReservedKeyWord("EXCLUSIVE".toLowerCase());
        this.addReservedKeyWord("EXISTS".toLowerCase());
        this.addReservedKeyWord("EXPLAIN".toLowerCase());
        this.addReservedKeyWord("FAIL".toLowerCase());
        this.addReservedKeyWord("FOR".toLowerCase());
        this.addReservedKeyWord("FOREIGN".toLowerCase());
        this.addReservedKeyWord("FROM".toLowerCase());
        this.addReservedKeyWord("FULL".toLowerCase());
        this.addReservedKeyWord("GLOB".toLowerCase());
        this.addReservedKeyWord("GROUP".toLowerCase());
        this.addReservedKeyWord("HAVING".toLowerCase());
        this.addReservedKeyWord("IF".toLowerCase());
        this.addReservedKeyWord("IGNORE".toLowerCase());
        this.addReservedKeyWord("IMMEDIATE".toLowerCase());
        this.addReservedKeyWord("IN".toLowerCase());
        this.addReservedKeyWord("INDEX".toLowerCase());
        this.addReservedKeyWord("INDEXED".toLowerCase());
        this.addReservedKeyWord("INITIALLY".toLowerCase());
        this.addReservedKeyWord("INNER".toLowerCase());
        this.addReservedKeyWord("INSERT".toLowerCase());
        this.addReservedKeyWord("INSTEAD".toLowerCase());
        this.addReservedKeyWord("INTERSECT".toLowerCase());
        this.addReservedKeyWord("INTO".toLowerCase());
        this.addReservedKeyWord("IS".toLowerCase());
        this.addReservedKeyWord("ISNULL".toLowerCase());
        this.addReservedKeyWord("JOIN".toLowerCase());
        this.addReservedKeyWord("KEY".toLowerCase());
        this.addReservedKeyWord("LEFT".toLowerCase());
        this.addReservedKeyWord("LIKE".toLowerCase());
        this.addReservedKeyWord("LIMIT".toLowerCase());
        this.addReservedKeyWord("MATCH".toLowerCase());
        this.addReservedKeyWord("NATURAL".toLowerCase());
        this.addReservedKeyWord("NO".toLowerCase());
        this.addReservedKeyWord("NOT".toLowerCase());
        this.addReservedKeyWord("NOTNULL".toLowerCase());
        this.addReservedKeyWord("NULL".toLowerCase());
        this.addReservedKeyWord("OF".toLowerCase());
        this.addReservedKeyWord("OFFSET".toLowerCase());
        this.addReservedKeyWord("ON".toLowerCase());
        this.addReservedKeyWord("OR".toLowerCase());
        this.addReservedKeyWord("ORDER".toLowerCase());
        this.addReservedKeyWord("OUTER".toLowerCase());
        this.addReservedKeyWord("PLAN".toLowerCase());
        this.addReservedKeyWord("PRAGMA".toLowerCase());
        this.addReservedKeyWord("PRIMARY".toLowerCase());
        this.addReservedKeyWord("QUERY".toLowerCase());
        this.addReservedKeyWord("RAISE".toLowerCase());
        this.addReservedKeyWord("REFERENCES".toLowerCase());
        this.addReservedKeyWord("REGEXP".toLowerCase());
        this.addReservedKeyWord("REINDEX".toLowerCase());
        this.addReservedKeyWord("RELEASE".toLowerCase());
        this.addReservedKeyWord("RENAME".toLowerCase());
        this.addReservedKeyWord("REPLACE".toLowerCase());
        this.addReservedKeyWord("RESTRICT".toLowerCase());
        this.addReservedKeyWord("RIGHT".toLowerCase());
        this.addReservedKeyWord("ROLLBACK".toLowerCase());
        this.addReservedKeyWord("ROW".toLowerCase());
        this.addReservedKeyWord("SAVEPOINT".toLowerCase());
        this.addReservedKeyWord("SELECT".toLowerCase());
        this.addReservedKeyWord("SET".toLowerCase());
        this.addReservedKeyWord("TABLE".toLowerCase());
        this.addReservedKeyWord("TEMP".toLowerCase());
        this.addReservedKeyWord("TEMPORARY".toLowerCase());
        this.addReservedKeyWord("THEN".toLowerCase());
        this.addReservedKeyWord("TO".toLowerCase());
        this.addReservedKeyWord("TRANSACTION".toLowerCase());
        this.addReservedKeyWord("TRIGGER".toLowerCase());
        this.addReservedKeyWord("UNION".toLowerCase());
        this.addReservedKeyWord("UNIQUE".toLowerCase());
        this.addReservedKeyWord("UPDATE".toLowerCase());
        this.addReservedKeyWord("USING".toLowerCase());
        this.addReservedKeyWord("VACUUM".toLowerCase());
        this.addReservedKeyWord("VALUES".toLowerCase());
        this.addReservedKeyWord("VIEW".toLowerCase());
        this.addReservedKeyWord("VIRTUAL".toLowerCase());
        this.addReservedKeyWord("WHEN".toLowerCase());
        this.addReservedKeyWord("WHERE".toLowerCase());
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBCommandSQLite(this, autoPrepareStmt);
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "`";
            }
            case SQL_QUOTES_CLOSE: {
                return "`";
            }
            case SQL_CONCAT_EXPR: {
                return "concat(?, {0})";
            }
            case SQL_BOOLEAN_TRUE: {
                return "1";
            }
            case SQL_BOOLEAN_FALSE: {
                return "0";
            }
            case SQL_CURRENT_DATE: {
                return "date('now','localtime');";
            }
            case SQL_DATE_PATTERN: {
                return "yyyy-MM-dd";
            }
            case SQL_DATE_TEMPLATE: {
                return "date('{0}')";
            }
            case SQL_CURRENT_TIME: {
                return "time('now');";
            }
            case SQL_TIME_TEMPLATE: {
                return "time('{0}')";
            }
            case SQL_DATETIME_PATTERN: {
                return "yyyy-MM-dd hh:mm:ss.sss";
            }
            case SQL_DATETIME_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "NOW()";
            }
            case SQL_TIMESTAMP_PATTERN: {
                return "yyyy-MM-dd hh:mm:ss.sss";
            }
            case SQL_TIMESTAMP_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_FUNC_COALESCE: {
                return "coalesce(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substring(?, {0})";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substring(?, {0}, {1})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "reverse(?)";
            }
            case SQL_FUNC_STRINDEX: {
                return "instr(?, {0})";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return "locate({0}, ?, {1})";
            }
            case SQL_FUNC_LENGTH: {
                return "length(?)";
            }
            case SQL_FUNC_UPPER: {
                return "upper(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lcase(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "truncate(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceiling(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "mod(?,{0})";
            }
            case SQL_FUNC_FORMAT: {
                return "printf({0:VARCHAR}, ?)";
            }
            case SQL_FUNC_DAY: {
                return "day(?)";
            }
            case SQL_FUNC_MONTH: {
                return "month(?)";
            }
            case SQL_FUNC_YEAR: {
                return "year(?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_DECODE: {
                return "case ? {0} end";
            }
            case SQL_FUNC_DECODE_SEP: {
                return " ";
            }
            case SQL_FUNC_DECODE_PART: {
                return "when {0} then {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "else {0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case VARCHAR: 
            case CHAR: {
                if (format != null) {
                    if (srcType == DataType.INTEGER || srcType == DataType.AUTOINC) {
                        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
                        return "?";
                    }
                    return "to_char(?, '" + format.toString() + "')";
                }
                return "convert(?, CHAR)";
            }
            case INTEGER: {
                return "convert(?, BIGINT)";
            }
            case DECIMAL: {
                return "convert(?, DECIMAL)";
            }
            case FLOAT: {
                return "convert(?, DOUBLE)";
            }
        }
        log.error("getConvertPhrase: unknown type (" + String.valueOf((Object)destType));
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn, DBMSHandler.DBSetGenKeys genKeys) throws SQLException {
        int count;
        block9: {
            Statement stmt = null;
            count = 0;
            try {
                if (sqlParams != null) {
                    PreparedStatement pstmt = conn.prepareStatement(sqlCmd);
                    stmt = pstmt;
                    this.prepareStatement(pstmt, sqlParams);
                    count = pstmt.executeUpdate();
                } else {
                    stmt = conn.createStatement();
                    count = stmt.executeUpdate(sqlCmd);
                }
                if (genKeys == null || count <= 0) break block9;
                try (ResultSet rs = stmt.getGeneratedKeys();){
                    int rownum = 0;
                    while (rs.next()) {
                        genKeys.set(rownum++, rs.getObject(1));
                    }
                }
            }
            finally {
                this.closeStatement(stmt);
            }
        }
        return count;
    }

    @Override
    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        if (dataType == DataType.DATETIME || dataType == DataType.TIMESTAMP) {
            try {
                return rset.getTimestamp(columnIndex);
            }
            catch (Exception ex) {
                try {
                    String datePattern = this.getSQLPhrase(DBSqlPhrase.SQL_DATETIME_PATTERN);
                    SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
                    Date timestamp = dateFormat.parse(rset.getString(columnIndex));
                    return new Timestamp(timestamp.getTime());
                }
                catch (ParseException e) {
                    throw new UnexpectedReturnValueException((Object)rset.getString(columnIndex), "getResultValue");
                }
            }
        }
        if (dataType == DataType.CLOB) {
            Clob clob = rset.getClob(columnIndex);
            return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
        }
        if (dataType == DataType.BLOB) {
            Blob blob = rset.getBlob(columnIndex);
            return blob != null ? blob.getBytes(1L, (int)blob.length()) : null;
        }
        return rset.getObject(columnIndex);
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new SQLiteDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String SeqName, int minValue, Connection conn) {
        throw new NotImplementedException(db, " sequence values are assigned dynamicaly from sqlite ");
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    public static class DBCommandSQLite
    extends DBCommand {
        public DBCommandSQLite(DBMSHandlerSQLite dmbs, boolean autoPrepareStmt) {
            super(dmbs, autoPrepareStmt);
        }

        @Override
        public DBCommandSQLite join(DBJoinExpr join) {
            if (join.getType() != DBJoinType.LEFT) {
                throw new NotImplementedException((Object)join.getType(), join.getLeftTable().getName() + " join " + join.getRightTable().getName());
            }
            super.join(join);
            return this;
        }

        @Override
        public void addJoins(List<DBJoinExpr> joinExprList) {
            for (DBJoinExpr joinExpr : joinExprList) {
                if (!(joinExpr instanceof DBColumnJoinExpr) || joinExpr.getType() == DBJoinType.LEFT) continue;
                DBColumnJoinExpr join = (DBColumnJoinExpr)joinExpr;
                throw new NotImplementedException((Object)joinExpr.getType(), join.getLeft() + " join " + join.getRight());
            }
            super.addJoins(joinExprList);
        }
    }
}

