/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCombinedCmd;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.mysql.MySQLDDLGenerator;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerMySQL
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerMySQL.class);
    private String databaseName = null;
    private String characterSet = "utf8";
    private boolean useSequenceTable = false;
    private String sequenceTableName = "Sequences";
    private String engine;
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBMSHandlerMySQL() {
        this.setReservedKeywords();
    }

    private void addReservedKeyWord(String keyWord) {
        boolean added = this.reservedSQLKeywords.add(keyWord.toLowerCase());
        if (!added) {
            log.debug("Existing keyWord added: " + keyWord);
        }
    }

    private void setReservedKeywords() {
        this.addReservedKeyWord("ACCESSIBLE".toLowerCase());
        this.addReservedKeyWord("ACCOUNT".toLowerCase());
        this.addReservedKeyWord("ACTION".toLowerCase());
        this.addReservedKeyWord("ADD".toLowerCase());
        this.addReservedKeyWord("AFTER".toLowerCase());
        this.addReservedKeyWord("AGAINST".toLowerCase());
        this.addReservedKeyWord("AGGREGATE".toLowerCase());
        this.addReservedKeyWord("ALGORITHM".toLowerCase());
        this.addReservedKeyWord("ALL".toLowerCase());
        this.addReservedKeyWord("ALTER".toLowerCase());
        this.addReservedKeyWord("ALWAYS".toLowerCase());
        this.addReservedKeyWord("ANALYSE".toLowerCase());
        this.addReservedKeyWord("ANALYZE".toLowerCase());
        this.addReservedKeyWord("AND".toLowerCase());
        this.addReservedKeyWord("ANY".toLowerCase());
        this.addReservedKeyWord("AS".toLowerCase());
        this.addReservedKeyWord("ASC".toLowerCase());
        this.addReservedKeyWord("ASCII".toLowerCase());
        this.addReservedKeyWord("ASENSITIVE".toLowerCase());
        this.addReservedKeyWord("AT".toLowerCase());
        this.addReservedKeyWord("AUTOEXTEND_SIZE".toLowerCase());
        this.addReservedKeyWord("AUTO_INCREMENT".toLowerCase());
        this.addReservedKeyWord("AVG".toLowerCase());
        this.addReservedKeyWord("AVG_ROW_LENGTH".toLowerCase());
        this.addReservedKeyWord("BACKUP".toLowerCase());
        this.addReservedKeyWord("BEFORE".toLowerCase());
        this.addReservedKeyWord("BEGIN".toLowerCase());
        this.addReservedKeyWord("BETWEEN".toLowerCase());
        this.addReservedKeyWord("BIGINT".toLowerCase());
        this.addReservedKeyWord("BINARY".toLowerCase());
        this.addReservedKeyWord("BINLOG".toLowerCase());
        this.addReservedKeyWord("BIT".toLowerCase());
        this.addReservedKeyWord("BLOB".toLowerCase());
        this.addReservedKeyWord("BLOCK".toLowerCase());
        this.addReservedKeyWord("BOOL".toLowerCase());
        this.addReservedKeyWord("BOOLEAN".toLowerCase());
        this.addReservedKeyWord("BOTH".toLowerCase());
        this.addReservedKeyWord("BTREE".toLowerCase());
        this.addReservedKeyWord("BY".toLowerCase());
        this.addReservedKeyWord("BYTE".toLowerCase());
        this.addReservedKeyWord("CACHE".toLowerCase());
        this.addReservedKeyWord("CALL".toLowerCase());
        this.addReservedKeyWord("CASCADE".toLowerCase());
        this.addReservedKeyWord("CASCADED".toLowerCase());
        this.addReservedKeyWord("CASE".toLowerCase());
        this.addReservedKeyWord("CATALOG_NAME".toLowerCase());
        this.addReservedKeyWord("CHAIN".toLowerCase());
        this.addReservedKeyWord("CHANGE".toLowerCase());
        this.addReservedKeyWord("CHANGED".toLowerCase());
        this.addReservedKeyWord("CHANNEL".toLowerCase());
        this.addReservedKeyWord("CHAR".toLowerCase());
        this.addReservedKeyWord("CHARACTER".toLowerCase());
        this.addReservedKeyWord("CHARSET".toLowerCase());
        this.addReservedKeyWord("CHECK".toLowerCase());
        this.addReservedKeyWord("CHECKSUM".toLowerCase());
        this.addReservedKeyWord("CIPHER".toLowerCase());
        this.addReservedKeyWord("CLASS_ORIGIN".toLowerCase());
        this.addReservedKeyWord("CLIENT".toLowerCase());
        this.addReservedKeyWord("CLOSE".toLowerCase());
        this.addReservedKeyWord("COALESCE".toLowerCase());
        this.addReservedKeyWord("CODE".toLowerCase());
        this.addReservedKeyWord("COLLATE".toLowerCase());
        this.addReservedKeyWord("COLLATION".toLowerCase());
        this.addReservedKeyWord("COLUMN".toLowerCase());
        this.addReservedKeyWord("COLUMNS".toLowerCase());
        this.addReservedKeyWord("COLUMN_FORMAT".toLowerCase());
        this.addReservedKeyWord("COLUMN_NAME".toLowerCase());
        this.addReservedKeyWord("COMMENT".toLowerCase());
        this.addReservedKeyWord("COMMIT".toLowerCase());
        this.addReservedKeyWord("COMMITTED".toLowerCase());
        this.addReservedKeyWord("COMPACT".toLowerCase());
        this.addReservedKeyWord("COMPLETION".toLowerCase());
        this.addReservedKeyWord("COMPRESSED".toLowerCase());
        this.addReservedKeyWord("COMPRESSION".toLowerCase());
        this.addReservedKeyWord("CONCURRENT".toLowerCase());
        this.addReservedKeyWord("CONDITION".toLowerCase());
        this.addReservedKeyWord("CONNECTION".toLowerCase());
        this.addReservedKeyWord("CONSISTENT".toLowerCase());
        this.addReservedKeyWord("CONSTRAINT".toLowerCase());
        this.addReservedKeyWord("CONSTRAINT_CATALOG".toLowerCase());
        this.addReservedKeyWord("CONSTRAINT_NAME".toLowerCase());
        this.addReservedKeyWord("CONSTRAINT_SCHEMA".toLowerCase());
        this.addReservedKeyWord("CONTAINS".toLowerCase());
        this.addReservedKeyWord("CONTEXT".toLowerCase());
        this.addReservedKeyWord("CONTINUE".toLowerCase());
        this.addReservedKeyWord("CONVERT".toLowerCase());
        this.addReservedKeyWord("CPU".toLowerCase());
        this.addReservedKeyWord("CREATE".toLowerCase());
        this.addReservedKeyWord("CROSS".toLowerCase());
        this.addReservedKeyWord("CUBE".toLowerCase());
        this.addReservedKeyWord("CURRENT".toLowerCase());
        this.addReservedKeyWord("CURRENT_DATE".toLowerCase());
        this.addReservedKeyWord("CURRENT_TIME".toLowerCase());
        this.addReservedKeyWord("CURRENT_TIMESTAMP".toLowerCase());
        this.addReservedKeyWord("CURRENT_USER".toLowerCase());
        this.addReservedKeyWord("CURSOR".toLowerCase());
        this.addReservedKeyWord("CURSOR_NAME".toLowerCase());
        this.addReservedKeyWord("DATA".toLowerCase());
        this.addReservedKeyWord("DATABASE".toLowerCase());
        this.addReservedKeyWord("DATABASES".toLowerCase());
        this.addReservedKeyWord("DATAFILE".toLowerCase());
        this.addReservedKeyWord("DATE".toLowerCase());
        this.addReservedKeyWord("DATETIME".toLowerCase());
        this.addReservedKeyWord("DAY".toLowerCase());
        this.addReservedKeyWord("DAY_HOUR".toLowerCase());
        this.addReservedKeyWord("DAY_MICROSECOND".toLowerCase());
        this.addReservedKeyWord("DAY_MINUTE".toLowerCase());
        this.addReservedKeyWord("DAY_SECOND".toLowerCase());
        this.addReservedKeyWord("DEALLOCATE".toLowerCase());
        this.addReservedKeyWord("DEC".toLowerCase());
        this.addReservedKeyWord("DECIMAL".toLowerCase());
        this.addReservedKeyWord("DECLARE".toLowerCase());
        this.addReservedKeyWord("DEFAULT".toLowerCase());
        this.addReservedKeyWord("DEFAULT_AUTH".toLowerCase());
        this.addReservedKeyWord("DEFINER".toLowerCase());
        this.addReservedKeyWord("DELAYED".toLowerCase());
        this.addReservedKeyWord("DELAY_KEY_WRITE".toLowerCase());
        this.addReservedKeyWord("DELETE".toLowerCase());
        this.addReservedKeyWord("DESC".toLowerCase());
        this.addReservedKeyWord("DESCRIBE".toLowerCase());
        this.addReservedKeyWord("DES_KEY_FILE".toLowerCase());
        this.addReservedKeyWord("DETERMINISTIC".toLowerCase());
        this.addReservedKeyWord("DIAGNOSTICS".toLowerCase());
        this.addReservedKeyWord("DIRECTORY".toLowerCase());
        this.addReservedKeyWord("DISABLE".toLowerCase());
        this.addReservedKeyWord("DISCARD".toLowerCase());
        this.addReservedKeyWord("DISK".toLowerCase());
        this.addReservedKeyWord("DISTINCT".toLowerCase());
        this.addReservedKeyWord("DISTINCTROW".toLowerCase());
        this.addReservedKeyWord("DIV".toLowerCase());
        this.addReservedKeyWord("DO".toLowerCase());
        this.addReservedKeyWord("DOUBLE".toLowerCase());
        this.addReservedKeyWord("DROP".toLowerCase());
        this.addReservedKeyWord("DUAL".toLowerCase());
        this.addReservedKeyWord("DUMPFILE".toLowerCase());
        this.addReservedKeyWord("DUPLICATE".toLowerCase());
        this.addReservedKeyWord("DYNAMIC".toLowerCase());
        this.addReservedKeyWord("EACH".toLowerCase());
        this.addReservedKeyWord("ELSE".toLowerCase());
        this.addReservedKeyWord("ELSEIF".toLowerCase());
        this.addReservedKeyWord("ENABLE".toLowerCase());
        this.addReservedKeyWord("ENCLOSED".toLowerCase());
        this.addReservedKeyWord("ENCRYPTION".toLowerCase());
        this.addReservedKeyWord("END".toLowerCase());
        this.addReservedKeyWord("ENDS".toLowerCase());
        this.addReservedKeyWord("ENGINE".toLowerCase());
        this.addReservedKeyWord("ENGINES".toLowerCase());
        this.addReservedKeyWord("ENUM".toLowerCase());
        this.addReservedKeyWord("ERROR".toLowerCase());
        this.addReservedKeyWord("ERRORS".toLowerCase());
        this.addReservedKeyWord("ESCAPE".toLowerCase());
        this.addReservedKeyWord("ESCAPED".toLowerCase());
        this.addReservedKeyWord("EVENT".toLowerCase());
        this.addReservedKeyWord("EVENTS".toLowerCase());
        this.addReservedKeyWord("EVERY".toLowerCase());
        this.addReservedKeyWord("EXCHANGE".toLowerCase());
        this.addReservedKeyWord("EXECUTE".toLowerCase());
        this.addReservedKeyWord("EXISTS".toLowerCase());
        this.addReservedKeyWord("EXIT".toLowerCase());
        this.addReservedKeyWord("EXPANSION".toLowerCase());
        this.addReservedKeyWord("EXPIRE".toLowerCase());
        this.addReservedKeyWord("EXPLAIN".toLowerCase());
        this.addReservedKeyWord("EXPORT".toLowerCase());
        this.addReservedKeyWord("EXTENDED".toLowerCase());
        this.addReservedKeyWord("EXTENT_SIZE".toLowerCase());
        this.addReservedKeyWord("FALSE".toLowerCase());
        this.addReservedKeyWord("FAST".toLowerCase());
        this.addReservedKeyWord("FAULTS".toLowerCase());
        this.addReservedKeyWord("FETCH".toLowerCase());
        this.addReservedKeyWord("FIELDS".toLowerCase());
        this.addReservedKeyWord("FILE".toLowerCase());
        this.addReservedKeyWord("FILE_BLOCK_SIZE".toLowerCase());
        this.addReservedKeyWord("FILTER".toLowerCase());
        this.addReservedKeyWord("FIRST".toLowerCase());
        this.addReservedKeyWord("FIXED".toLowerCase());
        this.addReservedKeyWord("FLOAT".toLowerCase());
        this.addReservedKeyWord("FLOAT4".toLowerCase());
        this.addReservedKeyWord("FLOAT8".toLowerCase());
        this.addReservedKeyWord("FLUSH".toLowerCase());
        this.addReservedKeyWord("FOLLOWS".toLowerCase());
        this.addReservedKeyWord("FOR".toLowerCase());
        this.addReservedKeyWord("FORCE".toLowerCase());
        this.addReservedKeyWord("FOREIGN".toLowerCase());
        this.addReservedKeyWord("FORMAT".toLowerCase());
        this.addReservedKeyWord("FOUND".toLowerCase());
        this.addReservedKeyWord("FROM".toLowerCase());
        this.addReservedKeyWord("FULL".toLowerCase());
        this.addReservedKeyWord("FULLTEXT".toLowerCase());
        this.addReservedKeyWord("FUNCTION".toLowerCase());
        this.addReservedKeyWord("GENERAL".toLowerCase());
        this.addReservedKeyWord("GENERATED".toLowerCase());
        this.addReservedKeyWord("GEOMETRY".toLowerCase());
        this.addReservedKeyWord("GEOMETRYCOLLECTION".toLowerCase());
        this.addReservedKeyWord("GET".toLowerCase());
        this.addReservedKeyWord("GET_FORMAT".toLowerCase());
        this.addReservedKeyWord("GLOBAL".toLowerCase());
        this.addReservedKeyWord("GRANT".toLowerCase());
        this.addReservedKeyWord("GRANTS".toLowerCase());
        this.addReservedKeyWord("GROUP".toLowerCase());
        this.addReservedKeyWord("GROUP_REPLICATION".toLowerCase());
        this.addReservedKeyWord("HANDLER".toLowerCase());
        this.addReservedKeyWord("HASH".toLowerCase());
        this.addReservedKeyWord("HAVING".toLowerCase());
        this.addReservedKeyWord("HELP".toLowerCase());
        this.addReservedKeyWord("HIGH_PRIORITY".toLowerCase());
        this.addReservedKeyWord("HOST".toLowerCase());
        this.addReservedKeyWord("HOSTS".toLowerCase());
        this.addReservedKeyWord("HOUR".toLowerCase());
        this.addReservedKeyWord("HOUR_MICROSECOND".toLowerCase());
        this.addReservedKeyWord("HOUR_MINUTE".toLowerCase());
        this.addReservedKeyWord("HOUR_SECOND".toLowerCase());
        this.addReservedKeyWord("IDENTIFIED".toLowerCase());
        this.addReservedKeyWord("IF".toLowerCase());
        this.addReservedKeyWord("IGNORE".toLowerCase());
        this.addReservedKeyWord("IGNORE_SERVER_IDS".toLowerCase());
        this.addReservedKeyWord("IMPORT".toLowerCase());
        this.addReservedKeyWord("IN".toLowerCase());
        this.addReservedKeyWord("INDEX".toLowerCase());
        this.addReservedKeyWord("INDEXES".toLowerCase());
        this.addReservedKeyWord("INFILE".toLowerCase());
        this.addReservedKeyWord("INITIAL_SIZE".toLowerCase());
        this.addReservedKeyWord("INNER".toLowerCase());
        this.addReservedKeyWord("INOUT".toLowerCase());
        this.addReservedKeyWord("INSENSITIVE".toLowerCase());
        this.addReservedKeyWord("INSERT".toLowerCase());
        this.addReservedKeyWord("INSERT_METHOD".toLowerCase());
        this.addReservedKeyWord("INSTALL".toLowerCase());
        this.addReservedKeyWord("INSTANCE".toLowerCase());
        this.addReservedKeyWord("INT".toLowerCase());
        this.addReservedKeyWord("INT1".toLowerCase());
        this.addReservedKeyWord("INT2".toLowerCase());
        this.addReservedKeyWord("INT3".toLowerCase());
        this.addReservedKeyWord("INT4".toLowerCase());
        this.addReservedKeyWord("INT8".toLowerCase());
        this.addReservedKeyWord("INTEGER".toLowerCase());
        this.addReservedKeyWord("INTERVAL".toLowerCase());
        this.addReservedKeyWord("INTO".toLowerCase());
        this.addReservedKeyWord("INVOKER".toLowerCase());
        this.addReservedKeyWord("IO".toLowerCase());
        this.addReservedKeyWord("IO_AFTER_GTIDS".toLowerCase());
        this.addReservedKeyWord("IO_BEFORE_GTIDS".toLowerCase());
        this.addReservedKeyWord("IO_THREAD".toLowerCase());
        this.addReservedKeyWord("IPC".toLowerCase());
        this.addReservedKeyWord("IS".toLowerCase());
        this.addReservedKeyWord("ISOLATION".toLowerCase());
        this.addReservedKeyWord("ISSUER".toLowerCase());
        this.addReservedKeyWord("ITERATE".toLowerCase());
        this.addReservedKeyWord("JOIN".toLowerCase());
        this.addReservedKeyWord("JSON".toLowerCase());
        this.addReservedKeyWord("KEY".toLowerCase());
        this.addReservedKeyWord("KEYS".toLowerCase());
        this.addReservedKeyWord("KEY_BLOCK_SIZE".toLowerCase());
        this.addReservedKeyWord("KILL".toLowerCase());
        this.addReservedKeyWord("LANGUAGE".toLowerCase());
        this.addReservedKeyWord("LAST".toLowerCase());
        this.addReservedKeyWord("LEADING".toLowerCase());
        this.addReservedKeyWord("LEAVE".toLowerCase());
        this.addReservedKeyWord("LEAVES".toLowerCase());
        this.addReservedKeyWord("LEFT".toLowerCase());
        this.addReservedKeyWord("LESS".toLowerCase());
        this.addReservedKeyWord("LEVEL".toLowerCase());
        this.addReservedKeyWord("LIKE".toLowerCase());
        this.addReservedKeyWord("LIMIT".toLowerCase());
        this.addReservedKeyWord("LINEAR".toLowerCase());
        this.addReservedKeyWord("LINES".toLowerCase());
        this.addReservedKeyWord("LINESTRING".toLowerCase());
        this.addReservedKeyWord("LIST".toLowerCase());
        this.addReservedKeyWord("LOAD".toLowerCase());
        this.addReservedKeyWord("LOCAL".toLowerCase());
        this.addReservedKeyWord("LOCALTIME".toLowerCase());
        this.addReservedKeyWord("LOCALTIMESTAMP".toLowerCase());
        this.addReservedKeyWord("LOCK".toLowerCase());
        this.addReservedKeyWord("LOCKS".toLowerCase());
        this.addReservedKeyWord("LOGFILE".toLowerCase());
        this.addReservedKeyWord("LOGS".toLowerCase());
        this.addReservedKeyWord("LONG".toLowerCase());
        this.addReservedKeyWord("LONGBLOB".toLowerCase());
        this.addReservedKeyWord("LONGTEXT".toLowerCase());
        this.addReservedKeyWord("LOOP".toLowerCase());
        this.addReservedKeyWord("LOW_PRIORITY".toLowerCase());
        this.addReservedKeyWord("MASTER".toLowerCase());
        this.addReservedKeyWord("MASTER_AUTO_POSITION".toLowerCase());
        this.addReservedKeyWord("MASTER_BIND".toLowerCase());
        this.addReservedKeyWord("MASTER_CONNECT_RETRY".toLowerCase());
        this.addReservedKeyWord("MASTER_DELAY".toLowerCase());
        this.addReservedKeyWord("MASTER_HEARTBEAT_PERIOD".toLowerCase());
        this.addReservedKeyWord("MASTER_HOST".toLowerCase());
        this.addReservedKeyWord("MASTER_LOG_FILE".toLowerCase());
        this.addReservedKeyWord("MASTER_LOG_POS".toLowerCase());
        this.addReservedKeyWord("MASTER_PASSWORD".toLowerCase());
        this.addReservedKeyWord("MASTER_PORT".toLowerCase());
        this.addReservedKeyWord("MASTER_RETRY_COUNT".toLowerCase());
        this.addReservedKeyWord("MASTER_SERVER_ID".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_CA".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_CAPATH".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_CERT".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_CIPHER".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_CRL".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_CRLPATH".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_KEY".toLowerCase());
        this.addReservedKeyWord("MASTER_SSL_VERIFY_SERVER_CERT".toLowerCase());
        this.addReservedKeyWord("MASTER_TLS_VERSION".toLowerCase());
        this.addReservedKeyWord("MASTER_USER".toLowerCase());
        this.addReservedKeyWord("MATCH".toLowerCase());
        this.addReservedKeyWord("MAXVALUE".toLowerCase());
        this.addReservedKeyWord("MAX_CONNECTIONS_PER_HOUR".toLowerCase());
        this.addReservedKeyWord("MAX_QUERIES_PER_HOUR".toLowerCase());
        this.addReservedKeyWord("MAX_ROWS".toLowerCase());
        this.addReservedKeyWord("MAX_SIZE".toLowerCase());
        this.addReservedKeyWord("MAX_STATEMENT_TIME".toLowerCase());
        this.addReservedKeyWord("MAX_UPDATES_PER_HOUR".toLowerCase());
        this.addReservedKeyWord("MAX_USER_CONNECTIONS".toLowerCase());
        this.addReservedKeyWord("MEDIUM".toLowerCase());
        this.addReservedKeyWord("MEDIUMBLOB".toLowerCase());
        this.addReservedKeyWord("MEDIUMINT".toLowerCase());
        this.addReservedKeyWord("MEDIUMTEXT".toLowerCase());
        this.addReservedKeyWord("MEMORY".toLowerCase());
        this.addReservedKeyWord("MERGE".toLowerCase());
        this.addReservedKeyWord("MESSAGE_TEXT".toLowerCase());
        this.addReservedKeyWord("MICROSECOND".toLowerCase());
        this.addReservedKeyWord("MIDDLEINT".toLowerCase());
        this.addReservedKeyWord("MIGRATE".toLowerCase());
        this.addReservedKeyWord("MINUTE".toLowerCase());
        this.addReservedKeyWord("MINUTE_MICROSECOND".toLowerCase());
        this.addReservedKeyWord("MINUTE_SECOND".toLowerCase());
        this.addReservedKeyWord("MIN_ROWS".toLowerCase());
        this.addReservedKeyWord("MOD".toLowerCase());
        this.addReservedKeyWord("MODE".toLowerCase());
        this.addReservedKeyWord("MODIFIES".toLowerCase());
        this.addReservedKeyWord("MODIFY".toLowerCase());
        this.addReservedKeyWord("MONTH".toLowerCase());
        this.addReservedKeyWord("MULTILINESTRING".toLowerCase());
        this.addReservedKeyWord("MULTIPOINT".toLowerCase());
        this.addReservedKeyWord("MULTIPOLYGON".toLowerCase());
        this.addReservedKeyWord("MUTEX".toLowerCase());
        this.addReservedKeyWord("MYSQL_ERRNO".toLowerCase());
        this.addReservedKeyWord("NAME".toLowerCase());
        this.addReservedKeyWord("NAMES".toLowerCase());
        this.addReservedKeyWord("NATIONAL".toLowerCase());
        this.addReservedKeyWord("NATURAL".toLowerCase());
        this.addReservedKeyWord("NCHAR".toLowerCase());
        this.addReservedKeyWord("NDB".toLowerCase());
        this.addReservedKeyWord("NDBCLUSTER".toLowerCase());
        this.addReservedKeyWord("NEVER".toLowerCase());
        this.addReservedKeyWord("NEW".toLowerCase());
        this.addReservedKeyWord("NEXT".toLowerCase());
        this.addReservedKeyWord("NO".toLowerCase());
        this.addReservedKeyWord("NODEGROUP".toLowerCase());
        this.addReservedKeyWord("NONBLOCKING".toLowerCase());
        this.addReservedKeyWord("NONE".toLowerCase());
        this.addReservedKeyWord("NOT".toLowerCase());
        this.addReservedKeyWord("NO_WAIT".toLowerCase());
        this.addReservedKeyWord("NO_WRITE_TO_BINLOG".toLowerCase());
        this.addReservedKeyWord("NULL".toLowerCase());
        this.addReservedKeyWord("NUMBER".toLowerCase());
        this.addReservedKeyWord("NUMERIC".toLowerCase());
        this.addReservedKeyWord("NVARCHAR".toLowerCase());
        this.addReservedKeyWord("OFFSET".toLowerCase());
        this.addReservedKeyWord("OLD_PASSWORD".toLowerCase());
        this.addReservedKeyWord("ON".toLowerCase());
        this.addReservedKeyWord("ONE".toLowerCase());
        this.addReservedKeyWord("ONLY".toLowerCase());
        this.addReservedKeyWord("OPEN".toLowerCase());
        this.addReservedKeyWord("OPTIMIZE".toLowerCase());
        this.addReservedKeyWord("OPTIMIZER_COSTS".toLowerCase());
        this.addReservedKeyWord("OPTION".toLowerCase());
        this.addReservedKeyWord("OPTIONALLY".toLowerCase());
        this.addReservedKeyWord("OPTIONS".toLowerCase());
        this.addReservedKeyWord("OR".toLowerCase());
        this.addReservedKeyWord("ORDER".toLowerCase());
        this.addReservedKeyWord("OUT".toLowerCase());
        this.addReservedKeyWord("OUTER".toLowerCase());
        this.addReservedKeyWord("OUTFILE".toLowerCase());
        this.addReservedKeyWord("OWNER".toLowerCase());
        this.addReservedKeyWord("PACK_KEYS".toLowerCase());
        this.addReservedKeyWord("PAGE".toLowerCase());
        this.addReservedKeyWord("PARSER".toLowerCase());
        this.addReservedKeyWord("PARSE_GCOL_EXPR".toLowerCase());
        this.addReservedKeyWord("PARTIAL".toLowerCase());
        this.addReservedKeyWord("PARTITION".toLowerCase());
        this.addReservedKeyWord("PARTITIONING".toLowerCase());
        this.addReservedKeyWord("PARTITIONS".toLowerCase());
        this.addReservedKeyWord("PASSWORD".toLowerCase());
        this.addReservedKeyWord("PHASE".toLowerCase());
        this.addReservedKeyWord("PLUGIN".toLowerCase());
        this.addReservedKeyWord("PLUGINS".toLowerCase());
        this.addReservedKeyWord("PLUGIN_DIR".toLowerCase());
        this.addReservedKeyWord("POINT".toLowerCase());
        this.addReservedKeyWord("POLYGON".toLowerCase());
        this.addReservedKeyWord("PORT".toLowerCase());
        this.addReservedKeyWord("PRECEDES".toLowerCase());
        this.addReservedKeyWord("PRECISION".toLowerCase());
        this.addReservedKeyWord("PREPARE".toLowerCase());
        this.addReservedKeyWord("PRESERVE".toLowerCase());
        this.addReservedKeyWord("PREV".toLowerCase());
        this.addReservedKeyWord("PRIMARY".toLowerCase());
        this.addReservedKeyWord("PRIVILEGES".toLowerCase());
        this.addReservedKeyWord("PROCEDURE".toLowerCase());
        this.addReservedKeyWord("PROCESSLIST".toLowerCase());
        this.addReservedKeyWord("PROFILE".toLowerCase());
        this.addReservedKeyWord("PROFILES".toLowerCase());
        this.addReservedKeyWord("PROXY".toLowerCase());
        this.addReservedKeyWord("PURGE".toLowerCase());
        this.addReservedKeyWord("QUARTER".toLowerCase());
        this.addReservedKeyWord("QUERY".toLowerCase());
        this.addReservedKeyWord("QUICK".toLowerCase());
        this.addReservedKeyWord("RANGE".toLowerCase());
        this.addReservedKeyWord("READ".toLowerCase());
        this.addReservedKeyWord("READS".toLowerCase());
        this.addReservedKeyWord("READ_ONLY".toLowerCase());
        this.addReservedKeyWord("READ_WRITE".toLowerCase());
        this.addReservedKeyWord("REAL".toLowerCase());
        this.addReservedKeyWord("REBUILD".toLowerCase());
        this.addReservedKeyWord("RECOVER".toLowerCase());
        this.addReservedKeyWord("REDOFILE".toLowerCase());
        this.addReservedKeyWord("REDO_BUFFER_SIZE".toLowerCase());
        this.addReservedKeyWord("REDUNDANT".toLowerCase());
        this.addReservedKeyWord("REFERENCES".toLowerCase());
        this.addReservedKeyWord("REGEXP".toLowerCase());
        this.addReservedKeyWord("RELAY".toLowerCase());
        this.addReservedKeyWord("RELAYLOG".toLowerCase());
        this.addReservedKeyWord("RELAY_LOG_FILE".toLowerCase());
        this.addReservedKeyWord("RELAY_LOG_POS".toLowerCase());
        this.addReservedKeyWord("RELAY_THREAD".toLowerCase());
        this.addReservedKeyWord("RELEASE".toLowerCase());
        this.addReservedKeyWord("RELOAD".toLowerCase());
        this.addReservedKeyWord("REMOVE".toLowerCase());
        this.addReservedKeyWord("RENAME".toLowerCase());
        this.addReservedKeyWord("REORGANIZE".toLowerCase());
        this.addReservedKeyWord("REPAIR".toLowerCase());
        this.addReservedKeyWord("REPEAT".toLowerCase());
        this.addReservedKeyWord("REPEATABLE".toLowerCase());
        this.addReservedKeyWord("REPLACE".toLowerCase());
        this.addReservedKeyWord("REPLICATE_DO_DB".toLowerCase());
        this.addReservedKeyWord("REPLICATE_DO_TABLE".toLowerCase());
        this.addReservedKeyWord("REPLICATE_IGNORE_DB".toLowerCase());
        this.addReservedKeyWord("REPLICATE_IGNORE_TABLE".toLowerCase());
        this.addReservedKeyWord("REPLICATE_REWRITE_DB".toLowerCase());
        this.addReservedKeyWord("REPLICATE_WILD_DO_TABLE".toLowerCase());
        this.addReservedKeyWord("REPLICATE_WILD_IGNORE_TABLE".toLowerCase());
        this.addReservedKeyWord("REPLICATION".toLowerCase());
        this.addReservedKeyWord("REQUIRE".toLowerCase());
        this.addReservedKeyWord("RESET".toLowerCase());
        this.addReservedKeyWord("RESIGNAL".toLowerCase());
        this.addReservedKeyWord("RESTORE".toLowerCase());
        this.addReservedKeyWord("RESTRICT".toLowerCase());
        this.addReservedKeyWord("RESUME".toLowerCase());
        this.addReservedKeyWord("RETURN".toLowerCase());
        this.addReservedKeyWord("RETURNED_SQLSTATE".toLowerCase());
        this.addReservedKeyWord("RETURNS".toLowerCase());
        this.addReservedKeyWord("REVERSE".toLowerCase());
        this.addReservedKeyWord("REVOKE".toLowerCase());
        this.addReservedKeyWord("RIGHT".toLowerCase());
        this.addReservedKeyWord("RLIKE".toLowerCase());
        this.addReservedKeyWord("ROLLBACK".toLowerCase());
        this.addReservedKeyWord("ROLLUP".toLowerCase());
        this.addReservedKeyWord("ROTATE".toLowerCase());
        this.addReservedKeyWord("ROUTINE".toLowerCase());
        this.addReservedKeyWord("ROW".toLowerCase());
        this.addReservedKeyWord("ROWS".toLowerCase());
        this.addReservedKeyWord("ROW_COUNT".toLowerCase());
        this.addReservedKeyWord("ROW_FORMAT".toLowerCase());
        this.addReservedKeyWord("RTREE".toLowerCase());
        this.addReservedKeyWord("SAVEPOINT".toLowerCase());
        this.addReservedKeyWord("SCHEDULE".toLowerCase());
        this.addReservedKeyWord("SCHEMA".toLowerCase());
        this.addReservedKeyWord("SCHEMAS".toLowerCase());
        this.addReservedKeyWord("SCHEMA_NAME".toLowerCase());
        this.addReservedKeyWord("SECOND".toLowerCase());
        this.addReservedKeyWord("SECOND_MICROSECOND".toLowerCase());
        this.addReservedKeyWord("SECURITY".toLowerCase());
        this.addReservedKeyWord("SELECT".toLowerCase());
        this.addReservedKeyWord("SENSITIVE".toLowerCase());
        this.addReservedKeyWord("SEPARATOR".toLowerCase());
        this.addReservedKeyWord("SERIAL".toLowerCase());
        this.addReservedKeyWord("SERIALIZABLE".toLowerCase());
        this.addReservedKeyWord("SERVER".toLowerCase());
        this.addReservedKeyWord("SESSION".toLowerCase());
        this.addReservedKeyWord("SET".toLowerCase());
        this.addReservedKeyWord("SHARE".toLowerCase());
        this.addReservedKeyWord("SHOW".toLowerCase());
        this.addReservedKeyWord("SHUTDOWN".toLowerCase());
        this.addReservedKeyWord("SIGNAL".toLowerCase());
        this.addReservedKeyWord("SIGNED".toLowerCase());
        this.addReservedKeyWord("SIMPLE".toLowerCase());
        this.addReservedKeyWord("SLAVE".toLowerCase());
        this.addReservedKeyWord("SLOW".toLowerCase());
        this.addReservedKeyWord("SMALLINT".toLowerCase());
        this.addReservedKeyWord("SNAPSHOT".toLowerCase());
        this.addReservedKeyWord("SOCKET".toLowerCase());
        this.addReservedKeyWord("SOME".toLowerCase());
        this.addReservedKeyWord("SONAME".toLowerCase());
        this.addReservedKeyWord("SOUNDS".toLowerCase());
        this.addReservedKeyWord("SOURCE".toLowerCase());
        this.addReservedKeyWord("SPATIAL".toLowerCase());
        this.addReservedKeyWord("SPECIFIC".toLowerCase());
        this.addReservedKeyWord("SQL".toLowerCase());
        this.addReservedKeyWord("SQLEXCEPTION".toLowerCase());
        this.addReservedKeyWord("SQLSTATE".toLowerCase());
        this.addReservedKeyWord("SQLWARNING".toLowerCase());
        this.addReservedKeyWord("SQL_AFTER_GTIDS".toLowerCase());
        this.addReservedKeyWord("SQL_AFTER_MTS_GAPS".toLowerCase());
        this.addReservedKeyWord("SQL_BEFORE_GTIDS".toLowerCase());
        this.addReservedKeyWord("SQL_BIG_RESULT".toLowerCase());
        this.addReservedKeyWord("SQL_BUFFER_RESULT".toLowerCase());
        this.addReservedKeyWord("SQL_CACHE".toLowerCase());
        this.addReservedKeyWord("SQL_CALC_FOUND_ROWS".toLowerCase());
        this.addReservedKeyWord("SQL_NO_CACHE".toLowerCase());
        this.addReservedKeyWord("SQL_SMALL_RESULT".toLowerCase());
        this.addReservedKeyWord("SQL_THREAD".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_DAY".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_HOUR".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_MINUTE".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_MONTH".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_QUARTER".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_SECOND".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_WEEK".toLowerCase());
        this.addReservedKeyWord("SQL_TSI_YEAR".toLowerCase());
        this.addReservedKeyWord("SSL".toLowerCase());
        this.addReservedKeyWord("STACKED".toLowerCase());
        this.addReservedKeyWord("START".toLowerCase());
        this.addReservedKeyWord("STARTING".toLowerCase());
        this.addReservedKeyWord("STARTS".toLowerCase());
        this.addReservedKeyWord("STATS_AUTO_RECALC".toLowerCase());
        this.addReservedKeyWord("STATS_PERSISTENT".toLowerCase());
        this.addReservedKeyWord("STATS_SAMPLE_PAGES".toLowerCase());
        this.addReservedKeyWord("STATUS".toLowerCase());
        this.addReservedKeyWord("STOP".toLowerCase());
        this.addReservedKeyWord("STORAGE".toLowerCase());
        this.addReservedKeyWord("STORED".toLowerCase());
        this.addReservedKeyWord("STRAIGHT_JOIN".toLowerCase());
        this.addReservedKeyWord("STRING".toLowerCase());
        this.addReservedKeyWord("SUBCLASS_ORIGIN".toLowerCase());
        this.addReservedKeyWord("SUBJECT".toLowerCase());
        this.addReservedKeyWord("SUBPARTITION".toLowerCase());
        this.addReservedKeyWord("SUBPARTITIONS".toLowerCase());
        this.addReservedKeyWord("SUPER".toLowerCase());
        this.addReservedKeyWord("SUSPEND".toLowerCase());
        this.addReservedKeyWord("SWAPS".toLowerCase());
        this.addReservedKeyWord("SWITCHES".toLowerCase());
        this.addReservedKeyWord("TABLE".toLowerCase());
        this.addReservedKeyWord("TABLES".toLowerCase());
        this.addReservedKeyWord("TABLESPACE".toLowerCase());
        this.addReservedKeyWord("TABLE_CHECKSUM".toLowerCase());
        this.addReservedKeyWord("TABLE_NAME".toLowerCase());
        this.addReservedKeyWord("TEMPORARY".toLowerCase());
        this.addReservedKeyWord("TEMPTABLE".toLowerCase());
        this.addReservedKeyWord("TERMINATED".toLowerCase());
        this.addReservedKeyWord("TEXT".toLowerCase());
        this.addReservedKeyWord("THAN".toLowerCase());
        this.addReservedKeyWord("THEN".toLowerCase());
        this.addReservedKeyWord("TIME".toLowerCase());
        this.addReservedKeyWord("TIMESTAMP".toLowerCase());
        this.addReservedKeyWord("TIMESTAMPADD".toLowerCase());
        this.addReservedKeyWord("TIMESTAMPDIFF".toLowerCase());
        this.addReservedKeyWord("TINYBLOB".toLowerCase());
        this.addReservedKeyWord("TINYINT".toLowerCase());
        this.addReservedKeyWord("TINYTEXT".toLowerCase());
        this.addReservedKeyWord("TO".toLowerCase());
        this.addReservedKeyWord("TRAILING".toLowerCase());
        this.addReservedKeyWord("TRANSACTION".toLowerCase());
        this.addReservedKeyWord("TRIGGER".toLowerCase());
        this.addReservedKeyWord("TRIGGERS".toLowerCase());
        this.addReservedKeyWord("TRUE".toLowerCase());
        this.addReservedKeyWord("TRUNCATE".toLowerCase());
        this.addReservedKeyWord("TYPE".toLowerCase());
        this.addReservedKeyWord("TYPES".toLowerCase());
        this.addReservedKeyWord("UNCOMMITTED".toLowerCase());
        this.addReservedKeyWord("UNDEFINED".toLowerCase());
        this.addReservedKeyWord("UNDO".toLowerCase());
        this.addReservedKeyWord("UNDOFILE".toLowerCase());
        this.addReservedKeyWord("UNDO_BUFFER_SIZE".toLowerCase());
        this.addReservedKeyWord("UNICODE".toLowerCase());
        this.addReservedKeyWord("UNINSTALL".toLowerCase());
        this.addReservedKeyWord("UNION".toLowerCase());
        this.addReservedKeyWord("UNIQUE".toLowerCase());
        this.addReservedKeyWord("UNKNOWN".toLowerCase());
        this.addReservedKeyWord("UNLOCK".toLowerCase());
        this.addReservedKeyWord("UNSIGNED".toLowerCase());
        this.addReservedKeyWord("UNTIL".toLowerCase());
        this.addReservedKeyWord("UPDATE".toLowerCase());
        this.addReservedKeyWord("UPGRADE".toLowerCase());
        this.addReservedKeyWord("USAGE".toLowerCase());
        this.addReservedKeyWord("USE".toLowerCase());
        this.addReservedKeyWord("USER".toLowerCase());
        this.addReservedKeyWord("USER_RESOURCES".toLowerCase());
        this.addReservedKeyWord("USE_FRM".toLowerCase());
        this.addReservedKeyWord("USING".toLowerCase());
        this.addReservedKeyWord("UTC_DATE".toLowerCase());
        this.addReservedKeyWord("UTC_TIME".toLowerCase());
        this.addReservedKeyWord("UTC_TIMESTAMP".toLowerCase());
        this.addReservedKeyWord("VALIDATION".toLowerCase());
        this.addReservedKeyWord("VALUE".toLowerCase());
        this.addReservedKeyWord("VALUES".toLowerCase());
        this.addReservedKeyWord("VARBINARY".toLowerCase());
        this.addReservedKeyWord("VARCHAR".toLowerCase());
        this.addReservedKeyWord("VARCHARACTER".toLowerCase());
        this.addReservedKeyWord("VARIABLES".toLowerCase());
        this.addReservedKeyWord("VARYING".toLowerCase());
        this.addReservedKeyWord("VIEW".toLowerCase());
        this.addReservedKeyWord("VIRTUAL".toLowerCase());
        this.addReservedKeyWord("WAIT".toLowerCase());
        this.addReservedKeyWord("WARNINGS".toLowerCase());
        this.addReservedKeyWord("WEEK".toLowerCase());
        this.addReservedKeyWord("WEIGHT_STRING".toLowerCase());
        this.addReservedKeyWord("WHEN".toLowerCase());
        this.addReservedKeyWord("WHERE".toLowerCase());
        this.addReservedKeyWord("WHILE".toLowerCase());
        this.addReservedKeyWord("WITH".toLowerCase());
        this.addReservedKeyWord("WITHOUT".toLowerCase());
        this.addReservedKeyWord("WORK".toLowerCase());
        this.addReservedKeyWord("WRAPPER".toLowerCase());
        this.addReservedKeyWord("WRITE".toLowerCase());
        this.addReservedKeyWord("X509".toLowerCase());
        this.addReservedKeyWord("XA".toLowerCase());
        this.addReservedKeyWord("XID".toLowerCase());
        this.addReservedKeyWord("XML".toLowerCase());
        this.addReservedKeyWord("XOR".toLowerCase());
        this.addReservedKeyWord("YEAR".toLowerCase());
        this.addReservedKeyWord("YEAR_MONTH".toLowerCase());
        this.addReservedKeyWord("ZEROFILL".toLowerCase());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public boolean isUseSequenceTable() {
        return this.useSequenceTable;
    }

    public void setUseSequenceTable(boolean useSequenceTable) {
        this.useSequenceTable = useSequenceTable;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    @Override
    public void attachDatabase(DBDatabase db, Connection conn) {
        try {
            if (StringUtils.isNotEmpty(this.databaseName)) {
                this.executeSQL("USE " + this.databaseName, null, conn, null);
            }
            if (this.useSequenceTable && db.getTable(this.sequenceTableName) == null) {
                new DBMSHandlerBase.DBSeqTable(this.sequenceTableName, db);
            }
            super.attachDatabase(db, conn);
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this, e);
        }
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBCommandMySQL(this, autoPrepareStmt);
    }

    @Override
    public DBSQLBuilder createSQLBuilder() {
        return new DBSQLBuilderMySQL(this);
    }

    @Override
    public DBCommandExpr createCombinedCommand(DBCommandExpr left, String keyWord, DBCommandExpr right) {
        return new DBCombinedCmd(left, keyWord, right){
            protected int limit;
            protected int skip;
            {
                this.limit = -1;
                this.skip = -1;
            }

            @Override
            public DBCommandExpr limitRows(int numRows) {
                this.limit = numRows;
                return this;
            }

            @Override
            public DBCommandExpr skipRows(int numRows) {
                this.skip = numRows;
                return this;
            }

            @Override
            public void clearLimit() {
                this.limit = -1;
                this.skip = -1;
            }

            @Override
            public void getSelect(DBSQLBuilder sql) {
                super.getSelect(sql);
                if (this.limit >= 0) {
                    sql.append("\r\nLIMIT ");
                    sql.append(String.valueOf(this.limit));
                    if (this.skip >= 0) {
                        sql.append(" OFFSET ");
                        sql.append(String.valueOf(this.skip));
                    }
                }
            }
        };
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return this.useSequenceTable;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "`";
            }
            case SQL_QUOTES_CLOSE: {
                return "`";
            }
            case SQL_CONCAT_EXPR: {
                return "concat(?, {0})";
            }
            case SQL_BOOLEAN_TRUE: {
                return "1";
            }
            case SQL_BOOLEAN_FALSE: {
                return "0";
            }
            case SQL_CURRENT_DATE: {
                return "CURRENT_DATE()";
            }
            case SQL_DATE_PATTERN: {
                return "yyyy-MM-dd";
            }
            case SQL_DATE_TEMPLATE: {
                return "STR_TO_DATE('{0}','%Y-%m-%d')";
            }
            case SQL_CURRENT_TIME: {
                return "CURRENT_TIME()";
            }
            case SQL_TIME_PATTERN: {
                return "HH:mm:ss";
            }
            case SQL_TIME_TEMPLATE: {
                return "STR_TO_DATE('{0}','%H:%i:%s')";
            }
            case SQL_DATETIME_PATTERN: {
                return "yyyy-MM-dd HH:mm:ss";
            }
            case SQL_DATETIME_TEMPLATE: {
                return "STR_TO_DATE('{0}','%Y-%m-%d %H:%i:%s')";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "CURRENT_TIMESTAMP()";
            }
            case SQL_TIMESTAMP_PATTERN: {
                return "yyyy-MM-dd HH:mm:ss.SSS";
            }
            case SQL_TIMESTAMP_TEMPLATE: {
                return "STR_TO_DATE('{0}','%Y-%m-%d %H:%i:%s.%f')";
            }
            case SQL_FUNC_COALESCE: {
                return "coalesce(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substring(?, {0})";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substring(?, {0}, {1})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "reverse(?)";
            }
            case SQL_FUNC_STRINDEX: {
                return "instr(?, {0})";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return "locate({0}, ?, {1})";
            }
            case SQL_FUNC_LENGTH: {
                return "length(?)";
            }
            case SQL_FUNC_UPPER: {
                return "upper(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lcase(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "truncate(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceiling(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "mod(?,{0})";
            }
            case SQL_FUNC_FORMAT: {
                return "format(?, {0:INTEGER})";
            }
            case SQL_FUNC_DAY: {
                return "day(?)";
            }
            case SQL_FUNC_MONTH: {
                return "month(?)";
            }
            case SQL_FUNC_YEAR: {
                return "year(?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_DECODE: {
                return "case ? {0} end";
            }
            case SQL_FUNC_DECODE_SEP: {
                return " ";
            }
            case SQL_FUNC_DECODE_PART: {
                return "when {0} then {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "else {0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "CAST(? AS UNSIGNED)";
            }
            case INTEGER: {
                return "CAST(? AS SIGNED)";
            }
            case DECIMAL: {
                return "CAST(? AS DECIMAL)";
            }
            case FLOAT: {
                return "CAST(? AS DECIMAL)";
            }
            case DATE: {
                return "CAST(? AS DATE)";
            }
            case TIME: {
                return "CAST(? AS TIME)";
            }
            case DATETIME: 
            case TIMESTAMP: {
                return "CAST(? AS DATETIME)";
            }
            case VARCHAR: 
            case CHAR: {
                if (format != null) {
                    return "CAST(? AS CHAR " + format.toString() + ")";
                }
                return "CAST(? AS CHAR)";
            }
            case BLOB: {
                return "CAST(? AS BLOB)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        if (this.useSequenceTable) {
            DBTable t = db.getTable(this.sequenceTableName);
            return ((DBMSHandlerBase.DBSeqTable)t).getNextValue(seqName, minValue, conn);
        }
        return null;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new MySQLDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public static class DBSQLBuilderMySQL
    extends DBSQLBuilder {
        public DBSQLBuilderMySQL(DBMSHandlerMySQL dbms) {
            super(dbms);
        }

        @Override
        protected void escapeAndAppendLiteral(String value) {
            if (value.indexOf(39) >= 0 || value.indexOf(92) >= 0) {
                int len = value.length();
                for (int i = 0; i < len; ++i) {
                    if (value.charAt(i) == '\'') {
                        this.sql.append("''");
                        continue;
                    }
                    if (value.charAt(i) == '\\') {
                        this.sql.append("\\\\");
                        continue;
                    }
                    this.sql.append(value.charAt(i));
                }
            } else {
                this.sql.append(value);
            }
        }
    }

    public static class DBCommandMySQL
    extends DBCommand {
        protected int limit = -1;
        protected int skip = -1;

        public DBCommandMySQL(DBMSHandlerMySQL dbms, boolean autoPrepareStmt) {
            super(dbms, autoPrepareStmt);
        }

        @Override
        public DBCommand limitRows(int numRows) {
            this.limit = numRows;
            return this;
        }

        @Override
        public DBCommand skipRows(int numRows) {
            this.skip = numRows;
            return this;
        }

        @Override
        public void clearLimit() {
            this.limit = -1;
            this.skip = -1;
        }

        @Override
        public void getSelect(DBSQLBuilder sql) {
            super.getSelect(sql);
            if (this.limit >= 0) {
                sql.append("\r\nLIMIT ");
                sql.append(String.valueOf(this.limit));
                if (this.skip >= 0) {
                    sql.append(" OFFSET ");
                    sql.append(String.valueOf(this.skip));
                }
            }
        }

        @Override
        protected void addDeleteWithJoins(DBSQLBuilder sql, DBRowSet table) {
            sql.append(table.getAlias());
            this.addFrom(sql);
            this.addWhere(sql);
        }
    }
}

