/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBUtils;
import org.apache.empire.db.context.DBContextAware;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSQLScript
implements DBContextAware,
Iterable<String> {
    private static final Logger log = LoggerFactory.getLogger(DBSQLScript.class);
    private static final String DEFAULT_COMMAND_SEPARATOR = ";\r\n\r\n";
    protected String commandSeparator = ";\r\n\r\n";
    protected ArrayList<SQLStmt> sqlStmtList = new ArrayList();
    protected final DBContext context;

    public DBSQLScript(DBContext context) {
        this.context = context;
    }

    public DBSQLScript(DBContext context, String commandSeparator) {
        this(context);
        this.commandSeparator = commandSeparator;
    }

    @Override
    public DBContext getContext() {
        return this.context;
    }

    public void addStmt(String sql) {
        this.sqlStmtList.add(new SQLStmt(sql, null));
    }

    public void addStmt(String sql, Object[] params) {
        this.sqlStmtList.add(new SQLStmt(sql, params));
    }

    public final void addStmt(DBSQLBuilder sql) {
        this.addStmt(sql.toString());
        sql.reset(0);
    }

    public void addInsert(DBCommand cmd) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        this.addStmt(cmd.getInsert(), cmd.getParamValues());
    }

    public void addUpdate(DBCommand cmd) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        this.addStmt(cmd.getUpdate(), cmd.getParamValues());
    }

    public void addDelete(DBCommand cmd, DBTable table) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        this.addStmt(cmd.getDelete(table), cmd.getParamValues());
    }

    public int getCount() {
        return this.sqlStmtList.size();
    }

    public String getStmt(int i) {
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        return this.sqlStmtList.get(i).getCmd();
    }

    public Object[] getStmtParams(int i) {
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        return this.sqlStmtList.get(i).getParams();
    }

    public void insertStmt(int i, String stmt, Object[] params) {
        if (stmt == null) {
            throw new InvalidArgumentException("stmt", stmt);
        }
        if (i < 0 || i > this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        this.sqlStmtList.add(i, new SQLStmt(stmt, params));
    }

    public final void insertStmt(int i, String stmt) {
        this.insertStmt(i, stmt, null);
    }

    public void replaceStmt(int i, String cmd, Object[] params) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        SQLStmt stmt = this.sqlStmtList.get(i);
        stmt.setCmd(cmd);
        stmt.setParams(params);
    }

    public final void replaceStmt(int i, String cmd) {
        this.replaceStmt(i, cmd, null);
    }

    public void removeStmt(int i) {
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        this.sqlStmtList.remove(i);
    }

    public void clear() {
        this.sqlStmtList.clear();
    }

    public int executeAll(boolean ignoreErrors) {
        log.info("Running script containing " + String.valueOf(this.getCount()) + " statements.");
        int errors = 0;
        int result = 0;
        DBMSHandler dbms = this.context.getDbms();
        Connection conn = this.context.getConnection();
        DBUtils utils = this.context.getUtils();
        for (SQLStmt stmt : this.sqlStmtList) {
            try {
                int count;
                String sqlCmd = stmt.getCmd();
                Object[] sqlParams = stmt.getParams();
                if (log.isDebugEnabled()) {
                    if (sqlParams != null && sqlParams.length > 0) {
                        log.debug("Executing Stmt: {}{}{}Parameters: [{}]", new Object[]{utils.LOG_NEW_LINE, sqlCmd, utils.LOG_NEW_LINE, utils.paramsToString(sqlParams)});
                    } else {
                        log.debug("Executing Stmt: {}{}", (Object)utils.LOG_NEW_LINE, (Object)sqlCmd);
                    }
                }
                result += (count = dbms.executeSQL(sqlCmd, sqlParams, conn, null)) >= 0 ? count : 0;
            }
            catch (SQLException e) {
                log.warn("Statement '" + stmt.getCmd() + "' failed with SQLException " + e.toString(), (Throwable)e);
                if (!ignoreErrors) {
                    throw new EmpireSQLException(dbms, e);
                }
                log.debug("Ignoring error. Continuing with script...");
                ++errors;
            }
        }
        log.info("Script completed with {} errors. {} records affected.", (Object)errors, (Object)result);
        return result;
    }

    public final int executeAll() {
        return this.executeAll(false);
    }

    public int executeBatch() {
        DBMSHandler dbms = this.context.getDbms();
        try {
            int count = this.sqlStmtList.size();
            String[] cmdList = new String[count];
            Object[][] paramList = null;
            int i = 0;
            for (SQLStmt stmt : this.sqlStmtList) {
                cmdList[i] = stmt.getCmd();
                if (stmt.getParams() != null) {
                    if (paramList == null) {
                        paramList = new Object[count][];
                    }
                    paramList[i] = stmt.getParams();
                }
                ++i;
            }
            log.info("Running batch containing " + String.valueOf(this.getCount()) + " statements.");
            int[] res = dbms.executeBatch(cmdList, paramList, this.context.getConnection());
            count = 0;
            for (i = 0; i < (res != null ? res.length : 0); ++i) {
                count += res[i] >= 0 ? res[i] : 0;
            }
            log.info("Script completed. {} records affected.", (Object)count);
            return count;
        }
        catch (SQLException e) {
            log.warn("Execute Batch failed with SQLException " + e.toString(), (Throwable)e);
            throw new EmpireSQLException(dbms, e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new SQLStmtIterator(this.sqlStmtList.iterator());
    }

    public String toString() {
        StringBuilder script = new StringBuilder();
        for (SQLStmt stmt : this.sqlStmtList) {
            script.append(stmt.getCmd());
            script.append(this.commandSeparator);
        }
        return script.toString();
    }

    private static class SQLStmtIterator
    implements Iterator<String> {
        private final Iterator<SQLStmt> iterator;

        private SQLStmtIterator(Iterator<SQLStmt> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next().getCmd();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    protected static class SQLStmt {
        private String cmd;
        private Object[] params;

        public SQLStmt(String cmd, Object[] params) {
            this.cmd = cmd;
            this.params = params;
        }

        public String getCmd() {
            return this.cmd;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }
    }
}

