/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBQueryColumn;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBUtils;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.RecordUpdateAmbiguousException;
import org.apache.empire.db.exceptions.RecordUpdateFailedException;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;

public class DBQuery
extends DBRowSet {
    private static AtomicInteger queryCount = new AtomicInteger(0);
    protected final DBCommandExpr cmdExpr;
    protected final DBColumn[] keyColumns;
    protected final DBQueryColumn[] queryColumns;
    protected final String alias;

    public DBQuery(DBCommandExpr cmd, DBColumn[] keyColumns, String alias) {
        super((DBDatabase)cmd.getDatabase());
        this.cmdExpr = cmd;
        this.alias = alias;
        DBColumnExpr[] exprList = cmd.getSelectExprList();
        this.queryColumns = new DBQueryColumn[exprList.length];
        for (int i = 0; i < exprList.length; ++i) {
            this.queryColumns[i] = this.createQueryColumn(exprList[i], i);
            DBColumn column = exprList[i] instanceof DBColumn ? (DBColumn)exprList[i] : new DBQueryExprColumn(this, this.queryColumns[i].getName(), exprList[i]);
            this.columns.add(column);
        }
        this.keyColumns = keyColumns;
    }

    public DBQuery(DBCommandExpr cmd, DBColumn[] keyColumns) {
        this(cmd, keyColumns, "q" + String.valueOf(queryCount.incrementAndGet()));
    }

    public DBQuery(DBCommandExpr cmd, DBColumn keyColumn, String alias) {
        this(cmd, new DBColumn[]{keyColumn}, alias);
    }

    public DBQuery(DBCommandExpr cmd, DBColumn keyColumn) {
        this(cmd, new DBColumn[]{keyColumn});
    }

    public DBQuery(DBCommandExpr cmd, String alias) {
        this(cmd, (DBColumn[])null, alias);
    }

    public DBQuery(DBCommandExpr cmd) {
        this(cmd, (DBColumn[])null);
    }

    public DBCommandExpr getCommandExpr() {
        return this.cmdExpr;
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isUpdateable() {
        return this.getKeyColumns() != null;
    }

    public DBQueryColumn[] getQueryColumns() {
        return this.queryColumns;
    }

    public DBQueryColumn findColumn(DBColumnExpr expr) {
        for (int i = 0; i < this.queryColumns.length; ++i) {
            if (!ObjectUtils.compareEqual(this.queryColumns[i].getExpr(), expr)) continue;
            return this.queryColumns[i];
        }
        return null;
    }

    public DBQueryColumn findColumn(String name) {
        for (int i = 0; i < this.queryColumns.length; ++i) {
            if (!StringUtils.compareEqual(this.queryColumns[i].getName(), name, true)) continue;
            return this.queryColumns[i];
        }
        return null;
    }

    public DBQueryColumn column(DBColumnExpr expr) {
        DBQueryColumn col = this.findColumn(expr);
        if (col == null) {
            throw new ItemNotFoundException(expr);
        }
        return col;
    }

    public DBQueryColumn column(String name) {
        DBQueryColumn col = this.findColumn(name);
        if (col == null) {
            throw new ItemNotFoundException((Object)name);
        }
        return col;
    }

    @Override
    public DBColumn[] getKeyColumns() {
        return this.keyColumns;
    }

    protected Object[] getRecordKey(DBRecordBase record) {
        if (record == null || record.getRowSet() != this) {
            throw new InvalidArgumentException("record", record);
        }
        Object rowSetData = this.getRowsetData(record);
        if (rowSetData instanceof Object[]) {
            return (Object[])rowSetData;
        }
        return record.getKey();
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        sql.append("(");
        sql.append(this.cmdExpr);
        sql.append(")");
        if ((context & 8L) != 0L && this.alias != null) {
            sql.append(" ");
            sql.append(this.alias);
        }
    }

    @Override
    public void initRecord(DBRecordBase record, DBRecordData recData) {
        super.initRecord(record, recData);
        if (this.keyColumns != null) {
            Object[] rowsetData = this.getRowsetData(record);
            if (rowsetData != null && !(rowsetData instanceof Object[]) && ((Object[])rowsetData).length != this.keyColumns.length) {
                throw new InvalidArgumentException("rowSetData", (Object)rowsetData);
            }
            if (rowsetData == null) {
                Object[] recordKey = new Object[this.keyColumns.length];
                for (int i = 0; i < recordKey.length; ++i) {
                    recordKey[i] = recData.get(this.keyColumns[i]);
                }
                rowsetData = recordKey;
                this.setRowsetData(record, rowsetData);
            }
        }
    }

    @Override
    public void createRecord(DBRecordBase record, Object[] initalKey, boolean deferredInit) {
        throw new NotImplementedException(this, "createRecord");
    }

    @Override
    public void readRecord(DBRecordBase record, DBCompareExpr whereConstraints) {
        if (record == null || whereConstraints == null) {
            throw new InvalidArgumentException("record|key", null);
        }
        DBCommand cmd = this.getCommandFromExpression();
        cmd.where(whereConstraints);
        this.readRecord(record, cmd);
    }

    public void updateRecord(DBRecordBase record) {
        if (!this.isUpdateable()) {
            throw new NotSupportedException(this, "updateRecord");
        }
        if (record == null) {
            throw new InvalidArgumentException("record", null);
        }
        if (!record.isModified()) {
            return;
        }
        DBColumn[] keyColumns = this.getKeyColumns();
        if (keyColumns == null) {
            throw new NoPrimaryKeyException(this);
        }
        Object[] fields = record.getFields();
        DBContext context = record.getContext();
        HashMap<DBRowSet, DBCommand> updCmds = new HashMap<DBRowSet, DBCommand>(3);
        for (int i = 0; i < this.columns.size(); ++i) {
            boolean modified;
            DBColumn col = (DBColumn)this.columns.get(i);
            if (col == null) continue;
            DBRowSet table = col.getRowSet();
            DBCommand updCmd = (DBCommand)updCmds.get(table);
            if (updCmd == null) {
                updCmd = this.createRecordCommand(context);
                updCmds.put(table, updCmd);
            }
            if (!(modified = record.wasModified(i))) continue;
            if (col.isReadOnly() && log.isDebugEnabled()) {
                log.debug("updateRecord: Read-only column '" + col.getName() + " has been modified!");
            }
            col.validateValue(fields[i]);
            updCmd.set(col.to(fields[i]));
        }
        Connection conn = context.getConnection();
        DBCommand cmd = this.getCommandFromExpression();
        Object[] key = this.getRecordKey(record);
        DBRowSet table = null;
        DBCommand upd = null;
        for (Map.Entry entry : updCmds.entrySet()) {
            DBUtils utils;
            int affected;
            int i = 0;
            table = (DBRowSet)entry.getKey();
            upd = (DBCommand)entry.getValue();
            if (upd.set == null) continue;
            for (i = 0; cmd.joins != null && i < cmd.joins.size(); ++i) {
                DBJoinExpr jex = cmd.joins.get(i);
                if (!(jex instanceof DBColumnJoinExpr)) continue;
                DBColumnJoinExpr join = (DBColumnJoinExpr)jex;
                DBColumn left = join.getLeft().getUpdateColumn();
                DBColumn right = join.getRight().getUpdateColumn();
                if (left.getRowSet() == table && table.isKeyColumn(left) && !this.addJoinRestriction(upd, left, right, keyColumns, key, record)) {
                    throw new ItemNotFoundException((Object)left.getFullName());
                }
                if (right.getRowSet() != table || !table.isKeyColumn(right) || this.addJoinRestriction(upd, right, left, keyColumns, key, record)) continue;
                throw new ItemNotFoundException((Object)right.getFullName());
            }
            for (i = 0; cmd.where != null && i < cmd.where.size(); ++i) {
                DBCompareExpr cmp = cmd.where.get(i);
                if (cmp instanceof DBCompareColExpr) {
                    DBCompareColExpr cmpExpr = (DBCompareColExpr)cmp;
                    DBColumn col = cmpExpr.getColumnExpr().getUpdateColumn();
                    if (col == null || col.getRowSet() != table) continue;
                    if (cmpExpr.getValue() instanceof DBCmdParam) {
                        DBColumnExpr colExpr = cmpExpr.getColumnExpr();
                        DBCmdParam param = (DBCmdParam)cmpExpr.getValue();
                        DBCmdParam value = upd.addParam(colExpr, param.getValue());
                        cmp = new DBCompareColExpr(colExpr, cmpExpr.getCmpOperator(), value);
                    }
                    upd.where(cmp);
                    continue;
                }
                throw new NotSupportedException(this, "updateRecord with " + cmp.getClass().getName());
            }
            for (i = 0; i < keyColumns.length; ++i) {
                if (keyColumns[i].getRowSet() != table) continue;
                Object value = key[i];
                upd.where((DBCompareExpr)keyColumns[i].is(value));
            }
            int timestampIndex = -1;
            Timestamp timestampValue = null;
            if (table.getTimestampColumn() != null) {
                DBColumn tsColumn = table.getTimestampColumn();
                timestampIndex = this.getColumnIndex(tsColumn);
                if (timestampIndex >= 0) {
                    timestampValue = context.getDbms().getUpdateTimestamp(conn);
                    Object lastTS = fields[timestampIndex];
                    if (!ObjectUtils.isEmpty(lastTS)) {
                        upd.where((DBCompareExpr)tsColumn.is(lastTS));
                    }
                    upd.set(tsColumn.to(timestampValue));
                } else {
                    upd.set(tsColumn.to(DBDatabase.SYSDATE));
                }
            }
            if ((affected = (utils = context.getUtils()).executeSQL(upd.getUpdate(), upd.getParamValues(), null)) <= 0) {
                if (affected == 0) {
                    throw new RecordUpdateFailedException(this, key);
                }
                return;
            }
            if (affected > 1) {
                throw new RecordUpdateAmbiguousException(this, key);
            }
            log.info("Record for table '" + table.getName() + " successfully updated!");
            if (timestampIndex < 0) continue;
            fields[timestampIndex] = timestampValue;
        }
        record.updateComplete();
    }

    @Override
    public void deleteRecord(Object[] key, DBContext context) {
        throw new NotImplementedException(this, "deleteRecord()");
    }

    protected boolean addJoinRestriction(DBCommand cmd, DBColumn updCol, DBColumn joinCol, DBColumn[] keyColumns, Object[] key, DBRecordBase record) {
        for (int i = 0; key != null && i < keyColumns.length; ++i) {
            if (keyColumns[i] != joinCol) continue;
            cmd.where((DBCompareExpr)updCol.is(key[i]));
            return true;
        }
        int index = this.getColumnIndex(updCol);
        if (index < 0) {
            index = this.getColumnIndex(joinCol);
        }
        if (index >= 0) {
            if (record.wasModified(index)) {
                return false;
            }
            cmd.where((DBCompareExpr)updCol.is(record.getValue(index)));
            return true;
        }
        return false;
    }

    protected DBCommand getCommandFromExpression() {
        if (this.cmdExpr instanceof DBCommand) {
            return (DBCommand)this.cmdExpr;
        }
        throw new NotSupportedException(this, "getCommand");
    }

    protected DBQueryColumn createQueryColumn(DBColumnExpr expr, int index) {
        String name = expr.getName();
        if (StringUtils.isEmpty(name)) {
            name = "COL_" + String.valueOf(index);
        }
        return new DBQueryColumn(this, name, expr);
    }

    @Override
    public int getColumnIndex(ColumnExpr columnExpr) {
        if (columnExpr instanceof DBColumn) {
            return this.getColumnIndex((DBColumn)columnExpr);
        }
        for (int i = 0; i < this.queryColumns.length; ++i) {
            DBColumnExpr expr = this.queryColumns[i].getExpr();
            if (!expr.equals(columnExpr)) continue;
            return i;
        }
        ColumnExpr unwrapped = ObjectUtils.unwrap(columnExpr);
        if (unwrapped != columnExpr) {
            return this.getColumnIndex(unwrapped);
        }
        return -1;
    }

    @Override
    public int getColumnIndex(DBColumn column) {
        int index = this.columns.indexOf(column);
        if (index >= 0) {
            return index;
        }
        index = 0;
        for (DBColumn c : this.columns) {
            if (c instanceof DBQueryExprColumn && column.equals(c.getUpdateColumn())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    protected DBColumnExpr getColumnExprAt(int index) {
        DBColumn column = (DBColumn)this.columns.get(index);
        if (column instanceof DBQueryColumn) {
            return ((DBQueryExprColumn)column).expr;
        }
        return column;
    }

    protected static class DBQueryExprColumn
    extends DBQueryColumn {
        protected DBQueryExprColumn(DBQuery q, String name, DBColumnExpr expr) {
            super(q, name, expr);
        }

        @Override
        public DBColumn getUpdateColumn() {
            return this.expr.getUpdateColumn();
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other)) {
                return true;
            }
            if (other instanceof DBQueryColumn) {
                DBQueryColumn oc = (DBQueryColumn)other;
                return this.rowset.equals(oc.getRowSet()) && this.expr.equals(oc.getExpr());
            }
            return false;
        }
    }
}

