/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBCmdParamList;
import org.apache.empire.db.DBCmdParams;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.compare.DBCompareAndOrExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.compare.DBCompareNotExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBCompareJoinExpr;
import org.apache.empire.db.expr.join.DBCrossJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.db.expr.order.DBOrderByExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBCommand
extends DBCommandExpr
implements Cloneable {
    protected static final Logger log = LoggerFactory.getLogger(DBCommand.class);
    protected boolean selectDistinct = false;
    protected List<DBColumnExpr> select = null;
    protected List<DBSetExpr> set = null;
    protected List<DBJoinExpr> joins = null;
    protected List<DBCompareExpr> where = null;
    protected List<DBCompareExpr> having = null;
    protected List<DBColumnExpr> groupBy = null;
    protected Set<DBRowSet> parentTables = null;
    protected boolean autoPrepareStmt = false;
    protected DBCmdParamList cmdParams;

    @Override
    protected DBSQLBuilder createSQLBuilder(String initalSQL) {
        DBSQLBuilder sql = super.createSQLBuilder(initalSQL);
        sql.setCmdParams(this.cmdParams);
        return sql;
    }

    protected DBCommand(DBMSHandler dbms, boolean autoPrepareStmt, DBCmdParamList cmdParams) {
        super(dbms);
        this.autoPrepareStmt = autoPrepareStmt;
        this.cmdParams = cmdParams;
    }

    protected DBCommand(DBMSHandler dbms, boolean autoPrepareStmt) {
        this(dbms, autoPrepareStmt, new DBCmdParamList());
    }

    public final boolean isAutoPrepareStmt() {
        return this.autoPrepareStmt;
    }

    @Override
    public DBCommand clone() {
        DBCommand clone = (DBCommand)super.clone();
        if (this.select != null) {
            clone.select = new ArrayList<DBColumnExpr>(this.select);
        }
        if (this.set != null) {
            clone.set = new ArrayList<DBSetExpr>(this.set);
        }
        if (this.joins != null) {
            clone.joins = new ArrayList<DBJoinExpr>(this.joins);
        }
        if (this.where != null) {
            clone.where = new ArrayList<DBCompareExpr>(this.where);
        }
        if (this.groupBy != null) {
            clone.groupBy = new ArrayList<DBColumnExpr>(this.groupBy);
        }
        if (this.having != null) {
            clone.having = new ArrayList<DBCompareExpr>(this.having);
        }
        clone.cmdParams = new DBCmdParamList(this.cmdParams.size());
        if (!this.cmdParams.isEmpty()) {
            int i;
            for (i = 0; clone.set != null && i < clone.set.size(); ++i) {
                clone.set.set(i, clone.set.get(i).copy(clone));
            }
            for (i = 0; clone.joins != null && i < clone.joins.size(); ++i) {
                clone.joins.set(i, clone.joins.get(i).copy(clone));
            }
            for (i = 0; clone.where != null && i < clone.where.size(); ++i) {
                clone.where.set(i, clone.where.get(i).copy(clone));
            }
            for (i = 0; clone.having != null && i < clone.having.size(); ++i) {
                clone.having.set(i, clone.having.get(i).copy(clone));
            }
        }
        return clone;
    }

    public final DBDatabase getDatabase() {
        if (this.hasSelectExpr()) {
            return this.select.get(0).getDatabase();
        }
        if (this.hasSetExpr()) {
            return this.set.get(0).getDatabase();
        }
        if (this.where != null && !this.where.isEmpty()) {
            return this.where.get(0).getDatabase();
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            return ((DBOrderByExpr)this.orderBy.get(0)).getDatabase();
        }
        throw new ObjectNotValidException(this);
    }

    @Override
    public DBCmdParams getParams() {
        return this.cmdParams;
    }

    protected void resetParamUsage() {
        this.cmdParams.resetParamUsage(this);
    }

    protected void completeParamUsage() {
        this.cmdParams.completeParamUsage(this);
    }

    protected void removeCommandParams(DBCompareExpr cmpExpr) {
        if (this.cmdParams.isEmpty()) {
            return;
        }
        if (cmpExpr instanceof DBCompareColExpr) {
            DBCompareColExpr cmp = (DBCompareColExpr)cmpExpr;
            if (cmp.getValue() instanceof DBCmdParam) {
                DBCmdParam param = (DBCmdParam)cmp.getValue();
                cmp.setValue(param.getValue());
                this.cmdParams.remove(param);
            }
        } else if (cmpExpr instanceof DBCompareAndOrExpr) {
            this.removeCommandParams(((DBCompareAndOrExpr)cmpExpr).getLeft());
            this.removeCommandParams(((DBCompareAndOrExpr)cmpExpr).getRight());
        } else if (cmpExpr instanceof DBCompareNotExpr) {
            this.removeCommandParams(((DBCompareNotExpr)cmpExpr).getExpr());
        } else if (ObjectUtils.isWrapper(cmpExpr)) {
            this.removeCommandParams(ObjectUtils.unwrap(cmpExpr));
        }
    }

    protected void removeAllCommandParams(List<DBCompareExpr> list) {
        if (list == null) {
            return;
        }
        for (DBCompareExpr cmp : list) {
            this.removeCommandParams(cmp);
        }
    }

    public void setParentTables(DBRowSet ... rowSets) {
        if (rowSets.length > 0) {
            this.parentTables = new HashSet<DBRowSet>(rowSets.length);
            for (DBRowSet r : rowSets) {
                this.parentTables.add(r);
            }
        } else {
            this.parentTables = null;
        }
    }

    @Override
    public boolean isValid() {
        return this.hasSelectExpr() || this.hasSetExpr();
    }

    public DBCommand selectDistinct() {
        this.selectDistinct = true;
        return this;
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    public boolean hasSelectExpr() {
        return this.select != null && !this.select.isEmpty();
    }

    @Override
    public boolean hasSelectExpr(DBColumnExpr expr) {
        return this.select != null ? this.select.indexOf(expr) >= 0 : false;
    }

    @Override
    public DataType getDataType() {
        if (this.select == null || this.select.size() != 1) {
            return DataType.UNKNOWN;
        }
        return this.select.get(0).getDataType();
    }

    public DBCommand select(DBColumnExpr expr) {
        if (this.select == null) {
            this.select = new ArrayList<DBColumnExpr>();
        }
        if (expr != null && !this.select.contains(expr)) {
            this.select.add(expr);
        }
        return this;
    }

    public final DBCommand select(DBColumnExpr ... exprs) {
        for (DBColumnExpr expr : exprs) {
            this.select(expr);
        }
        return this;
    }

    public final DBCommand select(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.select(dBColumnExpr);
        }
        return this;
    }

    public DBCommand selectQualified(DBColumnExpr ... columns) {
        for (DBColumnExpr col : columns) {
            this.select(col.qualified());
        }
        return this;
    }

    public final DBCommand selectQualified(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.select(dBColumnExpr.qualified());
        }
        return this;
    }

    public DBCommand qualifyAll() {
        if (this.select == null) {
            return this;
        }
        for (int i = 0; i < this.select.size(); ++i) {
            DBColumnExpr expr = this.select.get(i);
            if (expr instanceof DBColumn || expr instanceof DBAliasExpr) continue;
            this.select.set(i, expr.qualified());
        }
        return this;
    }

    @Override
    public DBColumnExpr[] getSelectExprList() {
        int count;
        int n = count = this.select != null ? this.select.size() : 0;
        if (count < 1) {
            return null;
        }
        DBColumnExpr[] exprList = new DBColumnExpr[count];
        for (int i = 0; i < count; ++i) {
            exprList[i] = this.select.get(i);
        }
        return exprList;
    }

    @Override
    public List<DBColumnExpr> getSelectExpressions() {
        return this.select != null ? Collections.unmodifiableList(this.select) : null;
    }

    public void replaceSelect(DBColumnExpr replExpr, DBColumnExpr replWith) {
        int idx;
        int n = idx = this.select != null ? this.select.indexOf(replExpr) : -1;
        if (idx < 0) {
            throw new ItemNotFoundException(replExpr);
        }
        if (replWith != null) {
            this.select.set(idx, replWith);
        } else {
            this.select.remove(idx);
        }
    }

    public void removeSelect(DBColumnExpr ... exprs) {
        if (this.select == null) {
            return;
        }
        for (int i = 0; i < exprs.length; ++i) {
            int idx = this.select.indexOf(exprs[i]);
            if (idx < 0) continue;
            this.select.remove(idx);
        }
    }

    public boolean hasAggegation() {
        for (DBColumnExpr expr : this.select) {
            if (!expr.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public DBCommand set(DBSetExpr expr) {
        if (this.set == null) {
            this.set = new ArrayList<DBSetExpr>();
        }
        for (int i = 0; i < this.set.size(); ++i) {
            DBSetExpr chk = this.set.get(i);
            if (!chk.column.equals(expr.column)) continue;
            if (this.useCmdParam(expr.column, expr.value)) {
                if (chk.value instanceof DBCmdParam) {
                    ((DBCmdParam)chk.value).setValue(expr.value);
                    expr.value = chk.value;
                    chk.value = null;
                } else {
                    expr.value = this.addParam(expr.column.getDataType(), expr.value);
                }
            } else if (chk.value instanceof DBCmdParam) {
                this.cmdParams.remove((DBCmdParam)chk.value);
            }
            this.set.set(i, expr);
            return this;
        }
        if (this.useCmdParam(expr.column, expr.value)) {
            expr.value = this.addParam(expr.column.getDataType(), expr.value);
        }
        this.set.add(expr);
        return this;
    }

    public final DBCommand set(DBSetExpr ... exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.set(exprs[i]);
        }
        return this;
    }

    public boolean hasSetExpr() {
        return this.set != null ? !this.set.isEmpty() : false;
    }

    protected boolean hasSetExprOn(DBColumn column) {
        if (this.set == null) {
            return false;
        }
        for (DBSetExpr setExpr : this.set) {
            if (!setExpr.column.equals(column)) continue;
            return true;
        }
        return false;
    }

    public List<DBSetExpr> getSetExpressions() {
        return this.set != null ? Collections.unmodifiableList(this.set) : null;
    }

    public DBCmdParam addParam(DataType type, Object value) {
        DBCmdParam param = new DBCmdParam(this, type, value);
        this.cmdParams.add(param);
        return param;
    }

    public final DBCmdParam addParam(DBColumnExpr colExpr, Object value) {
        return this.addParam(colExpr.getDataType(), value);
    }

    public final DBCmdParam addParam(Object value) {
        return this.addParam(DataType.UNKNOWN, value);
    }

    public final DBCmdParam addParam() {
        return this.addParam(DataType.UNKNOWN, null);
    }

    public DBCommand join(DBJoinExpr join) {
        if (join.getLeftTable().equals(join.getRightTable())) {
            throw new ObjectNotValidException(join, "The rowsets of a join expression must not be the same!");
        }
        if (this.joins == null) {
            this.joins = new ArrayList<DBJoinExpr>();
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            DBJoinExpr item = this.joins.get(i);
            if (!item.equals(join)) continue;
            return this;
        }
        this.joins.add(join);
        if (this.isPreparedStatementsEnabled()) {
            join.prepareCommand(this);
        }
        return this;
    }

    public final DBCommand join(DBJoinExpr join, DBJoinType joinType) {
        join.setType(joinType);
        return this.join(join);
    }

    public final DBCommand joinLeft(DBJoinExpr join) {
        return this.join(join, DBJoinType.LEFT);
    }

    public final DBCommand joinRight(DBJoinExpr join) {
        return this.join(join, DBJoinType.RIGHT);
    }

    public final DBCommand join(DBColumnExpr left, DBColumn right, DBCompareExpr ... addlConstraints) {
        return this.join(left, right, DBJoinType.INNER, addlConstraints);
    }

    public final DBCommand joinLeft(DBColumnExpr left, DBColumn right, DBCompareExpr ... addlConstraints) {
        return this.join(left, right, DBJoinType.LEFT, addlConstraints);
    }

    public final DBCommand joinRight(DBColumnExpr left, DBColumn right, DBCompareExpr ... addlConstraints) {
        return this.join(left, right, DBJoinType.RIGHT, addlConstraints);
    }

    public final DBCommand join(DBColumnExpr left, DBColumn right, DBJoinType joinType, DBCompareExpr ... addlConstraints) {
        if (left == null || right == null || left.getRowSet() == null) {
            throw new InvalidArgumentException("left|right", left);
        }
        if (left.getRowSet() == right.getRowSet()) {
            throw new InvalidArgumentException("rowset", left.getRowSet().getName() + "|" + right.getRowSet().getName());
        }
        DBCompareExpr where = null;
        for (int i = 0; i < addlConstraints.length; ++i) {
            DBCompareExpr cmpExpr = addlConstraints[i];
            if (cmpExpr == null) continue;
            where = where != null ? where.and(cmpExpr) : cmpExpr;
        }
        DBColumnJoinExpr join = new DBColumnJoinExpr(left, right, joinType, where);
        this.join(join);
        return this;
    }

    public final DBCommand join(DBColumn[] left, DBColumn[] right, DBJoinType joinType, DBCompareExpr ... addlConstraints) {
        DBCompareExpr cmpExpr;
        int i;
        if (left == null || right == null || left.length == 0 || left.length != right.length) {
            throw new InvalidArgumentException("left|right", left);
        }
        if (left[0].getRowSet() == right[0].getRowSet()) {
            throw new InvalidArgumentException("rowset", left[0].getRowSet().getName() + "|" + right[0].getRowSet().getName());
        }
        DBCompareExpr where = null;
        for (i = 1; i < left.length; ++i) {
            cmpExpr = right[i].is(left[i]);
            where = where != null ? where.and(cmpExpr) : cmpExpr;
        }
        for (i = 0; i < addlConstraints.length; ++i) {
            cmpExpr = addlConstraints[i];
            where = where != null ? where.and(cmpExpr) : cmpExpr;
        }
        DBColumnJoinExpr join = new DBColumnJoinExpr(left[0], right[0], joinType, where);
        this.join(join);
        return this;
    }

    public final DBCommand join(DBRowSet left, DBRowSet right) {
        DBCrossJoinExpr join = new DBCrossJoinExpr(left, right);
        this.join(join);
        return this;
    }

    public final DBCommand join(DBRowSet rowset, DBCompareExpr cmp, DBJoinType joinType) {
        DBCompareJoinExpr join = new DBCompareJoinExpr(rowset, cmp, joinType);
        this.join(join);
        return this;
    }

    public final DBCommand join(DBRowSet rowset, DBCompareExpr cmp) {
        return this.join(rowset, cmp, DBJoinType.INNER);
    }

    public void addJoins(List<DBJoinExpr> joinExprList) {
        if (this.joins == null) {
            this.joins = new ArrayList<DBJoinExpr>();
        }
        this.joins.addAll(joinExprList);
    }

    public boolean hasJoinOn(DBRowSet rowset) {
        if (this.joins == null) {
            return false;
        }
        for (DBJoinExpr join : this.joins) {
            if (!join.isJoinOn(rowset)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConstraintOn(DBRowSet rowset) {
        if (this.where == null && this.having == null) {
            return false;
        }
        int i = 0;
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        for (i = 0; this.where != null && i < this.where.size(); ++i) {
            ((DBExpr)this.where.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.having != null && i < this.having.size(); ++i) {
            ((DBExpr)this.having.get(i)).addReferencedColumns(columns);
        }
        for (DBColumn col : columns) {
            DBRowSet table = col.getRowSet();
            if (!table.equals(rowset)) continue;
            return true;
        }
        return false;
    }

    public boolean hasJoinOn(DBColumn column) {
        if (this.joins == null) {
            return false;
        }
        for (DBJoinExpr join : this.joins) {
            if (!join.isJoinOn(column)) continue;
            return true;
        }
        return false;
    }

    public boolean removeJoinsOn(DBRowSet rowset) {
        if (this.joins == null) {
            return false;
        }
        int size = this.joins.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!this.joins.get(i).isJoinOn(rowset)) continue;
            this.joins.remove(i);
        }
        return size != this.joins.size();
    }

    public boolean removeJoinsOn(DBColumn column) {
        if (this.joins == null) {
            return false;
        }
        int size = this.joins.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!this.joins.get(i).isJoinOn(column)) continue;
            this.joins.remove(i);
        }
        return size != this.joins.size();
    }

    public DBCommand where(DBCompareExpr expr) {
        if (this.where == null) {
            this.where = new ArrayList<DBCompareExpr>();
        }
        this.setConstraint(this.where, expr);
        return this;
    }

    public final DBCommand where(DBCompareExpr ... exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.where(exprs[i]);
        }
        return this;
    }

    public boolean hasWhereConstraints() {
        return this.where != null && this.where.size() > 0;
    }

    public List<DBCompareExpr> getWhereConstraints() {
        return this.where != null ? Collections.unmodifiableList(this.where) : null;
    }

    public boolean removeWhereConstraint(DBCompareExpr cmpExpr) {
        return this.removeConstraint(this.where, cmpExpr);
    }

    public DBCompareExpr removeWhereConstraintOn(DBColumnExpr col) {
        return this.removeConstraintOn(this.where, col);
    }

    public boolean hasWhereConstraintOn(DBColumnExpr col) {
        return this.findConstraintOn(this.where, col) != null;
    }

    public List<DBJoinExpr> getJoins() {
        return this.joins != null ? Collections.unmodifiableList(this.joins) : null;
    }

    public void addWhereConstraints(List<DBCompareExpr> constraints) {
        if (this.where == null) {
            this.where = new ArrayList<DBCompareExpr>();
        }
        this.where.addAll(constraints);
    }

    public DBCommand having(DBCompareExpr expr) {
        if (this.having == null) {
            this.having = new ArrayList<DBCompareExpr>();
        }
        this.setConstraint(this.having, expr);
        return this;
    }

    public boolean hasHavingConstraints() {
        return this.having != null && this.having.size() > 0;
    }

    public List<DBCompareExpr> getHavingConstraints() {
        return this.having != null ? Collections.unmodifiableList(this.having) : null;
    }

    public boolean removeHavingConstraint(DBCompareExpr cmpExpr) {
        return this.removeConstraint(this.having, cmpExpr);
    }

    public DBCompareExpr removeHavingConstraintOn(DBColumnExpr col) {
        return this.removeConstraintOn(this.having, col);
    }

    public boolean hasHavingConstraintOn(DBColumnExpr col) {
        return this.findConstraintOn(this.having, col) != null;
    }

    public boolean hasGroupBy() {
        return this.groupBy != null ? !this.groupBy.isEmpty() : false;
    }

    public List<DBColumnExpr> getGroupBy() {
        return this.groupBy != null ? Collections.unmodifiableList(this.groupBy) : null;
    }

    public DBCommand groupBy(DBColumnExpr columnExpr) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<DBColumnExpr>();
        }
        if (columnExpr.isAggregate()) {
            return this;
        }
        if (columnExpr instanceof DBAliasExpr) {
            columnExpr = ((DBAliasExpr)columnExpr).unwrap();
        }
        if (this.groupBy.contains(columnExpr)) {
            return this;
        }
        this.groupBy.add(columnExpr);
        return this;
    }

    public final DBCommand groupBy(DBColumnExpr ... exprs) {
        for (DBColumnExpr expr : exprs) {
            this.groupBy(expr);
        }
        return this;
    }

    public final DBCommand groupBy(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.groupBy(dBColumnExpr);
        }
        return this;
    }

    public final DBCommand groupAll() {
        this.clearGroupBy();
        if (this.select == null) {
            return this;
        }
        for (DBColumnExpr expr : this.select) {
            if (expr.isAggregate()) continue;
            this.groupBy(expr);
        }
        return this;
    }

    public void clearSelectDistinct() {
        this.selectDistinct = false;
    }

    public void clearSelect() {
        this.select = null;
    }

    public void clearSet() {
        if (this.set != null && !this.cmdParams.isEmpty()) {
            for (DBSetExpr set : this.set) {
                Object value = set.getValue();
                if (!(value instanceof DBCmdParam)) continue;
                this.cmdParams.remove((DBCmdParam)value);
            }
        }
        this.set = null;
    }

    public void clearJoin() {
        this.joins = null;
    }

    public void clearWhere() {
        this.removeAllCommandParams(this.where);
        this.where = null;
    }

    public void clearHaving() {
        this.removeAllCommandParams(this.having);
        this.having = null;
    }

    public void clearGroupBy() {
        this.groupBy = null;
    }

    @Override
    public DBCommand orderBy(DBOrderByExpr ... exprs) {
        return (DBCommand)super.orderBy(exprs);
    }

    @Override
    public DBCommand orderBy(DBColumnExpr ... exprs) {
        return (DBCommand)super.orderBy(exprs);
    }

    @Override
    public DBCommand orderBy(DBColumnExpr expr, boolean desc) {
        return (DBCommand)super.orderBy(expr, desc);
    }

    @Override
    public DBCommand limitRows(int limitRows) {
        return (DBCommand)super.limitRows(limitRows);
    }

    @Override
    public DBCommand skipRows(int skipRows) {
        return (DBCommand)super.skipRows(skipRows);
    }

    public void clear() {
        this.cmdParams.clear(0);
        this.parentTables = null;
        this.clearSelectDistinct();
        this.clearSelect();
        this.clearSet();
        this.clearJoin();
        this.clearWhere();
        this.clearHaving();
        this.clearGroupBy();
        this.clearOrderBy();
        this.clearLimit();
    }

    protected boolean isPreparedStatementsEnabled() {
        return this.autoPrepareStmt;
    }

    protected boolean useCmdParam(DBColumnExpr col, Object value) {
        if (value == null || value instanceof DBExpr || value instanceof DBDatabase.DBSystemDate) {
            return false;
        }
        if (this.isPreparedStatementsEnabled()) {
            return true;
        }
        DataType dt = col.getDataType();
        return dt == DataType.BLOB || dt == DataType.CLOB;
    }

    protected void setConstraint(List<DBCompareExpr> list, DBCompareExpr expr) {
        if (this.isPreparedStatementsEnabled()) {
            expr.prepareCommand(this);
        }
        for (int i = 0; i < list.size(); ++i) {
            DBCompareExpr other = list.get(i);
            if (!expr.isMutuallyExclusive(other)) continue;
            this.removeCommandParams(other);
            list.set(i, expr);
            return;
        }
        list.add(expr);
    }

    protected boolean removeConstraint(List<DBCompareExpr> list, DBCompareExpr cmpExpr) {
        if (list == null) {
            return false;
        }
        for (DBCompareExpr cmp : list) {
            if (!cmp.isMutuallyExclusive(cmpExpr)) continue;
            this.removeCommandParams(cmp);
            list.remove(cmp);
            return true;
        }
        return false;
    }

    protected DBCompareExpr removeConstraintOn(List<DBCompareExpr> list, DBColumnExpr colExpr) {
        DBCompareExpr cmpExpr = this.findConstraintOn(list, colExpr);
        if (cmpExpr != null) {
            this.removeCommandParams(cmpExpr);
            list.remove(cmpExpr);
        }
        return cmpExpr;
    }

    protected DBCompareExpr findConstraintOn(List<DBCompareExpr> list, DBColumnExpr colExpr) {
        if (list == null) {
            return null;
        }
        for (DBCompareExpr cmp : list) {
            if (!cmp.isConstraintOn(colExpr)) continue;
            return cmp;
        }
        return null;
    }

    protected List<DBRowSet> getRowSetList() {
        int i = 0;
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        for (i = 0; this.select != null && i < this.select.size(); ++i) {
            ((DBExpr)this.select.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.joins != null && i < this.joins.size(); ++i) {
            ((DBExpr)this.joins.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.where != null && i < this.where.size(); ++i) {
            ((DBExpr)this.where.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.groupBy != null && i < this.groupBy.size(); ++i) {
            ((DBExpr)this.groupBy.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.having != null && i < this.having.size(); ++i) {
            ((DBExpr)this.having.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.orderBy != null && i < this.orderBy.size(); ++i) {
            ((DBExpr)this.orderBy.get(i)).addReferencedColumns(columns);
        }
        ArrayList<DBRowSet> tables = new ArrayList<DBRowSet>();
        for (DBColumn col : columns) {
            DBRowSet table = col.getRowSet();
            if (table == this.cmdQuery) {
                log.error("Recursive Column Selection in Command!");
                continue;
            }
            if (tables.contains(table) || table == null) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public Object[] getParamValues() {
        return this.cmdParams.getParamValues();
    }

    @Override
    public void getSelect(DBSQLBuilder sql) {
        this.resetParamUsage();
        if (this.select == null) {
            throw new ObjectNotValidException(this);
        }
        this.addSelect(sql);
        this.addFrom(sql);
        this.addWhere(sql);
        this.addGrouping(sql);
        this.addOrder(sql);
        this.completeParamUsage();
    }

    public String getInsert() {
        this.resetParamUsage();
        if (this.set == null || this.set.get(0) == null) {
            return null;
        }
        DBSQLBuilder sql = this.createSQLBuilder("INSERT INTO ");
        DBRowSet table = this.set.get(0).getTable();
        table.addSQL(sql, 2L);
        sql.append("( ");
        ArrayList<DBCompareColExpr> compexpr = null;
        if (this.where != null && !this.where.isEmpty()) {
            compexpr = new ArrayList<DBCompareColExpr>(this.where.size());
            for (DBCompareExpr expr : this.where) {
                this.appendCompareColExprs(table, expr, compexpr);
            }
            if (compexpr.size() > 0) {
                this.addListExpr(sql, compexpr, 1L, ", ");
                if (this.set != null) {
                    sql.append(", ");
                }
            } else {
                compexpr = null;
            }
        }
        if (this.set != null) {
            this.addListExpr(sql, this.set, 1L, ", ");
        }
        sql.append(") VALUES ( ");
        if (compexpr != null) {
            this.addListExpr(sql, compexpr, 4L, ", ");
        }
        if (compexpr != null && this.set != null) {
            sql.append(", ");
        }
        if (this.set != null) {
            this.addListExpr(sql, this.set, 4L, ", ");
        }
        sql.append(")");
        this.completeParamUsage();
        return sql.toString();
    }

    protected void appendCompareColExprs(DBRowSet table, DBCompareExpr expr, List<DBCompareColExpr> list) {
        if (expr instanceof DBCompareColExpr) {
            DBColumn column = ((DBCompareColExpr)expr).getColumnExpr().getUpdateColumn();
            if (column != null && column.getRowSet().equals(table) && !this.hasSetExprOn(column)) {
                list.add((DBCompareColExpr)expr);
            }
        } else if (expr instanceof DBCompareAndOrExpr) {
            this.appendCompareColExprs(table, ((DBCompareAndOrExpr)expr).getLeft(), list);
            this.appendCompareColExprs(table, ((DBCompareAndOrExpr)expr).getRight(), list);
        } else if (expr instanceof DBCompareNotExpr) {
            this.appendCompareColExprs(table, ((DBCompareNotExpr)expr).getExpr(), list);
        } else if (ObjectUtils.isWrapper(expr)) {
            this.appendCompareColExprs(table, ObjectUtils.unwrap(expr), list);
        }
    }

    public final String getUpdate() {
        this.resetParamUsage();
        if (this.set == null) {
            return null;
        }
        DBSQLBuilder sql = this.createSQLBuilder("UPDATE ");
        DBRowSet table = this.set.get(0).getTable();
        if (this.joins != null && !this.joins.isEmpty()) {
            this.addUpdateWithJoins(sql, table);
        } else {
            this.addUpdateForTable(sql, table);
        }
        this.completeParamUsage();
        return sql.toString();
    }

    protected void addUpdateForTable(DBSQLBuilder sql, DBRowSet table) {
        table.addSQL(sql, 2L);
        long context = 5L;
        sql.append("\r\nSET ");
        this.addListExpr(sql, this.set, context, ", ");
        this.addWhere(sql, context);
    }

    protected void addUpdateWithJoins(DBSQLBuilder sql, DBRowSet table) {
        sql.append(table.getAlias());
        long context = 7L;
        sql.append("\r\nSET ");
        this.addListExpr(sql, this.set, context, ", ");
        this.addFrom(sql);
        this.addWhere(sql, context);
    }

    public final String getDelete(DBTable table) {
        this.resetParamUsage();
        DBSQLBuilder sql = this.createSQLBuilder("DELETE ");
        if (this.joins != null && !this.joins.isEmpty()) {
            this.addDeleteWithJoins(sql, table);
        } else {
            this.addDeleteForTable(sql, table);
        }
        this.completeParamUsage();
        return sql.toString();
    }

    protected void addDeleteForTable(DBSQLBuilder sql, DBRowSet table) {
        sql.append("FROM ");
        table.addSQL(sql, 2L);
        this.addWhere(sql, 5L);
    }

    protected void addDeleteWithJoins(DBSQLBuilder sql, DBRowSet table) {
        table.addSQL(sql, 2L);
        this.addFrom(sql);
        this.addWhere(sql, 7L);
    }

    protected void addSelect(DBSQLBuilder sql) {
        sql.append("SELECT ");
        if (this.selectDistinct) {
            sql.append("DISTINCT ");
        }
        this.addListExpr(sql, this.select, 15L, ", ");
    }

    protected void addFrom(DBSQLBuilder sql) {
        int originalLength = sql.length();
        sql.append("\r\nFROM ");
        boolean sep = false;
        List<DBRowSet> tables = this.getRowSetList();
        if (this.joins != null && this.joins.size() > 0) {
            ArrayList<DBRowSet> joinTables = new ArrayList<DBRowSet>();
            for (int i = 0; i < this.joins.size(); ++i) {
                long context;
                DBJoinExpr join = this.joins.get(i);
                if (i < 1) {
                    joinTables.add(join.getLeftTable());
                    joinTables.add(join.getRightTable());
                    tables.remove(join.getLeftTable());
                    tables.remove(join.getRightTable());
                    context = 5L;
                } else {
                    if (joinTables.contains(join.getRightTable())) {
                        join.reverse();
                    }
                    joinTables.add(join.getRightTable());
                    tables.remove(join.getRightTable());
                    context = 4L;
                    sql.append("\t");
                }
                join.addSQL(sql, context);
                if (i == this.joins.size() - 1) continue;
                sql.append("\r\n");
            }
            sep = true;
        }
        for (int i = 0; i < tables.size(); ++i) {
            DBRowSet t = tables.get(i);
            if (this.parentTables != null && this.parentTables.contains(t)) continue;
            if (sep) {
                sql.append(", ");
            }
            t.addSQL(sql, 15L);
            sep = true;
        }
        if (!sep) {
            String pseudoTable = this.getDatabase().getDbms().getSQLPhrase(DBSqlPhrase.SQL_PSEUDO_TABLE);
            if (StringUtils.isNotEmpty(pseudoTable)) {
                sql.append(pseudoTable);
            } else {
                sql.reset(originalLength);
            }
        }
    }

    protected void addWhere(DBSQLBuilder sql, long context) {
        if (this.where != null && !this.where.isEmpty()) {
            sql.append("\r\nWHERE ");
            this.addListExpr(sql, this.where, context, " AND ");
        }
    }

    protected final void addWhere(DBSQLBuilder sql) {
        this.addWhere(sql, 7L);
    }

    protected void addGrouping(DBSQLBuilder sql) {
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            sql.append("\r\nGROUP BY ");
            this.addListExpr(sql, this.groupBy, 7L, ", ");
        }
        if (this.having != null && !this.having.isEmpty()) {
            sql.append("\r\nHAVING ");
            this.addListExpr(sql, this.having, 7L, " AND ");
        }
    }

    protected void addOrder(DBSQLBuilder sql) {
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            sql.append("\r\nORDER BY ");
            this.addListExpr(sql, this.orderBy, 7L, ", ");
        }
    }
}

