/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Collections;
import java.util.Set;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.data.EntityType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class DBColumn
extends DBColumnExpr
implements Column {
    private static final Logger log = LoggerFactory.getLogger(DBColumn.class);
    protected final DBRowSet rowset;
    protected final String name;
    protected String comment;
    private Boolean quoteName = null;

    protected DBColumn(DBRowSet rowset, String name) {
        this.rowset = rowset;
        this.name = name;
        this.comment = null;
    }

    public String getIdentifier() {
        return this.rowset.getIdentifier() + "." + this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.rowset == null) {
            return super.equals(other);
        }
        if (other instanceof DBColumn) {
            DBColumn c = (DBColumn)other;
            if (!this.rowset.equals(c.getRowSet())) {
                return false;
            }
            return StringUtils.compareEqual(this.name, c.getName(), true);
        }
        return false;
    }

    public int hashCode() {
        if (this.rowset == null || this.name == null) {
            return super.hashCode();
        }
        return this.rowset.hashCode() + this.name.hashCode();
    }

    @Override
    public abstract double getSize();

    @Override
    public abstract boolean isRequired();

    @Override
    public abstract boolean isAutoGenerated();

    @Override
    public abstract boolean isReadOnly();

    @Override
    public abstract Object validateValue(Object var1);

    @Override
    public abstract Element addXml(Element var1, long var2);

    public final DBDatabase getDatabase() {
        return this.rowset != null ? this.rowset.getDatabase() : null;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        list.add(this);
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        Object dbms;
        if ((context & 2L) != 0L) {
            sql.append(this.rowset.getAlias());
            sql.append(".");
        }
        if ((dbms = this.getDatabase().getDbms()) == null) {
            throw new DatabaseNotOpenException(this.getDatabase());
        }
        dbms.appendObjectName(sql, this.name, this.quoteName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DBRowSet getRowSet() {
        return this.rowset;
    }

    @Override
    public EntityType getEntityType() {
        return this.rowset;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public DBColumnExpr reference() {
        return new DBValueExpr(this.getDatabase(), this, DataType.UNKNOWN);
    }

    public String getFullName() {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        return StringUtils.concat(this.rowset.getFullName(), ".", this.name);
    }

    public String getAlias() {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        String rsName = this.rowset.getEntityName();
        if (StringUtils.isEmpty(rsName)) {
            return this.name;
        }
        return StringUtils.concat(rsName, "_", this.name);
    }

    @Override
    public DBColumnExpr qualified() {
        return this.as(this.getAlias());
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    @Override
    public Set<Attributes.Attribute> getAttributes() {
        return this.attributes != null ? Collections.unmodifiableSet(this.attributes) : Collections.EMPTY_SET;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    public final boolean isEnum() {
        return this.getEnumType() != null;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.attributes != null ? (Class)this.getAttribute("enumType") : null;
    }

    @Override
    public Class<?> getJavaType() {
        Class<Enum<?>> enumType = this.getEnumType();
        if (enumType != null) {
            return enumType;
        }
        return super.getJavaType();
    }

    public DBColumnExpr decodeEnum() {
        return super.decodeEnum(this.getEnumType(), null);
    }

    public DBColumnExpr decodeSort(boolean defaultToEnd) {
        if (this.getDataType().isNumeric()) {
            log.warn("Unnecessary decode for numeric column");
            return this;
        }
        return super.decodeSort(this.getEnumType(), defaultToEnd);
    }

    public DBSetExpr to(Object value) {
        return new DBSetExpr(this, value);
    }

    @Override
    public String toString() {
        if (this.rowset == null) {
            return this.name;
        }
        return StringUtils.concat(this.rowset.getName(), ".", this.name);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

