/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtils.class);
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    public static final String NULL = "null";
    public static String DEFAULT_ITEM_SEPARATOR = "|";
    public static String LIST_TEMPLATE = "[*|*]";
    public static char TEMPLATE_SEP_CHAR = (char)42;

    private StringUtils() {
    }

    public static String toString(Object value, String listTemplate, String defValue) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Object[]) {
            value = StringUtils.arrayToString((Object[])value, listTemplate, defValue != null ? defValue : EMPTY);
        } else if (value instanceof Collection) {
            value = StringUtils.listToString((Collection)value, listTemplate, defValue != null ? defValue : EMPTY);
        }
        return value != null ? value.toString() : defValue;
    }

    public static String toString(Object value, String defValue) {
        return StringUtils.toString(value, DEFAULT_ITEM_SEPARATOR, defValue);
    }

    public static String toString(Object value) {
        return StringUtils.toString(value, null);
    }

    public static String valueOf(Object value) {
        return StringUtils.toString(value, EMPTY);
    }

    public static String asString(Object value) {
        return StringUtils.toString(value, LIST_TEMPLATE, EMPTY);
    }

    public static String coalesce(String preferred, String alternative) {
        return StringUtils.isEmpty(preferred) ? alternative : preferred;
    }

    public static String nullIfEmpty(Object value) {
        if (value == null) {
            return null;
        }
        String strval = value.toString();
        return strval.length() == 0 ? null : strval;
    }

    public static boolean contains(String value, String substring) {
        if (value == null || substring == null) {
            return false;
        }
        return value.indexOf(substring) >= 0;
    }

    public static boolean notContains(String value, String substring) {
        if (value == null || substring == null) {
            return true;
        }
        return value.indexOf(substring) < 0;
    }

    public static int indexOfAny(String value, char ... chars) {
        if (value == null || chars.length == 0) {
            return -1;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            for (int j = 0; j < chars.length; ++j) {
                if (c != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String value, char ... chars) {
        if (value == null || chars.length == 0) {
            return -1;
        }
        for (int i = value.length(); i >= 0; --i) {
            char c = value.charAt(i);
            for (int j = 0; j < chars.length; ++j) {
                if (c != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static String arrayToString(Object[] array, String template, String defItemValue, boolean ignoreEmpty) {
        int tbeg;
        if (array == null || array.length == 0) {
            return null;
        }
        int n = tbeg = template != null ? template.indexOf(TEMPLATE_SEP_CHAR) : -1;
        if (array.length > 1 || tbeg > 0) {
            int tend;
            int n2 = tend = tbeg >= 0 ? template.lastIndexOf(TEMPLATE_SEP_CHAR) : -1;
            String separator = tbeg > 0 ? (tend > tbeg ? template.substring(tbeg + 1, tend) : DEFAULT_ITEM_SEPARATOR) : template;
            int bufferLen = StringUtils.estimateArrayBufferSize(array, separator != null ? separator.length() : 0);
            if (template != null && template.length() > separator.length()) {
                bufferLen += template.length() - separator.length();
            }
            StringBuilder buf = new StringBuilder(bufferLen);
            if (tend > 0) {
                buf.append(template.substring(0, tbeg));
            }
            boolean isEmpty = true;
            boolean hasValue = false;
            for (int i = 0; i < array.length; ++i) {
                if (hasValue && separator != null) {
                    buf.append(separator);
                }
                String value = StringUtils.toString(array[i], template, defItemValue);
                hasValue = !ignoreEmpty || !StringUtils.isEmpty(value);
                isEmpty &= !hasValue;
                if (!hasValue || value == null) continue;
                buf.append(value);
            }
            if (!hasValue && !isEmpty && separator != null) {
                buf.setLength(buf.length() - separator.length());
            }
            if (tend > 0) {
                buf.append(template.substring(tend + 1));
            }
            if (buf.length() != bufferLen) {
                log.debug("estimateArrayBufferSize returned {} but string length is {}", (Object)bufferLen, (Object)buf.length());
            }
            return buf.toString();
        }
        String value = StringUtils.toString(array[0], template, defItemValue);
        if (ignoreEmpty && StringUtils.isEmpty(value)) {
            return defItemValue;
        }
        return value;
    }

    public static String arrayToString(Object[] array, String template, String defItemValue) {
        return StringUtils.arrayToString(array, template, defItemValue, SPACE.equals(template));
    }

    public static String arrayToString(Object[] array, String separator) {
        return StringUtils.arrayToString(array, separator, EMPTY);
    }

    public static int estimateArrayBufferSize(Object[] array, int separatorLength) {
        int estimate = 0;
        for (int i = 0; i < array.length; ++i) {
            Object item = array[i];
            int len = 0;
            if (item instanceof String) {
                len = ((String)item).length();
            } else if (item instanceof Number) {
                len = 10;
            } else if (item instanceof Object[]) {
                len = StringUtils.estimateArrayBufferSize((Object[])item, separatorLength);
            } else if (item instanceof Collection) {
                len = StringUtils.estimateListBufferSize((Collection)item, separatorLength);
            } else if (item != null) {
                len = 20;
            }
            if (len <= 0) continue;
            if (estimate > 0) {
                estimate += separatorLength;
            }
            estimate += len;
        }
        return estimate;
    }

    public static String listToString(Collection<?> list, String template, String defItemValue, boolean ignoreEmpty) {
        int tbeg;
        if (list == null || list.isEmpty()) {
            return null;
        }
        int n = tbeg = template != null ? template.indexOf(TEMPLATE_SEP_CHAR) : -1;
        if (list.size() > 1 || tbeg > 0) {
            int tend;
            int n2 = tend = tbeg >= 0 ? template.lastIndexOf(TEMPLATE_SEP_CHAR) : -1;
            String separator = tbeg > 0 ? (tend > tbeg ? template.substring(tbeg + 1, tend) : DEFAULT_ITEM_SEPARATOR) : template;
            int bufferLen = StringUtils.estimateListBufferSize(list, separator != null ? separator.length() : 0);
            if (template != null && template.length() > separator.length()) {
                bufferLen += template.length() - separator.length();
            }
            StringBuilder buf = new StringBuilder(bufferLen);
            if (tend > 0) {
                buf.append(template.substring(0, tbeg));
            }
            boolean isEmpty = true;
            boolean hasValue = false;
            for (Object item : list) {
                if (hasValue && separator != null) {
                    buf.append(separator);
                }
                String value = StringUtils.toString(item, template, defItemValue);
                hasValue = !ignoreEmpty || !StringUtils.isEmpty(value);
                isEmpty &= !hasValue;
                if (!hasValue || value == null) continue;
                buf.append(value);
            }
            if (!hasValue && !isEmpty && separator != null) {
                buf.setLength(buf.length() - separator.length());
            }
            if (tend > 0) {
                buf.append(template.substring(tend + 1));
            }
            if (buf.length() != bufferLen) {
                log.debug("estimateListBufferSize returned {} but string length is {}", (Object)bufferLen, (Object)buf.length());
            }
            return buf.toString();
        }
        String value = StringUtils.toString(list.iterator().next(), template, defItemValue);
        if (ignoreEmpty && StringUtils.isEmpty(value)) {
            return defItemValue;
        }
        return value;
    }

    public static String listToString(Collection<?> list, String template, String defItemValue) {
        return StringUtils.listToString(list, template, defItemValue, SPACE.equals(template));
    }

    public static String listToString(Collection<?> list, String separator) {
        return StringUtils.listToString(list, separator, EMPTY);
    }

    public static int estimateListBufferSize(Collection<?> list, int separatorLength) {
        int estimate = 0;
        for (Object item : list) {
            int len = 0;
            if (item instanceof String) {
                len = ((String)item).length();
            } else if (item instanceof Number) {
                len = 10;
            } else if (item instanceof Object[]) {
                len = StringUtils.estimateArrayBufferSize((Object[])item, separatorLength);
            } else if (item instanceof Collection) {
                len = StringUtils.estimateListBufferSize((Collection)item, separatorLength);
            } else if (item != null) {
                len = 20;
            }
            if (len <= 0) continue;
            if (estimate > 0) {
                estimate += separatorLength;
            }
            estimate += len;
        }
        return estimate;
    }

    public static String concat(String separator, Object ... params) {
        return StringUtils.arrayToString(params, separator);
    }

    public static String concat(String ... parts) {
        int totalLength = 0;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            totalLength += parts[i].length();
        }
        StringBuilder b = new StringBuilder(totalLength);
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            b.append(parts[i]);
        }
        return b.toString();
    }

    public static boolean isEmpty(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean compareEqual(String s1, String s2, boolean ignoreCase) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (StringUtils.isEmpty(s1) && StringUtils.isEmpty(s2)) {
            return true;
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public static boolean compareEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (StringUtils.isEmpty(s1)) {
            return StringUtils.isEmpty(s2);
        }
        if (StringUtils.isEmpty(s2)) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean compareNotEqual(String s1, String s2, boolean ignoreCase) {
        return !StringUtils.compareEqual(s1, s2, ignoreCase);
    }

    public static boolean compareNotEqual(String s1, String s2) {
        return !StringUtils.compareEqual(s1, s2);
    }

    public static String validate(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public static String replace(String source, String find, String replace) {
        if (source == null || find == null || find.length() == 0) {
            return source;
        }
        int index = source.indexOf(find);
        if (index < 0) {
            return source;
        }
        if (replace == null) {
            replace = EMPTY;
        }
        int len = find.length();
        return StringUtils.concat(source.substring(0, index), replace, StringUtils.replace(source.substring(index + len), find, replace));
    }

    public static String replaceAll(String s, String find, String replace) {
        if (s == null) {
            return null;
        }
        if (replace == null) {
            replace = EMPTY;
        }
        if (find == null || EMPTY.equals(find) || find.equals(replace)) {
            return s;
        }
        int start = s.indexOf(find);
        if (start < 0) {
            return s;
        }
        StringBuilder b = new StringBuilder(s.length());
        char[] origChars = s.toCharArray();
        int findLength = find.length();
        int copyFrom = 0;
        while (start >= 0) {
            b.append(origChars, copyFrom, start - copyFrom);
            if (replace.length() > 0) {
                b.append(replace);
            }
            copyFrom = start + findLength;
            start = s.indexOf(find, copyFrom);
        }
        if (origChars.length > copyFrom) {
            b.append(origChars, copyFrom, origChars.length - copyFrom);
        }
        return b.toString();
    }

    public static String remove(String s, String remove) {
        return StringUtils.replaceAll(s, remove, null);
    }

    public static String remove(String s, char c) {
        return StringUtils.replaceAll(s, String.valueOf(c), null);
    }

    public static String removeBlanks(String s) {
        return StringUtils.remove(s, SPACE);
    }

    public static boolean isCharBetween(char c, char beg, char end) {
        return c >= beg && c <= end;
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isNumber(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtils.isNumber(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(char c, boolean decimal) {
        if (c == '+' || c == '-') {
            return true;
        }
        if (decimal && (c == '.' || c == ',')) {
            return true;
        }
        return StringUtils.isNumber(c);
    }

    public static boolean isNumeric(String s, boolean decimal) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c == '+' || c == '-') && i > 0) {
                return false;
            }
            if (StringUtils.isNumeric(c, decimal)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z' || c >= '\u00c0' && c <= '\u00dd';
    }

    public static boolean isUpper(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        if (count > s.length()) {
            count = s.length();
        }
        for (int i = 0; i < count; ++i) {
            if (!StringUtils.isLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z' || c >= '\u00df' && c <= '\u00ff';
    }

    public static boolean isLower(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        if (count > s.length()) {
            count = s.length();
        }
        for (int i = 0; i < count; ++i) {
            if (!StringUtils.isUpper(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toUpper(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        if (s.length() <= count) {
            return s.toUpperCase();
        }
        String start = s.substring(0, count);
        return start.toUpperCase() + s.substring(count);
    }

    public static String toLower(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        if (s.length() <= count) {
            return s.toLowerCase();
        }
        String start = s.substring(0, count);
        return start.toLowerCase() + s.substring(count);
    }

    public static String truncate(String s, int maxChar) {
        if (StringUtils.isEmpty(s)) {
            return EMPTY;
        }
        if (maxChar < 1 || s.length() < maxChar) {
            return s;
        }
        return s.substring(0, maxChar);
    }

    public static String padLeft(String s, int size, char padChar) {
        if (s == null) {
            s = EMPTY;
        }
        if (s.length() >= size) {
            return s;
        }
        int padCount = size - s.length();
        if (padCount == 1) {
            return String.valueOf(padChar) + s;
        }
        StringBuilder b = new StringBuilder(size);
        while (b.length() < padCount) {
            b.append(padChar);
        }
        b.append(s);
        return b.toString();
    }

    public static String padRight(String s, int size, char padChar) {
        if (s == null) {
            s = EMPTY;
        }
        if (s.length() >= size) {
            return s;
        }
        if (size - s.length() == 1) {
            return s + String.valueOf(padChar);
        }
        StringBuilder b = new StringBuilder(size);
        b.append(s);
        while (b.length() < size) {
            b.append(padChar);
        }
        return b.toString();
    }
}

