/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ArraySet;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.exceptions.InvalidArgumentException;

public class ArrayMap<K, V>
extends AbstractMap<K, V> {
    private ArraySet<Map.Entry<K, V>> entries;

    public ArrayMap() {
        this.entries = new ArraySet();
    }

    public ArrayMap(int initialCapacity) {
        this.entries = new ArraySet(initialCapacity);
    }

    public ArrayMap(Map<K, V> other) {
        this.entries = new ArraySet(other.size());
        for (Map.Entry<K, V> e : other.entrySet()) {
            this.entries.fastAdd(new Entry<K, V>(e.getKey(), e.getValue()));
        }
    }

    public ArrayMap<K, V> add(K key, V value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries;
    }

    @Override
    public V remove(Object key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        Map.Entry entry = (Map.Entry)this.entries.get(index);
        this.entries.remove(index);
        return entry.getValue();
    }

    @Override
    public V put(K key, V value) {
        Map.Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            return entry.setValue(value);
        }
        this.entries.fastAdd(new Entry<K, V>(key, value));
        return null;
    }

    public void put(K key, V value, int index) {
        if (index < 0) {
            this.put(key, value);
            return;
        }
        if (index > this.entries.size()) {
            throw new InvalidArgumentException("index", index);
        }
        int current = this.getIndex(key);
        if (current == index) {
            Map.Entry entry = (Map.Entry)this.entries.get(index);
            entry.setValue(value);
            return;
        }
        if (current >= 0) {
            this.entries.remove(current);
            if (current < index) {
                --index;
            }
        }
        this.entries.fastAdd(index, new Entry<K, V>(key, value));
    }

    public int getIndex(K key) {
        for (int index = 0; index < this.entries.size(); ++index) {
            Map.Entry entry = (Map.Entry)this.entries.get(index);
            if (!ObjectUtils.compareEqual(entry.getKey(), key)) continue;
            return index;
        }
        return -1;
    }

    public Map.Entry<K, V> getEntry(K key) {
        int index = this.getIndex(key);
        return index >= 0 ? (Map.Entry)this.entries.get(index) : null;
    }

    public static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V prev = this.value;
            this.value = value;
            return prev;
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry other = (Entry)obj;
                return ObjectUtils.compareEqual(this.key, other.getKey()) && ObjectUtils.compareEqual(this.value, other.getValue());
            }
            return false;
        }

        public String toString() {
            String k = this.key instanceof Enum ? ((Enum)this.key).name() : String.valueOf(this.key);
            String v = String.valueOf(this.value);
            StringBuilder b = new StringBuilder(k.length() + v.length() + 4);
            b.append("{");
            b.append(k);
            b.append("=");
            b.append(v);
            b.append("}");
            return b.toString();
        }
    }
}

