/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pageelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.faces.event.ActionEvent;
import org.apache.empire.commons.ArraySet;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListPageElement<T>
extends PageElement {
    private static final Logger log = LoggerFactory.getLogger(ListPageElement.class);
    protected Class<T> beanClass;
    protected List<T> items = null;
    protected SelectionSet selectedItemKeys = null;

    public ListPageElement(Page page, Class<T> beanClass, String propertyName) {
        super(page, propertyName);
        this.beanClass = beanClass;
        if (ListPageElement.isSelectableItem(beanClass)) {
            this.selectedItemKeys = new SelectionSet();
        }
    }

    private static <T> boolean isSelectableItem(Class<T> beanClass) {
        for (Class<T> superClass = beanClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!superClass.equals(SelectableItem.class)) continue;
            return true;
        }
        return false;
    }

    public abstract ListTableInfo getTableInfo();

    public List<T> getItems() {
        if (this.items == null) {
            log.warn("Bean List has not been initialized!");
        }
        return this.items;
    }

    public final boolean isValid() {
        return this.items != null;
    }

    public final boolean isEmpty() {
        return this.items == null || this.items.size() == 0;
    }

    public final boolean isNotEmpty() {
        return this.items != null && this.items.size() > 0;
    }

    public final boolean isBlank() {
        return this.isEmpty();
    }

    public int getItemCount() {
        return this.getTableInfo().getItemCount();
    }

    public void clearItems() {
        this.clearSelection();
        this.items = null;
    }

    public void clearSelection() {
        if (this.selectedItemKeys != null) {
            this.selectedItemKeys.clear();
        }
    }

    public boolean isHasSelection() {
        if (this.selectedItemKeys == null) {
            return false;
        }
        return this.selectedItemKeys.size() > 0 || this.selectedItemKeys.isInvertSelection();
    }

    public int getSelectedItemCount() {
        if (this.selectedItemKeys == null) {
            return 0;
        }
        return this.selectedItemKeys.size();
    }

    public List<T> getSelectedItems() {
        if (this.selectedItemKeys == null) {
            throw new NotSupportedException((Object)this, "getSelectedItems");
        }
        ArrayList<T> selection = new ArrayList<T>(this.selectedItemKeys.size());
        for (T item : this.getItems()) {
            if (!((SelectableItem)item).isSelected()) continue;
            selection.add(item);
        }
        return selection;
    }

    public Set<Object[]> getSelectedItemKeys() {
        return this.selectedItemKeys;
    }

    public void setSelectedItems(Set<Object[]> items) {
        if (this.selectedItemKeys == null) {
            throw new NotSupportedException((Object)this, "setSelectedItems");
        }
        this.selectedItemKeys = new SelectionSet(items.size());
        for (Object[] key : items) {
            if (key == null || key.length == 0) {
                log.warn("Cannot select Null-Object.");
                continue;
            }
            this.selectedItemKeys.add(key);
        }
    }

    public boolean isInvertSelection() {
        if (this.selectedItemKeys == null) {
            return false;
        }
        return this.selectedItemKeys.isInvertSelection();
    }

    public void setInvertSelection(boolean invertSelection) {
        if (this.selectedItemKeys == null) {
            throw new NotSupportedException((Object)this, "setInvertSelection");
        }
        this.selectedItemKeys.setInvertSelection(invertSelection);
    }

    public boolean isSingleSelection() {
        if (this.selectedItemKeys == null) {
            return false;
        }
        return this.selectedItemKeys.isSingleSelection();
    }

    public void setSingleSelection(boolean singleSelection) {
        if (this.selectedItemKeys == null) {
            throw new NotSupportedException((Object)this, "setSingleSelection");
        }
        this.selectedItemKeys.setSingleSelection(singleSelection);
    }

    public void setSelection(SelectableItem item) {
        if (this.selectedItemKeys == null) {
            throw new NotSupportedException((Object)this, "setInvertSelection");
        }
        if (item != null) {
            this.selectedItemKeys.set(item.getKey());
        } else {
            this.selectedItemKeys.clear();
        }
    }

    public void setSelection(SelectableItem[] items) {
        if (this.selectedItemKeys == null) {
            throw new NotSupportedException((Object)this, "setInvertSelection");
        }
        this.selectedItemKeys.clear();
        for (SelectableItem item : items) {
            this.selectedItemKeys.add(item.getKey());
        }
    }

    public static class ListTableInfo {
        private int itemCount = -1;
        private boolean valid = false;
        private boolean modified = false;
        private String sortColumnName;
        private boolean sortAscending = true;
        private boolean sortOrderChanged = false;
        private int position = 0;
        private int pageSize = 0;

        public void init(int itemCount, int pageSize) {
            if (pageSize < 0) {
                throw new ObjectNotValidException((Object)this);
            }
            this.itemCount = itemCount;
            this.pageSize = pageSize;
            this.position = 0;
            this.valid = itemCount >= 0;
            this.modified = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            if (valid && this.itemCount < 0) {
                throw new ObjectNotValidException((Object)this);
            }
            this.valid = valid;
        }

        public boolean isModified() {
            return this.valid && this.modified;
        }

        public void setModified(boolean modified) {
            this.modified = modified;
        }

        public int getItemCount() {
            return this.itemCount;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public String getSortColumnName() {
            return this.sortColumnName;
        }

        public void setSortColumnName(String column) {
            if (ObjectUtils.compareEqual((Object)column, (Object)this.sortColumnName)) {
                return;
            }
            this.sortColumnName = column;
            this.position = 0;
            this.modified = true;
            this.sortOrderChanged = true;
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }

        public void setSortAscending(boolean sortAscending) {
            if (this.sortAscending == sortAscending) {
                return;
            }
            this.sortAscending = sortAscending;
            this.modified = true;
            this.sortOrderChanged = true;
        }

        public boolean isSortOrderChanged() {
            return this.sortOrderChanged;
        }

        public void setSortOrderChanged(boolean sortOrderChanged) {
            this.sortOrderChanged = sortOrderChanged;
        }

        public void setSortColumn(ActionEvent ae) {
            Object column = FacesUtils.getActionEventAttribute(ae, "item", Object.class);
            if (column == null) {
                log.warn("Unable to set sort column: Attribute \"item\" missing on command link component!");
                return;
            }
            String columnName = column instanceof Column ? ((Column)column).getName() : column.toString();
            if (StringUtils.compareEqual((String)columnName, (String)this.getSortColumnName(), (boolean)true)) {
                this.setSortAscending(!this.isSortAscending());
            } else {
                this.setSortColumnName(columnName);
            }
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            if (this.pageSize == 0) {
                throw new NotSupportedException((Object)this, "setPosition");
            }
            if (position < 0) {
                position = 0;
            }
            if (position >= this.itemCount) {
                position = this.itemCount - 1;
            }
            if (this.position == position) {
                return;
            }
            this.position = position;
            this.modified = true;
        }

        public boolean isAllowPagination() {
            return this.pageSize > 0;
        }

        public boolean isFirstPage() {
            return this.isValid() && this.isAllowPagination() && this.position == 0;
        }

        public boolean isLastPage() {
            return this.isValid() && this.isAllowPagination() && this.position + this.pageSize >= this.itemCount;
        }

        public boolean isHasNextPage() {
            if (this.isValid() && this.isAllowPagination()) {
                return this.itemCount - (this.position + this.pageSize) > 0;
            }
            return false;
        }

        public boolean isHasPrevPage() {
            return this.isValid() && this.isAllowPagination() && this.position > 0;
        }

        public void nextPage(ActionEvent e) {
            if (!this.isAllowPagination()) {
                throw new NotSupportedException((Object)this, "nextPage");
            }
            if (this.position + this.pageSize > this.itemCount) {
                return;
            }
            this.position += this.pageSize;
            this.modified = true;
        }

        public void prevPage(ActionEvent e) {
            if (!this.isAllowPagination()) {
                throw new NotSupportedException((Object)this, "prevPage");
            }
            if (this.position == 0) {
                return;
            }
            this.position = this.position > this.pageSize ? (this.position -= this.pageSize) : 0;
            this.modified = true;
        }

        public void firstPage(ActionEvent e) {
            if (!this.isAllowPagination()) {
                throw new NotSupportedException((Object)this, "nextPage");
            }
            if (this.position == 0) {
                return;
            }
            this.position = 0;
            this.modified = true;
        }

        public void lastPage(ActionEvent e) {
            if (!this.isAllowPagination()) {
                throw new NotSupportedException((Object)this, "nextPage");
            }
            if (this.position == this.itemCount - this.pageSize) {
                return;
            }
            this.position = this.itemCount - this.pageSize;
            this.modified = true;
        }

        public int getPageNumber() {
            if (!this.isAllowPagination()) {
                return 1;
            }
            int pageNumber = new Double(Math.ceil((double)this.position / (double)this.pageSize)).intValue() + 1;
            return pageNumber;
        }

        public void setPageNumber(int newPageNumber) {
            this.setPosition(--newPageNumber * this.pageSize);
        }

        public int getPageCount() {
            if (!this.isAllowPagination()) {
                return 1;
            }
            int pageCount = new Double(Math.ceil((double)this.itemCount / (double)this.pageSize)).intValue();
            return pageCount;
        }
    }

    public static abstract class SelectableItem {
        private Object[] key;
        private SelectionSet selectSet = null;

        protected void initSelect(Object[] key, SelectionSet selectSet) {
            if (key == null || selectSet == null) {
                throw new InvalidArgumentException("key|selectSet", null);
            }
            this.key = key;
            this.selectSet = selectSet;
        }

        public boolean isSelected() {
            if (this.key == null) {
                throw new ObjectNotValidException((Object)this);
            }
            return this.selectSet.contains(this.key);
        }

        public void setSelected(boolean selected) {
            if (this.key == null) {
                throw new ObjectNotValidException((Object)this);
            }
            if (selected != this.selectSet.isInvertSelection()) {
                this.selectSet.add(this.key);
            } else {
                this.selectSet.remove(this.key);
            }
        }

        public Object[] getKey() {
            return this.key;
        }
    }

    public static interface ParameterizedItem {
        public String getIdParam();

        public void setIdParam(String var1);
    }

    public static class SelectionSet
    extends ArraySet<Object[]> {
        private static final long serialVersionUID = 1L;
        private boolean singleSelection = false;
        private boolean invertSelection = false;

        public SelectionSet() {
        }

        public SelectionSet(int size) {
            super(size);
        }

        public boolean isSingleSelection() {
            return this.singleSelection;
        }

        public void setSingleSelection(boolean singleSelection) {
            this.singleSelection = singleSelection;
            this.clear();
        }

        public boolean isInvertSelection() {
            return this.invertSelection;
        }

        public boolean set(Object[] e) {
            this.clear();
            return super.add((Object)e);
        }

        public boolean add(Object[] e) {
            if (this.singleSelection) {
                return false;
            }
            return super.add((Object)e);
        }

        public boolean remove(Object o) {
            if (this.singleSelection) {
                return false;
            }
            return super.remove(o);
        }

        public void setInvertSelection(boolean invertSelection) {
            if (this.invertSelection == invertSelection) {
                return;
            }
            this.invertSelection = invertSelection;
            this.clear();
        }

        public boolean contains(Object item) {
            boolean exists = super.contains(item);
            return this.invertSelection ? !exists : exists;
        }
    }
}

