/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.model.SelectItem;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(SelectInputControl.class);
    public static final String COLATTR_ABBR_OPTIONS = "ABBR_OPTIONS";
    public static final String VALUE_EXPRESSION_FLAG = "VALUE_EXPRESSION_FLAG";
    public static final String FORMAT_SIZE = "size:";
    public static final String FORMAT_SIZE_ATTR = "format:size";
    public static final String NAME = "select";
    private final Class<? extends HtmlSelectOneMenu> menuComponentClass;
    private final Class<? extends HtmlSelectOneListbox> listComponentClass;

    public SelectInputControl(String name, Class<? extends HtmlSelectOneMenu> menuComponentClass, Class<? extends HtmlSelectOneListbox> listComponentClass) {
        super(name);
        this.menuComponentClass = menuComponentClass;
        this.listComponentClass = listComponentClass;
    }

    public SelectInputControl() {
        this(NAME, HtmlSelectOneMenu.class, HtmlSelectOneListbox.class);
    }

    public UISelectOne createSelectComponent(UIComponent parent, FacesContext context, Object formatSize) {
        int listSize = ObjectUtils.getInteger((Object)formatSize, (int)1);
        Class<Object> selectOneClass = listSize == -1 || listSize > 1 ? this.listComponentClass : this.menuComponentClass;
        UISelectOne selectOne = (UISelectOne)InputControlManager.createComponent(context, selectOneClass);
        if (selectOne instanceof HtmlSelectOneListbox && listSize > 1) {
            ((HtmlSelectOneListbox)selectOne).setSize(listSize);
        }
        return selectOne;
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        Object formatSize = this.getFormatOption(ii, FORMAT_SIZE, FORMAT_SIZE_ATTR);
        UISelectOne input = this.createSelectComponent(parent, context, formatSize);
        Object value = ii.getValue(false);
        input.getAttributes().put(VALUE_EXPRESSION_FLAG, value instanceof ValueExpression);
        this.copyAttributes(parent, ii, (UIInput)input);
        boolean disabled = this.setDisabled(input, ii);
        this.initOptions(input, ii.getTextResolver(), ii);
        compList.add((UIComponent)input);
        this.addRemoveDisabledStyle((UIInput)input, disabled);
        this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
        this.setInputValue((UIInput)input, ii);
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof UISelectOne)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "parent.getChildren()");
        }
        UISelectOne input = (UISelectOne)comp;
        this.addRemoveStyle((UIInput)input, TagStyleClass.INPUT_REQ, ii.isRequired());
        boolean disabled = this.setDisabled(input, ii);
        if (phaseId != PhaseId.APPLY_REQUEST_VALUES) {
            this.syncOptions(input, ii.getTextResolver(), ii);
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.addRemoveDisabledStyle((UIInput)input, disabled);
            this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
            this.setInputValue((UIInput)input, ii);
        }
    }

    protected boolean setDisabled(UISelectOne input, InputControl.InputInfo ii) {
        boolean disabled = ii.isDisabled();
        if (input instanceof HtmlSelectOneMenu) {
            ((HtmlSelectOneMenu)input).setDisabled(disabled);
        } else if (input instanceof HtmlSelectOneListbox) {
            ((HtmlSelectOneListbox)input).setDisabled(disabled);
        } else {
            log.warn("Unable to set disabled attribute!");
        }
        return disabled;
    }

    protected boolean isEmptyEntryRequired(UISelectOne input, Options options, InputControl.InputInfo ii, Object currentValue) {
        if (input instanceof HtmlSelectOneListbox) {
            return false;
        }
        if (options != null && options.containsNull()) {
            return false;
        }
        if (!ii.isRequired()) {
            return true;
        }
        return ObjectUtils.isEmpty((Object)currentValue);
    }

    public void initOptions(UISelectOne input, TextResolver textResolver, InputControl.InputInfo ii) {
        Object currentValue;
        Options options = ii.getOptions();
        if (options == null) {
            if (ii.getColumn() != null) {
                log.warn("No options given for column {}", (Object)ii.getColumn().getName());
            } else {
                log.warn("No options given for select tag {}", (Object)input.getClientId());
            }
            options = new Options();
        }
        if (this.isEmptyEntryRequired(input, options, ii, currentValue = ii.getValue(true))) {
            this.addSelectItem((UIComponent)input, textResolver, new OptionEntry(null, this.getNullText(ii)));
        }
        if (options != null && options.size() > 0) {
            for (OptionEntry oe : options) {
                if (oe.isActive() || ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                    this.addSelectItem((UIComponent)input, textResolver, oe);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Select item {} is not active.", oe.getValue());
            }
        }
    }

    public void syncOptions(UISelectOne input, TextResolver textResolver, InputControl.InputInfo ii) {
        Options options = ii.getOptions();
        if (options == null) {
            if (ii.getValue(false) != null) {
                log.warn("No options have been set for column {}", (Object)ii.getColumn().getName());
            } else {
                input.getChildren().clear();
            }
            return;
        }
        Object currentValue = ii.getValue(true);
        boolean hasEmpty = this.isEmptyEntryRequired(input, options, ii, currentValue);
        Iterator ioe = options.iterator();
        OptionEntry oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        List childList = input.getChildren();
        if (childList.isEmpty()) {
            childList.add(new UISelectItems());
        } else if (childList.size() > 1 && !(childList.get(1) instanceof UIParameter)) {
            log.warn("Unexpected number of child items ({}) for SelectInputControl of column {}", (Object)childList.size(), (Object)ii.getColumn().getName());
        }
        UISelectItems items = (UISelectItems)childList.get(0);
        ArrayList selectItemList = (ArrayList)items.getValue();
        if (selectItemList == null) {
            selectItemList = new ArrayList();
            items.setValue(selectItemList);
        }
        Iterator ico = selectItemList.iterator();
        int lastIndex = 0;
        boolean emptyPresent = false;
        while (ico.hasNext()) {
            ++lastIndex;
            SelectItem si = (SelectItem)ico.next();
            Object ov = si.getValue();
            if (ObjectUtils.isEmpty((Object)ov) && hasEmpty) {
                emptyPresent = true;
                continue;
            }
            while (oe != null && !oe.isActive() && !ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
            }
            if (oe == null) {
                --lastIndex;
                for (int index = selectItemList.size() - 1; index >= lastIndex; --index) {
                    selectItemList.remove(index);
                }
                return;
            }
            if (ObjectUtils.compareEqual((Object)ov, (Object)oe.getValue())) {
                this.setItemLabel(si, textResolver, oe);
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
                continue;
            }
            input.getChildren().clear();
            if (hasEmpty) {
                this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", this.getNullText(ii)));
            }
            for (OptionEntry opt : options) {
                if (!opt.isActive() && !ObjectUtils.compareEqual((Object)opt.getValue(), (Object)currentValue)) continue;
                this.addSelectItem((UIComponent)input, textResolver, opt);
            }
            return;
        }
        if (hasEmpty && !emptyPresent) {
            this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", this.getNullText(ii)), 0);
        }
        while (oe != null) {
            if (oe.isActive() || ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                this.addSelectItem((UIComponent)input, textResolver, oe);
            }
            oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        }
    }

    public void addSelectItem(UIComponent input, TextResolver textResolver, OptionEntry oe, int pos) {
        ArrayList<SelectItem> list;
        List children = input.getChildren();
        if (children.isEmpty()) {
            UISelectItems items = new UISelectItems();
            children.add(items);
            list = new ArrayList<SelectItem>();
            items.setValue(list);
        } else {
            UISelectItems items = (UISelectItems)children.get(0);
            list = (ArrayList<SelectItem>)items.getValue();
        }
        Object valueExpressionFlag = input.getAttributes().get(VALUE_EXPRESSION_FLAG);
        Object value = ObjectUtils.getBoolean(valueExpressionFlag) ? this.formatInputValue(oe.getValue()) : oe.getValueString();
        SelectItem selectItem = new SelectItem();
        selectItem.setValue(value);
        this.setItemLabel(selectItem, textResolver, oe);
        if (pos >= 0) {
            list.add(pos, selectItem);
        } else {
            list.add(selectItem);
        }
    }

    public void addSelectItem(UIComponent input, TextResolver textResolver, OptionEntry e) {
        this.addSelectItem(input, textResolver, e, -1);
    }

    protected void setItemLabel(SelectItem si, TextResolver textResolver, OptionEntry oe) {
        String text = oe.getText();
        if (si.getLabel() != null && text != null && text.startsWith("!")) {
            return;
        }
        text = textResolver.resolveText(text);
        si.setLabel(text);
    }

    protected String getNullText(InputControl.InputInfo ii) {
        String nullText = this.getFormatString(ii, "null:", "format:null");
        return nullText != null ? ii.getText(nullText) : "";
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        String text;
        Object attrValue;
        Column column;
        if (vi.getOptions() == null) {
            if (!this.hasFormatOption(vi, "nolookup")) {
                log.warn("Select field {} has no Option list attached!", (Object)vi.getColumn().getName());
            }
            return super.formatValue(value, vi);
        }
        if (this.hasFormatOption(vi, "short") && (column = vi.getColumn()) != null && (attrValue = column.getAttribute(COLATTR_ABBR_OPTIONS)) instanceof Options && (text = this.getOptionText((Options)attrValue, value, vi)) != null) {
            return text;
        }
        return super.formatValue(value, vi);
    }

    @Override
    protected Object formatInputValue(Object value, InputControl.InputInfo ii) {
        Class enumType;
        if (value instanceof Number && (enumType = ii.getColumn().getEnumType()) != null) {
            Enum enumVal = ObjectUtils.getEnum((Class)enumType, (Object)value);
            value = enumVal.name();
        }
        return this.formatInputValue(value);
    }

    protected Object formatInputValue(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        Class enumType = ii.getColumn().getEnumType();
        if (enumType != null) {
            return ObjectUtils.getEnumByName((Class)enumType, (String)value);
        }
        return value;
    }
}

