/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.oracle;

import java.util.ArrayList;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParamList;
import org.apache.empire.db.DBCmdParams;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.dbms.oracle.DBMSHandlerOracle;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;

public class DBCommandOracle
extends DBCommand {
    protected DBCompareExpr connectBy = null;
    protected DBCompareExpr startWith = null;
    protected String optimizerHint = null;
    protected int limitRows = -1;
    protected int skipRows = 0;

    public DBCommandOracle(DBMSHandlerOracle dbms, boolean autoPrepareStmt) {
        super(dbms, autoPrepareStmt);
    }

    public String getOptimizerHint() {
        return this.optimizerHint;
    }

    public void setOptimizerHint(String optimizerHint) {
        this.optimizerHint = optimizerHint;
    }

    public void setOptimizerIndexHint(DBIndex index) {
        if (index == null || index.getTable() == null) {
            throw new InvalidArgumentException("index", index);
        }
        String tableAlias = index.getTable().getAlias();
        String indexName = index.getName();
        String indexHint = "INDEX (" + tableAlias + " " + indexName + ")";
        this.optimizerHint = StringUtils.isNotEmpty(this.optimizerHint) && this.optimizerHint.indexOf(indexHint) < 0 ? this.optimizerHint + " " + indexHint : indexHint;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearConnectBy();
        this.optimizerHint = null;
    }

    public void clearConnectBy() {
        this.startWith = null;
        this.connectBy = null;
    }

    public void connectByPrior(DBCompareExpr expr) {
        this.connectBy = expr;
    }

    public void startWith(DBCompareExpr expr) {
        this.startWith = expr;
    }

    @Override
    public DBCommandOracle limitRows(int limitRows) {
        this.limitRows = limitRows;
        return this;
    }

    @Override
    public DBCommandOracle skipRows(int skipRows) {
        if (skipRows < 0) {
            throw new InvalidArgumentException("skipRows", skipRows);
        }
        this.skipRows = skipRows;
        return this;
    }

    @Override
    public void clearLimit() {
        this.limitRows = -1;
        this.skipRows = 0;
    }

    @Override
    public synchronized void getSelect(DBSQLBuilder sql) {
        this.resetParamUsage();
        if (this.select == null) {
            throw new ObjectNotValidException(this);
        }
        boolean usePreparedStatements = this.isPreparedStatementsEnabled();
        if (this.limitRows >= 0) {
            sql.append("SELECT * FROM (");
            if (this.skipRows > 0) {
                sql.append("SELECT row_.*, rownum rownum_ FROM (");
            }
        }
        sql.append("SELECT ");
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            sql.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        if (this.selectDistinct) {
            sql.append("DISTINCT ");
        }
        this.addListExpr(sql, this.select, 15L, ", ");
        this.addFrom(sql);
        this.addWhere(sql);
        if (this.connectBy != null) {
            sql.append("\r\nCONNECT BY PRIOR ");
            this.connectBy.addSQL(sql, 23L);
            if (this.startWith != null) {
                sql.append("\r\nSTART WITH ");
                this.startWith.addSQL(sql, 7L);
            }
        }
        this.addGrouping(sql);
        if (this.orderBy != null) {
            if (this.connectBy != null) {
                sql.append("\r\nORDER SIBLINGS BY ");
            } else {
                sql.append("\r\nORDER BY ");
            }
            this.addListExpr(sql, this.orderBy, 7L, ", ");
        }
        if (this.limitRows >= 0) {
            sql.append(") row_ WHERE rownum<=");
            sql.append(usePreparedStatements ? "?" : String.valueOf(this.skipRows + this.limitRows));
            if (this.skipRows > 0) {
                sql.append(") WHERE rownum_>");
                sql.append(usePreparedStatements ? "?" : String.valueOf(this.skipRows));
            }
        }
        this.completeParamUsage();
    }

    @Override
    public DBCmdParams getParams() {
        DBCmdParams params = super.getParams();
        if (this.limitRows < 0 || !this.isPreparedStatementsEnabled()) {
            return params;
        }
        DBCmdParamList extended = new DBCmdParamList(params);
        extended.add(this, DataType.INTEGER, this.limitRows);
        if (this.skipRows > 0) {
            extended.add(this, DataType.INTEGER, this.skipRows);
        }
        return extended;
    }

    @Override
    public Object[] getParamValues() {
        Object[] params = super.getParamValues();
        if (this.limitRows < 0 || !this.isPreparedStatementsEnabled()) {
            return params;
        }
        int newSize = (params != null ? params.length : 0) + (this.skipRows > 0 ? 2 : 1);
        Object[] newParams = new Object[newSize];
        for (int i = 0; params != null && i < params.length; ++i) {
            newParams[i] = params[i];
        }
        if (this.skipRows > 0) {
            newParams[--newSize] = this.skipRows;
        }
        newParams[--newSize] = this.skipRows + this.limitRows;
        return newParams;
    }

    @Override
    protected void addUpdateForTable(DBSQLBuilder sql, DBRowSet table) {
        long context = 2L;
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            sql.append("/*+ ").append(this.optimizerHint).append(" */ ");
            if (this.optimizerHint.contains(table.getAlias())) {
                context |= 8L;
            }
        }
        table.addSQL(sql, context);
        context = 5L;
        sql.append("\r\nSET ");
        this.addListExpr(sql, this.set, context, ", ");
        this.addWhere(sql, context);
    }

    @Override
    protected void addUpdateWithJoins(DBSQLBuilder sql, DBRowSet table) {
        DBColumn[] keyColumns = table.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(table);
        }
        sql.reset(0);
        sql.append("MERGE INTO ");
        table.addSQL(sql, 10L);
        sql.append("\r\nUSING (");
        ArrayList<DBColumnExpr> using = new ArrayList<DBColumnExpr>();
        for (DBColumn col : keyColumns) {
            using.add(col);
        }
        ArrayList<DBSetExpr> mergeSet = new ArrayList<DBSetExpr>(this.set.size());
        for (DBSetExpr sex : this.set) {
            DBColumn setColum;
            Object val = sex.getValue();
            if (val instanceof DBColumnExpr) {
                DBColumnExpr expr = (DBColumnExpr)val;
                if (!(expr instanceof DBColumn) && !(expr instanceof DBAliasExpr)) {
                    String name = "COL_" + String.valueOf(mergeSet.size());
                    expr = expr.as(name);
                }
                using.add(expr);
                DBValueExpr NAME_EXPR = this.getDatabase().getValueExpr("q0." + expr.getName(), DataType.UNKNOWN);
                mergeSet.add(sex.getColumn().to(NAME_EXPR));
            } else {
                mergeSet.add(sex);
            }
            if (!using.contains(setColum = sex.getColumn())) continue;
            using.remove(setColum);
        }
        sql.append("SELECT ");
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            sql.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        this.addListExpr(sql, using, 15L, ", ");
        this.addFrom(sql);
        this.addWhere(sql);
        this.addGrouping(sql);
        int count = 0;
        sql.append(") q0\r\nON (");
        for (DBColumn col : keyColumns) {
            if (!using.contains(col)) continue;
            if (count++ > 0) {
                sql.append(" AND ");
            }
            sql.append(" q0.");
            col.addSQL(sql, 1L);
            sql.append("=");
            sql.append(table.getAlias());
            sql.append(".");
            col.addSQL(sql, 1L);
        }
        sql.append(")\r\nWHEN MATCHED THEN UPDATE ");
        sql.append("\r\nSET ");
        this.addListExpr(sql, mergeSet, 7L, ", ");
    }

    @Override
    protected void addDeleteForTable(DBSQLBuilder sql, DBRowSet table) {
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            sql.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        super.addDeleteForTable(sql, table);
    }

    @Override
    protected void addDeleteWithJoins(DBSQLBuilder sql, DBRowSet table) {
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            sql.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        super.addDeleteWithJoins(sql, table);
    }
}

