/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.EntityType;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBXmlDictionary;
import org.apache.empire.db.context.DBRollbackHandler;
import org.apache.empire.db.exceptions.FieldReadOnlyException;
import org.apache.empire.db.exceptions.FieldValueNotFetchedException;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.RecordReadOnlyException;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DBRecordBase
extends DBRecordData
implements Record,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBRecordBase.class);
    private State state = State.Invalid;
    private Object[] fields = null;
    private boolean[] modified = null;
    Object rowsetData = null;
    protected boolean validateFieldValues = true;
    protected boolean allowReadOnlyUpdate = false;
    private Map<DBColumn, DBRecordBase> parentRecordMap = null;

    protected DBRecordBase() {
    }

    protected void checkValid() {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
    }

    protected void checkValid(int fieldIndex) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (fieldIndex < 0 || fieldIndex >= this.fields.length) {
            throw new InvalidArgumentException("index", fieldIndex);
        }
    }

    public void close() {
        this.fields = null;
        this.modified = null;
        this.rowsetData = null;
        if (this.state != State.Invalid) {
            this.changeState(State.Invalid);
        }
        this.onRecordChanged();
    }

    public DBRecordBase clone() {
        try {
            DBRecordBase rec = (DBRecordBase)super.clone();
            rec.state = this.state;
            if (rec.fields == this.fields && this.fields != null) {
                rec.fields = (Object[])this.fields.clone();
            }
            if (rec.modified == this.modified && this.modified != null) {
                rec.modified = (boolean[])this.modified.clone();
            }
            rec.rowsetData = ClassUtils.copy(this.rowsetData);
            return rec;
        }
        catch (CloneNotSupportedException e) {
            log.error("Unable to clone record.", (Throwable)e);
            return null;
        }
    }

    public abstract DBRowSet getRowSet();

    public abstract boolean isRollbackHandlingEnabled();

    @Override
    public EntityType getEntityType() {
        return this.getRowSet();
    }

    public DBDatabase getDatabase() {
        return this.getRowSet().getDatabase();
    }

    public State getState() {
        return this.state;
    }

    @Override
    public boolean isValid() {
        return this.state != State.Invalid;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isValid()) {
            return true;
        }
        DBRowSet rowset = this.getRowSet();
        return rowset == null || !rowset.isUpdateable();
    }

    @Override
    public boolean isModified() {
        return this.state.isEqualOrMore(State.Modified);
    }

    @Override
    public boolean isNew() {
        return this.state == State.New;
    }

    public boolean isExists() {
        return this.state == State.Valid || this.state == State.Modified;
    }

    @Override
    public int getFieldCount() {
        return this.fields != null ? this.fields.length : 0;
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        return this.getRowSet().getColumnIndex(column);
    }

    @Override
    public int getFieldIndex(String column) {
        List<DBColumn> columns = this.getRowSet().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            DBColumn col = columns.get(i);
            if (!col.getName().equalsIgnoreCase(column)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DBColumn getColumn(int index) {
        return this.getRowSet().getColumn(index);
    }

    public boolean wasModified(int index) {
        this.checkValid(index);
        if (this.modified == null) {
            return false;
        }
        return this.modified[index];
    }

    @Override
    public final boolean wasModified(Column column) {
        return this.wasModified(this.getFieldIndex(column));
    }

    public final boolean wasAnyModified(Column ... columns) {
        for (Column c : columns) {
            if (!this.wasModified(this.getFieldIndex(c))) continue;
            return true;
        }
        return false;
    }

    public boolean isValidateFieldValues() {
        return this.validateFieldValues;
    }

    public void setValidateFieldValues(boolean validateFieldValues) {
        this.validateFieldValues = validateFieldValues;
    }

    @Override
    public Column[] getKeyColumns() {
        return this.getRowSet().getKeyColumns();
    }

    @Override
    public Object[] getKey() {
        Column[] keyColumns = this.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(this.getRowSet());
        }
        Object[] key = new Object[keyColumns.length];
        for (int i = 0; i < keyColumns.length; ++i) {
            key[i] = this.get(keyColumns[i]);
            if (key[i] != null) continue;
            log.warn("DBRecord.getKey() failed: " + this.getRowSet().getName() + " primary key value is null!");
        }
        return key;
    }

    @Override
    public Object getValue(int index) {
        this.checkValid(index);
        if (this.fields[index] == ObjectUtils.NO_VALUE) {
            throw new FieldValueNotFetchedException(this.getColumn(index));
        }
        return this.fields[index];
    }

    public boolean isValueValid(int index) {
        this.checkValid(index);
        return this.fields[index] != ObjectUtils.NO_VALUE;
    }

    public Options getFieldOptions(DBColumn column) {
        return column.getOptions();
    }

    @Override
    public final Options getFieldOptions(Column column) {
        return this.getFieldOptions((DBColumn)column);
    }

    public void validateAllValues() {
        this.checkValid();
        if (this.modified == null) {
            return;
        }
        for (int index = 0; index < this.fields.length; ++index) {
            DBColumn column;
            if (!this.modified[index] || this.fields[index] == ObjectUtils.NO_VALUE || (column = this.getColumn(index)).isAutoGenerated()) continue;
            this.fields[index] = this.validateValue(column, this.fields[index]);
        }
    }

    @Override
    public void setValue(int index, Object value) {
        Object validated;
        Object current;
        this.checkValid(index);
        this.checkUpdateable();
        if (value instanceof DBRecordBase) {
            this.setParentRecord(this.getColumn(index), (DBRecordBase)value);
            return;
        }
        if (value instanceof String && ((String)value).length() == 0) {
            value = null;
        }
        if ((current = this.fields[index]) == ObjectUtils.NO_VALUE) {
            throw new FieldValueNotFetchedException(this.getColumn(index));
        }
        DBColumn column = this.getColumn(index);
        if (value instanceof Enum) {
            Enum enumVal = (Enum)value;
            boolean numeric = column.getDataType().isNumeric();
            value = ObjectUtils.getEnumValue(enumVal, numeric);
        }
        if (ObjectUtils.compareEqual(current, value)) {
            return;
        }
        if (!this.allowFieldChange(column)) {
            throw new FieldReadOnlyException(column);
        }
        if (this.isValidateFieldValues() && value != (validated = this.validateValue(column, value))) {
            if (ObjectUtils.compareEqual(current, validated)) {
                return;
            }
            value = validated;
        }
        this.modifyValue(index, value, true);
    }

    @Deprecated
    public DBRecordBase setValue(Column column, Object value) {
        return this.set(column, value);
    }

    @Override
    public DBRecordBase set(Column column, Object value) {
        this.setValue(this.getFieldIndex(column), value);
        return this;
    }

    @Override
    public Object validateValue(Column column, Object value) {
        return column.validateValue(value);
    }

    @Override
    public boolean isFieldVisible(Column column) {
        int index = this.getRowSet().getColumnIndex(column);
        if (index < 0) {
            log.warn("Column {} does not exist for record of {}", (Object)column.getName(), (Object)this.getRowSet().getName());
        }
        return index >= 0 && this.isValueValid(index);
    }

    @Override
    public boolean isFieldReadOnly(Column column) {
        DBRowSet rowset = this.getRowSet();
        if (this.getFieldIndex(column) < 0) {
            throw new InvalidArgumentException("column", column);
        }
        if (this.isValid() && !this.isNew() && rowset.isKeyColumn((DBColumn)column)) {
            return true;
        }
        return rowset.isColumnReadOnly((DBColumn)column);
    }

    @Override
    public boolean isFieldRequired(Column column) {
        if (this.getRowSet().getColumnIndex(column) < 0) {
            throw new InvalidArgumentException("column", column);
        }
        return column.isRequired();
    }

    @Override
    public int setRecordValues(Object bean, Collection<Column> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            DBColumn column = this.getColumn(i);
            if (column.isReadOnly() || ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            this.setRecordValue(column, bean, property);
            ++count;
        }
        return count;
    }

    @Override
    public final int setRecordValues(Object bean) {
        return this.setRecordValues(bean, null);
    }

    public void setParentRecord(DBColumn parentIdColumn, DBRecordBase record) {
        this.checkValid();
        DBRecordBase.checkParamNull("parentIdColumn", parentIdColumn);
        this.checkUpdateable();
        if (record == null) {
            if (this.parentRecordMap != null) {
                this.parentRecordMap.remove(parentIdColumn);
            }
            this.set(parentIdColumn, null);
            return;
        }
        Object[] key = record.getKey();
        if (key.length != 1) {
            throw new NotSupportedException(this, "setParentRecord");
        }
        if (key[0] == null) {
            if (this.parentRecordMap == null) {
                this.parentRecordMap = new HashMap<DBColumn, DBRecordBase>(1);
            }
            log.info("Deffering setting of {} until the record is saved!", (Object)parentIdColumn.getName());
            this.parentRecordMap.put(parentIdColumn, record);
        } else {
            int index = this.getFieldIndex(parentIdColumn);
            Object id = this.getValue(index);
            if (!ObjectUtils.compareEqual(id, key[0])) {
                this.modifyValue(index, key[0], true);
            }
        }
    }

    public boolean isSame(DBRecordBase other) {
        if (!this.isValid() || !other.isValid()) {
            return false;
        }
        if (!this.getRowSet().isSame(other.getRowSet())) {
            return false;
        }
        Object[] key1 = this.getKey();
        Object[] key2 = other.getKey();
        return ObjectUtils.compareEqual(key1, key2);
    }

    @Override
    public int addXmlMeta(Element parent) {
        this.checkValid();
        int count = 0;
        List<DBColumn> columns = this.getRowSet().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            DBColumn column = columns.get(i);
            if (!this.isFieldVisible(column)) continue;
            column.addXml(parent, 0L);
            ++count;
        }
        return count;
    }

    @Override
    public int addXmlData(Element parent) {
        this.checkValid();
        Column[] keyColumns = this.getKeyColumns();
        if (keyColumns != null && keyColumns.length > 0) {
            if (keyColumns.length > 1) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < keyColumns.length; ++i) {
                    if (i > 0) {
                        buf.append("/");
                    }
                    buf.append(this.getString(keyColumns[i]));
                }
                parent.setAttribute("id", buf.toString());
            } else {
                parent.setAttribute("id", this.getString(keyColumns[0]));
            }
        }
        if (this.isNew()) {
            parent.setAttribute("new", "1");
        }
        int count = 0;
        List<DBColumn> columns = this.getRowSet().getColumns();
        for (int i = 0; i < this.fields.length; ++i) {
            DBColumn column = columns.get(i);
            if (!this.isFieldVisible(column)) continue;
            String name = column.getName();
            if (this.fields[i] != null) {
                XMLUtil.addElement(parent, name, this.getString(i));
            } else {
                XMLUtil.addElement(parent, name).setAttribute("null", "yes");
            }
            ++count;
        }
        return count;
    }

    @Override
    public Document getXmlDocument() {
        this.checkValid();
        DBXmlDictionary xmlDic = this.getXmlDictionary();
        Element root = XMLUtil.createDocument(xmlDic.getRowSetElementName());
        DBRowSet rowset = this.getRowSet();
        if (rowset.getName() != null) {
            root.setAttribute("name", rowset.getName());
        }
        if (this.addXmlMeta(root) > 0) {
            this.addXmlData(XMLUtil.addElement(root, xmlDic.getRowElementName()));
        }
        return root.getOwnerDocument();
    }

    protected Object[] getFields() {
        return this.fields;
    }

    protected void changeState(State newState) {
        this.state = newState;
    }

    protected DBRollbackHandler createRollbackHandler() {
        return new DBRecordRollbackHandler(this);
    }

    protected void initData(boolean newRecord) {
        DBRowSet rowset = this.getRowSet();
        int colCount = rowset.getColumns().size();
        if (this.fields == null || this.fields.length != colCount) {
            this.fields = new Object[colCount];
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == ObjectUtils.NO_VALUE) continue;
                this.fields[i] = null;
            }
        }
        this.modified = null;
        this.rowsetData = null;
        this.changeState(rowset == null ? State.Invalid : (newRecord ? State.New : State.Valid));
    }

    protected void updateComplete() {
        this.modified = null;
        this.changeState(State.Valid);
    }

    protected void checkUpdateable() {
        if (this.isReadOnly() && !this.allowReadOnlyUpdate) {
            throw new RecordReadOnlyException(this);
        }
    }

    protected boolean allowFieldChange(DBColumn column) {
        if (!(!column.isAutoGenerated() || this.isNew() && this.isNull(column))) {
            return false;
        }
        return this.isNew() || !this.getRowSet().isKeyColumn(column);
    }

    protected void modifyValue(int index, Object value, boolean fireChangeEvent) {
        this.checkValid(index);
        if (this.modified == null) {
            this.modified = new boolean[this.fields.length];
            for (int j = 0; j < this.fields.length; ++j) {
                this.modified[j] = false;
            }
        }
        this.fields[index] = value;
        this.modified[index] = true;
        if (this.state.isLess(State.Modified)) {
            this.changeState(State.Modified);
        }
        if (fireChangeEvent) {
            this.onFieldChanged(index);
        }
    }

    protected void onRecordChanged() {
        if (log.isTraceEnabled() && this.isValid()) {
            log.trace("Record has been changed");
        }
        if (this.fields != null && this.isRollbackHandlingEnabled()) {
            this.getContext().removeRollbackHandler(this);
        }
    }

    protected void onFieldChanged(int i) {
        if (log.isDebugEnabled()) {
            log.debug("Record field " + this.getColumn(i).getName() + " changed to " + String.valueOf(this.fields[i]));
        }
    }

    protected void setRecordValue(Column column, Object bean, String property) {
        if (StringUtils.isEmpty(property)) {
            property = column.getBeanPropertyName();
        }
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            Object value = pub.getSimpleProperty(bean, property);
            this.set(column, value);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    protected void assignParentIdentities() {
        if (this.parentRecordMap == null) {
            return;
        }
        for (Map.Entry<DBColumn, DBRecordBase> e : this.parentRecordMap.entrySet()) {
            DBColumn parentIdColumn = e.getKey();
            Object keyValue = e.getValue().getKey()[0];
            if (keyValue == null) {
                throw new ObjectNotValidException(e.getValue());
            }
            log.info("Deffered setting of {} to {}!", (Object)parentIdColumn.getName(), keyValue);
            this.set(parentIdColumn, keyValue);
        }
        this.parentRecordMap.clear();
    }

    protected boolean isColumn(int index, DBColumn ... column) {
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (column == null) {
            throw new InvalidArgumentException("column", column);
        }
        DBColumn col = this.getColumn(index);
        for (int i = 0; i < column.length; ++i) {
            if (col != column[i]) continue;
            return true;
        }
        return false;
    }

    protected DBXmlDictionary getXmlDictionary() {
        return DBXmlDictionary.getInstance();
    }

    static /* synthetic */ Object[] access$202(DBRecordBase x0, Object[] x1) {
        x0.fields = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$102(DBRecordBase x0, boolean[] x1) {
        x0.modified = x1;
        return x1;
    }

    public static enum State {
        Invalid,
        Valid,
        Modified,
        New;


        boolean isLess(State other) {
            return this.ordinal() < other.ordinal();
        }

        boolean isEqualOrMore(State other) {
            return this.ordinal() >= other.ordinal();
        }
    }

    public static class DBRecordRollbackHandler
    implements DBRollbackHandler {
        private static final Logger log = LoggerFactory.getLogger(DBRecordRollbackHandler.class);
        public final DBRecordBase record;
        private final State state;
        private Object[] fields;
        private boolean[] modified;
        private Object rowsetData;

        public DBRecordRollbackHandler(DBRecordBase record) {
            this.record = record;
            if (record.state == State.Invalid) {
                throw new ObjectNotValidException(record);
            }
            this.state = record.state;
            this.modified = this.copy(record.modified);
            this.fields = this.copy(record.fields);
            this.rowsetData = this.copy(record.rowsetData);
        }

        @Override
        public DBObject getObject() {
            return this.record;
        }

        @Override
        public String getObjectInfo() {
            String info = "Record " + this.record.getRowSet().getName();
            if (this.record.getKeyColumns() == null) {
                return info;
            }
            return info + ":" + StringUtils.arrayToString(this.record.getKey(), "|");
        }

        @Override
        public void combine(DBRollbackHandler successor) {
            if (this.record != successor.getObject()) {
                throw new InvalidArgumentException("successor", successor);
            }
            DBRecordRollbackHandler s = (DBRecordRollbackHandler)successor;
            log.info("combining rollback state for record {}/{}", (Object)this.record.getRowSet().getName(), (Object)StringUtils.arrayToString(this.record.getKey(), "|"));
            if (s.modified == null) {
                return;
            }
            if (this.modified == null) {
                this.modified = new boolean[this.fields.length];
            }
            DBRowSet rowset = this.record.getRowSet();
            DBColumn tsColumn = this.record.getRowSet().getTimestampColumn();
            for (int i = 0; i < this.fields.length; ++i) {
                DBColumn column = this.record.getColumn(i);
                if (column == tsColumn || rowset.isKeyColumn(column) || !s.modified[i]) continue;
                this.fields[i] = s.fields[i];
                if (this.modified == null) continue;
                this.modified[i] = true;
            }
        }

        @Override
        public void rollback(Connection conn) {
            this.record.state = this.state;
            DBRecordBase.access$202(this.record, this.fields);
            DBRecordBase.access$102(this.record, this.modified);
            this.record.rowsetData = this.rowsetData;
            if (log.isInfoEnabled()) {
                log.info("Rollback for {} performed.", (Object)this.getObjectInfo());
            }
        }

        @Override
        public void discard(Connection conn) {
        }

        private boolean[] copy(boolean[] other) {
            if (other == null) {
                return null;
            }
            boolean[] copy = new boolean[other.length];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = other[i];
            }
            return copy;
        }

        private Object[] copy(Object[] other) {
            if (other == null) {
                return null;
            }
            Object[] copy = new Object[other.length];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = other[i];
            }
            return copy;
        }

        protected Object copy(Object other) {
            if (other == null) {
                return null;
            }
            if (other instanceof Object[]) {
                return this.copy((Object[])other);
            }
            return ClassUtils.copy(other);
        }
    }
}

