/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRecord
extends DBRecordBase {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBRecord.class);
    protected final transient DBContext context;
    protected final transient DBRowSet rowset;
    private boolean enableRollbackHandling;

    public static Object[] key(Object ... values) {
        if (values.length == 0) {
            throw new InvalidArgumentException("values", values);
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Record) {
                values[i] = ((Record)values[i]).getKey();
            }
            if (!(values[i] instanceof Object[])) continue;
            Object[] key = (Object[])values[i];
            if (key.length != 1) {
                throw new InvalidArgumentException("values", values[i]);
            }
            values[i] = key[0];
        }
        return values;
    }

    private void writeObject(ObjectOutputStream strm) throws IOException {
        this.writeContext(strm);
        this.writeRowSet(strm);
        strm.defaultWriteObject();
    }

    protected void writeContext(ObjectOutputStream strm) throws IOException {
        strm.writeObject(this.context);
    }

    protected void writeRowSet(ObjectOutputStream strm) throws IOException {
        String dbid = this.rowset.getDatabase().getIdentifier();
        String rsid = this.rowset.getName();
        strm.writeObject(dbid);
        strm.writeObject(rsid);
    }

    private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException {
        DBContext ctx = this.readContext(strm);
        ClassUtils.setPrivateFieldValue(DBRecord.class, this, "context", ctx);
        DBRowSet rowset = this.readRowSet(strm);
        ClassUtils.setPrivateFieldValue(DBRecord.class, this, "rowset", rowset);
        strm.defaultReadObject();
    }

    protected DBContext readContext(ObjectInputStream strm) throws IOException, ClassNotFoundException {
        return (DBContext)strm.readObject();
    }

    protected DBRowSet readRowSet(ObjectInputStream strm) throws IOException, ClassNotFoundException {
        String dbid = String.valueOf(strm.readObject());
        String rsid = String.valueOf(strm.readObject());
        DBDatabase dbo = DBDatabase.findByIdentifier(dbid);
        if (dbo == null) {
            throw new ItemNotFoundException((Object)dbid);
        }
        DBRowSet rso = dbo.getRowSet(rsid);
        if (rso == null) {
            throw new ItemNotFoundException((Object)dbid);
        }
        return rso;
    }

    protected DBRecord(DBContext context, DBRowSet rowset, boolean enableRollbackHandling) {
        this.context = context;
        this.rowset = rowset;
        this.enableRollbackHandling = enableRollbackHandling;
        this.validateFieldValues = true;
    }

    public DBRecord(DBContext context, DBRowSet rowset) {
        this(DBRecord.checkParamNull("context", context), DBRecord.checkParamNull("rowset", rowset), context.isRollbackHandlingEnabled());
    }

    @Override
    public DBContext getContext() {
        if (this.context == null) {
            throw new ObjectNotValidException(this);
        }
        return this.context;
    }

    @Override
    public DBRowSet getRowSet() {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        return this.rowset;
    }

    @Override
    public boolean isRollbackHandlingEnabled() {
        return this.enableRollbackHandling;
    }

    public void setRollbackHandlingEnabled(boolean enabled) {
        if (enabled && !this.getContext().isRollbackHandlingEnabled()) {
            throw new InvalidOperationException("Rollback handling cannot be enabled for this record since it is not supported for this context!");
        }
        this.enableRollbackHandling = enabled;
    }

    public long getIdentity() {
        Column[] keyColumns = this.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(this.getRowSet());
        }
        if (keyColumns.length != 1 || !keyColumns[0].getDataType().isNumeric()) {
            throw new NotSupportedException(this, "getIdentity");
        }
        return this.getLong(keyColumns[0]);
    }

    public DBRecord create(Object[] initalKey) {
        this.getRowSet().createRecord(this, initalKey, true);
        return this;
    }

    public DBRecord create() {
        this.getRowSet().createRecord(this, null, false);
        return this;
    }

    public DBRecord read(Object[] key) {
        DBRowSet rs = this.getRowSet();
        DBCompareExpr keyConstraints = rs.getKeyConstraints(key);
        rs.readRecord((DBRecordBase)this, keyConstraints);
        return this;
    }

    public DBRecord read(Object id) {
        if (ObjectUtils.isEmpty(id)) {
            throw new InvalidArgumentException("id", id);
        }
        Object[] key = id instanceof Object[] ? (Object[])id : (id instanceof Collection ? ((Collection)id).toArray() : new Object[]{id});
        return this.read(key);
    }

    public DBRecord read(DBCompareExpr whereConstraints) {
        this.getRowSet().readRecord((DBRecordBase)this, whereConstraints);
        return this;
    }

    public DBRecord read(Object[] key, DBRowSet.PartialMode mode, DBColumn ... columns) {
        DBRowSet rs = this.getRowSet();
        DBCompareExpr keyConstraints = rs.getKeyConstraints(key);
        rs.readRecord(this, keyConstraints, mode, columns);
        return this;
    }

    @Override
    public DBRecord set(Column column, Object value) {
        return (DBRecord)super.set(column, value);
    }

    public void update() {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (!this.isModified()) {
            return;
        }
        this.checkUpdateable();
        if (this.isRollbackHandlingEnabled()) {
            this.getContext().appendRollbackHandler(this.createRollbackHandler());
        }
        this.assignParentIdentities();
        this.getRowSet().updateRecord(this);
    }

    public void delete() {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        this.checkUpdateable();
        if (this.isRollbackHandlingEnabled()) {
            this.getContext().appendRollbackHandler(this.createRollbackHandler());
        }
        if (!this.isNew()) {
            Object[] key = this.getKey();
            log.info("Deleting record {}", (Object)StringUtils.arrayToString(key, "|"));
            this.getRowSet().deleteRecord(key, this.getContext());
        }
        this.close();
    }
}

