/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParams;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.expr.column.DBCmdResultExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.order.DBOrderByExpr;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class DBCommandExpr
extends DBExpr {
    private static final Logger log = LoggerFactory.getLogger(DBCommandExpr.class);
    private final DBMSHandler dbms;
    protected DBCmdQuery cmdQuery = null;
    protected List<DBOrderByExpr> orderBy = null;

    public DBCommandExpr(DBMSHandler dbms) {
        this.dbms = dbms;
    }

    public final DBMSHandler getDbms() {
        return this.dbms;
    }

    public DBCommandExpr clone() {
        try {
            DBCommandExpr clone = (DBCommandExpr)super.clone();
            if (this.orderBy != null) {
                clone.orderBy = new ArrayList<DBOrderByExpr>(this.orderBy);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Cloning DBCommand object failed!", (Throwable)e);
            throw new InternalException(e);
        }
    }

    public abstract boolean isValid();

    public abstract boolean hasSelectExpr();

    public abstract boolean hasSelectExpr(DBColumnExpr var1);

    public abstract DBColumnExpr[] getSelectExprList();

    public abstract List<DBColumnExpr> getSelectExpressions();

    public abstract void getSelect(DBSQLBuilder var1);

    public final String getSelect() {
        DBSQLBuilder sql = this.createSQLBuilder(null);
        this.getSelect(sql);
        return sql.toString();
    }

    public abstract DBCmdParams getParams();

    public abstract Object[] getParamValues();

    public abstract DataType getDataType();

    public DBColumnExpr result() {
        try {
            return new DBCmdResultExpr(this);
        }
        catch (InvalidArgumentException e) {
            throw new NotSupportedException(this, "result");
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 0x10L) == 0L) {
            sql.append("(");
        }
        sql.append(this);
        if ((context & 0x10L) == 0L) {
            sql.append(")");
        }
    }

    public DBCommandExpr union(DBCommandExpr other) {
        return this.dbms.createCombinedCommand(this, "UNION", other);
    }

    public DBCommandExpr unionAll(DBCommandExpr other) {
        return this.dbms.createCombinedCommand(this, "UNION ALL", other);
    }

    public DBCommandExpr intersect(DBCommandExpr other) {
        return this.dbms.createCombinedCommand(this, "INTERSECT", other);
    }

    public boolean hasOrderBy() {
        return this.orderBy != null ? !this.orderBy.isEmpty() : false;
    }

    public List<DBOrderByExpr> getOrderBy() {
        return this.orderBy != null ? Collections.unmodifiableList(this.orderBy) : null;
    }

    public void clearOrderBy() {
        this.orderBy = null;
    }

    public DBCommandExpr orderBy(DBOrderByExpr ... exprs) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<DBOrderByExpr>();
        }
        for (DBOrderByExpr expr : exprs) {
            for (DBOrderByExpr ob : this.orderBy) {
                if (!ob.getColumn().equals(expr.getColumn())) continue;
                ob.setDescending(expr.isDescending());
                expr = null;
                break;
            }
            if (expr == null) continue;
            this.orderBy.add(expr);
        }
        return this;
    }

    public DBCommandExpr orderBy(DBColumnExpr ... exprs) {
        for (DBColumnExpr expr : exprs) {
            this.orderBy(new DBOrderByExpr(expr, false));
        }
        return this;
    }

    public DBCommandExpr orderBy(DBColumnExpr expr, boolean desc) {
        return this.orderBy(new DBOrderByExpr(expr, desc));
    }

    public DBCommandExpr limitRows(int numRows) {
        throw new NotSupportedException(this, "limitRows");
    }

    public DBCommandExpr skipRows(int numRows) {
        throw new NotSupportedException(this, "skipRows");
    }

    public void clearLimit() {
    }

    public final String getInsertInto(DBTable table, List<DBColumnExpr> columns) {
        return this.getInsertInto(table, this.getSelectExprList(), columns);
    }

    public final String getInsertInto(DBTable table) {
        DBColumnExpr[] select = this.getSelectExprList();
        if (select == null || select.length < 1) {
            throw new ObjectNotValidException(this);
        }
        ArrayList<DBColumnExpr> inscols = new ArrayList<DBColumnExpr>(select.length);
        for (int i = 0; i < select.length; ++i) {
            DBColumnExpr expr = select[i];
            DBColumn col = table.getColumn(expr.getName());
            if (col == null) {
                log.warn("InsertInto: Column " + expr.getName() + " not found!");
                col = table.getColumn(i);
            }
            inscols.add(col);
        }
        return this.getInsertInto(table, select, inscols);
    }

    protected DBSQLBuilder createSQLBuilder(String initalSQL) {
        DBSQLBuilder sql = this.dbms.createSQLBuilder();
        if (initalSQL != null) {
            sql.append(initalSQL);
        }
        return sql;
    }

    protected DBColumnExpr getCmdColumn(DBColumnExpr col) {
        if (col instanceof DBCmdColumn) {
            DBCmdColumn c = (DBCmdColumn)col;
            if (c.getRowSet() == this.cmdQuery) {
                return col;
            }
            col = c.expr;
        }
        if (this.cmdQuery == null) {
            this.cmdQuery = new DBCmdQuery(this, (DBDatabase)col.getDatabase(), this.getSelectExprList());
        }
        return new DBCmdColumn((DBRowSet)this.cmdQuery, col);
    }

    protected void addListExpr(DBSQLBuilder sql, List<? extends DBExpr> list, long context, String separator) {
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sql.append(separator);
            }
            list.get(i).addSQL(sql, context);
        }
    }

    protected String getInsertInto(DBTable table, DBColumnExpr[] select, List<DBColumnExpr> columns) {
        if (select == null) {
            throw new ObjectNotValidException(this);
        }
        DBSQLBuilder sql = this.createSQLBuilder("INSERT INTO ");
        table.addSQL(sql, 2L);
        if (columns != null && columns.size() > 0) {
            if (columns.size() != select.length) {
                throw new InvalidArgumentException("columns", "size()!=select.length");
            }
            sql.append(" (");
            this.addListExpr(sql, columns, 1L, ", ");
            sql.append(")");
        }
        sql.append("\r\n");
        this.getSelect(sql);
        return sql.toString();
    }

    protected static class DBCmdColumn
    extends DBColumn {
        private DBColumnExpr expr;

        public DBCmdColumn(DBRowSet query, DBColumnExpr expr) {
            super(query, expr.getName());
            this.expr = expr;
        }

        @Override
        public void addSQL(DBSQLBuilder sql, long context) {
            sql.append(this.expr.getName());
        }

        @Override
        public DataType getDataType() {
            return this.expr.getDataType();
        }

        @Override
        public double getSize() {
            return 0.0;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public boolean isAutoGenerated() {
            return false;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public Object getAttribute(String name) {
            if (this.attributes != null && this.attributes.indexOf(name) >= 0) {
                return this.attributes.get(name);
            }
            return this.expr.getAttribute(name);
        }

        @Override
        public Options getOptions() {
            if (this.options != null) {
                return this.options;
            }
            return this.expr.getOptions();
        }

        @Override
        public Object validateValue(Object value) {
            return value;
        }

        @Override
        public Element addXml(Element parent, long flags) {
            return this.expr.addXml(parent, flags);
        }
    }

    protected static class DBCmdQuery
    extends DBRowSet {
        private DBCommandExpr cmd;

        public DBCmdQuery(DBCommandExpr cmd, DBDatabase db, DBColumnExpr[] exprList) {
            super(db);
            this.cmd = cmd;
            for (int i = 0; i < exprList.length; ++i) {
                this.columns.add(exprList[i].getUpdateColumn());
            }
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getAlias() {
            return null;
        }

        @Override
        public boolean isUpdateable() {
            return false;
        }

        @Override
        public void addReferencedColumns(Set<DBColumn> list) {
            list.addAll(this.columns);
        }

        @Override
        public void addSQL(DBSQLBuilder sql, long context) {
            sql.append("(");
            sql.append(this.cmd);
            sql.append(")");
        }

        @Override
        public DBColumn[] getKeyColumns() {
            throw new NotSupportedException(this, "getKeyColumns");
        }

        @Override
        public void createRecord(DBRecordBase record, Object[] initalKey, boolean deferredInit) {
            throw new NotSupportedException(this, "addRecord");
        }

        @Override
        public void readRecord(DBRecordBase record, DBCompareExpr whereConstraints) {
            throw new NotSupportedException(this, "getRecord");
        }

        public void updateRecord(DBRecordBase rec) {
            throw new NotSupportedException(this, "updateRecord");
        }

        @Override
        public void deleteRecord(Object[] key, DBContext context) {
            throw new NotSupportedException(this, "deleteRecord");
        }
    }
}

