/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBCmdParams;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.order.DBOrderByExpr;

public class DBCombinedCmd
extends DBCommandExpr {
    protected DBCommandExpr left;
    protected DBCommandExpr right;
    protected String keyWord;

    public DBCombinedCmd(DBCommandExpr left, String keyWord, DBCommandExpr right) {
        super(left.getDbms());
        this.left = left;
        this.right = right;
        this.keyWord = keyWord;
    }

    @Override
    public boolean isValid() {
        return this.left.isValid() && this.right.isValid();
    }

    public final DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
    }

    @Override
    public boolean hasSelectExpr() {
        return this.left.hasSelectExpr();
    }

    @Override
    public boolean hasSelectExpr(DBColumnExpr expr) {
        return this.left.hasSelectExpr(expr);
    }

    @Override
    public List<DBColumnExpr> getSelectExpressions() {
        return this.left.getSelectExpressions();
    }

    @Override
    public DBColumnExpr[] getSelectExprList() {
        return this.left.getSelectExprList();
    }

    @Override
    public DBCmdParams getParams() {
        final DBCmdParams lp = this.left.getParams();
        final DBCmdParams rp = this.right.getParams();
        if (lp.isEmpty()) {
            return rp;
        }
        if (rp.isEmpty()) {
            return lp;
        }
        DBCmdParams params = new DBCmdParams(){
            final ArrayList<DBCmdParam> list;
            {
                this.list = new ArrayList(lp.size() + rp.size());
                for (DBCmdParam p : lp) {
                    this.list.add(p);
                }
                for (DBCmdParam p : rp) {
                    this.list.add(p);
                }
            }

            @Override
            public boolean isEmpty() {
                return this.list.isEmpty();
            }

            @Override
            public int size() {
                return this.list.size();
            }

            @Override
            public Iterator<DBCmdParam> iterator() {
                return this.list.iterator();
            }
        };
        return params;
    }

    @Override
    public Object[] getParamValues() {
        int i;
        Object[] leftParams = this.left.getParamValues();
        Object[] rightParams = this.right.getParamValues();
        if (leftParams == null) {
            return rightParams;
        }
        if (rightParams == null) {
            return leftParams;
        }
        Object[] allParams = new Object[leftParams.length + rightParams.length];
        for (i = 0; i < leftParams.length; ++i) {
            allParams[i] = leftParams[i];
        }
        for (i = 0; i < rightParams.length; ++i) {
            allParams[leftParams.length + i] = rightParams[i];
        }
        return allParams;
    }

    @Override
    public DataType getDataType() {
        return this.left.getDataType();
    }

    @Override
    public void getSelect(DBSQLBuilder sql) {
        this.left.clearOrderBy();
        if (!(this.left instanceof DBCombinedCmd)) {
            sql.append("(");
            this.left.getSelect(sql);
            sql.append(")");
        } else {
            this.left.getSelect(sql);
        }
        sql.append("\r\n");
        sql.append(this.keyWord);
        sql.append("\r\n");
        this.right.clearOrderBy();
        if (!(this.right instanceof DBCombinedCmd)) {
            sql.append("(");
            this.right.getSelect(sql);
            sql.append(")");
        } else {
            this.right.getSelect(sql);
        }
        if (this.orderBy != null) {
            sql.append("\r\nORDER BY ");
            this.addListExpr(sql, this.orderBy, 7L, ", ");
        }
    }

    @Override
    public DBCommandExpr orderBy(DBOrderByExpr ... exprs) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList();
        }
        for (DBOrderByExpr obe : exprs) {
            DBColumnExpr c = this.getCmdColumn(obe.getColumn());
            this.orderBy.add(new DBOrderByExpr(c, obe.isDescending()));
        }
        return this;
    }
}

