/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.impl;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationInstanceFactoryMetadataMap;
import com.sun.faces.component.CompositeComponentStackManager;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.facelets.el.ContextualCompositeValueExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import java.util.ArrayList;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.utils.ValueExpressionUnwrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojarraImplementation
implements FacesImplementation {
    private static final Logger log = LoggerFactory.getLogger(FacesImplementation.class);
    private final ApplicationAssociate applAssociate;
    private FacesImplementation.BeanStorageProvider beanStorage = null;

    public MojarraImplementation(ExternalContext externalContext) {
        log.debug("MojarraImplementation created");
        this.applAssociate = ApplicationAssociate.getInstance((ExternalContext)externalContext);
    }

    @Override
    public boolean registerElResolver(Class<? extends ELResolver> resolverClass) {
        ArrayList list = this.applAssociate.getELResolversFromFacesConfig();
        if (list != null) {
            for (ELResolver resolver : list) {
                if (!resolver.getClass().equals(resolverClass)) continue;
                return false;
            }
        } else {
            list = new ArrayList();
            this.applAssociate.setELResolversFromFacesConfig(list);
        }
        log.error("registerElResolver is not supported for Mojarra! Reason is, that it's too late and the ElResolver chain has already been built. Please define in faces-config.xml");
        throw new NotSupportedException((Object)this, "registerElResolver");
    }

    @Override
    public void registerManagedBean(String beanName, String beanClass, String scope) {
        BeanManager bm = this.applAssociate.getBeanManager();
        if (bm.getRegisteredBeans().containsKey(beanName)) {
            throw new ItemExistsException((Object)beanName);
        }
        ManagedBeanInfo mbi = new ManagedBeanInfo(beanName, beanClass, "view", null, null, null, null);
        bm.register(mbi);
    }

    @Override
    public Object getManagedBean(String beanName, FacesContext fc) {
        BeanManager bm = this.applAssociate.getBeanManager();
        Object mbean = bm.getBeanFromScope(beanName, fc);
        if (mbean == null) {
            mbean = bm.create(beanName, fc);
        }
        return mbean;
    }

    @Override
    public UIComponent getValueParentComponent(ValueExpression ve) {
        if (ve instanceof ContextualCompositeValueExpression) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            ContextualCompositeValueExpression ccve = (ContextualCompositeValueExpression)ve;
            CompositeComponentStackManager manager = CompositeComponentStackManager.getManager((FacesContext)ctx);
            UIComponent cc = manager.findCompositeComponentUsingLocation(ctx, ccve.getLocation());
            return cc;
        }
        return null;
    }

    @Override
    public ValueExpression unwrapValueExpression(ValueExpression ve) {
        if (ve instanceof TagValueExpression) {
            ve = ((TagValueExpression)ve).getWrapped();
        }
        return ValueExpressionUnwrapper.getInstance().unwrap(ve);
    }

    @Override
    public FacesImplementation.BeanStorageProvider getBeanStorageProvider(ExternalContext externalContext) {
        if (this.beanStorage == null) {
            if (externalContext == null) {
                externalContext = FacesContext.getCurrentInstance().getExternalContext();
            }
            this.beanStorage = new MojarraBeanStorageProvider(externalContext);
        }
        return this.beanStorage;
    }

    @Override
    public void configComplete() {
        this.beanStorage = null;
    }

    protected static class MojarraBeanStorageProvider
    implements FacesImplementation.BeanStorageProvider {
        private final ApplicationInstanceFactoryMetadataMap<String, Object> classMetadataMap;
        private final InjectionProvider injectionProvider;

        public MojarraBeanStorageProvider(ExternalContext externalContext) {
            String METADATA_MAP_KEY = ApplicationConfigProcessor.class.getName() + ".METADATA";
            ServletContext sc = (ServletContext)externalContext.getContext();
            this.classMetadataMap = (ApplicationInstanceFactoryMetadataMap)sc.getAttribute(METADATA_MAP_KEY);
            this.injectionProvider = (InjectionProvider)FacesContext.getCurrentInstance().getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY);
        }

        @Override
        public void injectBean(Object bean) {
            if (this.classMetadataMap == null) {
                return;
            }
            String className = bean.getClass().getName();
            this.classMetadataMap.put((Object)className, bean.getClass());
            if (this.classMetadataMap.hasAnnotations(className)) {
                try {
                    this.injectionProvider.inject(bean);
                }
                catch (InjectionProviderException ex) {
                    log.error("Unable to inject instance" + className, (Throwable)ex);
                    throw new FacesException((Throwable)ex);
                }
                try {
                    this.injectionProvider.invokePostConstruct(bean);
                }
                catch (InjectionProviderException ex) {
                    log.error("Unable to invoke @PostConstruct annotated method on instance " + className, (Throwable)ex);
                    throw new FacesException((Throwable)ex);
                }
            }
        }
    }
}

