/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(RadioInputControl.class);
    public static final String COLATTR_ABBR_OPTIONS = "ABBR_OPTIONS";
    public static final String VALUE_EXPRESSION_FLAG = "VALUE_EXPRESSION_FLAG";
    public static final String NAME = "radio";
    private final Class<? extends HtmlSelectOneRadio> inputComponentClass;

    public RadioInputControl(String name, Class<? extends HtmlSelectOneRadio> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public RadioInputControl() {
        this(NAME, HtmlSelectOneRadio.class);
    }

    @Override
    public void renderValue(Object value, InputControl.ValueInfo vi, ResponseWriter writer) throws IOException {
        String style = vi.getStyleClass(TagStyleClass.RADIO.append(TagStyleClass.INPUT_DIS.get()));
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)style, null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)style, null);
        writer.startElement("tr", null);
        Options o = vi.getOptions();
        for (OptionEntry e : o) {
            writer.startElement("td", null);
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)NAME, null);
            writer.writeAttribute("disabled", (Object)"disabled", null);
            if (ObjectUtils.compareEqual((Object)e.getValue(), (Object)value)) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            writer.endElement("input");
            writer.startElement("label", null);
            writer.writeAttribute("class", (Object)TagStyleClass.RADIO.get(), null);
            String text = e.getText();
            text = vi.getTextResolver().resolveText(text);
            writer.writeText((Object)text, null);
            writer.endElement("label");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    @Override
    protected void copyAttributes(UIComponent parent, InputControl.InputInfo ii, UIInput input, String additonalStyle) {
        super.copyAttributes(parent, ii, input, TagStyleClass.RADIO.append(additonalStyle));
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        HtmlSelectOneRadio input = InputControlManager.createComponent(context, this.inputComponentClass);
        Object value = ii.getValue(false);
        input.getAttributes().put(VALUE_EXPRESSION_FLAG, value instanceof ValueExpression);
        this.copyAttributes(parent, ii, (UIInput)input);
        boolean disabled = ii.isDisabled();
        input.setDisabled(disabled);
        Options options = ii.getOptions();
        boolean addEmpty = this.getEmptyEntryRequired(ii, disabled) && !options.containsNull();
        String nullText = addEmpty ? this.getNullText(ii) : "";
        this.initOptions(input, ii.getTextResolver(), options, addEmpty, nullText);
        compList.add((UIComponent)input);
        this.addRemoveDisabledStyle((UIInput)input, disabled);
        this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
        this.setInputValue((UIInput)input, ii);
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof HtmlSelectOneRadio)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "parent.getChildren()");
        }
        HtmlSelectOneRadio input = (HtmlSelectOneRadio)comp;
        boolean disabled = ii.isDisabled();
        input.setDisabled(disabled);
        if (phaseId != PhaseId.APPLY_REQUEST_VALUES) {
            Options options = ii.getOptions();
            boolean addEmpty = this.getEmptyEntryRequired(ii, disabled) && !options.containsNull();
            String nullText = addEmpty ? this.getNullText(ii) : "";
            this.syncOptions(input, ii.getTextResolver(), options, addEmpty, nullText);
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.addRemoveDisabledStyle((UIInput)input, disabled);
            this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
            this.setInputValue((UIInput)input, ii);
        }
    }

    protected boolean getEmptyEntryRequired(InputControl.InputInfo ii, boolean disabled) {
        if (!(ii.isRequired() || disabled && ii.getColumn().isRequired())) {
            return true;
        }
        return ii.getValue(true) == null;
    }

    public void initOptions(HtmlSelectOneRadio input, TextResolver textResolver, Options options, boolean addEmpty, String nullText) {
        if (addEmpty) {
            this.addSelectItem((UIComponent)input, textResolver, new OptionEntry(null, nullText));
        }
        if (options != null && options.size() > 0) {
            for (OptionEntry e : options) {
                this.addSelectItem((UIComponent)input, textResolver, e);
            }
        }
    }

    public void syncOptions(HtmlSelectOneRadio input, TextResolver textResolver, Options options, boolean hasEmpty, String nullText) {
        Iterator ioe = options.iterator();
        OptionEntry oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        List childList = input.getChildren();
        Iterator ico = childList.iterator();
        int lastIndex = 0;
        while (ico.hasNext()) {
            UISelectItem si;
            Object ov;
            ++lastIndex;
            UIComponent co = (UIComponent)ico.next();
            if (!(co instanceof UISelectItem) || ObjectUtils.isEmpty((Object)(ov = (si = (UISelectItem)co).getItemValue())) && hasEmpty) continue;
            if (oe == null) {
                --lastIndex;
                for (int index = childList.size() - 1; index >= lastIndex; --index) {
                    childList.remove(index);
                }
                return;
            }
            if (ObjectUtils.compareEqual((Object)ov, (Object)oe.getValue())) {
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
                continue;
            }
            input.getChildren().clear();
            if (hasEmpty) {
                this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", nullText));
            }
            for (OptionEntry e : options) {
                this.addSelectItem((UIComponent)input, textResolver, e);
            }
            return;
        }
        while (oe != null) {
            this.addSelectItem((UIComponent)input, textResolver, oe);
            oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        }
    }

    public void addSelectItem(UIComponent input, TextResolver textResolver, OptionEntry e) {
        UISelectItem selectItem = new UISelectItem();
        Object valueExpressionFlag = input.getAttributes().get(VALUE_EXPRESSION_FLAG);
        Object value = ObjectUtils.getBoolean(valueExpressionFlag) ? e.getValue() : e.getValueString();
        selectItem.setItemValue(value);
        String text = e.getText();
        text = textResolver.resolveText(text);
        selectItem.setItemLabel(text);
        input.getChildren().add(selectItem);
    }

    protected String getNullText(InputControl.InputInfo ii) {
        String nullText = this.getFormatString(ii, "null:", "format:null");
        return nullText != null ? ii.getText(nullText) : "";
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        String text;
        Object attrValue;
        Column column;
        if (vi.getOptions() == null) {
            log.warn("Select field {} has no Option list attached!", (Object)vi.getColumn().getName());
            return super.formatValue(value, vi);
        }
        if (this.hasFormatOption(vi, "short") && (column = vi.getColumn()) != null && (attrValue = column.getAttribute(COLATTR_ABBR_OPTIONS)) instanceof Options && (text = this.getOptionText((Options)attrValue, value, vi)) != null) {
            return text;
        }
        return super.formatValue(value, vi);
    }

    @Override
    protected Object formatInputValue(Object value, InputControl.InputInfo ii) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        Class enumType = ii.getColumn().getEnumType();
        if (enumType != null) {
            return ObjectUtils.getEnumByName((Class)enumType, (String)value);
        }
        return value;
    }
}

