/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputAttachedObjectsHandler;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputControl {
    private static final Logger log = LoggerFactory.getLogger(InputControl.class);
    public static final String CSS_STYLE_CLASS = "styleClass";
    public static final String FORMAT_NULL = "null:";
    public static final String FORMAT_NULL_ATTRIBUTE = "format:null";
    public static final String FORMAT_NO_VALUE_STYLES = "noValueStyles";
    public static final String HTML_TAG_DIV = "div";
    public static final String HTML_TAG_SPAN = "span";
    public static final String HTML_TAG_TABLE = "table";
    public static final String HTML_TAG_TR = "tr";
    public static final String HTML_TAG_TD = "td";
    public static final String HTML_TAG_INPUT = "input";
    public static final String HTML_TAG_LABEL = "label";
    public static final String HTML_ATTR_ID = "id";
    public static final String HTML_ATTR_CLASS = "class";
    public static final String HTML_ATTR_STYLE = "style";
    public static final String HTML_ATTR_TYPE = "type";
    public static final String HTML_ATTR_DISABLED = "disabled";
    public static final String HTML_ATTR_CHECKED = "checked";
    public static String HTML_EXPR_NBSP = "&nbsp;";
    private final String name;
    private final String cssStyleClass;
    private boolean creatingComponents = false;

    protected InputControl(String name) {
        this.name = name;
        this.cssStyleClass = this.initCssStyleClass();
    }

    public final String getName() {
        return this.name;
    }

    public final String getCssStyleClass() {
        return this.cssStyleClass;
    }

    public String getLabelForId(InputInfo ii) {
        return ii.getInputId();
    }

    public boolean isCreatingComponents() {
        return this.creatingComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInput(UIComponent comp, InputInfo ii, FacesContext context) {
        List children = comp.getChildren();
        try {
            this.creatingComponents = true;
            this.createInputComponents(comp, ii, context, children);
            boolean resetChildId = ii.isInsideUIData();
            if (resetChildId && log.isDebugEnabled()) {
                UIComponent c1 = (UIComponent)comp.getChildren().get(0);
                String clientId = c1.getClientId();
                log.debug("Performing ChildId-reset for {}", (Object)clientId);
            }
            UIComponent parent = comp;
            while (!(parent instanceof UIInput)) {
                parent = parent.getParent();
            }
            for (UIComponent child : children) {
                if (resetChildId && child.getId() != null) {
                    child.setId(child.getId());
                }
                if (!(child instanceof ClientBehaviorHolder)) continue;
                this.addAttachedObjects(parent, context, ii, (UIComponentBase)child);
            }
        }
        finally {
            this.creatingComponents = false;
        }
    }

    public void renderValue(UIComponent comp, String tagName, String styleClass, String tooltip, ValueInfo vi, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object value = vi.getValue(true);
        if (tagName != null) {
            Object style;
            writer.startElement(tagName, comp);
            if (!this.hasFormatOption(vi, FORMAT_NO_VALUE_STYLES)) {
                styleClass = this.addDataValueStyle(vi, value, styleClass);
            }
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute(HTML_ATTR_CLASS, (Object)styleClass, null);
            }
            if (StringUtils.isNotEmpty((String)tooltip)) {
                writer.writeAttribute("title", (Object)tooltip, null);
            }
            if ((style = comp.getAttributes().get(HTML_ATTR_STYLE)) != null) {
                writer.writeAttribute(HTML_ATTR_STYLE, style, null);
            }
        }
        this.renderValue(value, vi, writer);
        if (tagName != null) {
            writer.endElement(tagName);
        }
    }

    public void renderValue(Object value, ValueInfo vi, ResponseWriter writer) throws IOException {
        String text = this.formatValue(value, vi);
        writer.append((CharSequence)(StringUtils.isEmpty((String)text) ? HTML_EXPR_NBSP : text));
    }

    public void renderInput(UIComponent comp, InputInfo ii, FacesContext context) throws IOException {
        for (UIComponent child : comp.getChildren()) {
            if (!child.isRendered()) continue;
            child.encodeAll(context);
        }
    }

    public void updateInputState(UIComponent parent, InputInfo ii, FacesContext context, PhaseId phaseId) {
        List children = parent.getChildren();
        if (children.isEmpty()) {
            return;
        }
        this.updateInputState(children, ii, context, phaseId);
        while (!(parent instanceof UIInput)) {
            parent = parent.getParent();
        }
        for (UIComponent child : children) {
            if (!(child instanceof ClientBehaviorHolder)) continue;
            this.updateAttachedObjects(parent, context, ii, (UIComponentBase)child);
        }
    }

    public void postUpdateModel(UIComponent comp, InputInfo ii, FacesContext fc) {
        UIInput input = this.getInputComponent(comp);
        if (input == null) {
            return;
        }
        this.clearSubmittedValue(input);
    }

    public Object getInputValue(UIComponent comp, InputInfo ii, boolean submitted) {
        Object value;
        UIInput input = this.getInputComponent(comp);
        if (input == null) {
            return null;
        }
        if (submitted) {
            if (ii.isDisabled()) {
                log.debug("Ignoring submitted value for disabled field {}.", (Object)ii.getColumn().getName());
                input.setSubmittedValue(null);
                return null;
            }
            value = input.getSubmittedValue();
            if (value == null && input.isLocalValueSet()) {
                if (log.isDebugEnabled()) {
                    log.debug("No submitted value but local value available for InputComponent {}. Local value is '{}'", (Object)input.getClientId(), input.getLocalValue());
                }
                if ((value = input.getLocalValue()) == null) {
                    value = "";
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Submitted value for {} is {}", (Object)comp.getClientId(), value);
            }
        } else {
            value = input.getValue();
        }
        return value;
    }

    public Object getConvertedValue(UIComponent comp, InputInfo ii, Object submittedValue) {
        if (submittedValue != null) {
            Object oldValue;
            UIInput input;
            String clientId;
            FacesContext fc = FacesContext.getCurrentInstance();
            Map reqMap = fc.getExternalContext().getRequestMap();
            if (reqMap.containsKey(clientId = (input = this.getInputComponent(comp)).getClientId()) && !ObjectUtils.compareEqual(oldValue = reqMap.get(clientId), (Object)submittedValue)) {
                log.debug("Replacing submitted value from '{}' to '{}' for " + clientId, oldValue, submittedValue);
            }
            reqMap.put(clientId, submittedValue);
        }
        if (submittedValue instanceof String && ((String)submittedValue).length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Converting value for colum {}. Value is {}", (Object)ii.getColumn().getName(), submittedValue);
            }
            return this.parseInputValue((String)submittedValue, ii);
        }
        return submittedValue;
    }

    protected String initCssStyleClass() {
        return StringUtils.concat((String[])new String[]{TagStyleClass.INPUT_TYPE_PREFIX.get(), this.name.substring(0, 1).toUpperCase(), this.name.substring(1)});
    }

    protected String addDataValueStyle(ValueInfo vi, Object value, String styleClass) {
        DataType dataType = vi.getColumn().getDataType();
        if (ObjectUtils.isEmpty((Object)value)) {
            styleClass = styleClass + " eValNull";
        } else if (dataType.isNumeric() && ObjectUtils.getLong((Object)value) < 0L) {
            styleClass = styleClass + " eValNeg";
        }
        return styleClass;
    }

    protected void addAttachedObjects(UIComponent parent, FacesContext context, InputInfo ii, UIComponentBase inputComponent) {
        InputAttachedObjectsHandler aoh = InputControlManager.getAttachedObjectsHandler();
        if (aoh != null) {
            aoh.addAttachedObjects(parent, context, ii.getColumn(), inputComponent);
        }
    }

    protected void updateAttachedObjects(UIComponent parent, FacesContext context, InputInfo ii, UIComponentBase inputComponent) {
        InputAttachedObjectsHandler aoh = InputControlManager.getAttachedObjectsHandler();
        if (aoh != null) {
            aoh.updateAttachedObjects(parent, context, ii.getColumn(), inputComponent);
        }
    }

    protected UIInput getFirstInput(List<UIComponent> compList) {
        for (int i = 0; i < compList.size(); ++i) {
            UIComponent child = compList.get(i);
            if (!(child instanceof UIInput)) continue;
            return (UIInput)child;
        }
        throw new ItemNotFoundException((Object)"UIInput");
    }

    protected void setInputValue(UIInput input, InputInfo ii) {
        Object value;
        String clientId;
        FacesContext fc = FacesContext.getCurrentInstance();
        Map reqMap = fc.getExternalContext().getRequestMap();
        if (reqMap.containsKey(clientId = input.getClientId())) {
            Object value2 = reqMap.get(clientId);
            if (!input.isLocalValueSet()) {
                input.setSubmittedValue(value2);
            }
            this.addRemoveValueNullStyle(input, ObjectUtils.isEmpty(value2));
            return;
        }
        if (input.getSubmittedValue() != null) {
            if (log.isDebugEnabled()) {
                log.debug("clearing submitted value for {}. value is {}.", (Object)ii.getColumn().getName(), input.getSubmittedValue());
            }
            input.setSubmittedValue(null);
        }
        if ((value = ii.getValue(false)) instanceof ValueExpression) {
            input.setValue(null);
            input.setLocalValueSet(false);
            input.setValueExpression("value", (ValueExpression)value);
        } else {
            value = this.formatInputValue(value, ii);
            input.setValue(value);
            this.addRemoveValueNullStyle(input, ObjectUtils.isEmpty((Object)value));
        }
    }

    protected void clearSubmittedValue(UIInput input) {
        input.setSubmittedValue(null);
        FacesContext fc = FacesContext.getCurrentInstance();
        Map reqMap = fc.getExternalContext().getRequestMap();
        String clientId = input.getClientId();
        if (reqMap.containsKey(clientId)) {
            reqMap.remove(clientId);
        }
    }

    protected Object formatInputValue(Object value, InputInfo ii) {
        return value;
    }

    protected Object parseInputValue(String value, InputInfo ii) {
        return value;
    }

    protected abstract void createInputComponents(UIComponent var1, InputInfo var2, FacesContext var3, List<UIComponent> var4);

    protected abstract void updateInputState(List<UIComponent> var1, InputInfo var2, FacesContext var3, PhaseId var4);

    protected UIInput getInputComponent(UIComponent parent) {
        int count = parent.getChildCount();
        if (count < 1) {
            return null;
        }
        UIInput inp = null;
        for (int i = 0; i < count; ++i) {
            UIComponent comp = (UIComponent)parent.getChildren().get(i);
            if (!(comp instanceof UIInput)) continue;
            if (inp != null) {
                throw new UnexpectedReturnValueException((Object)comp, "comp.getChildren().get(" + String.valueOf(i) + ")");
            }
            inp = (UIInput)comp;
        }
        if (inp == null) {
            for (UIComponent p = parent.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof UIData)) continue;
                log.info("Ignore value component for id '{}' inside a DataTable (javax.faces.component.UIData)", (Object)parent.getClientId());
                return null;
            }
            throw new UnexpectedReturnValueException(null, "comp.getChildren().get()");
        }
        return inp;
    }

    protected String getInputStyleClass(InputInfo ii, String additonalStyle) {
        return ii.getStyleClass(additonalStyle);
    }

    protected void setInputStyleClass(UIInput input, String cssStyleClass) {
        input.getAttributes().put(CSS_STYLE_CLASS, cssStyleClass);
    }

    protected void copyAttributes(UIComponent parent, InputInfo ii, UIInput input, String additonalStyle) {
        String inputId = ii.getInputId();
        if (StringUtils.isNotEmpty((String)inputId)) {
            input.getAttributes().put(HTML_ATTR_ID, inputId);
        }
        String styleClass = this.getInputStyleClass(ii, additonalStyle);
        this.setInputStyleClass(input, styleClass);
        this.copyAttribute(ii, input, HTML_ATTR_STYLE);
        this.copyAttribute(ii, input, "tabindex");
        this.copyAttribute(ii, input, "onchange");
        this.copyAttribute(ii, input, "onfocus");
        this.copyAttribute(ii, input, "onblur");
        this.copyAttribute(ii, input, "onkeydown");
        this.copyAttribute(ii, input, "onkeyup");
        this.copyAttribute(ii, input, "onclick");
        Object immediate = ii.getAttribute("immediate");
        if (immediate != null && ObjectUtils.getBoolean((Object)immediate)) {
            log.warn("Immediate attribute is not yet supported for {}!", (Object)ii.getColumn().getName());
        }
    }

    protected final void copyAttributes(UIComponent parent, InputInfo ii, UIInput input) {
        String addlStyles = null;
        if (ii.isRequired()) {
            addlStyles = TagStyleClass.INPUT_REQ.get();
        }
        if (ii.isModified()) {
            addlStyles = TagStyleClass.INPUT_MOD.addTo(addlStyles);
        }
        this.copyAttributes(parent, ii, input, addlStyles);
    }

    protected void copyAttribute(InputInfo ii, UIInput input, String name) {
        if (ii == null) {
            throw new InvalidArgumentException("InputInfo", (Object)ii);
        }
        Object value = ii.getAttribute(name);
        if (value == null) {
            value = ii.getColumn().getAttribute(name);
        }
        if (value != null) {
            input.getAttributes().put(name, String.valueOf(value));
        }
    }

    public void addRemoveValueNullStyle(UIInput input, boolean nullValue) {
        this.addRemoveStyle(input, TagStyleClass.VALUE_NULL, nullValue);
    }

    public void addRemoveDisabledStyle(UIInput input, boolean disabled) {
        this.addRemoveStyle(input, TagStyleClass.INPUT_DIS, disabled);
    }

    public void addRemoveInvalidStyle(UIInput input, boolean invalid) {
        this.addRemoveStyle(input, TagStyleClass.VALUE_INVALID, invalid);
    }

    public void addRemoveStyle(UIInput input, String styleName, boolean setStyle) {
        String styleClasses = StringUtils.toString(input.getAttributes().get(CSS_STYLE_CLASS), (String)"");
        boolean hasStyle = TagStyleClass.existsIn(styleClasses, styleName);
        if (setStyle == hasStyle) {
            return;
        }
        if (styleClasses.endsWith("-dis")) {
            styleClasses = styleClasses.substring(0, styleClasses.length() - 4);
        }
        styleClasses = setStyle ? TagStyleClass.addTo(styleClasses, styleName) : TagStyleClass.removeFrom(styleClasses, styleName);
        this.setInputStyleClass(input, styleClasses);
    }

    public final void addRemoveStyle(UIInput input, TagStyleClass style, boolean setStyle) {
        this.addRemoveStyle(input, style.get(), setStyle);
    }

    protected String formatValue(Object value, ValueInfo vi) {
        String text;
        Options options;
        if (value instanceof Enum && !this.hasFormatOption(vi, "nolookup")) {
            String text2 = ((Enum)value).toString();
            if (text2 != null) {
                return vi.getText(text2);
            }
            log.error("The enum '" + ((Enum)value).name() + "' has no text!");
        }
        if ((options = vi.getOptions()) != null && !this.hasFormatOption(vi, "nolookup") && (text = this.getOptionText(options, value, vi)) != null) {
            return text;
        }
        if (value == null) {
            value = this.getFormatOption(vi, FORMAT_NULL, FORMAT_NULL_ATTRIBUTE);
        }
        String s = StringUtils.toString((Object)value, (String)"");
        if (this.hasFormatOption(vi, "noencode")) {
            return s;
        }
        return this.escapeHTML(s);
    }

    protected String getOptionText(Options options, Object value, ValueInfo vi) {
        if (options == null) {
            throw new InvalidArgumentException("options", (Object)options);
        }
        OptionEntry entry = options.getEntry(value);
        if (entry != null) {
            return vi.getText(entry.getText());
        }
        if (ObjectUtils.isEmpty((Object)value)) {
            return "";
        }
        String column = vi.getColumn() != null ? vi.getColumn().getName() : "?";
        log.error("The element \"{}\" is not part of the supplied option list for column {}", value, (Object)column);
        return null;
    }

    protected String escapeHTML(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        if (text.indexOf(38) >= 0) {
            text = StringUtils.replaceAll((String)text, (String)"&", (String)"&amp;");
        }
        if (text.indexOf(60) >= 0) {
            text = StringUtils.replaceAll((String)text, (String)"<", (String)"&lt;");
        }
        if (text.indexOf(62) >= 0) {
            text = StringUtils.replaceAll((String)text, (String)">", (String)"&gt;");
        }
        return text;
    }

    protected boolean hasFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        return format != null ? format.indexOf(option) >= 0 : false;
    }

    protected boolean hasFormatOption(ValueInfo vi, String option, String columnAttributeName) {
        if (this.hasFormatOption(vi, option)) {
            return true;
        }
        Column column = vi.getColumn();
        return column != null ? !ObjectUtils.isEmpty((Object)column.getAttribute(columnAttributeName)) : false;
    }

    protected String getFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        if (format == null) {
            return null;
        }
        int beg = format.indexOf(option);
        if (beg < 0) {
            return null;
        }
        int end = format.indexOf(59, (beg += option.length()) + 1);
        if (end < beg) {
            return format.substring(beg);
        }
        return format.substring(beg, end);
    }

    protected Object getFormatOption(ValueInfo vi, String option, String columnAttributeName) {
        String format = this.getFormatOption(vi, option);
        if (format != null) {
            return format;
        }
        Column column = vi.getColumn();
        return column != null ? column.getAttribute(columnAttributeName) : null;
    }

    protected String getFormatString(ValueInfo vi, String option, String columnAttributeName) {
        return StringUtils.toString((Object)this.getFormatOption(vi, option, columnAttributeName));
    }

    protected int getFormatInteger(ValueInfo vi, String option, String columnAttributeName) {
        return ObjectUtils.getInteger((Object)this.getFormatOption(vi, option, columnAttributeName));
    }

    public static interface InputInfo
    extends ValueInfo {
        public void setValue(Object var1);

        public void validate(Object var1);

        public boolean isRequired();

        public boolean isModified();

        public boolean isDisabled();

        public DisabledType getDisabled();

        public String getInputId();

        public boolean hasError();

        public Object getAttribute(String var1);

        public Object getAttributeEx(String var1);
    }

    public static interface ValueInfo {
        public Column getColumn();

        public Options getOptions();

        public Object getValue(boolean var1);

        public String getFormat();

        public Locale getLocale();

        public String getText(String var1);

        public TextResolver getTextResolver();

        public String getStyleClass(String var1);

        public boolean isInsideUIData();
    }

    public static enum DisabledType {
        NO,
        READONLY,
        DISABLED;

    }
}

