/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;

public class MenuListTag
extends UIOutput {
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.MENU.get());
    protected String currentId = null;
    protected String currentClass = null;
    protected String parentClass = null;
    protected String disabledClass = null;
    protected String expandedClass = null;
    protected String itemWrapTag = null;
    protected String defaultItemClass = null;
    protected int level = 0;
    private MenuListTag parentMenu = null;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.initMenuAttributes(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)this);
        this.helper.writeComponentId(writer);
        this.helper.writeAttribute(writer, "class", this.getStyleClass());
        this.helper.writeAttribute(writer, "style", this.helper.getTagAttributeString("style"));
    }

    public boolean getRendersChildren() {
        boolean test = super.getRendersChildren();
        return test;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("ul");
    }

    protected void initMenuAttributes(FacesContext context) {
        this.currentId = this.helper.getTagAttributeString(Properties.currentId.name());
        this.currentClass = this.helper.getTagAttributeString(Properties.currentClass.name());
        this.disabledClass = this.helper.getTagAttributeString(Properties.disabledClass.name());
        this.parentClass = this.helper.getTagAttributeString(Properties.parentClass.name());
        this.expandedClass = this.helper.getTagAttributeString(Properties.expandedClass.name());
        this.itemWrapTag = this.helper.getTagAttributeString(Properties.itemWrapTag.name());
        this.defaultItemClass = this.helper.getTagAttributeString(Properties.defaultItemClass.name());
        if (this.parentMenu == null) {
            this.parentMenu = this.findParentMenu();
        }
        if (this.parentMenu == null) {
            return;
        }
        if (this.currentId == null) {
            this.currentId = this.parentMenu.getCurrentId();
        }
        if (this.currentClass == null) {
            this.currentClass = this.parentMenu.getCurrentClass();
        }
        if (this.disabledClass == null) {
            this.disabledClass = this.parentMenu.getDisabledClass();
        }
        if (this.parentClass == null) {
            this.parentClass = this.parentMenu.getParentClass();
        }
        if (this.expandedClass == null) {
            this.expandedClass = this.parentMenu.getExpandedClass();
        }
        if (this.itemWrapTag == null) {
            this.itemWrapTag = this.parentMenu.getItemWrapTag();
        }
        if (this.defaultItemClass == null) {
            this.defaultItemClass = this.parentMenu.defaultItemClass;
        }
        this.level = this.parentMenu.level + 1;
    }

    public String getCurrentId() {
        if (this.currentId == null) {
            this.currentId = StringUtils.toString((Object)this.getStateHelper().get((Serializable)((Object)Properties.currentId)));
        }
        return this.currentId;
    }

    public String getCurrentClass() {
        if (this.currentClass == null) {
            this.currentClass = StringUtils.toString((Object)this.getStateHelper().get((Serializable)((Object)Properties.currentClass)));
        }
        return this.currentClass;
    }

    public String getDisabledClass() {
        if (this.disabledClass == null) {
            this.disabledClass = StringUtils.toString((Object)this.getStateHelper().get((Serializable)((Object)Properties.disabledClass)));
        }
        return this.disabledClass;
    }

    public String getParentClass() {
        if (this.parentClass == null) {
            this.parentClass = StringUtils.toString((Object)this.getStateHelper().get((Serializable)((Object)Properties.parentClass)));
        }
        return this.parentClass;
    }

    public String getExpandedClass() {
        if (this.expandedClass == null) {
            this.expandedClass = StringUtils.toString((Object)this.getStateHelper().get((Serializable)((Object)Properties.expandedClass)));
        }
        return this.expandedClass;
    }

    public String getItemWrapTag() {
        if (this.itemWrapTag == null) {
            this.itemWrapTag = StringUtils.toString((Object)this.getStateHelper().get((Serializable)((Object)Properties.itemWrapTag)));
        }
        return this.itemWrapTag;
    }

    public int getLevel() {
        return this.level;
    }

    protected String getStyleClass() {
        String styleClass = this.helper.getTagAttributeString("styleClass");
        if (styleClass != null && styleClass.indexOf("{}") > 0) {
            styleClass = StringUtils.replace((String)styleClass, (String)"{}", (String)String.valueOf(this.level));
        }
        return styleClass;
    }

    public String getItemStyleClass() {
        if (this.defaultItemClass != null && this.defaultItemClass.indexOf("{}") > 0) {
            return StringUtils.replace((String)this.defaultItemClass, (String)"{}", (String)String.valueOf(this.level));
        }
        return this.defaultItemClass;
    }

    public void setCurrentId(String currentId) {
        this.currentId = currentId;
        this.getStateHelper().put((Serializable)((Object)Properties.currentId), (Object)currentId);
    }

    public void setCurrentClass(String currentClass) {
        this.currentClass = currentClass;
        this.getStateHelper().put((Serializable)((Object)Properties.currentClass), (Object)currentClass);
    }

    public void setDisabledClass(String disabledClass) {
        this.disabledClass = disabledClass;
        this.getStateHelper().put((Serializable)((Object)Properties.disabledClass), (Object)disabledClass);
    }

    public void setParentClass(String parentClass) {
        this.parentClass = parentClass;
        this.getStateHelper().put((Serializable)((Object)Properties.parentClass), (Object)parentClass);
    }

    public void setExpandedClass(String expandedClass) {
        this.expandedClass = expandedClass;
        this.getStateHelper().put((Serializable)((Object)Properties.expandedClass), (Object)expandedClass);
    }

    public void setItemWrapTag(String itemWrapTag) {
        this.itemWrapTag = itemWrapTag;
        this.getStateHelper().put((Serializable)((Object)Properties.itemWrapTag), (Object)itemWrapTag);
    }

    protected MenuListTag findParentMenu() {
        MenuListTag parent = this;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof MenuListTag)) continue;
            return parent;
        }
        return null;
    }

    private static enum Properties {
        currentId,
        currentClass,
        parentClass,
        disabledClass,
        expandedClass,
        itemWrapTag,
        defaultItemClass;

    }
}

