/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.hsql;

import java.util.ArrayList;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.dbms.hsql.DBMSHandlerHSql;

public class DBCommandHSql
extends DBCommand {
    protected int limitRows = -1;
    protected int skipRows = 0;

    public DBCommandHSql(DBMSHandlerHSql dbms, boolean autoPrepareStmt) {
        super(dbms, autoPrepareStmt);
    }

    @Override
    public DBCommandHSql limitRows(int limitRows) {
        this.limitRows = limitRows;
        return this;
    }

    @Override
    public DBCommandHSql skipRows(int skipRows) {
        this.skipRows = skipRows;
        return this;
    }

    @Override
    public void clearLimit() {
        this.limitRows = -1;
        this.skipRows = 0;
    }

    @Override
    public void getSelect(DBSQLBuilder sql) {
        super.getSelect(sql);
        if (this.limitRows >= 0) {
            sql.append("\r\nLIMIT ");
            sql.append(String.valueOf(this.limitRows));
            if (this.skipRows > 0) {
                sql.append(" OFFSET ");
                sql.append(String.valueOf(this.skipRows));
            }
        }
    }

    @Override
    protected void addUpdateWithJoins(DBSQLBuilder sql, DBRowSet table) {
        DBColumn[] keyColumns = table.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(table);
        }
        sql.reset(0);
        sql.append("MERGE INTO ");
        table.addSQL(sql, 10L);
        sql.append("\r\nUSING (");
        ArrayList<DBColumnExpr> using = new ArrayList<DBColumnExpr>();
        for (DBColumn col : keyColumns) {
            using.add(col);
        }
        ArrayList<DBSetExpr> mergeSet = new ArrayList<DBSetExpr>(this.set.size());
        for (DBSetExpr sex : this.set) {
            Object val = sex.getValue();
            if (val instanceof DBColumnExpr) {
                DBColumnExpr expr = (DBColumnExpr)val;
                if (!(expr instanceof DBColumn) && !(expr instanceof DBAliasExpr)) {
                    String name = "COL_" + String.valueOf(mergeSet.size());
                    expr = expr.as(name);
                }
                using.add(expr);
                DBValueExpr NAME_EXPR = this.getDatabase().getValueExpr("q0." + expr.getName(), DataType.UNKNOWN);
                mergeSet.add(sex.getColumn().to(NAME_EXPR));
                continue;
            }
            mergeSet.add(sex);
        }
        sql.append("SELECT ");
        this.addListExpr(sql, using, 15L, ", ");
        this.addFrom(sql);
        this.addWhere(sql);
        this.addGrouping(sql);
        sql.append(") q0\r\nON (");
        for (DBColumn col : keyColumns) {
            sql.append(" q0.");
            col.addSQL(sql, 1L);
            sql.append("=");
            sql.append(table.getAlias());
            sql.append(".");
            col.addSQL(sql, 1L);
        }
        sql.append(")\r\nWHEN MATCHED THEN UPDATE ");
        sql.append("\r\nSET ");
        this.addListExpr(sql, mergeSet, 7L, ", ");
    }
}

