/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.join;

import java.util.HashSet;
import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.exceptions.InvalidPropertyException;

public class DBColumnJoinExpr
extends DBJoinExpr {
    protected DBColumnExpr left;
    protected DBColumnExpr right;
    public DBCompareExpr compExpr = null;

    public DBColumnJoinExpr(DBColumnExpr left, DBColumnExpr right, DBJoinType type) {
        super(type);
        this.left = left;
        this.right = right;
    }

    public final DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    public DBColumnExpr getLeft() {
        return this.left;
    }

    public DBColumnExpr getRight() {
        return this.right;
    }

    @Override
    public DBRowSet getLeftTable() {
        DBColumn col = this.left.getSourceColumn();
        if (col == null) {
            throw new InvalidPropertyException("left", this.left);
        }
        return col.getRowSet();
    }

    @Override
    public DBRowSet getRightTable() {
        DBColumn col = this.right.getSourceColumn();
        if (col == null) {
            throw new InvalidPropertyException("right", this.right);
        }
        return col.getRowSet();
    }

    @Override
    public boolean isJoinOn(DBRowSet rowset) {
        if (rowset == null) {
            return false;
        }
        return rowset.equals(this.getLeftTable()) || rowset.equals(this.getRightTable());
    }

    @Override
    public boolean isJoinOn(DBColumn column) {
        if (column == null) {
            return false;
        }
        if (column.equals(this.left.getSourceColumn()) || column.equals(this.right.getSourceColumn())) {
            return true;
        }
        if (this.compExpr != null) {
            HashSet<DBColumn> set = new HashSet<DBColumn>();
            this.compExpr.addReferencedColumns(set);
            return set.contains(column);
        }
        return false;
    }

    @Override
    public DBRowSet getOuterTable() {
        switch (this.type) {
            case LEFT: {
                return this.getRightTable();
            }
            case RIGHT: {
                return this.getLeftTable();
            }
        }
        return null;
    }

    @Override
    public void reverse() {
        DBColumnExpr swap = this.left;
        this.left = this.right;
        this.right = swap;
        this.type = DBJoinType.reversed(this.type);
    }

    @Override
    public void prepareCommand(DBCommand cmd) {
        if (this.compExpr != null) {
            this.compExpr.prepareCommand(cmd);
        }
    }

    @Override
    public DBJoinExpr copy(DBCommand newCmd) {
        if (this.compExpr == null) {
            return this;
        }
        DBColumnJoinExpr join = new DBColumnJoinExpr(this.left, this.right, this.type);
        join.compExpr = this.compExpr.copy(newCmd);
        return join;
    }

    public DBCompareExpr getWhere() {
        return this.compExpr;
    }

    public void where(DBCompareExpr expr) {
        this.compExpr = expr;
    }

    public DBColumnJoinExpr and(DBCompareExpr expr) {
        this.compExpr = this.compExpr == null ? expr : this.compExpr.and(expr);
        return this;
    }

    public DBColumnJoinExpr and(DBColumnExpr c1, DBColumnExpr c2) {
        return this.and(c1.is(c2));
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
        if (this.compExpr != null) {
            this.compExpr.addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 1L) != 0L) {
            this.getLeftTable().addSQL(sql, 15L);
        }
        if ((context & 4L) != 0L) {
            switch (this.type) {
                case LEFT: {
                    sql.append(" LEFT JOIN ");
                    break;
                }
                case INNER: {
                    sql.append(" INNER JOIN ");
                    break;
                }
                case RIGHT: {
                    sql.append(" RIGHT JOIN ");
                    break;
                }
                case FULL: {
                    sql.append(" FULL JOIN ");
                    break;
                }
                default: {
                    sql.append(" JOIN ");
                }
            }
            this.getRightTable().addSQL(sql, 15L);
            sql.append(" ON ");
            this.right.addSQL(sql, 7L);
            sql.append(" = ");
            this.left.addSQL(sql, 7L);
            if (this.compExpr != null) {
                sql.append(" AND ");
                this.compExpr.addSQL(sql, 7L);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBColumnJoinExpr)) {
            return super.equals(obj);
        }
        DBColumnJoinExpr other = (DBColumnJoinExpr)obj;
        if (this.left.equals(other.left) && this.right.equals(other.right) && this.type == other.type) {
            return true;
        }
        return this.left.equals(other.right) && this.right.equals(other.left) && this.type == DBJoinType.reversed(other.type);
    }
}

