/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.compare;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBCmpType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;

public class DBCompareColExpr
extends DBCompareExpr {
    protected final DBColumnExpr expr;
    protected final DBCmpType cmpop;
    protected Object value;

    public DBCompareColExpr(DBColumnExpr expr, DBCmpType op, Object value) {
        if (expr instanceof DBAliasExpr) {
            expr = ((DBAliasExpr)expr).unwrap();
        }
        this.expr = expr;
        this.cmpop = op;
        this.value = value;
    }

    public final DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    public DBColumnExpr getColumnExpr() {
        return this.expr;
    }

    public DBCmpType getCmpOperator() {
        return this.cmpop;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void prepareCommand(DBCommand cmd) {
        if (this.value == null || this.value instanceof DBCmdParam || this.value instanceof DBExpr || this.value instanceof DBDatabase.DBSystemDate) {
            return;
        }
        switch (this.cmpop) {
            case EQUAL: 
            case NOTEQUAL: 
            case LESSTHAN: 
            case MOREOREQUAL: 
            case GREATERTHAN: 
            case LESSOREQUAL: 
            case LIKE: 
            case NOTLIKE: {
                this.value = cmd.addParam(this.expr.getDataType(), this.value);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public DBCompareExpr copy(DBCommand newCmd) {
        Object valueCopy = this.value;
        if (this.value instanceof DBCmdParam) {
            valueCopy = newCmd.addParam(DataType.UNKNOWN, ((DBCmdParam)this.value).getValue());
        }
        return new DBCompareColExpr(this.expr, this.cmpop, valueCopy);
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        if (this.value instanceof DBExpr) {
            ((DBExpr)this.value).addReferencedColumns(list);
        }
    }

    public void addCompareExpr(DBSQLBuilder sql, long context) {
        String arraySep;
        DBCmpType op = this.cmpop;
        if (ObjectUtils.isEmpty(this.value)) {
            op = DBCmpType.getNullType(op);
        }
        switch (op) {
            case BETWEEN: 
            case NOTBETWEEN: {
                arraySep = " AND ";
                break;
            }
            case IN: 
            case NOTIN: {
                arraySep = ", ";
                break;
            }
            default: {
                arraySep = "+";
            }
        }
        String suffix = null;
        switch (op) {
            case EQUAL: {
                sql.append("=");
                break;
            }
            case NOTEQUAL: {
                sql.append("<>");
                break;
            }
            case LESSTHAN: {
                sql.append("<");
                break;
            }
            case MOREOREQUAL: {
                sql.append(">=");
                break;
            }
            case GREATERTHAN: {
                sql.append(">");
                break;
            }
            case LESSOREQUAL: {
                sql.append("<=");
                break;
            }
            case LIKE: {
                sql.append(" LIKE ");
                break;
            }
            case NOTLIKE: {
                sql.append(" NOT LIKE ");
                break;
            }
            case NULL: {
                sql.append(" IS NULL");
                return;
            }
            case NOTNULL: {
                sql.append(" IS NOT NULL");
                return;
            }
            case BETWEEN: {
                sql.append(" BETWEEN ");
                break;
            }
            case NOTBETWEEN: {
                sql.append(" NOT BETWEEN ");
                break;
            }
            case IN: {
                sql.append(" IN (");
                if (this.value instanceof DBCommandExpr) {
                    context |= 0x10L;
                }
                suffix = ")";
                break;
            }
            case NOTIN: {
                sql.append(" NOT IN (");
                if (this.value instanceof DBCommandExpr) {
                    context |= 0x10L;
                }
                suffix = ")";
                break;
            }
            default: {
                sql.append(" ");
            }
        }
        sql.appendValue(this.expr.getDataType(), this.value, context, arraySep);
        if (suffix != null) {
            sql.append(suffix);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 4L) == 0L) {
            this.expr.addSQL(sql, context);
            return;
        }
        if ((context & 1L) == 0L) {
            sql.appendValue(this.expr.getDataType(), this.value, context, null);
            return;
        }
        this.expr.addSQL(sql, context);
        this.addCompareExpr(sql, context);
    }

    @Override
    public boolean isMutuallyExclusive(DBCompareExpr other) {
        if (other instanceof DBCompareColExpr) {
            DBCompareColExpr o = (DBCompareColExpr)other;
            DBColumnExpr oexpr = o.getColumnExpr();
            return ObjectUtils.compareEqual(this.expr, oexpr);
        }
        return this.equals(other);
    }
}

