/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBCaseExpr
extends DBColumnExpr {
    private final DBCompareExpr compExpr;
    private final DBColumnExpr trueExpr;
    private final DBColumnExpr elseExpr;

    public DBCaseExpr(DBCompareExpr compExpr, DBColumnExpr trueExpr, DBColumnExpr elseExpr) {
        this.compExpr = compExpr;
        this.trueExpr = trueExpr;
        this.elseExpr = elseExpr;
    }

    public final DBDatabase getDatabase() {
        return this.trueExpr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.trueExpr.getDataType();
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.trueExpr.getEnumType();
    }

    @Override
    public String getName() {
        return this.trueExpr.getName();
    }

    @Override
    public DBColumn getSourceColumn() {
        return this.trueExpr.getUpdateColumn();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.trueExpr.getUpdateColumn();
    }

    @Override
    public boolean isAggregate() {
        return this.trueExpr.isAggregate();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBCaseExpr) {
            DBCaseExpr otherCase = (DBCaseExpr)other;
            if (!this.compExpr.equals(otherCase.compExpr)) {
                return false;
            }
            if (!this.trueExpr.equals(otherCase.trueExpr)) {
                return false;
            }
            if (this.elseExpr == null) {
                return otherCase.elseExpr == null;
            }
            return this.elseExpr.equals(otherCase.elseExpr);
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.trueExpr.addReferencedColumns(list);
        this.compExpr.addReferencedColumns(list);
        if (this.elseExpr != null) {
            this.elseExpr.addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        sql.append("CASE WHEN ");
        this.compExpr.addSQL(sql, context &= 0xFFFFFFFFFFFFFFF7L);
        sql.append(" THEN ");
        this.trueExpr.addSQL(sql, context);
        sql.append(" ELSE ");
        if (this.elseExpr != null) {
            this.elseExpr.addSQL(sql, context);
        } else {
            sql.append("NULL");
        }
        sql.append(" END");
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.getDataType());
        }
        elem.setAttribute("function", "case");
        return elem;
    }
}

