/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import org.apache.empire.commons.StringUtils;

public enum TagStyleClass {
    VALUE("eVal"),
    VALUE_NULL("eValNull"),
    VALUE_INVALID("eInvalid"),
    LABEL("eLabel"),
    INPUT("eInput"),
    INPUT_DIS("eInpDis"),
    INPUT_REQ("eInpReq"),
    INPUT_MOD("eInpModified"),
    INPUT_HINT("eInputHint"),
    CONTROL("eControl"),
    CONTROL_LABEL("eCtlLabel"),
    CONTROL_INPUT("eCtlInput"),
    FORM_GRID("eFormGrid"),
    SELECT("eSelect"),
    RADIO("eCtlRadio"),
    LINK("eLink"),
    TITLE("eTitle"),
    MENU("eMenuList"),
    UNIT("eUnit"),
    TAB_VIEW("eTabView"),
    TAB_BAR("eTabBar"),
    TAB_BAR_PADDING("eTabBarEmpty"),
    TAB_PANEL("eTabPanel"),
    TAB_PAGE("eTabPage"),
    TAB_LINK("eTabLink"),
    TAB_LABEL("eTabLabel"),
    TAB_ACTIVE("eTabActive"),
    TAB_DISABLED("eTabDisabled");

    private static final char SPACE = ' ';
    private String styleClassName;

    private TagStyleClass(String styleClassName) {
        this.styleClassName = styleClassName;
    }

    public String get() {
        return this.styleClassName;
    }

    public void set(String styleClassName) {
        this.styleClassName = styleClassName;
    }

    private static final int find(String styleClasses, String styleClassName, int fromIdx) {
        int idx;
        int n = idx = styleClasses != null ? styleClasses.indexOf(styleClassName, fromIdx) : -1;
        if (idx < 0) {
            return -1;
        }
        if (idx > 0 && styleClasses.charAt(idx - 1) != ' ') {
            return TagStyleClass.find(styleClasses, styleClassName, idx + 1);
        }
        int end = idx + styleClassName.length();
        if (end < styleClasses.length() && styleClasses.charAt(end) != ' ') {
            return TagStyleClass.find(styleClasses, styleClassName, idx + 1);
        }
        return idx;
    }

    public static final boolean existsIn(String styleClasses, String styleClassName) {
        return TagStyleClass.find(styleClasses, styleClassName, 0) >= 0;
    }

    public final boolean existsIn(String styleClasses) {
        return TagStyleClass.existsIn(styleClasses, this.styleClassName);
    }

    public static final String addTo(String styleClasses, String styleClassName) {
        if (styleClasses == null || styleClasses.length() == 0) {
            return styleClassName;
        }
        if (TagStyleClass.existsIn(styleClasses, styleClassName)) {
            return styleClasses;
        }
        return StringUtils.concat((String[])new String[]{styleClasses, " ", styleClassName});
    }

    public final String addTo(String styleClasses) {
        return TagStyleClass.addTo(styleClasses, this.styleClassName);
    }

    public final String append(String ... appends) {
        String result = this.styleClassName;
        for (int i = 0; i < appends.length; ++i) {
            String append = appends[i];
            if (append == null || append.length() <= 0) continue;
            result = TagStyleClass.addTo(result, append);
        }
        return result;
    }

    public static final String removeFrom(String styleClasses, String styleClassName) {
        int idx = TagStyleClass.find(styleClasses, styleClassName, 0);
        if (idx < 0) {
            return styleClasses;
        }
        if (idx <= 1) {
            if (styleClasses.length() > (idx += styleClassName.length()) && styleClasses.charAt(idx) == ' ') {
                ++idx;
            }
            return styleClasses.substring(idx);
        }
        if (idx + styleClassName.length() == styleClasses.length()) {
            return styleClasses.substring(0, idx - 1);
        }
        int after = idx + styleClassName.length();
        int before = idx - 1;
        return StringUtils.concat((String[])new String[]{styleClasses.substring(0, before), styleClasses.substring(after)});
    }

    public final String removeFrom(String styleClasses) {
        return TagStyleClass.removeFrom(styleClasses, this.styleClassName);
    }

    public static final String addOrRemove(String styleClasses, String styleClassName, boolean add) {
        if (add) {
            return TagStyleClass.addTo(styleClasses, styleClassName);
        }
        return TagStyleClass.removeFrom(styleClasses, styleClassName);
    }

    public final String addOrRemove(String styleClasses, boolean add) {
        return TagStyleClass.addOrRemove(styleClasses, this.styleClassName, add);
    }

    public String toString() {
        return this.styleClassName;
    }
}

