/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.util.LinkedHashMap;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.UnspecifiedErrorException;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageDefinitions {
    private static final Logger log = LoggerFactory.getLogger(PageDefinitions.class);
    private static LinkedHashMap<String, PageDefinition> pageMap = new LinkedHashMap();
    private static PageDefinitions instance = null;
    protected String pageUriExtension;

    public static PageDefinitions getInstance() {
        return instance;
    }

    protected PageDefinitions(String pageUriExtension) {
        if (instance != null) {
            throw new UnspecifiedErrorException("PageDefintions alreday defined. Only one Instance allowed!");
        }
        instance = this;
        this.pageUriExtension = pageUriExtension;
        log.info("PageDefintions class created");
    }

    protected PageDefinitions() {
        this(null);
    }

    public void registerPageBeans(FacesImplementation facesImpl) {
        for (PageDefinition v : pageMap.values()) {
            String beanName = v.getPageBeanName();
            String beanClass = v.getPageBeanClass().getName();
            log.info("Registering managed bean '{}' of class '{}' for page '{}'.", new Object[]{beanName, beanClass, v.getPath()});
            facesImpl.registerManagedBean(beanName, beanClass, "view");
        }
    }

    public String getPageUriExtension() {
        return this.pageUriExtension;
    }

    public String getPageUri(PageDefinition pageDef) {
        String uri = pageDef.getPath();
        String fileExt = pageDef.getFileExtension();
        if (this.pageUriExtension != null && fileExt != null) {
            uri = uri.replace(fileExt, this.pageUriExtension);
        }
        return uri;
    }

    public boolean containsView(String viewId) {
        return pageMap.containsKey(viewId);
    }

    public PageDefinition getDefaultPage() {
        return pageMap.values().iterator().next();
    }

    public PageDefinition getPageFromViewId(String viewId) {
        PageDefinition view;
        if (StringUtils.isEmpty((String)viewId)) {
            return this.getDefaultPage();
        }
        int ext = viewId.lastIndexOf(46);
        if (ext > 0) {
            viewId = viewId.substring(0, ext);
        }
        if ((view = pageMap.get(viewId)) == null) {
            log.error("No page defintion for viewId {}", (Object)viewId);
        }
        return view;
    }

    protected static void registerPage(PageDefinition pageDef) {
        String name = pageDef.getPath();
        int ext = name.lastIndexOf(46);
        if (ext > 0) {
            name = name.substring(0, ext);
        }
        if (pageMap.containsKey(name)) {
            throw new ItemExistsException((Object)name);
        }
        log.info("Registering view '{}'.", (Object)name);
        pageMap.put(name, pageDef);
    }
}

