/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.components.TabPageTag;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabViewTag
extends UIOutput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(TabViewTag.class);
    protected final String TAB_ACTIVE_INDEX = "activeIndex";
    protected final String TABLINK_ID_PREFIX = "tabLink";
    protected final String TAB_RENDERED_ATTRIBUTE = "visible";
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.TAB_VIEW.get());
    private TabViewMode mode;

    public TabViewTag() {
        log.trace("TabViewTag created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public TabViewMode getViewMode() {
        if (this.mode == null) {
            this.mode = TabViewMode.detect(this.helper.getTagAttributeString("mode", TabViewMode.TABLE.name()));
        }
        return this.mode;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.getViewMode();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)this.getClientId(), null);
        writer.writeAttribute("class", (Object)this.helper.getSimpleStyleClass(), null);
        this.helper.writeAttribute(writer, "style", this.helper.getTagAttributeString("style"));
        if (ObjectUtils.getBoolean((Object)this.helper.getTagAttributeValue("hideTabBar"))) {
            this.encodeTabs(context, null);
        } else {
            writer.startElement(this.mode.BAR_TAG, (UIComponent)this);
            writer.writeAttribute("class", (Object)TagStyleClass.TAB_BAR.get(), null);
            if (this.mode.BAR_ROW_TAG != null) {
                writer.startElement(this.mode.BAR_ROW_TAG, (UIComponent)this);
            }
            this.encodeTabs(context, writer);
            if (this.mode.BAR_PAD_TAG != null) {
                writer.startElement(this.mode.BAR_PAD_TAG, (UIComponent)this);
                writer.writeAttribute("class", (Object)TagStyleClass.TAB_BAR_PADDING.get(), null);
                writer.endElement(this.mode.BAR_PAD_TAG);
            }
            if (this.mode.BAR_ROW_TAG != null) {
                writer.endElement(this.mode.BAR_ROW_TAG);
            }
            writer.endElement(this.mode.BAR_TAG);
        }
        writer.startElement(this.mode.PANEL_TAG, (UIComponent)this);
        writer.writeAttribute("class", (Object)TagStyleClass.TAB_PANEL.get(), null);
        String minHeight = this.helper.getTagAttributeString("minHeight");
        if (StringUtils.isNotEmpty((String)minHeight)) {
            writer.writeAttribute("style", (Object)("min-height:" + minHeight), null);
        }
    }

    public boolean getRendersChildren() {
        return super.getRendersChildren();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement(this.mode.PANEL_TAG);
        writer.endElement("div");
    }

    public void decode(FacesContext context) {
        for (UIComponent c : this.getChildren()) {
            c.decode(context);
        }
        super.decode(context);
    }

    protected void encodeTabs(FacesContext context, ResponseWriter writer) throws IOException {
        Iterator ci = this.getFacetsAndChildren();
        if (!ci.hasNext()) {
            log.warn("Invalid TabPage definition!");
            return;
        }
        UIComponent panel = (UIComponent)ci.next();
        int index = 0;
        int activeIndex = this.getActivePageIndex();
        List chk = panel.getChildren();
        for (int i = chk.size() - 1; i >= 0; --i) {
            if (!(chk.get(i) instanceof HtmlCommandLink)) continue;
            chk.remove(i);
        }
        for (UIComponent c : panel.getChildren()) {
            if (!(c instanceof TabPageTag)) continue;
            boolean active = index == activeIndex;
            TabPageTag page = (TabPageTag)c;
            boolean rendered = ObjectUtils.getBoolean((Object)ObjectUtils.coalesce(page.getAttributes().get(this.TAB_RENDERED_ATTRIBUTE), (Object)true));
            if (!rendered) {
                page.setRendered(false);
                continue;
            }
            if (writer != null) {
                boolean disabled = ObjectUtils.getBoolean((Object)TagEncodingHelper.getTagAttributeValue((UIComponent)page, "disabled"));
                writer.startElement(this.mode.BAR_ITEM_TAG, (UIComponent)this);
                String styleClasses = TagStyleClass.TAB_LABEL.get();
                if (active) {
                    styleClasses = TagStyleClass.TAB_ACTIVE.addTo(styleClasses);
                } else if (disabled) {
                    styleClasses = TagStyleClass.TAB_DISABLED.addTo(styleClasses);
                }
                writer.writeAttribute("class", (Object)styleClasses, null);
                this.encodeTabLink(context, writer, index, page, active || disabled);
                writer.endElement(this.mode.BAR_ITEM_TAG);
            }
            page.setRendered(active);
            ++index;
        }
    }

    protected void encodeTabLink(FacesContext context, ResponseWriter writer, int index, TabPageTag page, boolean disabled) throws IOException {
        HtmlCommandLink link = null;
        List tabLinks = this.getChildren();
        if (tabLinks.size() > index) {
            UIComponent c = (UIComponent)tabLinks.get(index);
            if (c instanceof HtmlCommandLink) {
                link = (HtmlCommandLink)c;
            } else {
                log.error("INFO: Unexpected child node for {}! Child item type is {}.", (Object)((Object)((Object)this)).getClass().getName(), (Object)c.getClass().getName());
                c.setRendered(true);
                c.encodeAll(context);
                c.setRendered(false);
                return;
            }
        }
        if (link == null) {
            String linkId = this.TABLINK_ID_PREFIX + String.valueOf(index);
            link = this.createCommandLink(context, linkId);
            tabLinks.add(index, link);
            TabPageActionListener tpal = new TabPageActionListener(this.getClientId());
            link.addActionListener((ActionListener)tpal);
        }
        link.setValue((Object)page.getTabLabel());
        link.setDisabled(disabled);
        link.setStyleClass(TagStyleClass.TAB_LINK.get());
        link.setRendered(true);
        link.encodeAll(context);
        link.setRendered(false);
    }

    protected HtmlCommandLink createCommandLink(FacesContext context, String linkId) {
        HtmlCommandLink link = InputControlManager.createComponent(context, HtmlCommandLink.class);
        link.setId(linkId);
        return link;
    }

    public int getActivePageIndex() {
        Object active = this.helper.getTagAttributeValue(this.TAB_ACTIVE_INDEX);
        return ObjectUtils.getInteger((Object)active);
    }

    public void setActivePageIndex(int activeIndex) {
        ValueExpression ve = this.getValueExpression(this.TAB_ACTIVE_INDEX);
        if (ve != null) {
            FacesContext fc = FacesUtils.getContext();
            ve.setValue(fc.getELContext(), (Object)activeIndex);
        } else {
            this.getAttributes().put(this.TAB_ACTIVE_INDEX, activeIndex);
        }
    }

    public void setActiveTab(ActionEvent event) {
        log.debug("setActiveTab");
        UIComponent comp = event.getComponent();
        String tabNo = comp.getId().substring(this.TABLINK_ID_PREFIX.length());
        int pageIndex = ObjectUtils.getInteger((Object)tabNo);
        if (pageIndex == this.getActivePageIndex()) {
            log.warn("setActiveTab is called for active page!");
            return;
        }
        this.setActivePageIndex(pageIndex);
        Object tcl = this.getAttributes().get("tabChangedListener");
        if (tcl != null) {
            if (!(tcl instanceof MethodExpression)) {
                log.error("tabChangedListener is not a valid method expression!");
                return;
            }
            FacesContext fc = FacesUtils.getContext();
            MethodExpression methodExpression = (MethodExpression)tcl;
            methodExpression.invoke(fc.getELContext(), new Object[]{pageIndex});
        }
    }

    public static enum TabViewMode {
        TABLE("table", "tr", "td", "td", "table", "tr", "td"),
        GRID("div", null, "div", "div", "div", null, "div");

        public final String BAR_TAG;
        public final String BAR_ROW_TAG;
        public final String BAR_ITEM_TAG;
        public final String BAR_PAD_TAG;
        public final String PANEL_TAG;
        public final String PAGE_WRAP_TAG;
        public final String PAGE_TAG;

        private TabViewMode(String barTag, String barRowTag, String barItemTag, String barPadTag, String panelTag, String pageWrapTag, String pageTag) {
            this.BAR_TAG = barTag;
            this.BAR_ROW_TAG = barRowTag;
            this.BAR_ITEM_TAG = barItemTag;
            this.BAR_PAD_TAG = barPadTag;
            this.PANEL_TAG = panelTag;
            this.PAGE_WRAP_TAG = pageWrapTag;
            this.PAGE_TAG = pageTag;
        }

        public static TabViewMode detect(String mode) {
            if (mode == null || mode.length() == 0) {
                return TABLE;
            }
            TabViewMode[] values = TabViewMode.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].name().equalsIgnoreCase(mode)) continue;
                return values[i];
            }
            log.warn("TabViewMode \"{}\" not found. Using default!", (Object)mode);
            return TABLE;
        }

        public String toString() {
            return this.name();
        }
    }

    public static class TabPageActionListener
    implements ActionListener,
    StateHolder {
        private String clientId;
        private boolean isTransient = false;

        public TabPageActionListener() {
        }

        public TabPageActionListener(String clientId) {
            this.clientId = clientId;
        }

        public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
            FacesContext fc = FacesContext.getCurrentInstance();
            UIComponent tabView = FacesUtils.getWebApplication().findComponent(fc, this.clientId, null);
            if (!(tabView instanceof TabViewTag)) {
                throw new UnexpectedReturnValueException((Object)tabView, "findComponent");
            }
            TabViewTag tvt = (TabViewTag)tabView;
            tvt.setActiveTab(actionEvent);
        }

        public void restoreState(FacesContext context, Object state) {
            this.clientId = (String)state;
        }

        public Object saveState(FacesContext context) {
            return this.clientId;
        }

        public void setTransient(boolean newTransientValue) {
            this.isTransient = newTransientValue;
        }

        public boolean isTransient() {
            return this.isTransient;
        }
    }
}

