/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.xml;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.FileParseException;
import org.apache.empire.exceptions.FileReadException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XMLConfiguration.class);
    private Element configRootNode = null;

    public void init(String filename, boolean fromResource) {
        this.readConfiguration(filename, fromResource);
    }

    public Element getRootNode() {
        return this.configRootNode;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readConfiguration(String fileName, boolean fromResource) {
        FileReader reader = null;
        InputStream inputStream = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            if (fromResource) {
                log.info("reading resource file: " + fileName);
                inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
                doc = docBuilder.parse(inputStream);
            } else {
                log.info("reading configuration file: " + fileName);
                reader = new FileReader(fileName);
                doc = docBuilder.parse(new InputSource(reader));
            }
            this.configRootNode = doc.getDocumentElement();
            this.close(reader);
            this.close(inputStream);
            return;
        }
        catch (FileNotFoundException e) {
            try {
                log.error("Configuration file {} not found!", (Object)fileName, (Object)e);
                throw new FileReadException(fileName, e);
                catch (IOException e2) {
                    log.error("Error reading configuration file {}", (Object)fileName, (Object)e2);
                    throw new FileReadException(fileName, e2);
                }
                catch (SAXException e3) {
                    log.error("Invalid XML in configuration file {}", (Object)fileName, (Object)e3);
                    throw new FileParseException(fileName, e3);
                }
                catch (ParserConfigurationException e4) {
                    log.error("ParserConfigurationException: {}", (Object)e4.getMessage(), (Object)e4);
                    throw new InternalException(e4);
                }
            }
            catch (Throwable throwable) {
                this.close(reader);
                this.close(inputStream);
                throw throwable;
            }
        }
    }

    public void readProperties(Object bean, String ... propertiesNodeNames) {
        if (this.configRootNode == null) {
            throw new ObjectNotValidException(this);
        }
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        Element propertiesNode = this.configRootNode;
        for (String nodeName : propertiesNodeNames) {
            if (StringUtils.isEmpty(nodeName)) {
                throw new InvalidArgumentException("propertiesNodeNames", null);
            }
            if ((propertiesNode = XMLUtil.findFirstChild(propertiesNode, nodeName)) != null) continue;
            log.warn("Property-Node {} has not been found.", (Object)nodeName);
            throw new ItemNotFoundException((Object)nodeName);
        }
        this.readProperties(bean, propertiesNode);
    }

    public void readProperties(Object bean, Element propertiesNode) {
        if (propertiesNode == null) {
            throw new InvalidArgumentException("propertiesNode", propertiesNode);
        }
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        log.info("reading bean properties from node: {}", (Object)propertiesNode.getNodeName());
        NodeList nodeList = propertiesNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            if (item.getNodeType() != 1 || !this.isProperty(item)) continue;
            this.setPropertyValue(bean, item);
        }
    }

    protected boolean isProperty(Node item) {
        NamedNodeMap map = item.getAttributes();
        if (map == null) {
            return false;
        }
        Node propAttr = map.getNamedItem("property");
        if (propAttr == null) {
            return true;
        }
        String value = propAttr.getNodeValue();
        if (value == null) {
            return true;
        }
        return ObjectUtils.getBoolean(value);
    }

    protected void setPropertyValue(Object bean, Node item) {
        String name = item.getNodeName();
        try {
            String newValue = XMLUtil.getElementText(item);
            BeanUtils.setProperty((Object)bean, (String)name, (Object)newValue);
            String value = BeanUtils.getProperty((Object)bean, (String)name);
            if (ObjectUtils.compareEqual(newValue, value)) {
                log.info("Configuration property '{}' set to \"{}\"", (Object)name, (Object)newValue);
            } else {
                log.error("Failed to set property '{}'. Value is \"{}\"", (Object)name, (Object)value);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Access to Property {} denied.", (Object)name);
        }
        catch (InvocationTargetException e) {
            log.error("Unable to set Property {}", (Object)name);
        }
        catch (NoSuchMethodException e) {
            log.warn("Property '{}' not found in {}. Will be ingored.", (Object)name, (Object)bean.getClass().getName());
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
        }
    }
}

