/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBView;
import org.apache.empire.db.context.DBContextStatic;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.validation.DBModelChecker;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.oracle.DBCommandOracle;
import org.apache.empire.dbms.oracle.OracleDBModelChecker;
import org.apache.empire.dbms.oracle.OracleDBModelParser;
import org.apache.empire.dbms.oracle.OracleDDLGenerator;
import org.apache.empire.dbms.oracle.OracleDataDictionnary;
import org.apache.empire.dbms.oracle.OracleSYSDatabase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerOracle
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerOracle.class);
    private boolean oracle8Compatibilty = false;
    private BooleanType booleanType = BooleanType.NUMBER;
    private DBDDLGenerator<?> ddlGenerator = null;
    private String schemaName;

    public DBMSHandlerOracle() {
        log.info("DBMSHandlerOracle created. Boolean Type is " + (Object)((Object)this.booleanType));
        this.reservedSQLKeywords.add("date");
        this.reservedSQLKeywords.add("number");
    }

    public boolean isOracle8Compatibilty() {
        return this.oracle8Compatibilty;
    }

    public void setOracle8Compatibilty(boolean oracle8Compatibilty) {
        this.oracle8Compatibilty = oracle8Compatibilty;
    }

    public BooleanType getBooleanType() {
        return this.booleanType;
    }

    public void setBooleanType(BooleanType booleanType) {
        this.booleanType = booleanType;
        log.info("DBDatabaseDriverOracle Boolean Type set to " + (Object)((Object)booleanType));
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return false;
            }
            case SEQUENCES: {
                return true;
            }
            case SEQUENCE_NEXTVAL: {
                return true;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBCommandOracle(this, autoPrepareStmt);
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "\"";
            }
            case SQL_QUOTES_CLOSE: {
                return "\"";
            }
            case SQL_CONCAT_EXPR: {
                return " || ";
            }
            case SQL_PSEUDO_TABLE: {
                return "DUAL";
            }
            case SQL_BOOLEAN_TRUE: {
                return this.booleanType == BooleanType.CHAR ? "'Y'" : "1";
            }
            case SQL_BOOLEAN_FALSE: {
                return this.booleanType == BooleanType.CHAR ? "'N'" : "0";
            }
            case SQL_CURRENT_DATE: {
                return "sysdate";
            }
            case SQL_DATE_PATTERN: {
                return "yyyy-MM-dd";
            }
            case SQL_DATE_TEMPLATE: {
                return "TO_DATE('{0}', 'YYYY-MM-DD')";
            }
            case SQL_CURRENT_TIME: {
                return "TO_DATE('2000-01-01'||TO_CHAR(sysdate, 'HH24:MI:SS'), 'YYYY-MM-DD HH24:MI:SS')";
            }
            case SQL_TIME_PATTERN: {
                return "HH:mm:ss";
            }
            case SQL_TIME_TEMPLATE: {
                return "TO_DATE('2000-01-01 {0}'), 'YYYY-MM-DD HH24:MI:SS')";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "systimestamp";
            }
            case SQL_DATETIME_PATTERN: 
            case SQL_TIMESTAMP_PATTERN: {
                return "yyyy-MM-dd HH:mm:ss.SSS";
            }
            case SQL_DATETIME_TEMPLATE: 
            case SQL_TIMESTAMP_TEMPLATE: {
                return "TO_TIMESTAMP('{0}', 'YYYY.MM.DD HH24:MI:SS.FF')";
            }
            case SQL_FUNC_COALESCE: {
                return "nvl(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substr(?, {0})";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substr(?, {0}, {1})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "reverse(?)";
            }
            case SQL_FUNC_STRINDEX: {
                return "instr(?, {0})";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return "instr(?, {0}, {1})";
            }
            case SQL_FUNC_LENGTH: {
                return "length(?)";
            }
            case SQL_FUNC_UPPER: {
                return "upper(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lower(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_CONCAT: {
                return "concat(?)";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "trunc(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceil(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "mod(?,{0})";
            }
            case SQL_FUNC_FORMAT: {
                return "TO_CHAR(?, {0:VARCHAR})";
            }
            case SQL_FUNC_DAY: {
                return this.oracle8Compatibilty ? "to_number(to_char(?,'DD'))" : "extract(day from ?)";
            }
            case SQL_FUNC_MONTH: {
                return this.oracle8Compatibilty ? "to_number(to_char(?,'MM'))" : "extract(month from ?)";
            }
            case SQL_FUNC_YEAR: {
                return this.oracle8Compatibilty ? "to_number(to_char(?,'YYYY'))" : "extract(year from ?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_STRAGG: {
                return "listagg(?,{0}) WITHIN GROUP (ORDER BY {1})";
            }
            case SQL_FUNC_DECODE: {
                return "decode(? {0})";
            }
            case SQL_FUNC_DECODE_SEP: {
                return ",";
            }
            case SQL_FUNC_DECODE_PART: {
                return "{0}, {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "{0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case VARCHAR: 
            case CHAR: 
            case CLOB: {
                if (format instanceof String) {
                    return "to_char(?, '" + format.toString() + "')";
                }
                return "to_char(?)";
            }
            case INTEGER: 
            case FLOAT: 
            case DECIMAL: {
                if (format instanceof String) {
                    return "to_number(?, '" + format.toString() + "')";
                }
                return "to_number(?)";
            }
            case DATE: 
            case DATETIME: {
                if (format instanceof String) {
                    return "to_date(?, '" + format.toString() + "')";
                }
                return "to_date(?)";
            }
            case TIME: {
                return "to_date(?, 'HH24:mm:ss')";
            }
            case TIMESTAMP: {
                if (format instanceof String) {
                    return "to_timestamp(?, '" + format.toString() + "')";
                }
                return "to_timestamp(?)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    @Override
    public String extractErrorMessage(SQLException sqle) {
        String msg = sqle.getMessage();
        int end = (msg = msg.substring(msg.indexOf(58) + 1)).indexOf("ORA");
        if (end >= 0) {
            msg = msg.substring(0, end - 1);
        }
        return msg;
    }

    @Override
    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        if (dataType == DataType.BOOL) {
            String val = rset.getString(columnIndex);
            if (val == null || rset.wasNull()) {
                return null;
            }
            if (val.equalsIgnoreCase("Y") || val.equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return super.getResultValue(rset, columnIndex, dataType);
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        Object val;
        DBSQLBuilder sql = this.createSQLBuilder();
        sql.append("SELECT ");
        db.appendQualifiedName(sql, seqName, null);
        sql.append(".NEXTVAL FROM DUAL");
        String sqlCmd = sql.toString();
        if (log.isDebugEnabled()) {
            log.debug("Executing: " + sqlCmd);
        }
        if (ObjectUtils.isEmpty(val = this.querySingleValue(sqlCmd, null, DataType.UNKNOWN, conn))) {
            log.error("getNextSequenceValue: Invalid sequence value for sequence " + seqName);
            throw new QueryNoResultException(sqlCmd);
        }
        return val;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        String seqName = StringUtils.toString(column.getDefaultValue());
        if (StringUtils.isEmpty(seqName)) {
            throw new InvalidArgumentException("column", column);
        }
        DBSQLBuilder sql = this.createSQLBuilder();
        column.getDatabase().appendQualifiedName(sql, seqName, null);
        sql.append(".NEXTVAL");
        return new DBValueExpr(column.getDatabase(), sql.toString(), DataType.UNKNOWN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        Timestamp timestamp;
        ResultSet rs = null;
        try {
            rs = this.executeQuery("SELECT systimestamp FROM DUAL", null, false, conn);
            timestamp = rs.next() ? rs.getTimestamp(1) : null;
        }
        catch (SQLException e) {
            try {
                throw new EmpireSQLException(this, e);
            }
            catch (Throwable throwable) {
                try {
                    Statement stmt;
                    Statement statement = stmt = rs != null ? rs.getStatement() : null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw new EmpireSQLException(this, e2);
                }
            }
        }
        try {
            Statement stmt;
            Statement statement = stmt = rs != null ? rs.getStatement() : null;
            if (rs != null) {
                rs.close();
            }
            if (stmt == null) return timestamp;
            stmt.close();
            return timestamp;
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this, e);
        }
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new OracleDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    @Override
    public void appendEnableRelationStmt(DBRelation r, boolean enable, DBSQLScript script) {
        DBSQLBuilder sql = this.createSQLBuilder();
        sql.append("ALTER TABLE ");
        r.getForeignKeyTable().addSQL(sql, 2L);
        sql.append(enable ? " ENABLE " : " DISABLE ");
        sql.append("CONSTRAINT ");
        sql.append(r.getName());
        script.addStmt(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDatabase(DBDatabase db, String owner, Connection conn) {
        DBContextStatic context = new DBContextStatic(this, conn);
        if (owner == null || owner.length() == 0) {
            throw new InvalidArgumentException("owner", owner);
        }
        OracleSYSDatabase sysDB = new OracleSYSDatabase(this);
        DBCommand sysDBCommand = this.createCommand(false);
        sysDBCommand.select(sysDB.CI.getColumns());
        sysDBCommand.where((DBCompareExpr)sysDB.CI.C_OWNER.is(owner));
        OracleDataDictionnary dataDictionnary = new OracleDataDictionnary();
        try (DBReader rd = new DBReader(context);){
            rd.open(sysDBCommand);
            log.info("---------------------------------------------------------------------------------");
            log.info("checkDatabase start: " + db.getClass().getName());
            String skipTable = "";
            while (rd.moveNext()) {
                String tableName = rd.getString(sysDB.CI.C_TABLE_NAME);
                if (tableName.equals(skipTable)) continue;
                String columnName = rd.getString(sysDB.CI.C_COLUMN_NAME);
                DBTable dbTable = db.getTable(tableName);
                DBView dbView = db.getView(tableName);
                String dataType = rd.getString(sysDB.CI.C_DATA_TYPE);
                int charLength = rd.getInt(sysDB.CI.C_CHAR_LENGTH);
                int dataLength = rd.getInt(sysDB.CI.C_DATA_LENGTH);
                int dataPrecision = rd.getInt(sysDB.CI.C_DATA_PRECISION);
                int dataScale = rd.getInt(sysDB.CI.C_DATA_SCALE);
                String nullable = rd.getString(sysDB.CI.C_NULLABLE);
                dataDictionnary.fillDataDictionnary(tableName, columnName, dataType, charLength, dataLength, dataPrecision, dataScale, nullable);
                if (dbTable != null) {
                    DBColumn col = dbTable.getColumn(columnName);
                    if (col != null) continue;
                    log.warn("COLUMN NOT FOUND IN " + db.getClass().getName() + "\t: [" + tableName + "][" + columnName + "][" + dataType + "][" + dataLength + "]");
                    continue;
                }
                if (dbView != null) {
                    log.debug("Column check for view " + tableName + " not yet implemented.");
                    continue;
                }
                log.debug("TABLE OR VIEW NOT FOUND IN " + db.getClass().getName() + "\t: [" + tableName + "]");
                skipTable = tableName;
            }
            dataDictionnary.checkDBTableDefinition(db.getTables());
            dataDictionnary.checkDBViewDefinition(db.getViews());
            log.info("checkDatabase end: " + db.getClass().getName());
            log.info("---------------------------------------------------------------------------------");
        }
    }

    @Override
    public OracleDBModelParser createModelParser(String catalog, String schema) {
        String schemaPattern = StringUtils.coalesce(schema, this.schemaName);
        if (StringUtils.isEmpty(schemaPattern)) {
            throw new InvalidPropertyException("schemaName", (Object)null);
        }
        return new OracleDBModelParser(schemaPattern);
    }

    @Override
    public DBModelChecker createModelChecker(DBDatabase db) {
        OracleDBModelParser modelParser = this.createModelParser(null, db != null ? db.getSchema() : null);
        return new OracleDBModelChecker(modelParser, this.getBooleanType());
    }

    public static enum BooleanType {
        CHAR,
        NUMBER;

    }
}

