/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.validation;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBView;
import org.apache.empire.db.validation.DBModelErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBModelErrorLogger
implements DBModelErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DBModelErrorLogger.class);
    protected int errorCount;
    protected int warnCount;

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarnCount() {
        return this.warnCount;
    }

    protected void logWarn(String msg, Object ... params) {
        log.warn(msg, params);
    }

    protected void logError(String msg, Object ... params) {
        log.error(msg, params);
    }

    @Override
    public void itemNotFound(DBObject dbo) {
        if (dbo instanceof DBTable) {
            DBTable table = (DBTable)dbo;
            this.logError("The table {} does not exist in the target database.", table.getName());
        } else if (dbo instanceof DBColumn) {
            DBColumn column = (DBColumn)dbo;
            this.logError("The column {} does not exist in the target database.", column.getFullName());
        } else if (dbo instanceof DBIndex) {
            DBIndex dbi = (DBIndex)dbo;
            this.logError("The primary key {} for table{} does not exist in the target database.", dbi.getName(), dbi.getTable().getName());
        } else if (dbo instanceof DBView) {
            DBView view = (DBView)dbo;
            this.logError("The view {} does not exist in the target database.", view.getName());
        } else if (dbo instanceof DBRelation) {
            DBRelation relation = (DBRelation)dbo;
            this.logError("The foreing key relation " + relation.getName() + " from table {} to table {} does not exist in the target database.", relation.getForeignKeyTable().getName(), relation.getReferencedTable().getName());
        } else {
            this.logError("The object {} does not exist in the target database.", dbo.toString());
        }
        ++this.errorCount;
    }

    @Override
    public void objectTypeMismatch(DBObject object, String name, Class<?> expectedType) {
        this.logError("The oboject \"{}\" type of {} does not match the expected type of {}.", name, object.getClass().getSimpleName(), expectedType.getSimpleName());
        ++this.errorCount;
    }

    @Override
    public void columnTypeMismatch(DBColumn col, DataType type) {
        if (col instanceof DBView.DBViewColumn && col.getDataType() == DataType.DECIMAL && type == DataType.INTEGER) {
            return;
        }
        this.logError("The column " + col.getFullName() + " type of {} does not match the database type of {}.", new Object[]{col.getDataType(), type});
        ++this.errorCount;
    }

    @Override
    public void columnSizeMismatch(DBColumn col, int size, int scale) {
        if (size > 0 && (double)size < col.getSize()) {
            this.logError("The column " + col.getFullName() + " size of {} does not match the database size of {}.", col.getSize(), size);
            ++this.errorCount;
        } else if (col.getDataType() != DataType.INTEGER) {
            this.logWarn("The column " + col.getFullName() + " size of {} does not match the database size of {}.", col.getSize(), size);
            ++this.warnCount;
        }
    }

    @Override
    public void columnNullableMismatch(DBColumn col, boolean nullable) {
        if (nullable) {
            this.logError("The column " + col.getFullName() + " must not be nullable", new Object[0]);
        } else {
            this.logError("The column " + col.getFullName() + " must be nullable", new Object[0]);
        }
        ++this.errorCount;
    }

    @Override
    public void primaryKeyColumnMissing(DBIndex primaryKey, DBColumn column) {
        this.logError("The primary key of table {} misses the column {}", primaryKey.getTable().getName(), column.getName());
        ++this.errorCount;
    }

    @Override
    public void primaryKeyMismatch(DBIndex primaryKey, DBColumn[] tableKey) {
        int i;
        StringBuilder b = new StringBuilder("[");
        DBColumn[] keyColumns = primaryKey.getColumns();
        for (i = 0; i < keyColumns.length; ++i) {
            if (i > 0) {
                b.append("|");
            }
            b.append(keyColumns[i].getName());
        }
        b.append("]");
        String defColumns = b.toString();
        b.setLength(1);
        for (i = 0; i < tableKey.length; ++i) {
            if (i > 0) {
                b.append("|");
            }
            b.append(tableKey[i].getName());
        }
        b.append("]");
        String tblColumns = b.toString();
        this.logError("The primary key of table {} {} does not match the key of the existing table {}.", primaryKey.getTable().getName(), defColumns, tblColumns);
        ++this.warnCount;
    }
}

