/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBUtils;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.RecordDeleteFailedException;
import org.apache.empire.db.exceptions.RecordUpdateFailedException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.exceptions.UnspecifiedErrorException;

public class DBTable
extends DBRowSet
implements Cloneable {
    public static final int INT_SIZE_DEFAULT = 0;
    public static final int INT_SIZE_SMALL = 2;
    public static final int INT_SIZE_MEDIUM = 4;
    public static final int INT_SIZE_BIG = 8;
    private static AtomicInteger tableCount = new AtomicInteger(0);
    private final String name;
    private String alias;
    private DBIndex primaryKey = null;
    private final List<DBIndex> indexes = new ArrayList<DBIndex>();
    private Boolean quoteName = null;
    private DBRelation.DBCascadeAction cascadeDeleteAction = DBRelation.DBCascadeAction.NONE;

    public DBTable(String name, DBDatabase db, String alias) {
        super(db);
        if (alias == null) {
            alias = "t" + String.valueOf(tableCount.incrementAndGet());
        }
        this.name = name;
        this.alias = alias;
        if (db != null) {
            db.addTable(this);
        }
    }

    public DBTable(String name, DBDatabase db) {
        this(name, db, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public DBColumn[] getKeyColumns() {
        return this.primaryKey != null ? this.primaryKey.getColumns() : null;
    }

    public Object clone() throws CloneNotSupportedException {
        DBTable clone = (DBTable)super.clone();
        this.initClonedFields(clone);
        clone.alias = "t" + String.valueOf(tableCount.incrementAndGet());
        log.info("clone: Table " + this.name + " cloned! Alias old=" + this.alias + " new=" + clone.alias);
        return clone;
    }

    public <T extends DBTable> T clone(String newAlias) {
        try {
            DBTable clone = (DBTable)super.clone();
            this.initClonedFields(clone);
            clone.alias = StringUtils.isEmpty(newAlias) ? "t" + String.valueOf(tableCount.incrementAndGet()) : newAlias;
            log.info("clone: Table " + this.name + " cloned! Alias old=" + this.alias + " new=" + clone.alias);
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Unable to clone table " + this.getName());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBTable> void initClonedFields(T clone) throws CloneNotSupportedException {
        Class<?> colClass = ((DBColumn)this.columns.get(0)).getClass();
        Class<?> colBase = colClass.getSuperclass();
        clone.columns = new ArrayList();
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < this.columns.size(); ++i) {
            DBTableColumn srcCol = (DBTableColumn)this.columns.get(i);
            DBTableColumn newCol = new DBTableColumn(clone, srcCol);
            for (int j = 0; j < fields.length; ++j) {
                Field f = fields[j];
                Class<?> type = f.getType();
                if (type != colClass && type != colBase) continue;
                try {
                    if (f.get(clone) != srcCol) continue;
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                        try {
                            f.set(clone, newCol);
                            continue;
                        }
                        finally {
                            f.setAccessible(false);
                        }
                    }
                    f.set(clone, newCol);
                    continue;
                }
                catch (Exception e) {
                    String fieldName = fields[j].getName();
                    log.error("Failed to modify declared table field: " + fieldName + ". Reason is: " + e.toString());
                    CloneNotSupportedException cnse = new CloneNotSupportedException("Unable to replace field reference for field " + fieldName);
                    cnse.initCause(e);
                    throw cnse;
                }
            }
        }
    }

    protected void addColumn(DBTableColumn column) {
        if (column == null || column.getRowSet() != this) {
            throw new InvalidArgumentException("column", column);
        }
        if (this.getColumn(column.getName()) != null) {
            throw new ItemExistsException((Object)column.getName());
        }
        this.columns.add(column);
    }

    protected DBTableColumn createAndAppendColumn(String columnName, DataType type, double size, boolean required, Object defValue) {
        if (this.getColumn(columnName) != null) {
            throw new ItemExistsException((Object)columnName);
        }
        boolean autoGenerated = type == DataType.AUTOINC || type == DataType.UNIQUEID;
        DBTableColumn column = new DBTableColumn(this, type, columnName, size, required, autoGenerated, defValue);
        if (column.getDataType() == DataType.AUTOINC) {
            if (this.primaryKey == null) {
                this.setPrimaryKey(column);
            } else {
                throw new UnspecifiedErrorException("Table " + this.getName() + " already has a Primary-Key! No column of type AUTOINC can be added.");
            }
        }
        this.addColumn(column);
        return column;
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Object defValue) {
        if (defValue instanceof Class) {
            log.warn("Column {}: a class object of type \"{}\" has been passed as default value. Please check!", (Object)columnName, (Object)((Class)defValue).getName());
        }
        return this.createAndAppendColumn(columnName, type, size, required, defValue);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required) {
        return this.createAndAppendColumn(columnName, type, size, required, null);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Options options) {
        DBTableColumn col = this.createAndAppendColumn(columnName, type, size, required, null);
        col.setOptions(options);
        return col;
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Options options, Object defValue) {
        if (defValue != null && !options.contains(defValue)) {
            throw new InvalidArgumentException("devValue", defValue);
        }
        DBTableColumn col = this.createAndAppendColumn(columnName, type, size, required, defValue);
        col.setOptions(options);
        return col;
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Class<?> enumType) {
        if (!enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        DBTableColumn col = this.createAndAppendColumn(columnName, type, size, required, null);
        col.setEnumOptions(enumType);
        return col;
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Enum<?> enumValue) {
        Object defValue = ObjectUtils.getEnumValue(enumValue, type.isNumeric());
        DBTableColumn col = this.createAndAppendColumn(columnName, type, size, required, defValue);
        col.setEnumOptions(enumValue.getClass());
        return col;
    }

    public DBTableColumn addIdentity(String name, String seqName) {
        return this.addColumn(name, DataType.AUTOINC, 8.0, true, seqName);
    }

    public final DBTableColumn addIdentity(String name) {
        return this.addIdentity(name, null);
    }

    public DBTableColumn addForeignKey(String name, DBTable target, boolean required, Options options, DBRelation.DBCascadeAction cascadeAction) {
        if (target == null) {
            throw new ObjectNotValidException(target);
        }
        DBColumn[] keyCols = target.getKeyColumns();
        if (keyCols == null || keyCols.length != 1) {
            throw new NotSupportedException(target, "addForeignKey");
        }
        DBTableColumn keyCol = (DBTableColumn)keyCols[0];
        DataType keyDataType = keyCol.getDataType();
        if (keyDataType == DataType.AUTOINC) {
            keyDataType = DataType.INTEGER;
        }
        DBTableColumn referenceColumn = this.addColumn(name, keyDataType, keyCol.getSize(), required, options);
        String fkName = this.getName() + "_" + name.replace("_ID", "_FK");
        DBRelation relation = this.db.addRelation(fkName, referenceColumn.referenceOn(keyCol));
        if (cascadeAction != null) {
            relation.setOnDeleteAction(cascadeAction);
        }
        return referenceColumn;
    }

    public final DBTableColumn addForeignKey(String name, DBTable target, boolean required, boolean cascade) {
        return this.addForeignKey(name, target, required, null, cascade ? DBRelation.DBCascadeAction.CASCADE : DBRelation.DBCascadeAction.NONE);
    }

    public final DBTableColumn addForeignKey(String name, DBTable target, boolean required) {
        return this.addForeignKey(name, target, required, false);
    }

    public DBTableColumn addTimestamp(String name) {
        if (this.timestampColumn != null) {
            String msg = MessageFormat.format("A Timestamp column ({0}) already exists for table {1}", this.timestampColumn.getName(), this.getName());
            throw new UnspecifiedErrorException(msg);
        }
        DBTableColumn tsColumn = this.addColumn(name, DataType.TIMESTAMP, 0.0, true);
        this.setTimestampColumn(tsColumn);
        return tsColumn;
    }

    public DBIndex getPrimaryKey() {
        return this.primaryKey;
    }

    public List<DBIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public void setPrimaryKey(DBColumn ... columns) {
        DBTable.checkParamNull("columns", columns);
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getRowSet() == this) continue;
            throw new InvalidArgumentException("columns[" + String.valueOf(i) + "]", columns[i].getFullName());
        }
        if (this.primaryKey != null) {
            if (this.primaryKey.compareColumns(columns)) {
                return;
            }
            log.warn("A PrimaryKey for the Table {} has already been set. Replacing with new one.", (Object)this.getName());
            this.removeIndex(this.primaryKey);
        }
        if (columns.length > 0) {
            this.primaryKey = new DBIndex(this.name + "_PK", DBIndex.DBIndexType.PRIMARY_KEY, columns);
            this.addIndex(this.primaryKey);
            log.debug("PrimaryKey {} of length {} has been set for table {}", new Object[]{this.primaryKey.getName(), columns.length, this.getName()});
        } else {
            this.primaryKey = null;
        }
    }

    public DBIndex addIndex(DBIndex index) {
        if (index == null) {
            throw new InvalidArgumentException("index", null);
        }
        String name = index.getName();
        for (DBIndex i : this.indexes) {
            if (i != index && !name.equalsIgnoreCase(i.getName())) continue;
            throw new ItemExistsException((Object)name);
        }
        this.indexes.add(index);
        index.setTable(this);
        return index;
    }

    public final DBIndex addIndex(String name, DBIndex.DBIndexType type, DBColumn ... columns) {
        if (name == null || columns == null || columns.length == 0) {
            throw new InvalidArgumentException("name|columns", null);
        }
        if (type == DBIndex.DBIndexType.PRIMARY_KEY && this.primaryKey != null) {
            throw new InvalidArgumentException("type", DBIndex.DBIndexType.PRIMARY_KEY.name());
        }
        DBIndex index = new DBIndex(name, type, columns);
        this.addIndex(index);
        return index;
    }

    public final DBIndex addIndex(String name, boolean unique, DBColumn ... columns) {
        return this.addIndex(name, unique ? DBIndex.DBIndexType.UNIQUE : DBIndex.DBIndexType.STANDARD, columns);
    }

    public void removeIndex(DBIndex index) {
        if (index.getTable() != this || !this.indexes.contains(index)) {
            throw new InvalidArgumentException("index", index);
        }
        this.indexes.remove(index);
        index.setTable(null);
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 1L | 2L) != 0L) {
            this.db.appendQualifiedName(sql, this.name, this.quoteName);
        }
        if ((context & 8L) != 0L && this.alias != null) {
            sql.append(this.getRenameTablePhrase());
            sql.append(this.getAlias());
        }
    }

    @Override
    public void createRecord(DBRecordBase record, Object[] initalKey, boolean deferredInit) {
        DBRowSet.FieldInitMode fieldInitMode = deferredInit ? DBRowSet.FieldInitMode.SET_DEFAULTS_DEFERRED : DBRowSet.FieldInitMode.SET_DEFAULTS;
        super.initRecord(record, initalKey, fieldInitMode, true);
    }

    public DBIndex checkUniqueConstraints(DBRecordBase record) {
        for (DBIndex idx : this.getIndexes()) {
            if (idx.getType() == DBIndex.DBIndexType.PRIMARY_KEY ? !record.isNew() : !idx.getType().isUnique() || !record.isNew() && !record.wasAnyModified(idx.getColumns())) continue;
            DBCommand cmd = this.createRecordCommand(record.getContext());
            cmd.select(this.count());
            for (DBColumn c : idx.getColumns()) {
                Object value = record.get(c);
                cmd.where((DBCompareExpr)c.is(value));
            }
            DBUtils utils = record.getContext().getUtils();
            int count = utils.querySingleInt(cmd);
            if (count <= 0) continue;
            return idx;
        }
        return null;
    }

    public DBRelation.DBCascadeAction getDefaultCascadeDeleteAction() {
        return this.cascadeDeleteAction;
    }

    public void setDefaultCascadeDeleteAction(DBRelation.DBCascadeAction cascadeDeleteAction) {
        this.cascadeDeleteAction = cascadeDeleteAction;
    }

    @Override
    public void deleteRecord(Object[] key, DBContext context) {
        if (this.primaryKey == null) {
            throw new NoPrimaryKeyException(this);
        }
        DBColumn[] keyColumns = this.primaryKey.getColumns();
        if (key == null || key.length != keyColumns.length) {
            throw new InvalidArgumentException("key", key);
        }
        this.deleteAllReferences(key, context);
        DBCommand cmd = this.createRecordCommand(context);
        cmd.where(this.getKeyConstraints(key));
        String sqlCmd = cmd.getDelete(this);
        int affected = context.executeSQL(sqlCmd, cmd.getParamValues());
        if (affected < 0) {
            throw new UnexpectedReturnValueException(affected, "db.executeSQL()");
        }
        if (affected == 0) {
            throw new RecordDeleteFailedException(this, key);
        }
        if (affected > 1) {
            throw new RecordUpdateFailedException(this, key);
        }
    }

    public List<DBRelation> getForeignKeyRelations() {
        ArrayList<DBRelation> relations = new ArrayList<DBRelation>();
        for (DBRelation r : this.getDatabase().getRelations()) {
            if (!this.equals(r.getForeignKeyTable())) continue;
            relations.add(r);
        }
        return Collections.unmodifiableList(relations);
    }

    protected Object validateValue(DBTableColumn column, Object value) {
        return this.db.validateValue(column, value);
    }

    @Override
    protected void initRecordDefaultValues(DBRecordBase record, DBRowSet.FieldInitMode fieldInitMode) {
        if (fieldInitMode == DBRowSet.FieldInitMode.NONE) {
            throw new InvalidArgumentException("fieldInitMode", (Object)fieldInitMode);
        }
        Connection conn = fieldInitMode == DBRowSet.FieldInitMode.SET_DEFAULTS_DEFERRED ? null : record.getContext().getConnection();
        Object[] fields = record.getFields();
        for (int i = 0; i < fields.length; ++i) {
            DBColumn column;
            Object value;
            if (fields[i] != null || ObjectUtils.isEmpty(value = ((DBTableColumn)(column = (DBColumn)this.columns.get(i))).getRecordDefaultValue(conn))) continue;
            fields[i] = value;
        }
    }
}

