/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParamList;
import org.apache.empire.db.DBCmdParams;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBSQLBuilder
implements Appendable {
    private static final Logger log = LoggerFactory.getLogger(DBSQLBuilder.class);
    protected static final char TEXT_DELIMITER = '\'';
    protected final DBMSHandler dbms;
    protected final StringBuilder sql = new StringBuilder(64);
    protected DBCmdParamList cmdParamList;

    protected DBSQLBuilder(DBMSHandler dbms) {
        this.dbms = dbms;
    }

    public void setCmdParams(DBCmdParamList cmdParamList) {
        this.cmdParamList = cmdParamList;
    }

    public String toString() {
        return this.sql.toString();
    }

    public DBMSHandler getDbms() {
        return this.dbms;
    }

    public String getPhrase(DBSqlPhrase phrase) {
        return this.dbms.getSQLPhrase(phrase);
    }

    public int length() {
        return this.sql.length();
    }

    public void reset(int pos) {
        if (pos > this.sql.length()) {
            throw new InvalidArgumentException("pos", pos);
        }
        this.sql.setLength(pos);
    }

    @Override
    public DBSQLBuilder append(CharSequence sqlLiteral) {
        this.sql.append(sqlLiteral);
        return this;
    }

    @Override
    public DBSQLBuilder append(CharSequence sqlLiteral, int start, int end) {
        this.sql.append(sqlLiteral, start, end);
        return this;
    }

    @Override
    public DBSQLBuilder append(char c) {
        this.sql.append(c);
        return this;
    }

    public DBSQLBuilder append(long l) {
        this.sql.append(l);
        return this;
    }

    public DBSQLBuilder append(double d) {
        this.sql.append(d);
        return this;
    }

    public DBSQLBuilder append(DBSqlPhrase phrase) {
        this.sql.append(this.dbms.getSQLPhrase(phrase));
        return this;
    }

    public void append(DBCommandExpr subQueryCmd) {
        this.sql.append(subQueryCmd.getSelect());
        DBCmdParams params = subQueryCmd.getParams();
        if (params.isEmpty()) {
            return;
        }
        if (this.cmdParamList == null) {
            throw new NotSupportedException(this, "append command with params");
        }
        this.cmdParamList.mergeSubqueryParams(params);
    }

    public void appendValue(DataType type, Object value) {
        this.appendValue(type, value, 7L, "+");
    }

    public void appendValue(DataType dataType, Object value, long context, String arraySep) {
        if (value instanceof DBExpr) {
            ((DBExpr)value).addSQL(this, context);
            return;
        }
        if (value instanceof OptionEntry) {
            value = ((OptionEntry)value).getValue();
        }
        if (value instanceof Enum) {
            value = ObjectUtils.getEnumValue((Enum)value, dataType.isNumeric());
        } else if (value instanceof Collection) {
            value = ((Collection)value).toArray();
        }
        if (value != null && value.getClass().isArray()) {
            Object[] array = value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0 && arraySep != null) {
                    this.sql.append(arraySep);
                }
                this.appendValue(dataType, array[i], context, arraySep);
            }
            return;
        }
        this.appendSimpleValue(dataType, value);
    }

    public void appendTemplate(String template, Object[] values, DataType[] dataTypes, long context, String arraySep) {
        int beg;
        int pos = 0;
        while ((beg = template.indexOf(123, pos)) >= 0) {
            this.sql.append(template.substring(pos, beg));
            int end = template.indexOf(125, ++beg);
            if (end < 0) {
                throw new InvalidArgumentException("template", template);
            }
            int iParam = Integer.parseInt(template.substring(beg, end));
            if (iParam < 0 || iParam >= values.length) {
                throw new InvalidArgumentException("params", values);
            }
            DataType dataType = dataTypes.length >= iParam ? dataTypes[iParam] : dataTypes[0];
            this.appendValue(dataType, values[iParam], context, arraySep);
            pos = end + 1;
        }
        if (pos < template.length()) {
            this.sql.append(template.substring(pos));
            if (pos == 0 && values != null && values.length > 0) {
                log.warn("No Placeholder for found in template {}!", (Object)template);
            }
        }
    }

    protected void appendSimpleValue(DataType type, Object value) {
        if (value instanceof Enum) {
            log.warn("Enum of type {} supplied for getValueString. Converting value...", (Object)value.getClass().getName());
            value = ObjectUtils.getEnumValue((Enum)value, type.isNumeric());
        }
        if (ObjectUtils.isEmpty(value)) {
            this.append(DBSqlPhrase.SQL_NULL);
            return;
        }
        switch (type) {
            case DATE: {
                this.sql.append(this.getDateTimeString(value, DBSqlPhrase.SQL_DATE_TEMPLATE, DBSqlPhrase.SQL_DATE_PATTERN, DBSqlPhrase.SQL_CURRENT_DATE));
                return;
            }
            case TIME: {
                this.sql.append(this.getDateTimeString(value, DBSqlPhrase.SQL_TIME_TEMPLATE, DBSqlPhrase.SQL_TIME_PATTERN, DBSqlPhrase.SQL_CURRENT_TIME));
                return;
            }
            case DATETIME: {
                String text = !DBDatabase.SYSDATE.equals(value) && !(value instanceof Date) && ObjectUtils.lengthOf(value) <= 10 ? this.getDateTimeString(value, DBSqlPhrase.SQL_DATE_TEMPLATE, DBSqlPhrase.SQL_DATE_PATTERN, DBSqlPhrase.SQL_CURRENT_TIMESTAMP) : this.getDateTimeString(value, DBSqlPhrase.SQL_DATETIME_TEMPLATE, DBSqlPhrase.SQL_DATETIME_PATTERN, DBSqlPhrase.SQL_CURRENT_TIMESTAMP);
                this.sql.append(text);
                return;
            }
            case TIMESTAMP: {
                this.sql.append(this.getDateTimeString(value, DBSqlPhrase.SQL_TIMESTAMP_TEMPLATE, DBSqlPhrase.SQL_TIMESTAMP_PATTERN, DBSqlPhrase.SQL_CURRENT_TIMESTAMP));
                return;
            }
            case VARCHAR: 
            case CHAR: 
            case CLOB: 
            case UNIQUEID: {
                this.appendStringLiteral(type, value);
                return;
            }
            case BOOL: {
                boolean boolVal = false;
                boolVal = value instanceof Boolean ? ((Boolean)value).booleanValue() : this.stringToBoolean(value.toString());
                this.append(boolVal ? DBSqlPhrase.SQL_BOOLEAN_TRUE : DBSqlPhrase.SQL_BOOLEAN_FALSE);
                return;
            }
            case INTEGER: 
            case DECIMAL: 
            case FLOAT: {
                this.sql.append(this.getNumberString(value, type));
                return;
            }
            case BLOB: {
                throw new NotSupportedException(this, "appendSimpleValue(DataType.BLOB)");
            }
            case AUTOINC: 
            case UNKNOWN: {
                this.sql.append(value.toString());
                return;
            }
        }
        log.warn("Unknown DataType {} for getValueString().", (Object)type);
        this.sql.append(value.toString());
    }

    protected String getDateTimeString(Object value, DBSqlPhrase sqlTemplate, DBSqlPhrase sqlPattern, DBSqlPhrase sqlCurrentDate) {
        Timestamp ts;
        if (DBDatabase.SYSDATE.equals(value)) {
            return this.dbms.getSQLPhrase(sqlCurrentDate);
        }
        if (value instanceof Timestamp) {
            ts = (Timestamp)value;
        } else if (value instanceof Date) {
            ts = new Timestamp(((Date)value).getTime());
        } else if (value instanceof LocalDate) {
            ts = Timestamp.valueOf(((LocalDate)value).atStartOfDay());
        } else if (value instanceof LocalDateTime) {
            ts = Timestamp.valueOf((LocalDateTime)value);
        } else {
            String dtValue = value.toString().trim();
            try {
                ts = Timestamp.valueOf(dtValue);
            }
            catch (Throwable e) {
                log.error("Unable to parse date value " + dtValue, e);
                throw new InvalidArgumentException("value", value);
            }
        }
        String pattern = this.dbms.getSQLPhrase(sqlPattern);
        SimpleDateFormat sqlFormat = new SimpleDateFormat(this.dbms.getSQLPhrase(sqlPattern));
        String datetime = sqlFormat.format(ts);
        int nanos = ts.getNanos() % 1000000;
        if (pattern.endsWith(".SSS") && nanos > 0) {
            datetime = nanos % 100 > 0 ? datetime + String.format("%06d", nanos) : datetime + String.format("%04d", nanos / 100);
        }
        String template = this.dbms.getSQLPhrase(sqlTemplate);
        return StringUtils.replace(template, "{0}", datetime);
    }

    protected void appendStringLiteral(DataType type, Object value) {
        if (value == null) {
            this.append(DBSqlPhrase.SQL_NULL);
            return;
        }
        String text = value.toString();
        this.sql.append('\'');
        if (!"\u0000".equals(text)) {
            this.escapeAndAppendLiteral(text);
        }
        this.sql.append('\'');
    }

    protected void escapeAndAppendLiteral(String value) {
        int delim;
        int pos = 0;
        while ((delim = value.indexOf(39, pos)) >= 0) {
            if (delim > pos) {
                this.sql.append(value.substring(pos, delim));
            }
            this.sql.append("''");
            pos = delim + 1;
        }
        if (pos == 0) {
            this.sql.append(value);
        } else if (pos < value.length()) {
            this.sql.append(value.substring(pos));
        }
    }

    protected String getNumberString(Object value, DataType type) {
        if (value instanceof Number) {
            return value.toString();
        }
        String s = value.toString();
        boolean integerOnly = type == DataType.INTEGER;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' || c == '+') continue;
            if (c == ' ' && i > 0) {
                return s.substring(0, i);
            }
            if (!integerOnly && (c == '.' || c == ',')) continue;
            throw new NumberFormatException(s);
        }
        return s;
    }

    protected boolean stringToBoolean(String value) {
        return "1".equals(value) || "true".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value);
    }
}

