/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.context.DBContextAware;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DBRecordData
extends DBObject
implements DBContextAware,
RecordData {
    private static final Logger log = LoggerFactory.getLogger(DBRecordData.class);

    @Override
    public abstract int getFieldCount();

    @Override
    public abstract int getFieldIndex(ColumnExpr var1);

    @Override
    public abstract int getFieldIndex(String var1);

    public abstract int addXmlMeta(Element var1);

    public abstract int addXmlData(Element var1);

    public abstract Document getXmlDocument();

    @Override
    public abstract Object getValue(int var1);

    @Deprecated
    public Object getValue(ColumnExpr column) {
        return this.get(column);
    }

    @Deprecated
    public final <T> T getValue(Column column, Class<T> returnType) {
        return this.get(column, returnType);
    }

    @Deprecated
    public final Object[] getValues(ColumnExpr ... columns) {
        return this.getArray(columns);
    }

    @Override
    public final Object get(ColumnExpr column) {
        int index = this.getFieldIndex(column);
        if (index < 0) {
            throw new ItemNotFoundException((Object)column.getName());
        }
        return this.getValue(index);
    }

    public final <T> T get(Column column, Class<T> returnType) {
        return ObjectUtils.convert(returnType, this.get(column));
    }

    public final Object[] getArray(ColumnExpr ... columns) {
        Object[] values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int index = this.getFieldIndex(columns[i]);
            if (index < 0) {
                throw new ItemNotFoundException((Object)columns[i].getName());
            }
            values[i] = this.getValue(index);
        }
        return values;
    }

    public int getInt(int index) {
        return ObjectUtils.getInteger(this.getValue(index));
    }

    public final int getInt(ColumnExpr column) {
        return this.getInt(this.getFieldIndex(column));
    }

    public long getLong(int index) {
        return ObjectUtils.getLong(this.getValue(index));
    }

    public final long getLong(ColumnExpr column) {
        return this.getLong(this.getFieldIndex(column));
    }

    public double getDouble(int index) {
        return ObjectUtils.getDouble(this.getValue(index));
    }

    public final double getDouble(ColumnExpr column) {
        return this.getDouble(this.getFieldIndex(column));
    }

    public BigDecimal getDecimal(int index) {
        return ObjectUtils.getDecimal(this.getValue(index));
    }

    public final BigDecimal getDecimal(ColumnExpr column) {
        return this.getDecimal(this.getFieldIndex(column));
    }

    public boolean getBoolean(int index) {
        return ObjectUtils.getBoolean(this.getValue(index));
    }

    public final boolean getBoolean(ColumnExpr column) {
        return this.getBoolean(this.getFieldIndex(column));
    }

    public String getString(int index) {
        return ObjectUtils.getString(this.getValue(index));
    }

    public final String getString(ColumnExpr column) {
        return this.getString(this.getFieldIndex(column));
    }

    public final Date getDateTime(int index) {
        return ObjectUtils.getDate(this.getValue(index));
    }

    public final Date getDateTime(ColumnExpr column) {
        return this.getDateTime(this.getFieldIndex(column));
    }

    public final LocalDate getLocalDate(int index) {
        return ObjectUtils.getLocalDate(this.getValue(index));
    }

    public final LocalDate getLocalDate(ColumnExpr column) {
        return this.getLocalDate(this.getFieldIndex(column));
    }

    public final LocalDateTime getLocalDateTime(int index) {
        return ObjectUtils.getLocalDateTime(this.getValue(index));
    }

    public final LocalDateTime getLocalDateTime(ColumnExpr column) {
        return this.getLocalDateTime(this.getFieldIndex(column));
    }

    public <T extends Enum<?>> T getEnum(int index, Class<T> enumType) {
        if (this.isNull(index)) {
            return null;
        }
        ColumnExpr col = this.getColumn(index);
        try {
            boolean numeric = col.getDataType().isNumeric();
            return ObjectUtils.getEnum(enumType, numeric ? Integer.valueOf(this.getInt(index)) : this.getValue(index));
        }
        catch (Exception e) {
            String value = StringUtils.valueOf(this.getValue(index));
            log.error("Unable to resolve enum value of '{}' for type {}", (Object)value, (Object)enumType.getName());
            throw new FieldIllegalValueException(col.getSourceColumn(), value, (Throwable)e);
        }
    }

    public final <T extends Enum<?>> T getEnum(ColumnExpr column, Class<T> enumType) {
        return this.getEnum(this.getFieldIndex(column), enumType);
    }

    public final <T extends Enum<?>> T getEnum(Column column) {
        Class<Enum<?>> enumType = column.getEnumType();
        if (enumType == null) {
            throw new InvalidArgumentException("column", column);
        }
        return (T)this.getEnum(this.getFieldIndex(column), enumType);
    }

    @Override
    public boolean isNull(int index) {
        return ObjectUtils.isEmpty(this.getValue(index));
    }

    @Override
    public final boolean isNull(ColumnExpr column) {
        return this.isNull(this.getFieldIndex(column));
    }

    public String getText(ColumnExpr column) {
        String text;
        Object value = this.get(column);
        Options options = column.getOptions();
        if (options != null && options.has(value)) {
            text = options.get(value);
        } else if (value instanceof String) {
            text = (String)value;
        } else if (ObjectUtils.isEmpty(value)) {
            value = column.getAttribute("nullText");
            text = value != null ? value.toString() : "";
        } else {
            text = this.formatValue(column, value);
            if (text == null) {
                text = "";
            }
        }
        return text;
    }

    protected String formatValue(ColumnExpr column, Object value) {
        return ObjectUtils.getString(value);
    }

    protected void setBeanProperty(ColumnExpr column, Object bean, String property, Object value) {
        if (StringUtils.isEmpty(property)) {
            property = column.getBeanPropertyName();
        }
        try {
            if (bean == null) {
                throw new InvalidArgumentException("bean", bean);
            }
            if (StringUtils.isEmpty(property)) {
                throw new InvalidArgumentException("property", property);
            }
            if (log.isTraceEnabled()) {
                log.trace("{}: setting property '{}' to {}", new Object[]{bean.getClass().getName(), property, value});
            }
            if (value != null) {
                Class<Enum<?>> enumType = column.getEnumType();
                if (enumType != null) {
                    value = ObjectUtils.getEnum(enumType, value);
                }
                BeanUtils.setProperty((Object)bean, (String)property, value);
            } else {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)bean, (String)property);
                if (pd == null) {
                    return;
                }
                Method method = PropertyUtils.getWriteMethod((PropertyDescriptor)pd);
                if (method == null) {
                    throw new PropertyReadOnlyException(property);
                }
                method.invoke(bean, value);
            }
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }

    @Override
    public int setBeanProperties(Object bean, Collection<? extends ColumnExpr> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            ColumnExpr column = this.getColumn(i);
            if (ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            if (property != null) {
                this.setBeanProperty(column, bean, property, this.getValue(i));
            }
            ++count;
        }
        return count;
    }

    public final int setBeanProperties(Object bean) {
        return this.setBeanProperties(bean, null);
    }
}

