/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBQuery;
import org.w3c.dom.Element;

public class DBQueryColumn
extends DBColumn {
    protected final DBColumnExpr expr;

    public DBQueryColumn(DBQuery query, String name, DBColumnExpr expr) {
        super(query, name);
        this.expr = expr;
    }

    public DBColumnExpr getExpr() {
        return this.expr;
    }

    @Override
    public DataType getDataType() {
        return this.expr.getDataType();
    }

    @Override
    public double getSize() {
        DBColumn column = this.expr.getSourceColumn();
        if (column == null) {
            return 0.0;
        }
        return column.getSize();
    }

    @Override
    public boolean isReadOnly() {
        DBColumn column = this.expr.getSourceColumn();
        if (column == null) {
            return true;
        }
        return column.isReadOnly();
    }

    @Override
    public boolean isAutoGenerated() {
        DBColumn column = this.expr.getSourceColumn();
        if (column == null) {
            return false;
        }
        return column.isAutoGenerated();
    }

    @Override
    public boolean isRequired() {
        DBColumn column = this.expr.getSourceColumn();
        if (column == null) {
            return false;
        }
        return column.isRequired();
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        Object enumType = this.expr.getAttribute("enumType");
        if (enumType != null) {
            return (Class)enumType;
        }
        DBColumn col = this.expr.getSourceColumn();
        if (col != null) {
            return col.getEnumType();
        }
        return super.getEnumType();
    }

    @Override
    public Object validateValue(Object value) {
        DBColumn column = this.expr.getSourceColumn();
        if (column == null) {
            return value;
        }
        return column.validateValue(value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes != null && this.attributes.contains(name)) {
            return this.attributes.get(name);
        }
        DBColumn column = this.expr.getSourceColumn();
        if (column == null) {
            return null;
        }
        return column.getAttribute(name);
    }

    @Override
    public Options getOptions() {
        if (this.options != null) {
            return this.options;
        }
        DBColumn column = this.expr.getSourceColumn();
        if (column == null) {
            return null;
        }
        return column.getOptions();
    }

    @Override
    public Element addXml(Element parent, long flags) {
        return this.expr.addXml(parent, flags);
    }
}

