/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    protected static final Logger log = LoggerFactory.getLogger(XMLWriter.class);
    protected PrintWriter out;
    protected boolean canonical;
    private static String xmlWriterRoot = null;
    private String charsetEncoding = "utf-8";

    public static void debug(Document doc) {
        XMLWriter dbg = new XMLWriter(System.out);
        dbg.print(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugToFile(Document doc, String filename) {
        String styleSheet = "../" + filename.substring(0, filename.length() - 3) + "xslt";
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(xmlWriterRoot, filename);
            if (file.exists()) {
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            XMLWriter dbg = new XMLWriter(fileOutputStream);
            dbg.print(doc, styleSheet);
        }
        catch (IOException ioe) {
            log.error("Error: Could not write XML to file: " + filename + " in directory: " + xmlWriterRoot);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException ioe) {
                log.error("Cannot write Document file", (Throwable)ioe);
            }
        }
    }

    public static void saveAsFile(Document doc, String filename) {
        try {
            File file = new File(filename);
            if (file.exists()) {
                file.delete();
            }
            DOMSource domSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer trf = transformerFactory.newTransformer();
            trf.transform(domSource, streamResult);
        }
        catch (Exception ex) {
            log.error("Error: Could not write XML to file: " + filename);
        }
    }

    public static void setXmlWriterDebugPath(String path) {
        xmlWriterRoot = path;
    }

    public XMLWriter(Writer writer, String charsetEncoding) {
        this.out = new PrintWriter(writer);
        if (charsetEncoding != null) {
            this.charsetEncoding = charsetEncoding;
        }
        this.canonical = false;
    }

    public XMLWriter(OutputStream outStream, String charsetEncoding) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outStream, charsetEncoding), charsetEncoding);
    }

    public XMLWriter(OutputStream outStream) {
        try {
            this.charsetEncoding = "utf-8";
            this.out = new PrintWriter(new OutputStreamWriter(outStream, this.charsetEncoding));
            this.canonical = false;
        }
        catch (UnsupportedEncodingException e) {
            log.error("The encoding \"" + this.charsetEncoding + "\" is not supported!", (Throwable)e);
        }
    }

    public int print(Node node, int level) {
        if (node == null) {
            return 0;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.print(((Document)node).getDocumentElement(), 0);
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int len = children.getLength();
                    if (len > 0 && children.item(0).getNodeType() != 3) {
                        this.out.println('>');
                    } else {
                        this.out.print('>');
                    }
                    int prevType = 0;
                    for (int i = 0; i < len; ++i) {
                        if (i > 0 || children.item(i).getNodeType() != 3) {
                            for (int s = 0; s < level; ++s) {
                                this.out.print(" ");
                            }
                        }
                        prevType = this.print(children.item(i), level + 1);
                    }
                    if (len > 0 && prevType != 3) {
                        for (int s = 1; s < level; ++s) {
                            this.out.print(" ");
                        }
                    }
                    this.out.print("</");
                    this.out.print(node.getNodeName());
                    this.out.println('>');
                    break;
                }
                this.out.println("/>");
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i), level + 1);
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (!this.canonical) {
                    this.out.print("<![CDATA[");
                    this.out.print(node.getNodeValue());
                    this.out.println("]]>");
                    break;
                }
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.println("?>");
                break;
            }
        }
        this.out.flush();
        return type;
    }

    public void print(Document doc) {
        this.print(doc, null);
    }

    public void print(Document doc, String styleSheet) {
        if (!this.canonical) {
            this.out.println("<?xml version=\"1.0\" encoding=\"" + this.charsetEncoding + "\"?>");
        }
        if (styleSheet != null) {
            this.out.print("<?xml-stylesheet type=\"text/xsl\" href=\"");
            this.out.print(styleSheet);
            this.out.println("\"?>");
        }
        this.print(doc.getDocumentElement(), 0);
        this.out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    protected String normalize(String s) {
        return XMLWriter.normalize(s, this.canonical);
    }

    public static String normalize(String s, boolean canonical) {
        StringBuilder str = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        continue block7;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

