/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.postgresql;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.expr.compare.DBCompareExpr;

public class PostgresAtAt
extends DBCompareExpr {
    private final DBColumnExpr left;
    private final DBColumnExpr right;

    public PostgresAtAt(DBColumnExpr left, DBColumnExpr right) {
        this.left = left;
        this.right = right;
    }

    public DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    @Override
    public void prepareCommand(DBCommand cmd) {
    }

    @Override
    public DBCompareExpr copy(DBCommand newCmd) {
        return new PostgresAtAt(this.left, this.right);
    }

    @Override
    public boolean isMutuallyExclusive(DBCompareExpr other) {
        if (ObjectUtils.isWrapper(other)) {
            other = ObjectUtils.unwrap(other);
        }
        if (other instanceof PostgresAtAt) {
            PostgresAtAt otherAtAt = (PostgresAtAt)other;
            return this.left.equals(otherAtAt.left) && this.right.equals(otherAtAt.right);
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        this.left.addSQL(buf, context);
        buf.append(" @@ ");
        this.right.addSQL(buf, context);
    }
}

