/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.postgresql;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.dbms.postgresql.PostgresAtAt;
import org.apache.empire.dbms.postgresql.PostgresBoolAndOrExpr;
import org.apache.empire.dbms.postgresql.PostgresExtractField;
import org.apache.empire.dbms.postgresql.PostgresFuncExpr;
import org.apache.empire.dbms.postgresql.PostgresSqlPhrase;

public class DBCommandPostgres
extends DBCommand {
    protected int limit = -1;
    protected int skip = -1;

    public DBCommandPostgres(boolean autoPrepareStmt) {
        super(autoPrepareStmt);
    }

    public DBColumnExpr pgAge(DBColumnExpr expr) {
        return new PostgresFuncExpr(expr, PostgresSqlPhrase.AGE, null, DataType.INTEGER);
    }

    public DBColumnExpr pgAge(DBColumnExpr expr1, DBColumnExpr expr2) {
        return new PostgresFuncExpr(expr1, PostgresSqlPhrase.AGE_BETWEEN, new Object[]{expr2}, DataType.INTEGER);
    }

    public DBColumnExpr pgExtract(PostgresExtractField field, DBColumnExpr expr) {
        return new PostgresFuncExpr(expr, PostgresSqlPhrase.EXTRACT, new Object[]{field.name()}, DataType.INTEGER);
    }

    public DBColumnExpr pgToTsquery(DBColumnExpr expr) {
        return new PostgresFuncExpr(expr, PostgresSqlPhrase.TO_TSQUERY, null, DataType.UNKNOWN);
    }

    public DBColumnExpr pgToTsvector(DBColumnExpr expr) {
        return new PostgresFuncExpr(expr, PostgresSqlPhrase.TO_TSVECTOR, null, DataType.UNKNOWN);
    }

    public DBColumnExpr pgPlaintoTsquery(DBColumnExpr expr) {
        return new PostgresFuncExpr(expr, PostgresSqlPhrase.PLAINTO_TSQUERY, null, DataType.UNKNOWN);
    }

    public DBColumnExpr pgBoolAnd(DBCompareExpr cmpExpr) {
        return new PostgresBoolAndOrExpr(cmpExpr, false);
    }

    public DBColumnExpr pgBoolOr(DBCompareExpr cmpExpr) {
        return new PostgresBoolAndOrExpr(cmpExpr, true);
    }

    public PostgresAtAt pgCompareAtAt(DBColumnExpr left, DBColumnExpr right) {
        return new PostgresAtAt(left, right);
    }

    @Override
    public DBCommand limitRows(int numRows) {
        this.limit = numRows;
        return this;
    }

    @Override
    public DBCommand skipRows(int numRows) {
        this.skip = numRows;
        return this;
    }

    @Override
    public void clearLimit() {
        this.limit = -1;
        this.skip = -1;
    }

    @Override
    public void getSelect(StringBuilder buf) {
        super.getSelect(buf);
        if (this.limit >= 0) {
            buf.append("\r\nLIMIT ");
            buf.append(String.valueOf(this.limit));
            if (this.skip >= 0) {
                buf.append(" OFFSET ");
                buf.append(String.valueOf(this.skip));
            }
        }
    }

    @Override
    protected void addUpdateWithJoins(StringBuilder buf, DBRowSet table) {
        DBColumn[] keyColumns = table.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(table);
        }
        table.addSQL(buf, 1L);
        buf.append(" t0");
        long context = 7L;
        buf.append("\r\nSET ");
        this.addListExpr(buf, this.set, context, ", ");
        this.addFrom(buf);
        buf.append("\r\nWHERE");
        for (DBColumn col : keyColumns) {
            buf.append(" t0.");
            col.addSQL(buf, 1L);
            buf.append("=");
            buf.append(table.getAlias());
            buf.append(".");
            col.addSQL(buf, 1L);
        }
        if (this.where != null && !this.where.isEmpty()) {
            buf.append("\r\n  AND ");
            this.addListExpr(buf, this.where, context, " AND ");
        }
    }
}

