/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.oracle;

import java.util.ArrayList;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;

public class DBCommandOracle
extends DBCommand {
    protected DBCompareExpr connectBy = null;
    protected DBCompareExpr startWith = null;
    protected String optimizerHint = null;
    protected int limitRows = -1;
    protected int skipRows = 0;

    public DBCommandOracle(boolean autoPrepareStmt) {
        super(autoPrepareStmt);
    }

    public String getOptimizerHint() {
        return this.optimizerHint;
    }

    public void setOptimizerHint(String optimizerHint) {
        this.optimizerHint = optimizerHint;
    }

    public void setOptimizerIndexHint(DBIndex index) {
        if (index == null || index.getTable() == null) {
            throw new InvalidArgumentException("index", index);
        }
        String tableAlias = index.getTable().getAlias();
        String indexName = index.getName();
        String indexHint = "INDEX (" + tableAlias + " " + indexName + ")";
        this.optimizerHint = StringUtils.isNotEmpty(this.optimizerHint) && this.optimizerHint.indexOf(indexHint) < 0 ? this.optimizerHint + " " + indexHint : indexHint;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearConnectBy();
        this.optimizerHint = null;
    }

    public void clearConnectBy() {
        this.startWith = null;
        this.connectBy = null;
    }

    public void connectByPrior(DBCompareExpr expr) {
        this.connectBy = expr;
    }

    public void startWith(DBCompareExpr expr) {
        this.startWith = expr;
    }

    @Override
    public DBCommandOracle limitRows(int limitRows) {
        this.limitRows = limitRows;
        return this;
    }

    @Override
    public DBCommandOracle skipRows(int skipRows) {
        if (skipRows < 0) {
            throw new InvalidArgumentException("skipRows", skipRows);
        }
        this.skipRows = skipRows;
        return this;
    }

    @Override
    public void clearLimit() {
        this.limitRows = -1;
        this.skipRows = 0;
    }

    @Override
    public synchronized void getSelect(StringBuilder buf) {
        this.resetParamUsage();
        if (this.select == null) {
            throw new ObjectNotValidException(this);
        }
        boolean usePreparedStatements = this.isPreparedStatementsEnabled();
        if (this.limitRows >= 0) {
            buf.append("SELECT * FROM (");
            if (this.skipRows > 0) {
                buf.append("SELECT row_.*, rownum rownum_ FROM (");
            }
        }
        buf.append("SELECT ");
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        if (this.selectDistinct) {
            buf.append("DISTINCT ");
        }
        this.addListExpr(buf, this.select, 15L, ", ");
        this.addFrom(buf);
        this.addWhere(buf);
        if (this.connectBy != null) {
            buf.append("\r\nCONNECT BY PRIOR ");
            this.connectBy.addSQL(buf, 23L);
            if (this.startWith != null) {
                buf.append("\r\nSTART WITH ");
                this.startWith.addSQL(buf, 7L);
            }
        }
        this.addGrouping(buf);
        if (this.orderBy != null) {
            if (this.connectBy != null) {
                buf.append("\r\nORDER SIBLINGS BY ");
            } else {
                buf.append("\r\nORDER BY ");
            }
            this.addListExpr(buf, this.orderBy, 7L, ", ");
        }
        if (this.limitRows >= 0) {
            buf.append(") row_ WHERE rownum<=");
            buf.append(usePreparedStatements ? "?" : String.valueOf(this.skipRows + this.limitRows));
            if (this.skipRows > 0) {
                buf.append(") WHERE rownum_>");
                buf.append(usePreparedStatements ? "?" : String.valueOf(this.skipRows));
            }
        }
        this.completeParamUsage();
    }

    @Override
    public Object[] getParamValues() {
        Object[] params = super.getParamValues();
        if (this.limitRows < 0 || !this.isPreparedStatementsEnabled()) {
            return params;
        }
        int newSize = (params != null ? params.length : 0) + (this.skipRows > 0 ? 2 : 1);
        Object[] newParams = new Object[newSize];
        for (int i = 0; params != null && i < params.length; ++i) {
            newParams[i] = params[i];
        }
        if (this.skipRows > 0) {
            newParams[--newSize] = this.skipRows;
        }
        newParams[--newSize] = this.skipRows + this.limitRows;
        return newParams;
    }

    @Override
    protected void addUpdateForTable(StringBuilder buf, DBRowSet table) {
        long context = 2L;
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
            if (this.optimizerHint.contains(table.getAlias())) {
                context |= 8L;
            }
        }
        table.addSQL(buf, context);
        context = 5L;
        buf.append("\r\nSET ");
        this.addListExpr(buf, this.set, context, ", ");
        this.addWhere(buf, context);
    }

    @Override
    protected void addUpdateWithJoins(StringBuilder buf, DBRowSet table) {
        DBColumn[] keyColumns = table.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(table);
        }
        buf.setLength(0);
        buf.append("MERGE INTO ");
        table.addSQL(buf, 10L);
        buf.append("\r\nUSING (");
        ArrayList<DBColumnExpr> using = new ArrayList<DBColumnExpr>();
        for (DBColumn col : keyColumns) {
            using.add(col);
        }
        ArrayList<DBSetExpr> mergeSet = new ArrayList<DBSetExpr>(this.set.size());
        for (DBSetExpr sex : this.set) {
            Object val = sex.getValue();
            if (val instanceof DBColumnExpr) {
                DBColumnExpr expr = (DBColumnExpr)val;
                if (!(expr instanceof DBColumn) && !(expr instanceof DBAliasExpr)) {
                    String name = "COL_" + String.valueOf(mergeSet.size());
                    expr = expr.as(name);
                }
                using.add(expr);
                DBValueExpr NAME_EXPR = this.getDatabase().getValueExpr("q0." + expr.getName(), DataType.UNKNOWN);
                mergeSet.add(sex.getColumn().to(NAME_EXPR));
                continue;
            }
            mergeSet.add(sex);
        }
        buf.append("SELECT ");
        this.addListExpr(buf, using, 15L, ", ");
        this.addFrom(buf);
        this.addWhere(buf);
        this.addGrouping(buf);
        buf.append(") q0\r\nON (");
        for (DBColumn col : keyColumns) {
            buf.append(" q0.");
            col.addSQL(buf, 1L);
            buf.append("=");
            buf.append(table.getAlias());
            buf.append(".");
            col.addSQL(buf, 1L);
        }
        buf.append(")\r\nWHEN MATCHED THEN UPDATE ");
        buf.append("\r\nSET ");
        this.addListExpr(buf, mergeSet, 7L, ", ");
    }

    @Override
    protected void addDeleteForTable(StringBuilder buf, DBRowSet table) {
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        super.addDeleteForTable(buf, table);
    }

    @Override
    protected void addDeleteWithJoins(StringBuilder buf, DBRowSet table) {
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        super.addDeleteWithJoins(buf, table);
    }
}

