/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.hsql;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.dbms.hsql.DBMSHandlerHSql;

public class HSqlDDLGenerator
extends DBDDLGenerator<DBMSHandlerHSql> {
    public HSqlDDLGenerator(DBMSHandlerHSql dbms) {
        super(dbms);
        this.databaseObjectName = "SCHEMA";
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_CLOB = "LONGVARCHAR";
        this.DATATYPE_BLOB = "LONGVARBINARY";
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        for (DBTable table : db.getTables()) {
            for (DBColumn dbColumn : table.getColumns()) {
                DBTableColumn c = (DBTableColumn)dbColumn;
                if (c.getDataType() != DataType.AUTOINC) continue;
                this.createSequence(db, c, script);
            }
        }
        super.createDatabase(db, script);
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        super.getDDLScript(type, dbo, script);
        if (type == DBDDLGenerator.DDLActionType.DROP && dbo instanceof DBTable) {
            for (DBColumn c : ((DBTable)dbo).getColumns()) {
                if (c.getDataType() != DataType.AUTOINC || !(c instanceof DBTableColumn)) continue;
                DBTableColumn column = (DBTableColumn)c;
                String seqName = ((DBMSHandlerHSql)this.dbms).getColumnSequenceName(column);
                script.addStmt("DROP SEQUENCE " + seqName);
            }
        }
    }

    protected void createSequence(DBDatabase db, DBTableColumn column, DBSQLScript script) {
        String seqName = ((DBMSHandlerHSql)this.dbms).getColumnSequenceName(column);
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating sequence for column ");
        sql.append(column.toString());
        sql.append(" --\r\n");
        sql.append("CREATE SEQUENCE ");
        db.appendQualifiedName(sql, seqName, null);
        sql.append(" START WITH 1");
        script.addStmt(sql);
    }
}

