/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms;

public enum DBSqlPhrase {
    SQL_NULL("null"),
    SQL_PARAMETER("?"),
    SQL_RENAME_TABLE(" "),
    SQL_RENAME_COLUMN(" AS "),
    SQL_DATABASE_LINK("@"),
    SQL_QUOTES_OPEN("\""),
    SQL_QUOTES_CLOSE("\""),
    SQL_CONCAT_EXPR("+"),
    SQL_PSEUDO_TABLE(""),
    SQL_BOOLEAN_TRUE("1"),
    SQL_BOOLEAN_FALSE("0"),
    SQL_CURRENT_DATE("CURRENT_DATE"),
    SQL_DATE_PATTERN("yyyy-MM-dd"),
    SQL_DATE_TEMPLATE("TO_DATE('{0}', 'YYYY-MM-DD')"),
    SQL_CURRENT_TIME("CURRENT_TIME"),
    SQL_TIME_PATTERN("HH:mm:ss"),
    SQL_TIME_TEMPLATE("'{0}'"),
    SQL_DATETIME_PATTERN("yyyy-MM-dd HH:mm:ss.SSS"),
    SQL_DATETIME_TEMPLATE("TO_DATE('{0}', 'YYYY-MM-DD HH24:MI:SS')"),
    SQL_CURRENT_TIMESTAMP("systimestamp"),
    SQL_TIMESTAMP_PATTERN("yyyy-MM-dd HH:mm:ss.SSS"),
    SQL_TIMESTAMP_TEMPLATE("TO_TIMESTAMP('{0}', 'YYYY.MM.DD HH24:MI:SS.FF')"),
    SQL_FUNC_COALESCE("coalesce(?, {0})"),
    SQL_FUNC_SUBSTRING("substring(?, {0:INTEGER})"),
    SQL_FUNC_SUBSTRINGEX("substring(?, {0:INTEGER}, {1:INTEGER})"),
    SQL_FUNC_REPLACE("replace(?, {0}, {1})"),
    SQL_FUNC_REVERSE("reverse(?)"),
    SQL_FUNC_STRINDEX("charindex({0}, ?)"),
    SQL_FUNC_STRINDEXFROM("charindex({0}, ?, {1:INTEGER})"),
    SQL_FUNC_LENGTH("length(?)"),
    SQL_FUNC_UPPER("upper(?)"),
    SQL_FUNC_LOWER("lower(?)"),
    SQL_FUNC_TRIM("trim(?)"),
    SQL_FUNC_LTRIM("ltrim(?)"),
    SQL_FUNC_RTRIM("rtrim(?)"),
    SQL_FUNC_ESCAPE("? escape {0:VARCHAR}"),
    SQL_FUNC_CONCAT("concat(?)"),
    SQL_FUNC_ABS("abs(?)"),
    SQL_FUNC_ROUND("round(?, {0})"),
    SQL_FUNC_TRUNC("trunc(?, {0})"),
    SQL_FUNC_FLOOR("floor(?)"),
    SQL_FUNC_CEILING("ceiling(?)"),
    SQL_FUNC_MOD("((?) % {0})"),
    SQL_FUNC_FORMAT("format(?, {0:VARCHAR})"),
    SQL_FUNC_DAY("day(?)"),
    SQL_FUNC_MONTH("month(?)"),
    SQL_FUNC_YEAR("year(?)"),
    SQL_FUNC_SUM("sum(?)", true),
    SQL_FUNC_MAX("max(?)", true),
    SQL_FUNC_MIN("min(?)", true),
    SQL_FUNC_AVG("avg(?)", true),
    SQL_FUNC_STRAGG(null),
    SQL_FUNC_DECODE("case ? {0} end"),
    SQL_FUNC_DECODE_SEP(" "),
    SQL_FUNC_DECODE_PART("when {0} then {1}"),
    SQL_FUNC_DECODE_ELSE("else {0}");

    private static final String PREFIX_SQL = "SQL_";
    private static final String PREFIX_FUNC = "FUNC_";
    private final String funcName;
    private final String sqlDefault;
    private final boolean aggregate;

    private DBSqlPhrase(String sqlDefault, boolean aggregate) {
        this.sqlDefault = sqlDefault;
        this.aggregate = aggregate;
        String name = this.name();
        if (name.startsWith(PREFIX_SQL)) {
            name = name.substring(PREFIX_SQL.length());
        }
        if (name.startsWith(PREFIX_FUNC)) {
            name = name.substring(PREFIX_FUNC.length());
        }
        this.funcName = name;
    }

    private DBSqlPhrase(String sqlDefault) {
        this(sqlDefault, false);
    }

    public String getFuncName() {
        return this.funcName;
    }

    public String getSqlDefault() {
        return this.sqlDefault;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }
}

