/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.join;

import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBQuery;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.expr.compare.DBCompareAndOrExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.compare.DBCompareNotExpr;
import org.apache.empire.db.expr.compare.DBCompareParenthesisExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCompareJoinExpr
extends DBColumnJoinExpr {
    private static final Logger log = LoggerFactory.getLogger(DBCompareJoinExpr.class);
    protected final DBCompareExpr cmp;

    private static DBColumnExpr findFirstColumn(DBCompareExpr expr) {
        if (expr instanceof DBCompareParenthesisExpr) {
            return DBCompareJoinExpr.findFirstColumn(((DBCompareParenthesisExpr)expr).unwrap());
        }
        if (expr instanceof DBCompareAndOrExpr) {
            return DBCompareJoinExpr.findFirstColumn(((DBCompareAndOrExpr)expr).getLeft());
        }
        if (expr instanceof DBCompareNotExpr) {
            return DBCompareJoinExpr.findFirstColumn(((DBCompareNotExpr)expr).getExpr());
        }
        if (expr instanceof DBCompareColExpr) {
            return ((DBCompareColExpr)expr).getColumnExpr();
        }
        log.error("Unknown class found for building a valid JOIN Expression");
        return null;
    }

    private static DBColumnExpr firstRsetColumn(DBRowSet rset) {
        if (rset instanceof DBQuery) {
            return ((DBQuery)rset).getQueryColumns()[0];
        }
        return rset.getColumn(0);
    }

    public DBCompareJoinExpr(DBRowSet rset, DBCompareExpr cmp, DBJoinType joinType) {
        super(DBCompareJoinExpr.firstRsetColumn(rset), DBCompareJoinExpr.findFirstColumn(cmp), joinType);
        this.cmp = cmp;
    }

    public DBCompareExpr getJoinConstraint() {
        return this.cmp;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L) != 0L) {
            this.getLeftTable().addSQL(buf, 15L);
        }
        if ((context & 4L) != 0L) {
            switch (this.type) {
                case LEFT: {
                    buf.append(" LEFT JOIN ");
                    break;
                }
                case INNER: {
                    buf.append(" INNER JOIN ");
                    break;
                }
                case RIGHT: {
                    buf.append(" RIGHT JOIN ");
                    break;
                }
                default: {
                    buf.append(" JOIN ");
                }
            }
            this.getRightTable().addSQL(buf, 15L);
            buf.append(" ON ");
            this.cmp.addSQL(buf, 7L);
            if (this.compExpr != null) {
                buf.append(" AND ");
                this.compExpr.addSQL(buf, 7L);
            }
        }
    }
}

