/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.compare;

import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBExistsExpr
extends DBCompareExpr {
    private static final Logger log = LoggerFactory.getLogger(DBExistsExpr.class);
    public final DBCommandExpr cmd;
    public final DBCompareExpr compareExpr;

    public DBExistsExpr(DBCommandExpr cmd) {
        this(cmd, null);
    }

    public DBExistsExpr(DBCommandExpr cmd, DBCompareExpr compareExpr) {
        this.cmd = cmd;
        this.compareExpr = compareExpr;
    }

    public final DBDatabase getDatabase() {
        return this.cmd.getDatabase();
    }

    @Override
    public void prepareCommand(DBCommand cmd) {
        if (this.compareExpr != null) {
            this.compareExpr.prepareCommand(cmd);
        }
    }

    @Override
    public DBCompareExpr copy(DBCommand newCmd) {
        if (this.compareExpr == null) {
            return this;
        }
        return new DBExistsExpr(this.cmd, this.compareExpr.copy(newCmd));
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 4L) == 0L) {
            log.warn("cannot add name only of exits expression");
            return;
        }
        if ((context & 1L) == 0L) {
            log.warn("cannot add value only of exits expression");
            return;
        }
        buf.append(" exists (");
        this.cmd.getSelect(buf);
        if (this.compareExpr != null) {
            if (this.cmd instanceof DBCommand && ((DBCommand)this.cmd).getWhereConstraints() == null) {
                buf.append(" where ");
            } else {
                buf.append(" and ");
            }
            buf.append("(");
            this.compareExpr.addSQL(buf, context);
            buf.append(") ");
        }
        buf.append(") ");
    }

    @Override
    public boolean isMutuallyExclusive(DBCompareExpr other) {
        if (other instanceof DBExistsExpr) {
            DBExistsExpr o = (DBExistsExpr)other;
            if (this.cmd.equals(o.cmd) && this.compareExpr.equals(o.compareExpr)) {
                return true;
            }
        }
        return false;
    }
}

