/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.commons.Unwrappable;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.w3c.dom.Element;

public class DBAliasExpr
extends DBColumnExpr
implements Unwrappable<DBColumnExpr> {
    private final DBColumnExpr expr;
    private final String alias;

    public DBAliasExpr(DBColumnExpr expr, String alias) {
        this.expr = expr.getClass().equals(this.getClass()) ? ((DBAliasExpr)expr).expr : expr;
        this.alias = alias;
    }

    public final DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.expr.getDataType();
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.expr.getEnumType();
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public DBColumn getSourceColumn() {
        return this.expr.getSourceColumn();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.expr.getUpdateColumn();
    }

    @Override
    public boolean isWrapper() {
        return true;
    }

    @Override
    public DBColumnExpr unwrap() {
        return this.expr;
    }

    @Override
    public boolean isAggregate() {
        return this.expr.isAggregate();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBAliasExpr) {
            DBAliasExpr otherExpr = (DBAliasExpr)other;
            return this.alias.equalsIgnoreCase(otherExpr.getName()) && this.expr.equals(otherExpr.expr);
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 8L) != 0L) {
            this.expr.addSQL(buf, context);
            Object dbms = this.getDatabase().getDbms();
            String asExpr = dbms.getSQLPhrase(DBSqlPhrase.SQL_RENAME_COLUMN);
            if (asExpr != null) {
                buf.append(asExpr);
                dbms.appendObjectName(buf, this.alias, null);
            }
        } else {
            this.expr.addSQL(buf, context);
        }
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element field = this.expr.addXml(parent, flags);
        if (field != null) {
            if (field.hasAttribute("name")) {
                field.setAttribute("source", StringUtils.toString(field.getAttribute("name")));
            }
            field.setAttribute("name", this.alias);
        }
        return field;
    }

    @Override
    public String toString() {
        return this.alias;
    }
}

