/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class DBAbstractFuncExpr
extends DBColumnExpr {
    protected static final Logger log = LoggerFactory.getLogger(DBAbstractFuncExpr.class);
    protected final DBColumnExpr expr;
    protected final boolean isAggregate;
    protected final DataType dataType;

    public DBAbstractFuncExpr(DBColumnExpr expr, boolean isAggregate, DataType dataType) {
        this.expr = expr;
        this.isAggregate = isAggregate || expr.isAggregate();
        this.dataType = dataType;
    }

    protected abstract String getFunctionName();

    protected DBMSHandler getDbms() {
        Object db = this.expr.getDatabase();
        if (db == null) {
            throw new InvalidArgumentException("expr", this.expr);
        }
        Object dbms = ((DBDatabase)db).getDbms();
        if (dbms == null) {
            throw new DatabaseNotOpenException((DBDatabase)db);
        }
        return dbms;
    }

    public final DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        String exprName = this.expr.getName();
        String funcName = this.getFunctionName();
        return StringUtils.isNotEmpty(exprName) ? exprName + "_" + funcName : funcName;
    }

    @Override
    public DBColumn getSourceColumn() {
        return this.expr.getSourceColumn();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.expr.getUpdateColumn();
    }

    @Override
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBAbstractFuncExpr) {
            DBAbstractFuncExpr otherFunc = (DBAbstractFuncExpr)other;
            if (!this.expr.equals(otherFunc.expr)) {
                return false;
            }
            String tname = this.getFunctionName();
            String oname = otherFunc.getFunctionName();
            return StringUtils.compareEqual(tname, oname);
        }
        return false;
    }

    public final void addSQL(StringBuilder sql, String template, Object[] params, long context) {
        int end;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                int end2;
                DataType paramDataType = this.expr.getDataType();
                String ph = "{" + String.valueOf(i);
                int idx = template.indexOf(ph);
                if (idx >= 0) {
                    end2 = template.indexOf(125, idx += ph.length());
                    if (end2 < idx) {
                        throw new InvalidArgumentException("template", template);
                    }
                    if (template.charAt(idx) == ':') {
                        String typeName;
                        String string = typeName = end2 >= idx ? template.substring(idx + 1, end2) : null;
                        paramDataType = StringUtils.isNotEmpty(typeName) && !typeName.equals("*") ? DataType.valueOf(typeName) : (typeName.equals("*") || params[i] == null || params[i] instanceof DBExpr ? DataType.UNKNOWN : DataType.fromJavaType(params[i].getClass()));
                    }
                } else {
                    log.info("No placeholder found in template {} for paramter {}", (Object)template, (Object)i);
                    continue;
                }
                ph = ph + template.substring(idx, end2 + 1);
                String paramAsString = this.getObjectValue(paramDataType, params[i], 7L, ",");
                template = StringUtils.replaceAll(template, ph, paramAsString);
            }
        }
        int beg = 0;
        while ((end = template.indexOf("?", beg)) >= 0) {
            sql.append(template.substring(beg, end));
            this.expr.addSQL(sql, context & 0xFFFFFFFFFFFFFFF7L);
            beg = end + 1;
        }
        if (beg < template.length()) {
            sql.append(template.substring(beg));
            if (beg == 0) {
                log.warn("No Placeholder for Column found in function template.");
            }
        }
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        elem.setAttribute("function", this.getFunctionName());
        elem.setAttribute("dataType", this.getDataType().name());
        elem.setAttribute("aggregate", String.valueOf(this.isAggregate));
        DBColumn source = this.getSourceColumn();
        if (source != null) {
            Element elemSource = XMLUtil.addElement(elem, "source");
            source.addXml(elemSource, flags);
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.dataType);
        }
        return elem;
    }
}

