/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.context;

import java.sql.Connection;
import org.apache.empire.db.context.DBContextBase;
import org.apache.empire.db.context.DBRollbackManager;
import org.apache.empire.dbms.DBMSHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBContextStatic
extends DBContextBase {
    private static final Logger log = LoggerFactory.getLogger(DBContextStatic.class);
    private final DBMSHandler dbms;
    private final Connection conn;
    private final boolean closeOnDiscard;
    private boolean enableRollbackHandling = false;
    private boolean autoPrepareStmt = false;
    private static final DBRollbackManager staticRollbackManager = new DBRollbackManager(2, 16);

    public DBContextStatic(DBMSHandler dbmsHandler, Connection conn) {
        this(dbmsHandler, conn, false);
    }

    public DBContextStatic(DBMSHandler dbmsHandler, Connection conn, boolean closeOnDiscard) {
        this.dbms = dbmsHandler;
        this.conn = conn;
        this.closeOnDiscard = closeOnDiscard;
    }

    @Override
    public DBMSHandler getDbms() {
        return this.dbms;
    }

    @Override
    public boolean isPreparedStatementsEnabled() {
        return this.autoPrepareStmt;
    }

    public DBContextStatic setPreparedStatementsEnabled(boolean enabled) {
        this.autoPrepareStmt = enabled;
        log.info("PreparedStatementsEnabled has been set to " + this.autoPrepareStmt);
        return this;
    }

    @Override
    public boolean isRollbackHandlingEnabled() {
        return this.enableRollbackHandling;
    }

    public DBContextStatic setRollbackHandlingEnabled(boolean enabled) {
        this.enableRollbackHandling = enabled;
        log.info("RollbackHandlingEnabled has been set to " + this.enableRollbackHandling);
        return this;
    }

    @Override
    public void discard() {
        super.discard();
        if (this.closeOnDiscard) {
            if (this.enableRollbackHandling) {
                staticRollbackManager.releaseConnection(this.conn, DBRollbackManager.ReleaseAction.Discard);
            }
            this.closeConnection();
        }
    }

    @Override
    protected Connection getConnection(boolean create) {
        return this.conn;
    }

    @Override
    protected DBRollbackManager getRollbackManager(boolean create) {
        return staticRollbackManager;
    }
}

