/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.data.EntityType;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRecordBean;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBUtils;
import org.apache.empire.db.context.DBContextBase;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.db.exceptions.FieldReadOnlyException;
import org.apache.empire.db.exceptions.InvalidKeyException;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.RecordUpdateAmbiguousException;
import org.apache.empire.db.exceptions.RecordUpdateFailedException;
import org.apache.empire.db.expr.column.DBCountExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.list.DBBeanFactoryCache;
import org.apache.empire.db.list.DBBeanListFactory;
import org.apache.empire.db.list.DBBeanListFactoryImpl;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.exceptions.UnspecifiedErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBRowSet
extends DBExpr
implements EntityType {
    protected static final Logger log = LoggerFactory.getLogger(DBRowSet.class);
    protected final DBDatabase db;
    protected String comment = null;
    protected String entityName = null;
    protected DBColumn timestampColumn = null;
    protected Map<DBColumn, DBColumn> columnReferences = null;
    protected List<DBColumn> columns = new ArrayList<DBColumn>();
    protected Class<?> beanType = null;

    protected void checkParamRecord(DBRecordBase record, boolean checkValid) {
        if (record instanceof DBRecordBean && !checkValid) {
            ((DBRecordBean)record).rowset = this;
        }
        if (record == null || record.getRowSet() != this) {
            throw new InvalidArgumentException("record", record);
        }
        if (checkValid && !record.isValid()) {
            throw new ObjectNotValidException(record);
        }
    }

    public static DBColumn[] key(DBColumn ... parts) {
        return parts;
    }

    public DBRowSet(DBDatabase db) {
        this.db = db;
    }

    public String getIdentifier() {
        return this.db.getIdentifier() + "." + this.getName();
    }

    public int hashCode() {
        String nameWithAlias = this.getFullName() + "_" + this.getAlias();
        return nameWithAlias.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.db == null) {
            return super.equals(other);
        }
        if (other instanceof DBRowSet) {
            DBRowSet r = (DBRowSet)other;
            if (!this.db.equals(r.getDatabase())) {
                return false;
            }
            if (this.getAlias() == null) {
                return super.equals(other);
            }
            return StringUtils.compareEqual(this.getAlias(), r.getAlias(), true);
        }
        return false;
    }

    public boolean isSame(DBRowSet other) {
        if (!this.getDatabase().equals(other.getDatabase())) {
            return false;
        }
        return StringUtils.compareEqual(this.getName(), other.getName(), true);
    }

    public abstract String getName();

    public abstract String getAlias();

    public abstract boolean isUpdateable();

    public abstract void createRecord(DBRecordBase var1, Object[] var2, boolean var3);

    public abstract void deleteRecord(Object[] var1, DBContext var2);

    public abstract DBColumn[] getKeyColumns();

    public String getFullName() {
        String name = this.getName();
        String schema = this.db.getSchema();
        return schema != null ? schema + "." + name : name;
    }

    @Override
    public String getEntityName() {
        return StringUtils.coalesce(this.entityName, this.getName());
    }

    protected void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Override
    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.setBeanType(beanType, null);
    }

    public <T> void setBeanType(Class<T> beanType, DBBeanListFactory<T> factory) {
        this.beanType = beanType;
        if (this.entityName == null) {
            this.setEntityName(beanType.getSimpleName().toUpperCase());
        }
        if (factory == null) {
            factory = new DBBeanListFactoryImpl<T>(beanType, this.getKeyColumns(), this.getColumns());
        }
        DBBeanFactoryCache.setFactoryForType(beanType, factory);
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        list.addAll(this.columns);
    }

    public DBDatabase getDatabase() {
        return this.db;
    }

    public List<DBColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public int getColumnIndex(DBColumn column) {
        return this.columns.indexOf(column);
    }

    public int getColumnIndex(ColumnExpr columnExpr) {
        if (columnExpr instanceof DBColumn) {
            return this.getColumnIndex((DBColumn)columnExpr);
        }
        Column source = columnExpr.getSourceColumn();
        if (source instanceof DBColumn) {
            return this.getColumnIndex((DBColumn)source);
        }
        return -1;
    }

    public DBColumn getColumn(int iColumn) {
        if (iColumn < 0 || iColumn >= this.columns.size()) {
            return null;
        }
        return this.columns.get(iColumn);
    }

    public DBColumn getColumn(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            DBColumn col = this.columns.get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    public boolean isColumnReadOnly(DBColumn col) {
        if (this.getColumnIndex(col) < 0) {
            return true;
        }
        if (col.isAutoGenerated() || col == this.timestampColumn) {
            return true;
        }
        return col.isReadOnly();
    }

    public boolean isKeyColumn(DBColumn column) {
        DBColumn[] keyColumns = this.getKeyColumns();
        return ObjectUtils.contains(keyColumns, column);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public DBColumn getTimestampColumn() {
        return this.timestampColumn;
    }

    public void setTimestampColumn(DBColumn timestampColumn) {
        if (timestampColumn != null && timestampColumn.getRowSet() != this) {
            throw new InvalidArgumentException("timestampColumn", timestampColumn);
        }
        if (timestampColumn != null && this.timestampColumn != null && this.timestampColumn != timestampColumn) {
            throw new UnspecifiedErrorException("A Timestamp column has already been set for rowset " + this.getName());
        }
        if (timestampColumn instanceof DBTableColumn) {
            ((DBTableColumn)timestampColumn).setReadOnly(true);
        }
        this.timestampColumn = timestampColumn;
        log.debug("Timestamp column {} has been set for table {}", (Object)timestampColumn.getName(), (Object)this.getName());
    }

    public Map<DBColumn, DBColumn> getColumnReferences() {
        return this.columnReferences;
    }

    protected void addColumnReference(DBColumn source, DBColumn target) {
        if (source.getRowSet() != this) {
            throw new InvalidArgumentException("column", source.getFullName());
        }
        if (this.columnReferences == null) {
            this.columnReferences = new HashMap<DBColumn, DBColumn>();
        }
        this.columnReferences.put(source, target);
    }

    public DBColumnExpr count() {
        return new DBCountExpr(this);
    }

    protected String getRenameTablePhrase() {
        if (this.db == null || this.db.getDbms() == null) {
            return " ";
        }
        return this.db.getDbms().getSQLPhrase(DBSqlPhrase.SQL_RENAME_TABLE);
    }

    protected DBColumnExpr getColumnExprAt(int index) {
        return this.columns.get(index);
    }

    protected void initRecord(DBRecordBase record, Object[] key, FieldInitMode fieldInitMode, boolean newRecord) {
        this.checkParamRecord(record, false);
        this.prepareInitRecord(record, newRecord);
        if (key != null) {
            DBColumn[] keyColumns = this.getKeyColumns();
            if (keyColumns == null) {
                throw new NoPrimaryKeyException(this);
            }
            if (key.length != keyColumns.length) {
                throw new InvalidArgumentException("key", key);
            }
            Object[] fields = record.getFields();
            for (int i = 0; i < keyColumns.length; ++i) {
                if (key[i] == null) continue;
                DBColumn keyColumn = keyColumns[i];
                if (newRecord && keyColumn.isAutoGenerated()) {
                    throw new FieldReadOnlyException(keyColumn);
                }
                int field = this.getColumnIndex(keyColumn);
                fields[field] = key[i];
            }
        }
        if (fieldInitMode != FieldInitMode.NONE) {
            this.initRecordDefaultValues(record, fieldInitMode);
        }
        this.completeInitRecord(record);
    }

    public void initRecord(DBRecordBase record, DBRecordData recData) {
        this.checkParamRecord(record, false);
        this.prepareInitRecord(record, false);
        Object[] fields = record.getFields();
        DBColumn[] keyColumns = this.getKeyColumns();
        for (int i = 0; i < fields.length; ++i) {
            DBColumnExpr column = this.getColumnExprAt(i);
            int rdi = recData.getFieldIndex(column);
            if (rdi < 0) {
                if (keyColumns != null && ObjectUtils.contains(keyColumns, column)) {
                    throw new ItemNotFoundException((Object)column.getName());
                }
                if (this.timestampColumn == column && log.isInfoEnabled()) {
                    log.info(this.getName() + "No record timestamp value has been provided. Hence concurrent changes will not be detected.");
                }
                fields[i] = ObjectUtils.NO_VALUE;
                continue;
            }
            fields[i] = recData.getValue(rdi);
        }
        this.completeInitRecord(record);
    }

    protected void initRecordDefaultValues(DBRecordBase record, FieldInitMode fieldInitMode) {
        if (fieldInitMode == FieldInitMode.NONE) {
            throw new InvalidArgumentException("fieldInitMode", (Object)fieldInitMode);
        }
        Object[] fields = record.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] != null) continue;
            fields[i] = ObjectUtils.NO_VALUE;
        }
    }

    protected void prepareInitRecord(DBRecordBase record, boolean newRecord) {
        if (record == null || record.getRowSet() != this) {
            throw new InvalidArgumentException("rec", record);
        }
        if (this.columns.size() < 1) {
            throw new ObjectNotValidException(this);
        }
        record.initData(newRecord);
    }

    protected void completeInitRecord(DBRecordBase record) {
        record.onRecordChanged();
    }

    protected DBCompareExpr getKeyConstraints(Object[] key) {
        DBColumn[] keyColumns = this.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(this);
        }
        if (key == null || key.length != keyColumns.length) {
            throw new InvalidKeyException(this, key);
        }
        DBCompareExpr compareExpr = keyColumns[0].is(key[0]);
        for (int i = 1; i < key.length; ++i) {
            DBColumn column = keyColumns[i];
            Object value = key[i];
            compareExpr = compareExpr.and(column.is(value));
        }
        return compareExpr;
    }

    protected void readRecord(DBRecordBase record, DBCommand cmd) {
        this.checkParamRecord(record, false);
        try (DBReader reader = null;){
            reader = new DBReader(record.getContext(), false);
            reader.getRecordData(cmd);
            this.initRecord(record, reader);
        }
    }

    public void readRecord(DBRecordBase record, DBCompareExpr whereConstraints) {
        DBRowSet.checkParamNull("whereConstraints", whereConstraints);
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        whereConstraints.addReferencedColumns(columns);
        for (DBColumn c : columns) {
            if (c.getRowSet().equals(this)) continue;
            throw new InvalidArgumentException("whereConstraints", c.getFullName());
        }
        DBCommand cmd = this.createRecordCommand(record.getContext());
        cmd.select(this.getColumns());
        cmd.where(whereConstraints);
        this.readRecord(record, cmd);
    }

    public void readRecord(DBRecordBase record, DBCompareExpr whereConstraints, PartialMode mode, DBColumn ... columns) {
        DBRowSet.checkParamNull("whereConstraints", whereConstraints);
        DBCommand cmd = this.createRecordCommand(record.getContext());
        for (DBColumn column : this.columns) {
            if (this.isKeyColumn(column)) {
                cmd.select((DBColumnExpr)column);
                continue;
            }
            for (int i = 0; i < columns.length; ++i) {
                if (column.equals(columns[i])) {
                    if (mode != PartialMode.INCLUDE) continue;
                    cmd.select((DBColumnExpr)column);
                    continue;
                }
                if (mode != PartialMode.EXCLUDE) continue;
                cmd.select((DBColumnExpr)column);
            }
        }
        cmd.where(whereConstraints);
        this.readRecord(record, cmd);
    }

    public boolean recordExists(Object[] key, DBContext context) {
        DBRowSet.checkParamNull("key", key);
        DBRowSet.checkParamNull("context", context);
        DBCommand cmd = this.createRecordCommand(context);
        cmd.select(this.count());
        cmd.where(this.getKeyConstraints(key));
        return context.getUtils().querySingleInt(cmd, 0) == 1;
    }

    public final boolean recordExists(Object id, DBContext context) {
        return this.recordExists(Record.key(id), context);
    }

    public <R extends DBRecordBase> void updateRecord(R record) {
        int i;
        Object value;
        int i2;
        if (!this.isUpdateable()) {
            throw new NotSupportedException(this, "updateRecord");
        }
        this.checkParamRecord(record, true);
        DBContext context = record.getContext();
        Connection conn = context.getConnection();
        String name = this.getName();
        Timestamp timestamp = this.timestampColumn != null ? context.getDbms().getUpdateTimestamp(conn) : null;
        DBSetRecordKey setGenKey = null;
        Object[] fields = record.getFields();
        DBCommand cmd = this.createRecordCommand(context);
        String sql = null;
        int setCount = 0;
        DBColumn[] keyColumns = this.getKeyColumns();
        DBRecordBase.State recordState = record.getState();
        if (recordState == DBRecordBase.State.New) {
            for (i2 = 0; i2 < this.columns.size(); ++i2) {
                boolean empty;
                value = fields[i2];
                DBTableColumn col = (DBTableColumn)this.columns.get(i2);
                if (this.timestampColumn == col) {
                    if (timestamp == null) continue;
                    cmd.set(col.to(timestamp));
                    continue;
                }
                boolean bl = empty = value == ObjectUtils.NO_VALUE || ObjectUtils.isEmpty(value);
                if (empty && col.isAutoGenerated()) {
                    if (col.getDataType() == DataType.AUTOINC && !this.db.getDbms().isSupported(DBMSFeature.SEQUENCES)) {
                        setGenKey = new DBSetRecordKey(fields, i2);
                        continue;
                    }
                    fields[i2] = value = col.getRecordDefaultValue(conn);
                    empty = ObjectUtils.isEmpty(value);
                }
                if (!empty) {
                    cmd.set(col.to(value));
                    ++setCount;
                    continue;
                }
                if (ObjectUtils.contains(keyColumns, col)) {
                    throw new FieldNotNullException(col);
                }
                if (!col.isRequired()) continue;
                throw new FieldNotNullException(col);
            }
            sql = cmd.getInsert();
        } else if (recordState == DBRecordBase.State.Modified) {
            if (keyColumns == null) {
                log.error("updateRecord: " + name + " no primary key defined!");
                throw new NoPrimaryKeyException(this);
            }
            for (i2 = 0; i2 < this.columns.size(); ++i2) {
                value = fields[i2];
                if (value == ObjectUtils.NO_VALUE) {
                    if (this.timestampColumn != this.columns.get(i2)) continue;
                    log.info("Record has no value for timestamp column. Concurrent changes will not be detected.");
                    continue;
                }
                boolean modified = record.wasModified(i2);
                boolean empty = ObjectUtils.isEmpty(value);
                DBTableColumn col = (DBTableColumn)this.columns.get(i2);
                if (ObjectUtils.contains(keyColumns, col)) {
                    if (modified) {
                        log.warn("updateRecord: " + name + " primary has been modified!");
                    }
                    cmd.where((DBCompareExpr)col.is(value));
                    continue;
                }
                if (this.timestampColumn == col) {
                    if (!empty) {
                        cmd.where((DBCompareExpr)col.is(value));
                    }
                    if (timestamp == null) continue;
                    cmd.set(col.to(timestamp));
                    continue;
                }
                if (!modified) continue;
                if (col.isReadOnly()) {
                    log.warn("updateRecord: Read-only column '" + col.getName() + " has been modified!");
                }
                cmd.set(col.to(value));
                ++setCount;
            }
            sql = cmd.getUpdate();
        } else {
            log.info("updateRecord: " + name + " record has not been modified! ");
            return;
        }
        if (setCount == 0) {
            log.info("updateRecord: " + name + " nothing to update or insert!");
            return;
        }
        DBUtils utils = context.getUtils();
        int affected = utils.executeSQL(sql, cmd.getParamValues(), setGenKey);
        if (affected < 0) {
            throw new UnexpectedReturnValueException(affected, "db.executeSQL()");
        }
        if (affected == 0) {
            throw new RecordUpdateFailedException(this, record.getKey());
        }
        if (affected > 1) {
            throw new RecordUpdateAmbiguousException(this, record.getKey());
        }
        if (this.timestampColumn != null && timestamp != null && (i = record.getFieldIndex(this.timestampColumn)) >= 0) {
            fields[i] = timestamp;
        }
        record.updateComplete();
    }

    public final void deleteRecord(long id, DBContext context) {
        this.deleteRecord(new Object[]{id}, context);
    }

    protected final void deleteAllReferences(Object[] key, DBContext context) {
        List<DBRelation> relations = this.db.getRelations();
        DBColumn[] keyColumns = this.getKeyColumns();
        if (keyColumns == null) {
            return;
        }
        for (DBRelation rel : relations) {
            if (rel.getOnDeleteAction() != DBRelation.DBCascadeAction.CASCADE_RECORDS) continue;
            DBRelation.DBReference[] refs = rel.getReferences();
            for (int i = 0; i < refs.length; ++i) {
                if (!refs[i].getTargetColumn().equals(keyColumns[0])) continue;
                DBRowSet rs = refs[0].getSourceColumn().getRowSet();
                rs.deleteReferenceRecords(refs, key, context);
            }
        }
    }

    protected void deleteReferenceRecords(DBRelation.DBReference[] refs, Object[] parentKey, DBContext context) {
        if (refs.length != parentKey.length) {
            throw new InvalidArgumentException("refs", refs);
        }
        DBColumnExpr[] keyColumns = this.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            DBCommand cmd = this.createRecordCommand(context);
            for (int i = 0; i < parentKey.length; ++i) {
                cmd.where((DBCompareExpr)refs[i].getSourceColumn().is(parentKey[i]));
            }
            if (context.executeDelete((DBTable)this, cmd) < 0) {
                throw new UnexpectedReturnValueException(-1, "db.executeSQL()");
            }
        } else {
            int i;
            DBCommand cmd = this.createRecordCommand(context);
            cmd.select(keyColumns);
            for (i = 0; i < parentKey.length; ++i) {
                cmd.where((DBCompareExpr)refs[i].getSourceColumn().is(parentKey[i]));
            }
            for (i = 0; i < keyColumns.length; ++i) {
                cmd.orderBy(keyColumns[i], true);
            }
            List<Object[]> recKeys = context.getUtils().queryObjectList(cmd);
            for (Object[] recKey : recKeys) {
                log.info("Deleting Record " + StringUtils.valueOf(recKey) + " from table " + this.getName());
                this.deleteRecord(recKey, context);
            }
        }
    }

    protected DBCommand createRecordCommand(DBContext context) {
        if (context instanceof DBContextBase && !((DBContextBase)context).isPreparedStatementsEnabled() && this.getDatabase().isPreparedStatementsEnabled()) {
            return context.getDbms().createCommand(true);
        }
        return context.createCommand();
    }

    protected final Object getRowsetData(DBRecordBase record) {
        return record.rowsetData;
    }

    protected final void setRowsetData(DBRecordBase record, Object rowsetData) {
        record.rowsetData = rowsetData;
    }

    private static class DBSetRecordKey
    implements DBMSHandler.DBSetGenKeys {
        private Object[] fields;
        private int index;

        public DBSetRecordKey(Object[] fields, int index) {
            this.fields = fields;
            this.index = index;
        }

        @Override
        public void set(int rownum, Object value) {
            this.fields[this.index] = value;
        }
    }

    public static enum FieldInitMode {
        NONE,
        SET_DEFAULTS,
        SET_DEFAULTS_DEFERRED;

    }

    public static enum PartialMode {
        INCLUDE,
        EXCLUDE;

    }
}

