/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBQuery;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.compare.DBCompareAndOrExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.compare.DBCompareNotExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBCompareJoinExpr;
import org.apache.empire.db.expr.join.DBCrossJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.db.expr.order.DBOrderByExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.UnspecifiedErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBCommand
extends DBCommandExpr
implements Cloneable {
    protected static final Logger log = LoggerFactory.getLogger(DBCommand.class);
    protected boolean selectDistinct = false;
    protected List<DBColumnExpr> select = null;
    protected List<DBSetExpr> set = null;
    protected List<DBJoinExpr> joins = null;
    protected List<DBCompareExpr> where = null;
    protected List<DBCompareExpr> having = null;
    protected List<DBColumnExpr> groupBy = null;
    protected boolean autoPrepareStmt = false;
    protected List<DBCmdParam> cmdParams = null;
    private int paramUsageCount = 0;

    protected DBCommand(boolean autoPrepareStmt) {
        this.autoPrepareStmt = autoPrepareStmt;
    }

    public final boolean isAutoPrepareStmt() {
        return this.autoPrepareStmt;
    }

    @Override
    public DBCommand clone() {
        DBCommand clone = (DBCommand)super.clone();
        if (this.select != null) {
            clone.select = new ArrayList<DBColumnExpr>(this.select);
        }
        if (this.set != null) {
            clone.set = new ArrayList<DBSetExpr>(this.set);
        }
        if (this.joins != null) {
            clone.joins = new ArrayList<DBJoinExpr>(this.joins);
        }
        if (this.where != null) {
            clone.where = new ArrayList<DBCompareExpr>(this.where);
        }
        if (this.groupBy != null) {
            clone.groupBy = new ArrayList<DBColumnExpr>(this.groupBy);
        }
        if (this.having != null) {
            clone.having = new ArrayList<DBCompareExpr>(this.having);
        }
        if (this.cmdParams != null && !this.cmdParams.isEmpty()) {
            int i;
            clone.paramUsageCount = 0;
            clone.cmdParams = new ArrayList<DBCmdParam>(this.cmdParams.size());
            for (i = 0; clone.set != null && i < clone.set.size(); ++i) {
                clone.set.set(i, clone.set.get(i).copy(clone));
            }
            for (i = 0; clone.where != null && i < clone.where.size(); ++i) {
                clone.where.set(i, clone.where.get(i).copy(clone));
            }
            for (i = 0; clone.having != null && i < clone.having.size(); ++i) {
                clone.having.set(i, clone.having.get(i).copy(clone));
            }
        }
        return clone;
    }

    public final DBDatabase getDatabase() {
        if (this.hasSelectExpr()) {
            return this.select.get(0).getDatabase();
        }
        if (this.hasSetExpr()) {
            return this.set.get(0).getDatabase();
        }
        if (this.where != null && !this.where.isEmpty()) {
            return this.where.get(0).getDatabase();
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            return ((DBOrderByExpr)this.orderBy.get(0)).getDatabase();
        }
        throw new ObjectNotValidException(this);
    }

    protected void resetParamUsage() {
        this.paramUsageCount = 0;
        if (this.cmdParams == null) {
            return;
        }
        for (int i = this.cmdParams.size() - 1; i >= 0; --i) {
            if (this.cmdParams.get(i).getCmd() == this) continue;
            this.cmdParams.remove(i);
        }
    }

    protected void completeParamUsage() {
        if (this.cmdParams == null) {
            return;
        }
        if (this.paramUsageCount < this.cmdParams.size()) {
            log.warn("DBCommand has {} unused Command params", (Object)(this.cmdParams.size() - this.paramUsageCount));
            for (int i = this.cmdParams.size() - 1; i >= this.paramUsageCount; --i) {
                if (this.cmdParams.get(i).getCmd() == this) continue;
                this.cmdParams.remove(i);
            }
        }
    }

    protected void notifyParamUsage(DBCmdParam param) {
        int index = this.cmdParams.indexOf(param);
        if (index < 0) {
            throw new UnspecifiedErrorException("The CmdParam has not been found on this Command.");
        }
        if (index < this.paramUsageCount) {
            log.debug("The DBCmdParam already been used. Adding a temporary copy");
            this.cmdParams.add(this.paramUsageCount, new DBCmdParam(null, param.getDataType(), param.getValue()));
        } else if (index > this.paramUsageCount) {
            this.cmdParams.remove(index);
            this.cmdParams.add(this.paramUsageCount, param);
        }
        ++this.paramUsageCount;
    }

    protected void removeCommandParams(DBCompareExpr cmpExpr) {
        if (this.cmdParams == null) {
            return;
        }
        if (cmpExpr instanceof DBCompareColExpr) {
            DBCompareColExpr cmp = (DBCompareColExpr)cmpExpr;
            if (cmp.getValue() instanceof DBCmdParam) {
                this.cmdParams.remove(cmp.getValue());
            }
        } else if (cmpExpr instanceof DBCompareAndOrExpr) {
            this.removeCommandParams(((DBCompareAndOrExpr)cmpExpr).getLeft());
            this.removeCommandParams(((DBCompareAndOrExpr)cmpExpr).getRight());
        } else if (cmpExpr instanceof DBCompareNotExpr) {
            this.removeCommandParams(((DBCompareNotExpr)cmpExpr).getExpr());
        } else if (ObjectUtils.isWrapper(cmpExpr)) {
            this.removeCommandParams(ObjectUtils.unwrap(cmpExpr));
        }
    }

    protected void removeAllCommandParams(List<DBCompareExpr> list) {
        if (this.cmdParams == null) {
            return;
        }
        for (DBCompareExpr cmp : list) {
            this.removeCommandParams(cmp);
        }
    }

    @Override
    public boolean isValid() {
        return this.hasSelectExpr() || this.hasSetExpr();
    }

    public DBCommand selectDistinct() {
        this.selectDistinct = true;
        return this;
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    public boolean hasSelectExpr() {
        return this.select != null && !this.select.isEmpty();
    }

    @Override
    public boolean hasSelectExpr(DBColumnExpr expr) {
        return this.select != null ? this.select.indexOf(expr) >= 0 : false;
    }

    @Override
    public DataType getDataType() {
        if (this.select == null || this.select.size() != 1) {
            return DataType.UNKNOWN;
        }
        return this.select.get(0).getDataType();
    }

    public DBCommand select(DBColumnExpr expr) {
        if (this.select == null) {
            this.select = new ArrayList<DBColumnExpr>();
        }
        if (expr != null && !this.select.contains(expr)) {
            this.select.add(expr);
        }
        return this;
    }

    public final DBCommand select(DBColumnExpr ... exprs) {
        for (DBColumnExpr expr : exprs) {
            this.select(expr);
        }
        return this;
    }

    public final DBCommand select(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.select(dBColumnExpr);
        }
        return this;
    }

    public DBCommand selectQualified(DBColumnExpr ... columns) {
        for (DBColumnExpr col : columns) {
            this.select(col.qualified());
        }
        return this;
    }

    public final DBCommand selectQualified(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.select(dBColumnExpr.qualified());
        }
        return this;
    }

    public DBCommand qualifyAll() {
        if (this.select == null) {
            return this;
        }
        for (int i = 0; i < this.select.size(); ++i) {
            DBColumnExpr expr = this.select.get(i);
            if (expr instanceof DBColumn || expr instanceof DBAliasExpr) continue;
            this.select.set(i, expr.qualified());
        }
        return this;
    }

    @Override
    public DBColumnExpr[] getSelectExprList() {
        int count;
        int n = count = this.select != null ? this.select.size() : 0;
        if (count < 1) {
            return null;
        }
        DBColumnExpr[] exprList = new DBColumnExpr[count];
        for (int i = 0; i < count; ++i) {
            exprList[i] = this.select.get(i);
        }
        return exprList;
    }

    @Override
    public List<DBColumnExpr> getSelectExpressions() {
        return this.select != null ? Collections.unmodifiableList(this.select) : null;
    }

    public void replaceSelect(DBColumnExpr replExpr, DBColumnExpr replWith) {
        int idx;
        int n = idx = this.select != null ? this.select.indexOf(replExpr) : -1;
        if (idx < 0) {
            throw new ItemNotFoundException(replExpr);
        }
        if (replWith != null) {
            this.select.set(idx, replWith);
        } else {
            this.select.remove(idx);
        }
    }

    public void removeSelect(DBColumnExpr ... exprs) {
        if (this.select == null) {
            return;
        }
        for (int i = 0; i < exprs.length; ++i) {
            int idx = this.select.indexOf(exprs[i]);
            if (idx < 0) continue;
            this.select.remove(idx);
        }
    }

    public boolean hasAggegation() {
        for (DBColumnExpr expr : this.select) {
            if (!expr.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public DBCommand set(DBSetExpr expr) {
        if (this.set == null) {
            this.set = new ArrayList<DBSetExpr>();
        }
        for (int i = 0; i < this.set.size(); ++i) {
            DBSetExpr chk = this.set.get(i);
            if (!chk.column.equals(expr.column)) continue;
            if (this.useCmdParam(expr.column, expr.value)) {
                if (chk.value instanceof DBCmdParam) {
                    ((DBCmdParam)chk.value).setValue(expr.value);
                    expr.value = chk.value;
                    chk.value = null;
                } else {
                    expr.value = this.addParam(expr.column.getDataType(), expr.value);
                }
            } else if (this.cmdParams != null && chk.value instanceof DBCmdParam) {
                this.cmdParams.remove(chk.value);
            }
            this.set.set(i, expr);
            return this;
        }
        if (this.useCmdParam(expr.column, expr.value)) {
            expr.value = this.addParam(expr.column.getDataType(), expr.value);
        }
        this.set.add(expr);
        return this;
    }

    public final DBCommand set(DBSetExpr ... exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.set(exprs[i]);
        }
        return this;
    }

    public boolean hasSetExpr() {
        return this.set != null ? !this.set.isEmpty() : false;
    }

    protected boolean hasSetExprOn(DBColumn column) {
        if (this.set == null) {
            return false;
        }
        for (DBSetExpr setExpr : this.set) {
            if (!setExpr.column.equals(column)) continue;
            return true;
        }
        return false;
    }

    public List<DBSetExpr> getSetExpressions() {
        return this.set != null ? Collections.unmodifiableList(this.set) : null;
    }

    public DBCmdParam addParam(DataType type, Object value) {
        if (this.cmdParams == null) {
            this.cmdParams = new ArrayList<DBCmdParam>();
        }
        DBCmdParam param = new DBCmdParam(this, type, value);
        this.cmdParams.add(param);
        return param;
    }

    public final DBCmdParam addParam(DBColumnExpr colExpr, Object value) {
        return this.addParam(colExpr.getDataType(), value);
    }

    public final DBCmdParam addParam(Object value) {
        return this.addParam(DataType.UNKNOWN, value);
    }

    public final DBCmdParam addParam() {
        return this.addParam(DataType.UNKNOWN, null);
    }

    public DBCommand join(DBJoinExpr join) {
        if (join.getLeftTable().equals(join.getRightTable())) {
            throw new InvalidArgumentException("left|right", join.getLeftTable());
        }
        if (this.joins == null) {
            this.joins = new ArrayList<DBJoinExpr>();
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            DBJoinExpr item = this.joins.get(i);
            if (!item.equals(join)) continue;
            return this;
        }
        this.joins.add(join);
        return this;
    }

    public final DBCommand join(DBColumnExpr left, DBColumn right, DBCompareExpr ... addlConstraints) {
        return this.join(left, right, DBJoinType.INNER, addlConstraints);
    }

    public final DBCommand joinLeft(DBColumnExpr left, DBColumn right, DBCompareExpr ... addlConstraints) {
        return this.join(left, right, DBJoinType.LEFT, addlConstraints);
    }

    public final DBCommand joinRight(DBColumnExpr left, DBColumn right, DBCompareExpr ... addlConstraints) {
        return this.join(left, right, DBJoinType.RIGHT, addlConstraints);
    }

    public final DBCommand join(DBColumnExpr left, DBColumn right, DBJoinType joinType, DBCompareExpr ... addlConstraints) {
        if (left == null || right == null || left.getSourceColumn() == null) {
            throw new InvalidArgumentException("left|right", left);
        }
        if (left.getSourceColumn().getRowSet() == right.getRowSet()) {
            throw new InvalidArgumentException("rowset", left.getSourceColumn().getRowSet().getName() + "|" + right.getRowSet().getName());
        }
        DBColumnJoinExpr join = new DBColumnJoinExpr(left, right, joinType);
        DBCompareExpr where = null;
        for (int i = 0; i < addlConstraints.length; ++i) {
            DBCompareExpr cmpExpr = addlConstraints[i];
            if (this.isPreparedStatementsEnabled()) {
                cmpExpr.prepareCommand(this);
            }
            where = where != null ? where.and(cmpExpr) : cmpExpr;
        }
        if (where != null) {
            join.where(where);
        }
        this.join(join);
        return this;
    }

    public final DBCommand join(DBColumn[] left, DBColumn[] right, DBJoinType joinType, DBCompareExpr ... addlConstraints) {
        DBCompareExpr cmpExpr;
        int i;
        if (left == null || right == null || left.length == 0 || left.length != right.length) {
            throw new InvalidArgumentException("left|right", left);
        }
        if (left[0].getRowSet() == right[0].getRowSet()) {
            throw new InvalidArgumentException("rowset", left[0].getSourceColumn().getRowSet().getName() + "|" + right[0].getRowSet().getName());
        }
        DBColumnJoinExpr join = new DBColumnJoinExpr(left[0], right[0], joinType);
        DBCompareExpr where = null;
        for (i = 1; i < left.length; ++i) {
            cmpExpr = right[i].is(left[i]);
            if (this.isPreparedStatementsEnabled()) {
                cmpExpr.prepareCommand(this);
            }
            where = where != null ? where.and(cmpExpr) : cmpExpr;
        }
        for (i = 0; i < addlConstraints.length; ++i) {
            cmpExpr = addlConstraints[i];
            if (this.isPreparedStatementsEnabled()) {
                cmpExpr.prepareCommand(this);
            }
            where = where != null ? where.and(cmpExpr) : cmpExpr;
        }
        if (where != null) {
            join.where(where);
        }
        this.join(join);
        return this;
    }

    public final DBCommand join(DBRowSet left, DBRowSet right) {
        DBCrossJoinExpr join = new DBCrossJoinExpr(left, right);
        this.join(join);
        return this;
    }

    public final DBCommand join(DBRowSet rowset, DBCompareExpr cmp, DBJoinType joinType) {
        DBCompareJoinExpr join = new DBCompareJoinExpr(rowset, cmp, joinType);
        this.join(join);
        return this;
    }

    public final DBCommand join(DBRowSet rowset, DBCompareExpr cmp) {
        return this.join(rowset, cmp, DBJoinType.INNER);
    }

    public void addJoins(List<DBJoinExpr> joinExprList) {
        if (this.joins == null) {
            this.joins = new ArrayList<DBJoinExpr>();
        }
        this.joins.addAll(joinExprList);
    }

    public boolean hasJoinOn(DBRowSet rowset) {
        if (this.joins == null) {
            return false;
        }
        for (DBJoinExpr join : this.joins) {
            if (!join.isJoinOn(rowset)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConstraintOn(DBRowSet rowset) {
        if (this.where == null && this.having == null) {
            return false;
        }
        int i = 0;
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        for (i = 0; this.where != null && i < this.where.size(); ++i) {
            ((DBExpr)this.where.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.having != null && i < this.having.size(); ++i) {
            ((DBExpr)this.having.get(i)).addReferencedColumns(columns);
        }
        for (DBColumn col : columns) {
            DBRowSet table = col.getRowSet();
            if (!table.equals(rowset)) continue;
            return true;
        }
        return false;
    }

    public boolean hasJoinOn(DBColumn column) {
        if (this.joins == null) {
            return false;
        }
        for (DBJoinExpr join : this.joins) {
            if (!join.isJoinOn(column)) continue;
            return true;
        }
        return false;
    }

    public boolean removeJoinsOn(DBRowSet rowset) {
        if (this.joins == null) {
            return false;
        }
        int size = this.joins.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!this.joins.get(i).isJoinOn(rowset)) continue;
            this.joins.remove(i);
        }
        return size != this.joins.size();
    }

    public boolean removeJoinsOn(DBColumn column) {
        if (this.joins == null) {
            return false;
        }
        int size = this.joins.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!this.joins.get(i).isJoinOn(column)) continue;
            this.joins.remove(i);
        }
        return size != this.joins.size();
    }

    public DBCommand where(DBCompareExpr expr) {
        if (this.where == null) {
            this.where = new ArrayList<DBCompareExpr>();
        }
        this.setConstraint(this.where, expr);
        return this;
    }

    public final DBCommand where(DBCompareExpr ... exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.where(exprs[i]);
        }
        return this;
    }

    public boolean hasWhereConstraints() {
        return this.where != null && this.where.size() > 0;
    }

    public List<DBCompareExpr> getWhereConstraints() {
        return this.where != null ? Collections.unmodifiableList(this.where) : null;
    }

    public void removeWhereConstraint(DBCompareExpr cmpExpr) {
        if (this.where == null) {
            return;
        }
        this.removeConstraint(this.where, cmpExpr);
    }

    public void removeWhereConstraintOn(DBColumnExpr col) {
        if (this.where == null) {
            return;
        }
        this.removeConstraintOn(this.where, col);
    }

    public boolean hasWhereConstraintOn(DBColumnExpr col) {
        if (this.where == null) {
            return false;
        }
        return this.hasConstraintOn(this.where, col);
    }

    public List<DBJoinExpr> getJoins() {
        return this.joins != null ? Collections.unmodifiableList(this.joins) : null;
    }

    public void addWhereConstraints(List<DBCompareExpr> constraints) {
        if (this.where == null) {
            this.where = new ArrayList<DBCompareExpr>();
        }
        this.where.addAll(constraints);
    }

    public DBCommand having(DBCompareExpr expr) {
        if (this.having == null) {
            this.having = new ArrayList<DBCompareExpr>();
        }
        this.setConstraint(this.having, expr);
        return this;
    }

    public boolean hasHavingConstraints() {
        return this.having != null && this.having.size() > 0;
    }

    public List<DBCompareExpr> getHavingConstraints() {
        return this.having != null ? Collections.unmodifiableList(this.having) : null;
    }

    public void removeHavingConstraint(DBCompareExpr cmpExpr) {
        if (this.having == null) {
            return;
        }
        this.removeConstraint(this.having, cmpExpr);
    }

    public void removeHavingConstraintOn(DBColumnExpr col) {
        if (this.having == null) {
            return;
        }
        this.removeConstraintOn(this.having, col);
    }

    public boolean hasHavingConstraintOn(DBColumnExpr col) {
        if (this.where == null) {
            return false;
        }
        return this.hasConstraintOn(this.having, col);
    }

    public boolean hasGroupBy() {
        return this.groupBy != null ? !this.groupBy.isEmpty() : false;
    }

    public List<DBColumnExpr> getGroupBy() {
        return this.groupBy != null ? Collections.unmodifiableList(this.groupBy) : null;
    }

    public DBCommand groupBy(DBColumnExpr columnExpr) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<DBColumnExpr>();
        }
        if (columnExpr.isAggregate()) {
            return this;
        }
        if (columnExpr instanceof DBAliasExpr) {
            columnExpr = ((DBAliasExpr)columnExpr).unwrap();
        }
        if (this.groupBy.contains(columnExpr)) {
            return this;
        }
        this.groupBy.add(columnExpr);
        return this;
    }

    public final DBCommand groupBy(DBColumnExpr ... exprs) {
        for (DBColumnExpr expr : exprs) {
            this.groupBy(expr);
        }
        return this;
    }

    public final DBCommand groupBy(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.groupBy(dBColumnExpr);
        }
        return this;
    }

    public final DBCommand groupAll() {
        this.clearGroupBy();
        if (this.select == null) {
            return this;
        }
        for (DBColumnExpr expr : this.select) {
            if (expr.isAggregate()) continue;
            this.groupBy(expr);
        }
        return this;
    }

    public void clearSelectDistinct() {
        this.selectDistinct = false;
    }

    public void clearSelect() {
        this.select = null;
    }

    public void clearSet() {
        if (this.set != null && this.cmdParams != null) {
            for (DBSetExpr set : this.set) {
                Object value = set.getValue();
                if (!(value instanceof DBCmdParam)) continue;
                this.cmdParams.remove(value);
            }
        }
        this.set = null;
    }

    public void clearJoin() {
        this.joins = null;
    }

    public void clearWhere() {
        this.removeAllCommandParams(this.where);
        this.where = null;
    }

    public void clearHaving() {
        this.removeAllCommandParams(this.having);
        this.having = null;
    }

    public void clearGroupBy() {
        this.groupBy = null;
    }

    @Override
    public DBCommand orderBy(DBOrderByExpr ... exprs) {
        return (DBCommand)super.orderBy(exprs);
    }

    @Override
    public DBCommand orderBy(DBColumnExpr ... exprs) {
        return (DBCommand)super.orderBy(exprs);
    }

    @Override
    public DBCommand orderBy(DBColumnExpr expr, boolean desc) {
        return (DBCommand)super.orderBy(expr, desc);
    }

    @Override
    public DBCommand limitRows(int limitRows) {
        return (DBCommand)super.limitRows(limitRows);
    }

    @Override
    public DBCommand skipRows(int skipRows) {
        return (DBCommand)super.skipRows(skipRows);
    }

    public void clear() {
        this.cmdParams = null;
        this.clearSelectDistinct();
        this.clearSelect();
        this.clearSet();
        this.clearJoin();
        this.clearWhere();
        this.clearHaving();
        this.clearGroupBy();
        this.clearOrderBy();
        this.clearLimit();
        this.resetParamUsage();
    }

    protected boolean isPreparedStatementsEnabled() {
        return this.autoPrepareStmt;
    }

    protected boolean useCmdParam(DBColumnExpr col, Object value) {
        if (value == null || value instanceof DBExpr || value instanceof DBDatabase.DBSystemDate) {
            return false;
        }
        if (this.isPreparedStatementsEnabled()) {
            return true;
        }
        DataType dt = col.getDataType();
        return dt == DataType.BLOB || dt == DataType.CLOB;
    }

    protected void setConstraint(List<DBCompareExpr> list, DBCompareExpr expr) {
        if (this.isPreparedStatementsEnabled()) {
            expr.prepareCommand(this);
        }
        for (int i = 0; i < list.size(); ++i) {
            DBCompareExpr other = list.get(i);
            if (!expr.isMutuallyExclusive(other)) continue;
            this.removeCommandParams(other);
            list.set(i, expr);
            return;
        }
        list.add(expr);
    }

    protected void removeConstraint(List<DBCompareExpr> list, DBCompareExpr cmpExpr) {
        if (list == null) {
            return;
        }
        for (DBCompareExpr cmp : list) {
            if (!cmp.isMutuallyExclusive(cmpExpr)) continue;
            this.removeCommandParams(cmp);
            list.remove(cmp);
            return;
        }
    }

    protected boolean hasConstraintOn(List<DBCompareExpr> list, DBColumnExpr colExpr) {
        if (list == null) {
            return false;
        }
        for (DBCompareExpr cmp : list) {
            if (!(cmp instanceof DBCompareColExpr)) continue;
            DBColumnExpr cmpCol = ((DBCompareColExpr)cmp).getColumnExpr();
            if (ObjectUtils.compareEqual(cmpCol, colExpr)) {
                return true;
            }
            if (!(colExpr instanceof DBColumn) || cmpCol instanceof DBColumn || !colExpr.equals(colExpr.getUpdateColumn())) continue;
            return true;
        }
        return false;
    }

    protected void removeConstraintOn(List<DBCompareExpr> list, DBColumnExpr colExpr) {
        if (list == null) {
            return;
        }
        for (DBCompareExpr cmp : list) {
            if (!(cmp instanceof DBCompareColExpr)) continue;
            DBColumnExpr cmpCol = ((DBCompareColExpr)cmp).getColumnExpr();
            if (ObjectUtils.compareEqual(cmpCol, colExpr)) {
                this.removeCommandParams(cmp);
                list.remove(cmp);
                return;
            }
            if (!(colExpr instanceof DBColumn) || cmpCol instanceof DBColumn || !colExpr.equals(colExpr.getUpdateColumn())) continue;
            this.removeCommandParams(cmp);
            list.remove(cmp);
            return;
        }
    }

    protected List<DBRowSet> getRowSetList() {
        int i = 0;
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        for (i = 0; this.select != null && i < this.select.size(); ++i) {
            ((DBExpr)this.select.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.joins != null && i < this.joins.size(); ++i) {
            ((DBExpr)this.joins.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.where != null && i < this.where.size(); ++i) {
            ((DBExpr)this.where.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.groupBy != null && i < this.groupBy.size(); ++i) {
            ((DBExpr)this.groupBy.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.having != null && i < this.having.size(); ++i) {
            ((DBExpr)this.having.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.orderBy != null && i < this.orderBy.size(); ++i) {
            ((DBExpr)this.orderBy.get(i)).addReferencedColumns(columns);
        }
        ArrayList<DBRowSet> tables = new ArrayList<DBRowSet>();
        for (DBColumn col : columns) {
            DBRowSet table = col.getRowSet();
            if (table == this.cmdQuery) {
                log.error("Recursive Column Selection in Command!");
                continue;
            }
            if (tables.contains(table) || table == null) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public Object[] getParamValues() {
        if (this.cmdParams == null || this.paramUsageCount == 0) {
            return null;
        }
        if (this.paramUsageCount != this.cmdParams.size()) {
            log.info("DBCommand parameter count (" + String.valueOf(this.cmdParams.size()) + ") does not match parameter use count (" + String.valueOf(this.paramUsageCount) + ")");
        }
        Object[] values = new Object[this.paramUsageCount];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.cmdParams.get(i).getValue();
        }
        return values;
    }

    @Override
    public void getSelect(StringBuilder buf) {
        this.resetParamUsage();
        if (this.select == null) {
            throw new ObjectNotValidException(this);
        }
        this.addSelect(buf);
        this.addFrom(buf);
        this.addWhere(buf);
        this.addGrouping(buf);
        this.addOrder(buf);
        this.completeParamUsage();
    }

    public String getInsert() {
        this.resetParamUsage();
        if (this.set == null || this.set.get(0) == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("INSERT INTO ");
        DBRowSet table = this.set.get(0).getTable();
        table.addSQL(buf, 2L);
        buf.append("( ");
        ArrayList<DBCompareColExpr> compexpr = null;
        if (this.where != null && !this.where.isEmpty()) {
            compexpr = new ArrayList<DBCompareColExpr>(this.where.size());
            for (DBCompareExpr expr : this.where) {
                this.appendCompareColExprs(table, expr, compexpr);
            }
            if (compexpr.size() > 0) {
                this.addListExpr(buf, compexpr, 1L, ", ");
                if (this.set != null) {
                    buf.append(", ");
                }
            } else {
                compexpr = null;
            }
        }
        if (this.set != null) {
            this.addListExpr(buf, this.set, 1L, ", ");
        }
        buf.append(") VALUES ( ");
        if (compexpr != null) {
            this.addListExpr(buf, compexpr, 4L, ", ");
        }
        if (compexpr != null && this.set != null) {
            buf.append(", ");
        }
        if (this.set != null) {
            this.addListExpr(buf, this.set, 4L, ", ");
        }
        buf.append(")");
        this.completeParamUsage();
        return buf.toString();
    }

    protected void appendCompareColExprs(DBRowSet table, DBCompareExpr expr, List<DBCompareColExpr> list) {
        if (expr instanceof DBCompareColExpr) {
            DBColumn column = ((DBCompareColExpr)expr).getColumnExpr().getUpdateColumn();
            if (column != null && column.getRowSet().equals(table) && !this.hasSetExprOn(column)) {
                list.add((DBCompareColExpr)expr);
            }
        } else if (expr instanceof DBCompareAndOrExpr) {
            this.appendCompareColExprs(table, ((DBCompareAndOrExpr)expr).getLeft(), list);
            this.appendCompareColExprs(table, ((DBCompareAndOrExpr)expr).getRight(), list);
        } else if (expr instanceof DBCompareNotExpr) {
            this.appendCompareColExprs(table, ((DBCompareNotExpr)expr).getExpr(), list);
        } else if (ObjectUtils.isWrapper(expr)) {
            this.appendCompareColExprs(table, ObjectUtils.unwrap(expr), list);
        }
    }

    public final String getUpdate() {
        this.resetParamUsage();
        if (this.set == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("UPDATE ");
        DBRowSet table = this.set.get(0).getTable();
        if (this.joins != null && !this.joins.isEmpty()) {
            this.addUpdateWithJoins(buf, table);
        } else {
            this.addUpdateForTable(buf, table);
        }
        this.completeParamUsage();
        return buf.toString();
    }

    protected void addUpdateForTable(StringBuilder buf, DBRowSet table) {
        table.addSQL(buf, 2L);
        long context = 5L;
        buf.append("\r\nSET ");
        this.addListExpr(buf, this.set, context, ", ");
        this.addWhere(buf, context);
    }

    protected void addUpdateWithJoins(StringBuilder buf, DBRowSet table) {
        buf.append(table.getAlias());
        long context = 7L;
        buf.append("\r\nSET ");
        this.addListExpr(buf, this.set, context, ", ");
        this.addFrom(buf);
        this.addWhere(buf, context);
    }

    public final String getDelete(DBTable table) {
        this.resetParamUsage();
        StringBuilder buf = new StringBuilder("DELETE ");
        if (this.joins != null && !this.joins.isEmpty()) {
            this.addDeleteWithJoins(buf, table);
        } else {
            this.addDeleteForTable(buf, table);
        }
        this.completeParamUsage();
        return buf.toString();
    }

    protected void addDeleteForTable(StringBuilder buf, DBRowSet table) {
        buf.append("FROM ");
        table.addSQL(buf, 2L);
        this.addWhere(buf, 5L);
    }

    protected void addDeleteWithJoins(StringBuilder buf, DBRowSet table) {
        table.addSQL(buf, 2L);
        this.addFrom(buf);
        this.addWhere(buf, 7L);
    }

    protected void addSelect(StringBuilder buf) {
        buf.append("SELECT ");
        if (this.selectDistinct) {
            buf.append("DISTINCT ");
        }
        this.addListExpr(buf, this.select, 15L, ", ");
    }

    protected void addFrom(StringBuilder buf) {
        int originalLength = buf.length();
        buf.append("\r\nFROM ");
        boolean sep = false;
        int whichParams = 0;
        List<DBRowSet> tables = this.getRowSetList();
        if (this.joins != null && this.joins.size() > 0) {
            ArrayList<DBRowSet> joinTables = new ArrayList<DBRowSet>();
            for (int i = 0; i < this.joins.size(); ++i) {
                long context;
                DBJoinExpr join = this.joins.get(i);
                if (i < 1) {
                    joinTables.add(join.getLeftTable());
                    joinTables.add(join.getRightTable());
                    tables.remove(join.getLeftTable());
                    tables.remove(join.getRightTable());
                    context = 5L;
                    whichParams = 0;
                } else {
                    if (joinTables.contains(join.getRightTable())) {
                        join.reverse();
                    }
                    joinTables.add(join.getRightTable());
                    tables.remove(join.getRightTable());
                    context = 4L;
                    buf.append("\t");
                    whichParams = 1;
                }
                this.addJoin(buf, join, context, whichParams);
                if (i == this.joins.size() - 1) continue;
                buf.append("\r\n");
            }
            sep = true;
        }
        for (int i = 0; i < tables.size(); ++i) {
            if (sep) {
                buf.append(", ");
            }
            DBRowSet t = tables.get(i);
            t.addSQL(buf, 15L);
            if (t instanceof DBQuery) {
                this.mergeSubqueryParams(((DBQuery)t).getCommandExpr().getParamValues());
            }
            sep = true;
        }
        if (!sep) {
            String pseudoTable = this.getDatabase().getDbms().getSQLPhrase(DBSqlPhrase.SQL_PSEUDO_TABLE);
            if (StringUtils.isNotEmpty(pseudoTable)) {
                buf.append(pseudoTable);
            } else {
                buf.setLength(originalLength);
            }
        }
    }

    protected void addJoin(StringBuilder buf, DBJoinExpr join, long context, int whichParams) {
        int paramInsertPos = this.paramUsageCount;
        join.addSQL(buf, context);
        Object[] subQueryParams = join.getSubqueryParams(whichParams);
        if (subQueryParams != null) {
            if (paramInsertPos == this.paramUsageCount) {
                this.mergeSubqueryParams(subQueryParams);
            } else {
                int tempCounter = this.paramUsageCount;
                this.paramUsageCount = paramInsertPos;
                this.mergeSubqueryParams(subQueryParams);
                int insertCount = this.paramUsageCount - paramInsertPos;
                this.paramUsageCount = tempCounter + insertCount;
            }
        }
    }

    protected void mergeSubqueryParams(Object[] subQueryParams) {
        if (subQueryParams == null || subQueryParams.length == 0) {
            return;
        }
        if (this.cmdParams == null) {
            this.cmdParams = new ArrayList<DBCmdParam>(subQueryParams.length);
        }
        for (int p = 0; p < subQueryParams.length; ++p) {
            this.cmdParams.add(this.paramUsageCount++, new DBCmdParam(null, DataType.UNKNOWN, subQueryParams[p]));
        }
    }

    protected void addWhere(StringBuilder buf, long context) {
        if (this.where != null && !this.where.isEmpty()) {
            buf.append("\r\nWHERE ");
            this.addListExpr(buf, this.where, context, " AND ");
        }
    }

    protected final void addWhere(StringBuilder buf) {
        this.addWhere(buf, 7L);
    }

    protected void addGrouping(StringBuilder buf) {
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            buf.append("\r\nGROUP BY ");
            this.addListExpr(buf, this.groupBy, 7L, ", ");
        }
        if (this.having != null && !this.having.isEmpty()) {
            buf.append("\r\nHAVING ");
            this.addListExpr(buf, this.having, 7L, " AND ");
        }
    }

    protected void addOrder(StringBuilder buf) {
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            buf.append("\r\nORDER BY ");
            this.addListExpr(buf, this.orderBy, 7L, ", ");
        }
    }
}

