/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.list;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.RecordData;
import org.apache.empire.data.list.DataListEntry;
import org.apache.empire.data.list.DataListFactory;
import org.apache.empire.data.list.DataListHead;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.UnsupportedTypeException;

public class DataListFactoryImpl<T extends DataListEntry>
implements DataListFactory<T> {
    protected final Constructor<T> constructor;
    protected final DataListHead head;

    protected static <T extends DataListEntry> Constructor<T> findEntryConstructor(Class<?> listEntryClass, Class<? extends DataListHead> listHeadClass) {
        Constructor<?> constructor = ClassUtils.findMatchingConstructor(listEntryClass, 2, listHeadClass, Object[].class, Integer.TYPE);
        if (constructor == null) {
            throw new UnsupportedTypeException(listEntryClass);
        }
        return constructor;
    }

    public DataListFactoryImpl(Constructor<T> constructor, DataListHead head) {
        this.constructor = constructor;
        this.head = head;
    }

    public DataListFactoryImpl(Class<T> listEntryClass, DataListHead head) {
        this(DataListFactoryImpl.findEntryConstructor(listEntryClass, head.getClass()), head);
    }

    @Override
    public void prepareQuery(Object cmd, Object context) {
    }

    @Override
    public List<T> newList(int capacity) {
        return new ArrayList(capacity);
    }

    @Override
    public T newEntry(int rownum, RecordData dataRow) {
        ColumnExpr[] columns = this.head.getColumns();
        if (columns.length != dataRow.getFieldCount()) {
            throw new InvalidArgumentException("dataRow", dataRow);
        }
        Object[] values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            values[i] = dataRow.getValue(i);
        }
        return this.newEntry(rownum, values);
    }

    protected T newEntry(int rownum, Object[] values) {
        try {
            if (this.constructor == null) {
                throw new NotSupportedException(this, "newEntry");
            }
            switch (this.constructor.getParameterCount()) {
                case 3: {
                    return (T)((DataListEntry)this.constructor.newInstance(this.head, values, rownum));
                }
                case 2: {
                    return (T)((DataListEntry)this.constructor.newInstance(this.head, values));
                }
            }
            throw new UnsupportedTypeException(this.constructor.getClass());
        }
        catch (InstantiationException e) {
            throw new InternalException(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public void completeQuery(List<T> list) {
    }
}

