/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.list;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.EntityType;
import org.apache.empire.data.RecordData;
import org.apache.empire.data.list.DataListHead;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataListEntry
implements RecordData,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DataListEntry.class);
    protected final DataListHead head;
    protected final Object[] values;
    protected int rownum;

    public DataListEntry(DataListHead head, Object[] values, int rownum) {
        this.head = head;
        this.values = values;
        this.rownum = rownum;
        int headColumnCount = head.getColumns().length;
        if (values.length != headColumnCount) {
            log.warn("DataListEntry number of values {} do not match number of head columns {}!", (Object)values.length, (Object)headColumnCount);
        }
    }

    public DataListEntry(DataListHead head, Object[] values) {
        this(head, values, -1);
    }

    public <T extends DataListHead> T getHead() {
        return (T)this.head;
    }

    public Object[] getRecordKey(EntityType entityType) {
        Column[] keyColumns = entityType.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(entityType);
        }
        Object[] key = new Object[keyColumns.length];
        for (int i = 0; i < key.length; ++i) {
            key[i] = this.get(keyColumns[i]);
        }
        return key;
    }

    public long getRecordId(EntityType entityType) {
        Column[] keyColumns = entityType.getKeyColumns();
        if (keyColumns == null || keyColumns.length != 1) {
            throw new InvalidArgumentException("entityType", entityType.getEntityName());
        }
        return ObjectUtils.getLong(this.get(keyColumns[0]));
    }

    public boolean compareKey(Column[] keyColumns, Object[] key) {
        for (int i = 0; i < keyColumns.length; ++i) {
            int index = this.getFieldIndex(keyColumns[i]);
            if (index < 0) {
                throw new ItemNotFoundException((Object)keyColumns[i].getName());
            }
            if (ObjectUtils.compareEqual(this.values[index], key[i])) continue;
            return false;
        }
        return true;
    }

    public void updateData(RecordData recData) {
        ColumnExpr[] cols = this.head.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            ColumnExpr col = ObjectUtils.unwrap(cols[i]);
            if (!(col instanceof Column)) {
                log.info("Column expression {} is not a column. Skipping update.", (Object)col.getName());
                continue;
            }
            int ri = recData.getFieldIndex(col);
            if (ri < 0) continue;
            try {
                this.values[i] = recData.getValue(ri);
                continue;
            }
            catch (Exception e) {
                log.error("Failed to update value for column {}", (Object)cols[i].getName());
            }
        }
    }

    public void modifyValue(ColumnExpr col, Object value) {
        int i = this.getFieldIndex(col);
        if (i < 0) {
            throw new ItemNotFoundException(col);
        }
        this.values[i] = value;
    }

    public int getRownum() {
        return this.rownum;
    }

    @Override
    public int getFieldCount() {
        return this.head.columns.length;
    }

    public boolean hasField(ColumnExpr column) {
        return this.head.getColumnIndex(column) >= 0;
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        return this.head.getColumnIndex(column);
    }

    @Override
    public int getFieldIndex(String column) {
        return this.head.getColumnIndex(column);
    }

    @Override
    public ColumnExpr getColumn(int index) {
        if (index < 0 || index >= this.values.length) {
            throw new InvalidArgumentException("index", index);
        }
        return this.head.columns[index];
    }

    @Override
    public Object getValue(int index) {
        if (index < 0 || index >= this.values.length) {
            throw new InvalidArgumentException("index", index);
        }
        return this.values[index];
    }

    @Override
    public final Object get(ColumnExpr column) {
        return this.getValue(this.indexOf(column));
    }

    @Deprecated
    public Object getValue(ColumnExpr column) {
        return this.get(column);
    }

    public final <T> T get(Column column, Class<T> returnType) {
        return ObjectUtils.convert(returnType, this.get(column));
    }

    public final Object[] getArray(ColumnExpr ... columns) {
        Object[] values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int index = this.getFieldIndex(columns[i]);
            if (index < 0) {
                throw new ItemNotFoundException((Object)columns[i].getName());
            }
            values[i] = this.getValue(index);
        }
        return values;
    }

    @Override
    public boolean isNull(int index) {
        return ObjectUtils.isEmpty(this.getValue(index));
    }

    public String getString(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getString(o);
    }

    public final String getString(ColumnExpr column) {
        return this.getString(this.indexOf(column));
    }

    public int getInt(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getInteger(o);
    }

    public final int getInt(ColumnExpr column) {
        return this.getInt(this.indexOf(column));
    }

    public long getLong(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getLong(o);
    }

    public final long getLong(ColumnExpr column) {
        return this.getLong(this.indexOf(column));
    }

    public BigDecimal getDecimal(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getDecimal(o);
    }

    public final BigDecimal getDecimal(ColumnExpr column) {
        return this.getDecimal(this.indexOf(column));
    }

    public boolean getBoolean(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getBoolean(o);
    }

    public final boolean getBoolean(ColumnExpr column) {
        return this.getBoolean(this.indexOf(column));
    }

    public <T extends Enum<?>> T getEnum(int index, Class<T> enumType) {
        if (this.isNull(index)) {
            return null;
        }
        ColumnExpr col = this.getColumn(index);
        boolean numeric = col.getDataType().isNumeric();
        return ObjectUtils.getEnum(enumType, numeric ? Integer.valueOf(this.getInt(index)) : this.getValue(index));
    }

    public final <T extends Enum<?>> T getEnum(ColumnExpr column, Class<T> enumType) {
        return this.getEnum(this.indexOf(column), enumType);
    }

    public final <T extends Enum<?>> T getEnum(Column column) {
        Class<Enum<?>> enumType = column.getEnumType();
        if (enumType == null) {
            throw new InvalidArgumentException("column", column);
        }
        return (T)this.getEnum(this.indexOf(column), enumType);
    }

    public Date getDate(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getDate(o);
    }

    public final Date getDate(ColumnExpr column) {
        return this.getDate(this.indexOf(column));
    }

    @Override
    public final boolean isNull(ColumnExpr column) {
        return this.isNull(this.indexOf(column));
    }

    @Override
    public int setBeanProperties(Object bean, Collection<? extends ColumnExpr> ignoreList) {
        throw new NotImplementedException(this, "setBeanProperties");
    }

    public int setBeanProperties(Object bean) {
        return this.setBeanProperties(bean, null);
    }

    public String getText(String name) {
        int idx = this.getFieldIndex(name);
        return this.head.getText(idx, this.values[idx]);
    }

    public String getText(ColumnExpr col) {
        int idx = this.getFieldIndex(col);
        return this.head.getText(idx, this.values[idx]);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            b.append(this.head.getText(i, this.values[i]));
            b.append(this.head.columnSeparator);
        }
        return b.toString();
    }

    protected int indexOf(ColumnExpr column) {
        int index = this.head.getColumnIndex(column);
        if (index < 0) {
            throw new ItemNotFoundException((Object)column.getName());
        }
        return index;
    }
}

